/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.navigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.security.NetworkSecurityPolicy;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.SystemUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.CMPStrategy;
import io.rong.imlib.HttpDnsManager;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.filetransfer.upload.FilePlatformInfo;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationObserver;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class NavigationClient {
    private static final String TAG = "NavigationClient";
    private static final String NAVIGATION_HTTP_IP_URL = "http://%s/navi.json";
    private static final String NAVIGATION_HTTPS_URL = "https://nav.cn.ronghub.com/navi.json";
    private static final String NAVIGATION_HTTP_URL = "http://nav.cn.ronghub.com/navi.json";
    private static final String NAVIGATION_2_HTTPS_URL = "https://nav2-cn.ronghub.com/navi.json";
    private static final String NAVIGATION_2_HTTP_URL = "http://nav2-cn.ronghub.com/navi.json";
    private final String NAVI_SUFFIX = "navi.json";
    private List<String> naviUrlList = new ArrayList<String>();
    private String naviString;
    private NaviUpdateListener naviUpdateListener = null;
    private ExecutorService executor;
    private Context context;
    private volatile NavigationObserver navigationObserver;
    private static final String SEP1 = ";";
    private static final String NAVI_SPLIT_SYMBOL = ";";
    private static final String NAVI_IN_TOKEN_SPLIT_SYMBOL = "@";
    private String latestTokenNaviEncodeStr;
    private List<String> latestTokenNaviList = new ArrayList<String>();
    private AtomicBoolean fetching = new AtomicBoolean(false);

    private NavigationClient() {
        this.executor = Executors.newSingleThreadExecutor();
        if (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted()) {
            this.naviUrlList.add(NAVIGATION_HTTPS_URL);
            this.naviUrlList.add(NAVIGATION_2_HTTPS_URL);
        } else {
            this.naviUrlList.add(NAVIGATION_HTTP_URL);
            this.naviUrlList.add(NAVIGATION_2_HTTP_URL);
        }
        this.naviString = this.listToString(this.naviUrlList);
    }

    private String listToString(List<?> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || list.get(i) == "") continue;
                sb.append(list.get(i));
                sb.append(";");
            }
        }
        return sb.toString();
    }

    public static NavigationClient getInstance() {
        return SingletonHolder.sIns;
    }

    public boolean isFetching() {
        return this.fetching.get();
    }

    public void setNaviDomainList(String navi) {
        this.naviString = navi;
        if (this.naviUrlList == null) {
            return;
        }
        this.naviUrlList.clear();
        if (navi == null) {
            return;
        }
        this.naviUrlList.addAll(this.naviStrToList(navi, ";"));
        HttpDnsManager.getInstance().shouldEnableHttpDns(this.naviUrlList);
    }

    private List<String> naviStrToList(String naviStr, String split) {
        String[] naviArray;
        ArrayList<String> naviList = new ArrayList<String>();
        if (TextUtils.isEmpty((CharSequence)naviStr)) {
            return naviList;
        }
        for (String navi : naviArray = naviStr.split(split)) {
            String naviUrl;
            if (TextUtils.isEmpty((CharSequence)navi) || naviList.contains(naviUrl = this.formatServerAddress(navi.trim(), "navi.json"))) continue;
            naviList.add(naviUrl);
        }
        return naviList;
    }

    public String formatServerAddress(@NonNull String domain, String path) {
        String strFormat = domain.toLowerCase().startsWith("http") ? "%s/%s" : (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? "https://%s/%s" : "http://%s/%s");
        return String.format(strFormat, domain, path);
    }

    public void addObserver(NavigationObserver observer) {
        this.navigationObserver = observer;
    }

    public void getCMPServerString(Context context, String appKey, String token) {
        RLog.d(TAG, "[connect] getCMPServerString.");
        this.context = context.getApplicationContext();
        if (this.isNaviCacheValid(context, appKey, token)) {
            RLog.d(TAG, "[connect] cache is valid.");
            String userId = NavigationCacheHelper.getUserId(context);
            this.navigationObserver.onSuccess(userId);
        } else {
            String userId = NavigationCacheHelper.getUserId(context);
            if (!token.equals(NavigationCacheHelper.getToken(context))) {
                userId = "";
                NavigationCacheHelper.clearUserId(context);
                RLog.d(TAG, "[connect] clear userId.");
            }
            if (CMPStrategy.getInstance().getCmpList().size() > 0) {
                RLog.d(TAG, "[connect] cache cmp length > 0.");
                this.navigationObserver.onSuccess(userId);
            } else {
                this.requestNavi(appKey, token, true);
            }
        }
    }

    public boolean isNaviCacheValid(Context context, String appKey, String token) {
        return NavigationCacheHelper.isCacheValid(context, appKey, token, this.naviString);
    }

    public void requestNavi(final String appKey, final String token, final boolean shouldNotifyObserver) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        List combineNaviList = NavigationClient.this.getAllNaviURLs(token);
                        if (combineNaviList.size() > 0) {
                            boolean isLastNavi;
                            String naviUrl;
                            boolean result;
                            NavigationClient.this.fetching.set(true);
                            Iterator iterator = combineNaviList.iterator();
                            while (iterator.hasNext() && !(result = NavigationClient.this.request(naviUrl, appKey, token, shouldNotifyObserver, isLastNavi = combineNaviList.indexOf(naviUrl = (String)iterator.next()) == combineNaviList.size() - 1))) {
                            }
                            NavigationClient.this.fetching.set(false);
                        }
                    }
                    catch (Exception e) {
                        FwLog.write(1, 1, FwLog.LogTag.L_CRASH_IPC_EPT_F.getTag(), "stacks", FwLog.stackToString(e));
                        if (!shouldNotifyObserver) break block4;
                        String userId = NavigationCacheHelper.getUserId(NavigationClient.this.context);
                        NavigationClient.this.navigationObserver.onError(userId, 30004);
                    }
                }
            }
        });
    }

    public boolean isMPOpened(Context context) {
        return NavigationCacheHelper.isMPOpened(context);
    }

    public boolean isGROpened(Context context) {
        return NavigationCacheHelper.isGetRemoteEnabled(context);
    }

    public int getGroupMessageLimit(Context context) {
        return NavigationCacheHelper.getGroupMessageLimit(context);
    }

    public boolean isUSOpened(Context context) {
        return NavigationCacheHelper.isUSOpened(context);
    }

    public String getUserId(Context context) {
        return NavigationCacheHelper.getUserId(context);
    }

    public void requestCmpIfNeed(Context context, final String appKey, final String token) {
        if (NavigationCacheHelper.isCacheTimeout(context)) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    NavigationClient.this.requestNavi(appKey, token, true);
                }
            });
        }
    }

    public void clearCacheTime(Context context) {
        NavigationCacheHelper.updateTime(context, 0L);
    }

    public String getVoIPCallInfo(Context context) {
        return NavigationCacheHelper.getVoIPCallInfo(context);
    }

    public String getMediaServer(Context context) {
        return NavigationCacheHelper.getMediaServer(context);
    }

    public List<FilePlatformInfo> getMediaServerConfigs(Context context) {
        return NavigationCacheHelper.getMediaServerCache(context);
    }

    public boolean isGetRemoteHistoryEnabled(Context context) {
        return NavigationCacheHelper.isGetRemoteEnabled(context);
    }

    public boolean isChatroomHistoryEnabled(Context context) {
        return NavigationCacheHelper.isChatroomHistoryEnabled(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean request(String urlStr, String appKey, String token, boolean shouldNotifyObserver, boolean isLastNavi) {
        RLog.d(TAG, "[connect] request " + urlStr + ", appKey:" + appKey + ", token: " + token + ", forceUpdate:" + shouldNotifyObserver);
        HttpURLConnection connection = null;
        BufferedInputStream responseStream = null;
        int responseCode = -1;
        boolean requestResult = false;
        String host = "";
        URL url = this.getUrlStr(urlStr);
        if (url != null) {
            host = url.getHost();
        }
        try {
            int c;
            long start_time;
            String requestIp;
            HashMap<String, String> ipMap = HttpDnsManager.getInstance().getHttpDnsIps(this.context, host);
            String resolveIp = ipMap.get("resolveIp");
            String clientIp = ipMap.get("clientIp");
            String requestToken = this.getTokenExceptNavi(token);
            if (TextUtils.isEmpty((CharSequence)resolveIp)) {
                requestIp = NavigationCacheHelper.queryRequestIP(urlStr);
                start_time = System.currentTimeMillis();
                FwLog.write(3, 1, FwLog.LogTag.L_GET_NAVI_T.getTag(), "url|ip", urlStr, requestIp);
                connection = this.createConnection("", urlStr, appKey, requestToken, "");
            } else {
                requestIp = resolveIp;
                start_time = System.currentTimeMillis();
                FwLog.write(3, 1, FwLog.LogTag.L_GET_NAVI_T.getTag(), "url|ip", urlStr, requestIp);
                RLog.i(TAG, "https connection ip = " + requestIp);
                URL dnsUrl = new URL(urlStr.replaceFirst(host, resolveIp));
                connection = this.createConnection(host, dnsUrl.toString(), appKey, requestToken, clientIp);
            }
            connection.connect();
            responseCode = connection.getResponseCode();
            InputStream inputStream = responseCode != 200 ? connection.getErrorStream() : connection.getInputStream();
            responseStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream responseData = new ByteArrayOutputStream(512);
            while ((c = responseStream.read()) != -1) {
                responseData.write(c);
            }
            String data = new String(responseData.toByteArray(), "utf-8").trim();
            long delta = System.currentTimeMillis() - start_time;
            FwLog.write(3, 1, FwLog.LogTag.L_GET_NAVI_R.getTag(), "code|url|duration|ip", responseCode, urlStr, delta, requestIp);
            int result = NavigationCacheHelper.decode2File(this.context, data, responseCode);
            String userId = NavigationCacheHelper.getUserId(this.context);
            if (result == 0) {
                FwLog.write(3, 1, FwLog.LogTag.L_DECODE_NAVI_S.getTag(), "code", result);
                if (NavigationCacheHelper.getPrivateCloudConfig(this.context)) {
                    if (shouldNotifyObserver) {
                        this.navigationObserver.onError(userId, 34005);
                    }
                    boolean bl = false;
                    return bl;
                }
                NavigationCacheHelper.clearComplexConnectionEntries(this.context);
                CMPStrategy.getInstance().onGetCmpEntriesFromNavi();
                if (shouldNotifyObserver) {
                    this.navigationObserver.onSuccess(userId);
                }
                NavigationCacheHelper.cacheRequest(this.context, appKey, token);
                NavigationCacheHelper.cacheLastSuccessNaviDomainList(this.context, this.naviString);
                this.notifyNaviUpdate();
                requestResult = true;
            } else {
                FwLog.write(1, 1, FwLog.LogTag.L_DECODE_NAVI_S.getTag(), "code|data", result, data.replaceAll("\\n", ""));
                if (this.navigationObserver != null && isLastNavi && shouldNotifyObserver) {
                    this.navigationObserver.onError(userId, result);
                }
                RLog.e(TAG, "request failure : " + result + ", data = " + data);
            }
        }
        catch (Exception e) {
            FwLog.write(1, 1, FwLog.LogTag.L_CRASH_IPC_EPT_F.getTag(), "stacks", FwLog.stackToString(e));
            FwLog.write(3, 1, FwLog.LogTag.L_GET_NAVI_R.getTag(), "code|url", responseCode, urlStr);
            if (this.navigationObserver != null && isLastNavi && shouldNotifyObserver) {
                String userId = NavigationCacheHelper.getUserId(this.context);
                this.navigationObserver.onError(userId, 30004);
            }
            RLog.e(TAG, "request exception.");
        }
        finally {
            RLog.i(TAG, "request end: " + responseCode + ", force = " + shouldNotifyObserver);
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "IOException ", e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return requestResult;
    }

    private URL getUrlStr(String urlStr) {
        URL url;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            url = null;
            RLog.e(TAG, "getUrlStr ", e);
        }
        return url;
    }

    private HttpURLConnection createConnection(String originalHost, final String urlStr, String appKey, String token, String clientIp) throws IOException {
        HttpURLConnection conn = NetUtils.createURLConnection(urlStr);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(10000);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("User-Agent", "RongCloud");
        String host = TextUtils.isEmpty((CharSequence)originalHost) ? NavigationClient.getNavHost(urlStr) : originalHost;
        if (!TextUtils.isEmpty((CharSequence)clientIp)) {
            conn.setRequestProperty("clientIp", clientIp);
            NavigationCacheHelper.updateClientIp(this.context, clientIp);
        }
        if (!TextUtils.isEmpty((CharSequence)host)) {
            conn.setRequestProperty("Host", host);
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return !TextUtils.isEmpty((CharSequence)urlStr) && urlStr.contains(hostname);
                    }
                });
            }
        }
        String params = "token=";
        params = params + URLEncoder.encode(token, "UTF-8");
        params = params + "&v=4.1.0";
        params = params + "&p=Android";
        conn.setRequestProperty("Content-Length", String.valueOf(params.length()));
        conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("appId", appKey);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        OutputStream os = conn.getOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        writer.write(params);
        writer.flush();
        writer.close();
        os.close();
        return conn;
    }

    private static String getNavHost(String navi) {
        try {
            URL url = new URL(navi);
            String host = url.getHost();
            int port = url.getPort();
            if (port != -1 && url.getDefaultPort() != url.getPort()) {
                host = host + ":" + port;
            }
            return host;
        }
        catch (MalformedURLException e) {
            RLog.e(TAG, "MalformedURLException ", e);
            return null;
        }
    }

    public String getNaviString() {
        return this.naviString;
    }

    private List<String> getNaviFromToken(String token) {
        String naviStr;
        ArrayList<String> naviList = new ArrayList<String>();
        String[] splitResult = token.split(NAVI_IN_TOKEN_SPLIT_SYMBOL);
        if (splitResult.length > 1 && !TextUtils.isEmpty((CharSequence)(naviStr = splitResult[1]))) {
            if (!naviStr.equals(this.latestTokenNaviEncodeStr)) {
                naviList.addAll(this.naviStrToList(naviStr, ";"));
                this.latestTokenNaviList.clear();
                this.latestTokenNaviList.addAll(naviList);
                this.latestTokenNaviEncodeStr = naviStr;
            } else {
                naviList.addAll(this.latestTokenNaviList);
            }
        }
        return naviList;
    }

    public String getTokenExceptNavi(String token) {
        if (!TextUtils.isEmpty((CharSequence)token) && token.contains(NAVI_IN_TOKEN_SPLIT_SYMBOL)) {
            token = token.substring(0, token.indexOf(NAVI_IN_TOKEN_SPLIT_SYMBOL) + 1);
        }
        return token;
    }

    public void setNaviUpdateListener(NaviUpdateListener listener) {
        this.naviUpdateListener = listener;
    }

    private void notifyNaviUpdate() {
        if (this.naviUpdateListener != null) {
            this.naviUpdateListener.onNaviUpdate();
        }
    }

    public String getUploadLogConfigInfo(Context context) {
        return NavigationCacheHelper.getRealTimeLogConfig(context);
    }

    private List<String> getAllNaviURLs(String token) {
        ArrayList<String> combineNaviList = new ArrayList<String>();
        List<String> naviFromToken = this.getNaviFromToken(token);
        if (naviFromToken.size() > 0) {
            combineNaviList.addAll(naviFromToken);
        }
        for (String navi : this.naviUrlList) {
            if (combineNaviList.contains(navi)) continue;
            combineNaviList.add(navi);
        }
        FwLog.write(3, 1, FwLog.LogTag.L_NAVI_INFO_S.getTag(), "token|navis", token, SystemUtils.listToString(combineNaviList));
        return combineNaviList;
    }

    public static interface NaviUpdateListener {
        public void onNaviUpdate();
    }

    private static class SingletonHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final NavigationClient sIns = new NavigationClient();

        private SingletonHolder() {
        }
    }
}

