/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.navigation;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.CMPStrategy;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.SharedPreferencesUtils;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.upload.FilePlatformInfo;
import io.rong.imlib.navigation.DNSResolve;
import io.rong.imlib.navigation.LocationConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigationCacheHelper {
    private static final String TAG = "NavigationCacheHelper";
    private static final String NAVIGATION_PREFERENCE = "RongNavigation";
    private static final String NAVIGATION_IP_PREFERENCE = "RongNavigationIp";
    private static final long TIME_OUT = 0x6DDD00L;
    private static final String DEFAULT_VIDEO_TIME = "300";
    private static final int DEFAULT_GIF_SIZE = 2048;
    private static final int USERID_MAX_LENGTH = 64;
    private static final String CODE = "code";
    private static final String CMP_SERVER = "server";
    private static final String BACKUP_SERVER = "bs";
    private static final String MEDIA_SERVER = "uploadServer";
    private static final String LOCATION_CONFIG = "location";
    private static final String CACHED_TIME = "cached_time";
    private static final String APP_KEY = "appKey";
    private static final String TOKEN = "token";
    private static final String VOIP_CALL_INFO = "voipCallInfo";
    private static final String LOG_MONITOR = "monitor";
    private static final String OPEN_MP = "openMp";
    private static final String OPEN_US = "openUS";
    private static final String GET_REMOTE_SERVICE = "historyMsg";
    private static final String GET_GROUP_MESSAGE_LIMIT = "grpMsgLimit";
    private static final String GET_CHATROOM_HISTORY_SERVICE = "chatroomMsg";
    private static final String JOIN_MULTI_CHATROOM = "joinMChrm";
    private static final String USER_ID = "userId";
    private static final String TYPE = "type";
    private static final String LAST_SUCCESS_NAVI = "lastSuccessNavi";
    private static final String COMPLEX_CONNECTION = "complexConnection";
    private static final String CONN_POLICY = "connPolicy";
    private static final String VIDEO_TIMES = "videoTimes";
    private static final String GIF_SIZE = "gifSize";
    private static long sCacheTime = 0L;
    private static boolean userPolicy = false;
    private static final String OFFLINE_LOG_SERVER = "offlinelogserver";
    private static final String ONLINE_LOG_SERVER = "onlinelogserver";
    private static final String EXT_KIT_SWITCH = "extkitSwitch";
    private static final String OPEN_DNS = "openHttpDNS";
    private static final String CLIENT_IP = "clientIp";
    private static final String KV_STORAGE = "kvStorage";
    private static final String TIMING_UPLOAD_LOG_CONFIG = "logPolicy";
    private static final String TIMING_UPLOAD_LOG_SWITCH = "logSwitch";
    private static final String BAI_DU_MEDIA_SERVER = "bosAddr";
    private static final String MEDIA_SERVER_CONFIG = "ossConfig";
    private static final String DEFAULT_MEDIA_SERVER_HOST_BAIDU = "gz.bcebos.com";
    private static Object lock = new Object();

    public static boolean isCacheValid(@NonNull Context context, String appKey, String token, String naviUrls) {
        if (NavigationCacheHelper.getConnectionCmpList(context).size() == 0) {
            return false;
        }
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        String cachedKey = sharedPreferences.getString(APP_KEY, null);
        String cachedToken = sharedPreferences.getString(TOKEN, null);
        String userId = sharedPreferences.getString(USER_ID, null);
        String cacheNaviDomainList = NavigationCacheHelper.getLastSuccessNaviDomainList(context);
        sCacheTime = sharedPreferences.getLong(CACHED_TIME, 0L);
        long currentTime = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        boolean isValid = cachedKey != null && cachedKey.equals(appKey) && cachedToken != null && cachedToken.equals(token) && currentTime - sCacheTime <= 0x6DDD00L && !TextUtils.isEmpty((CharSequence)userId) && NavigationCacheHelper.isNaviUrlsValid(cacheNaviDomainList, naviUrls);
        FwLog.write(3, 1, FwLog.LogTag.L_GET_NAVI_S.getTag(), "cache_valid|delta_time", isValid, currentTime - sCacheTime);
        return isValid;
    }

    private static boolean isNaviUrlsValid(String cachedNaviDomain, String naviUrls) {
        if (TextUtils.isEmpty((CharSequence)naviUrls) || TextUtils.isEmpty((CharSequence)cachedNaviDomain)) {
            return false;
        }
        return naviUrls.equals(cachedNaviDomain);
    }

    static boolean isUSOpened(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(OPEN_US, false);
    }

    static boolean isMPOpened(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(OPEN_MP, true);
    }

    static boolean isCacheTimeout(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        long cachedTime = sharedPreferences.getLong(CACHED_TIME, 0L);
        long currentTime = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        return cachedTime != 0L && currentTime - cachedTime > 0x6DDD00L;
    }

    public static long getCachedTime() {
        return sCacheTime;
    }

    public static void clearCache(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().clear().commit();
    }

    public static void clearNaviCache(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_IP_PREFERENCE, 0);
        sharedPreferences.edit().clear().commit();
    }

    public static List<String> getConnectionCmpList(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        String cmp = sharedPreferences.getString(CMP_SERVER, null);
        String backupStr = sharedPreferences.getString(BACKUP_SERVER, null);
        ArrayList<String> cmpList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)cmp)) {
            cmpList.add(cmp);
        }
        if (!TextUtils.isEmpty((CharSequence)backupStr)) {
            String[] backups;
            for (String backup : backups = backupStr.split(",")) {
                if (TextUtils.isEmpty((CharSequence)backup)) continue;
                cmpList.add(backup);
            }
        }
        return cmpList;
    }

    static void clearComplexConnectionEntries(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().remove(COMPLEX_CONNECTION).commit();
    }

    public static String getToken(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(TOKEN, "");
    }

    public static void updateTime(Context context, long time) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(CACHED_TIME, time);
        editor.commit();
    }

    static void cacheLastSuccessNaviDomainList(Context context, String naviList) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_IP_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(LAST_SUCCESS_NAVI, naviList);
        editor.commit();
    }

    private static String getLastSuccessNaviDomainList(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_IP_PREFERENCE, 0);
        return sharedPreferences.getString(LAST_SUCCESS_NAVI, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getVoIPCallInfo(Context context) {
        Object object = lock;
        synchronized (object) {
            SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
            return sharedPreferences.getString(VOIP_CALL_INFO, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVoIPCallInfo(Context context, String rtcProfile) {
        Object object = lock;
        synchronized (object) {
            SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(VOIP_CALL_INFO, rtcProfile);
            editor.commit();
        }
    }

    static String getMediaServer(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(MEDIA_SERVER, null);
    }

    static String getBaiDuMediaServer(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(BAI_DU_MEDIA_SERVER, DEFAULT_MEDIA_SERVER_HOST_BAIDU);
    }

    static boolean isGetRemoteEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(GET_REMOTE_SERVICE, false);
    }

    public static int getGroupMessageLimit(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(GET_GROUP_MESSAGE_LIMIT, 1000);
    }

    @Deprecated
    public static String getOfflineLogServer(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(OFFLINE_LOG_SERVER, "https://feedback.cn.ronghub.com");
    }

    @Deprecated
    public static String getOnlineLogServer(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(ONLINE_LOG_SERVER, null);
    }

    static boolean isChatroomHistoryEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(GET_CHATROOM_HISTORY_SERVICE, false);
    }

    public static boolean isJoinMChatroomEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(JOIN_MULTI_CHATROOM, false);
    }

    public static boolean isPhraseEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(EXT_KIT_SWITCH, false);
    }

    public static boolean isDnsEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(OPEN_DNS, false);
    }

    public static LocationConfig getLocationConfig(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        String value = sharedPreferences.getString(LOCATION_CONFIG, null);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                LocationConfig config = new LocationConfig();
                JSONObject jsonObj = new JSONObject(value);
                config.setConfigure(jsonObj.optBoolean("configure"));
                if (jsonObj.has("conversationTypes")) {
                    JSONArray array = jsonObj.optJSONArray("conversationTypes");
                    int[] types = new int[array.length()];
                    for (int j = 0; j < array.length(); ++j) {
                        types[j] = array.optInt(j);
                    }
                    config.setConversationTypes(types);
                }
                config.setMaxParticipant(jsonObj.optInt("maxParticipant"));
                config.setDistanceFilter(jsonObj.optInt("distanceFilter"));
                config.setRefreshInterval(jsonObj.optInt("refreshInterval"));
                return config;
            }
            catch (JSONException e) {
                RLog.e(TAG, "getLocationConfig ", e);
            }
        }
        return null;
    }

    public static int getLogMonitor(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(LOG_MONITOR, 0);
    }

    public static String getUserId(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(USER_ID, null);
    }

    public static void saveUserId(Context context, String userId) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(USER_ID, userId);
        editor.apply();
    }

    public static void clearUserId(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        sharedPreferences.edit().remove(USER_ID).commit();
    }

    public static boolean isKvStorageEnabled(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(KV_STORAGE, false);
    }

    public static String getRealTimeLogConfig(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(TIMING_UPLOAD_LOG_CONFIG, null);
    }

    static void cacheRequest(Context context, String appKey, String token) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        long gmtTimestamp = System.currentTimeMillis() - (long)TimeZone.getDefault().getRawOffset();
        editor.putLong(CACHED_TIME, gmtTimestamp);
        editor.putString(APP_KEY, appKey);
        editor.putString(TOKEN, token);
        editor.commit();
    }

    static int decode2File(Context context, String data, int httpCode) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            RLog.e(TAG, "[connect] decode2File: navi data is empty.");
            return RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue();
        }
        try {
            int logSwitch;
            JSONObject jsonObj = new JSONObject(data);
            if (!jsonObj.has(CODE)) {
                return RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue();
            }
            int naviCode = jsonObj.optInt(CODE);
            if (naviCode != 200) {
                RLog.e(TAG, "[connect] decode2File: code & httpCode " + naviCode + "-" + httpCode);
                if (naviCode == 401 && httpCode == 403 || naviCode == 403 && httpCode == 401) {
                    return RongIMClient.ErrorCode.RC_CONN_USER_OR_PASSWD_ERROR.getValue();
                }
                return RongIMClient.ErrorCode.RC_NAVI_RESOURCE_ERROR.getValue();
            }
            SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String userId = jsonObj.optString(USER_ID);
            if (TextUtils.isEmpty((CharSequence)userId) || userId.getBytes().length > 64) {
                RLog.e(TAG, "[connect] decode2File: no user_id." + data);
                return RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue();
            }
            editor.putString(USER_ID, userId);
            String server = jsonObj.optString(CMP_SERVER);
            String bsServer = jsonObj.optString(BACKUP_SERVER);
            if (TextUtils.isEmpty((CharSequence)server) && TextUtils.isEmpty((CharSequence)bsServer)) {
                RLog.e(TAG, "[connect] decode2File: cmp is invalid, " + data);
                return RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue();
            }
            editor.putString(CMP_SERVER, server);
            editor.putString(BACKUP_SERVER, bsServer);
            editor.putString(MEDIA_SERVER, jsonObj.optString(MEDIA_SERVER));
            editor.putString(MEDIA_SERVER_CONFIG, jsonObj.optString(MEDIA_SERVER_CONFIG));
            editor.putString(LOCATION_CONFIG, jsonObj.optString(LOCATION_CONFIG));
            editor.putString(VOIP_CALL_INFO, jsonObj.optString(VOIP_CALL_INFO));
            editor.putBoolean(GET_REMOTE_SERVICE, jsonObj.optBoolean(GET_REMOTE_SERVICE));
            editor.putBoolean(GET_CHATROOM_HISTORY_SERVICE, jsonObj.optBoolean(GET_CHATROOM_HISTORY_SERVICE));
            if (jsonObj.has(GET_GROUP_MESSAGE_LIMIT)) {
                editor.putInt(GET_GROUP_MESSAGE_LIMIT, jsonObj.optInt(GET_GROUP_MESSAGE_LIMIT));
            }
            editor.putBoolean(JOIN_MULTI_CHATROOM, jsonObj.optBoolean(JOIN_MULTI_CHATROOM));
            editor.putBoolean(OPEN_MP, jsonObj.optInt(OPEN_MP) == 1);
            editor.putBoolean(OPEN_US, jsonObj.optInt(OPEN_US) == 1);
            if (jsonObj.has(LOG_MONITOR)) {
                editor.putInt(LOG_MONITOR, jsonObj.optInt(LOG_MONITOR));
            }
            editor.putBoolean(TYPE, jsonObj.optInt(TYPE) == 1);
            if (jsonObj.has(CONN_POLICY)) {
                editor.putInt(CONN_POLICY, jsonObj.optInt(CONN_POLICY));
            }
            if (jsonObj.has(VIDEO_TIMES)) {
                editor.putInt(VIDEO_TIMES, jsonObj.optInt(VIDEO_TIMES));
            }
            editor.putString(OFFLINE_LOG_SERVER, jsonObj.optString(OFFLINE_LOG_SERVER));
            editor.putString(ONLINE_LOG_SERVER, jsonObj.optString(ONLINE_LOG_SERVER));
            editor.putBoolean(EXT_KIT_SWITCH, jsonObj.optInt(EXT_KIT_SWITCH) == 1);
            editor.putBoolean(KV_STORAGE, jsonObj.optInt(KV_STORAGE) == 1);
            if (jsonObj.has(GIF_SIZE)) {
                editor.putInt(GIF_SIZE, jsonObj.optInt(GIF_SIZE));
            }
            editor.putBoolean(OPEN_DNS, jsonObj.optInt(OPEN_DNS) == 1);
            if (jsonObj.has(BAI_DU_MEDIA_SERVER)) {
                editor.putString(BAI_DU_MEDIA_SERVER, jsonObj.optString(BAI_DU_MEDIA_SERVER));
            }
            if ((logSwitch = jsonObj.optInt(TIMING_UPLOAD_LOG_SWITCH)) == 1) {
                String config = jsonObj.optString(TIMING_UPLOAD_LOG_CONFIG);
                if (!TextUtils.isEmpty((CharSequence)config)) {
                    editor.putString(TIMING_UPLOAD_LOG_CONFIG, config.replaceAll("&quot;", "\""));
                } else {
                    editor.putString(TIMING_UPLOAD_LOG_CONFIG, "");
                }
            } else {
                editor.putString(TIMING_UPLOAD_LOG_CONFIG, "");
            }
            editor.commit();
            return 0;
        }
        catch (JSONException e) {
            return RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue();
        }
    }

    public static int getVideoLimitTime(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(VIDEO_TIMES, Integer.valueOf(DEFAULT_VIDEO_TIME).intValue());
    }

    public static boolean isCMPValid(String cmp) {
        return CMPStrategy.getInstance().isCMPValid(cmp);
    }

    public static boolean getPrivateCloudConfig(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getBoolean(TYPE, false);
    }

    public static boolean isConnPolicyEnable(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        boolean naviEnabled = sharedPreferences.getInt(CONN_POLICY, 0) == 1;
        RLog.i(TAG, "isConnPolicyEnable, userPolicy = " + userPolicy + ", naviPolicy = " + naviEnabled);
        if (naviEnabled) {
            return true;
        }
        return userPolicy;
    }

    public static void setUserPolicy(boolean enable) {
        RLog.i(TAG, "setUserPolicy, userPolicy = " + enable);
        userPolicy = enable;
    }

    private static String decode(String data, String key1, String key2) {
        int end;
        if (data == null) {
            return null;
        }
        int start = data.indexOf(key1) + key1.length();
        if (start >= (end = data.indexOf(key2)) || end == 0) {
            return null;
        }
        return data.substring(start, end);
    }

    static String queryRequestIP(String urlStr) {
        DNSResolve dnsTh = new DNSResolve(urlStr);
        dnsTh.resolveHost();
        return dnsTh.getIP();
    }

    public static int getGifSizeLimit(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getInt(GIF_SIZE, 2048);
    }

    static void updateClientIp(Context context, String ip) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(CLIENT_IP, ip);
        editor.commit();
    }

    public static String getClientIp(Context context) {
        SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
        return sharedPreferences.getString(CLIENT_IP, "");
    }

    public static List<FilePlatformInfo> getMediaServerCache(Context context) {
        List<FilePlatformInfo> platforms = null;
        try {
            SharedPreferences sharedPreferences = SharedPreferencesUtils.get(context, NAVIGATION_PREFERENCE, 0);
            if (sharedPreferences.contains(MEDIA_SERVER_CONFIG)) {
                platforms = NavigationCacheHelper.getMediaServerConfig(sharedPreferences);
            }
            if (platforms == null || platforms.size() == 0) {
                platforms = NavigationCacheHelper.getOldMediaServerConfig(sharedPreferences);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, " getMediaServerCache ", e);
            platforms = null;
        }
        return platforms;
    }

    private static List<FilePlatformInfo> getOldMediaServerConfig(SharedPreferences sp) {
        ArrayList<FilePlatformInfo> platforms = new ArrayList<FilePlatformInfo>();
        try {
            FilePlatformInfo platform;
            String mQiniuServer = sp.getString(MEDIA_SERVER, null);
            String mBaiduServer = sp.getString(BAI_DU_MEDIA_SERVER, DEFAULT_MEDIA_SERVER_HOST_BAIDU);
            if (!TextUtils.isEmpty((CharSequence)mQiniuServer)) {
                platform = new FilePlatformInfo(mQiniuServer, FtConst.ServiceType.QI_NIU.getPriority(), FtConst.ServiceType.QI_NIU);
                platforms.add(platform);
            }
            if (!TextUtils.isEmpty((CharSequence)mBaiduServer)) {
                platform = new FilePlatformInfo(mBaiduServer, FtConst.ServiceType.BAI_DU.getPriority(), FtConst.ServiceType.BAI_DU);
                platforms.add(platform);
            }
            Collections.sort(platforms);
        }
        catch (Exception e) {
            e.printStackTrace();
            RLog.e(TAG, " getOldMediaServerConfig ", e);
            platforms.clear();
        }
        return platforms;
    }

    private static List<FilePlatformInfo> getMediaServerConfig(SharedPreferences sp) {
        ArrayList<FilePlatformInfo> platforms = new ArrayList<FilePlatformInfo>();
        String mediaServerConfigJson = sp.getString(MEDIA_SERVER_CONFIG, null);
        try {
            JsonArray jsonArray = new JsonParser().parse(mediaServerConfigJson).getAsJsonArray();
            for (JsonElement element : jsonArray) {
                Set set = element.getAsJsonObject().keySet();
                Iterator iterator = set.iterator();
                String host = null;
                String priority = "";
                FtConst.ServiceType type = null;
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (TextUtils.equals((CharSequence)key, (CharSequence)FtConst.ServiceType.QI_NIU.getName())) {
                        type = FtConst.ServiceType.reverse(key);
                        host = element.getAsJsonObject().get(key).getAsString();
                        continue;
                    }
                    if (TextUtils.equals((CharSequence)key, (CharSequence)FtConst.ServiceType.BAI_DU.getName())) {
                        type = FtConst.ServiceType.reverse(key);
                        String bDHost = element.getAsJsonObject().get(key).getAsString();
                        host = TextUtils.isEmpty((CharSequence)bDHost) ? DEFAULT_MEDIA_SERVER_HOST_BAIDU : bDHost;
                        continue;
                    }
                    if (TextUtils.equals((CharSequence)key, (CharSequence)FtConst.ServiceType.ALI_OSS.getName())) {
                        type = FtConst.ServiceType.reverse(key);
                        host = element.getAsJsonObject().get(key).getAsString();
                        continue;
                    }
                    if (!TextUtils.equals((CharSequence)key, (CharSequence)"p")) continue;
                    priority = element.getAsJsonObject().get(key).getAsString();
                }
                if (type == null) continue;
                FilePlatformInfo platform = new FilePlatformInfo(host, priority, type);
                platforms.add(platform);
            }
            Collections.sort(platforms);
        }
        catch (Exception e) {
            FwLog.write(2, 1, "L-check_ossconfig_data-S", "value", mediaServerConfigJson);
            e.printStackTrace();
            RLog.e(TAG, " getMediaServerConfig ", e);
            platforms.clear();
        }
        return platforms;
    }
}

