/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.navigation;

import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class DNSResolve {
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final String TAG = "DNSResolve";
    private InetAddress address = null;
    private String host;
    private CountDownLatch cdl = new CountDownLatch(1);

    DNSResolve(String host) {
        this.host = host;
    }

    void resolveHost() {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (DNSResolve.this.host.toLowerCase().startsWith("http") || DNSResolve.this.host.toLowerCase().startsWith("https")) {
                        URL url = new URL(DNSResolve.this.host);
                        DNSResolve.this.host = url.getHost();
                    }
                    InetAddress address = InetAddress.getByName(DNSResolve.this.host);
                    DNSResolve.this.set(address);
                    DNSResolve.this.cdl.countDown();
                }
                catch (MalformedURLException e) {
                    FwLog.write(1, 1, FwLog.LogTag.L_DNS_PARSE_F.getTag(), "catch", "MalformedURLException");
                    RLog.e(DNSResolve.TAG, "MalformedURLException ", e);
                }
                catch (UnknownHostException e) {
                    FwLog.write(1, 1, FwLog.LogTag.L_DNS_PARSE_F.getTag(), "catch", "UnknownHostException");
                    RLog.e(DNSResolve.TAG, "UnknownHostException ", e);
                }
                catch (Exception e) {
                    FwLog.write(1, 1, FwLog.LogTag.L_DNS_PARSE_F.getTag(), "catch|stacks", "Exception", FwLog.stackToString(e));
                }
            }
        });
    }

    private void set(InetAddress address) {
        this.address = address;
    }

    public String getIP() {
        try {
            if (this.cdl.await(500L, TimeUnit.MILLISECONDS)) {
                RLog.i(TAG, "getIP countDownLatch is success");
            } else {
                RLog.i(TAG, "getIP countDownLatch is timeout");
            }
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "getIP", e);
            Thread.currentThread().interrupt();
        }
        if (null != this.address) {
            return this.address.getHostAddress();
        }
        return null;
    }
}

