/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import io.rong.common.RLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserOnlineStatusInfo {
    private static final String TAG = "UserOnlineStatusInfo";
    private int serviceStatus;
    private int customerStatus;
    private PlatformInfo platform;

    private PlatformInfo getPlatFormEnum(String platformStr) {
        if (platformStr == null) {
            return PlatformInfo.valueOf(0);
        }
        switch (platformStr = platformStr.toLowerCase()) {
            case "ios": {
                return PlatformInfo.valueOf(1);
            }
            case "android": {
                return PlatformInfo.valueOf(2);
            }
            case "web": {
                return PlatformInfo.valueOf(3);
            }
            case "pc": {
                return PlatformInfo.valueOf(4);
            }
        }
        return PlatformInfo.valueOf(0);
    }

    public UserOnlineStatusInfo(JSONObject jsonObject, int index) {
        try {
            this.serviceStatus = jsonObject.getInt("o");
            this.customerStatus = jsonObject.getInt("s");
            JSONArray jsonArray = jsonObject.optJSONArray("p");
            if (jsonArray != null && jsonArray.length() > 0) {
                if (index < jsonArray.length()) {
                    String platInfo = jsonArray.optString(index);
                    this.platform = this.getPlatFormEnum(platInfo);
                }
            } else {
                this.platform = this.getPlatFormEnum(null);
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, TAG, e);
        }
    }

    public int getServiceStatus() {
        return this.serviceStatus;
    }

    public int getCustomerStatus() {
        return this.customerStatus;
    }

    public PlatformInfo getPlatform() {
        return this.platform;
    }

    public static enum PlatformInfo {
        Platform_Other(0),
        Platform_iOS(1),
        Platform_Android(2),
        Platform_Web(3),
        Platform_PC(4);

        private int code;

        private PlatformInfo(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }

        public static PlatformInfo valueOf(int code) {
            for (PlatformInfo platformCode : PlatformInfo.values()) {
                if (code != platformCode.getValue()) continue;
                return platformCode;
            }
            return Platform_Other;
        }
    }
}

