/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.AndroidConfig;
import io.rong.imlib.model.IOSConfig;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagePushConfig
implements Parcelable {
    public static final String TAG = "MessagePushConfig";
    private boolean disablePushTitle;
    private String pushTitle;
    private String pushContent;
    private String pushData;
    private boolean forceShowDetailContent;
    private IOSConfig iOSConfig;
    private AndroidConfig androidConfig;
    public static final Parcelable.Creator<MessagePushConfig> CREATOR = new Parcelable.Creator<MessagePushConfig>(){

        public MessagePushConfig createFromParcel(Parcel source) {
            return new MessagePushConfig(source);
        }

        public MessagePushConfig[] newArray(int size) {
            return new MessagePushConfig[size];
        }
    };

    public MessagePushConfig() {
    }

    public String getPushTitle() {
        return this.pushTitle;
    }

    public void setPushTitle(String pushTitle) {
        this.pushTitle = pushTitle;
    }

    public String getPushContent() {
        return this.pushContent;
    }

    public void setPushContent(String pushContent) {
        this.pushContent = pushContent;
    }

    public String getPushData() {
        return this.pushData;
    }

    public void setPushData(String pushData) {
        this.pushData = pushData;
    }

    public boolean isForceShowDetailContent() {
        return this.forceShowDetailContent;
    }

    public void setForceShowDetailContent(boolean forceShowDetailContent) {
        this.forceShowDetailContent = forceShowDetailContent;
    }

    public IOSConfig getIOSConfig() {
        return this.iOSConfig;
    }

    public void setIOSConfig(IOSConfig iOSConfig) {
        this.iOSConfig = iOSConfig;
    }

    public AndroidConfig getAndroidConfig() {
        return this.androidConfig;
    }

    public void setAndroidConfig(AndroidConfig androidConfig) {
        this.androidConfig = androidConfig;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.disablePushTitle ? (byte)1 : 0);
        dest.writeString(this.pushTitle);
        dest.writeString(this.pushContent);
        dest.writeString(this.pushData);
        dest.writeByte(this.forceShowDetailContent ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.iOSConfig, flags);
        dest.writeParcelable((Parcelable)this.androidConfig, flags);
    }

    protected MessagePushConfig(Parcel in) {
        this.disablePushTitle = in.readByte() != 0;
        this.pushTitle = in.readString();
        this.pushContent = in.readString();
        this.pushData = in.readString();
        this.forceShowDetailContent = in.readByte() != 0;
        this.iOSConfig = (IOSConfig)in.readParcelable(IOSConfig.class.getClassLoader());
        this.androidConfig = (AndroidConfig)in.readParcelable(AndroidConfig.class.getClassLoader());
    }

    public String toString() {
        return "MessagePushConfig{ disablePushTitle=" + this.disablePushTitle + ", pushTitle='" + this.pushTitle + '\'' + ", pushContent='" + this.pushContent + '\'' + ", pushData='" + this.pushData + '\'' + ", forceShowDetailContent=" + this.forceShowDetailContent + ", iOSConfig=" + this.iOSConfig + ", androidConfig=" + this.androidConfig + '}';
    }

    public String channelToJson() {
        JSONObject iosObject;
        JSONArray array = new JSONArray();
        if (this.androidConfig != null) {
            JSONArray androidArray = this.androidConfig.toJson();
            for (int i = 0; i < androidArray.length(); ++i) {
                try {
                    array.put(androidArray.get(i));
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.iOSConfig != null && (iosObject = this.iOSConfig.toJson()) != null) {
            array.put((Object)iosObject);
        }
        return array.toString();
    }

    public void setChannelFromJson(String jsonStr) {
        try {
            if (TextUtils.isEmpty((CharSequence)jsonStr)) {
                RLog.e(TAG, "setChannelFromJson jsonStr is null");
                return;
            }
            JSONArray jsonArray = new JSONArray(jsonStr);
            AndroidConfig androidConfig = new AndroidConfig();
            IOSConfig iosConfig = new IOSConfig();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject inObject;
                JSONObject outObject = jsonArray.getJSONObject(i);
                if (outObject.has(AndroidConfig.ChannelKey.HW.getKey())) {
                    inObject = outObject.getJSONObject(AndroidConfig.ChannelKey.HW.getKey());
                    if (!inObject.has("channelId")) continue;
                    androidConfig.setChannelIdHW(inObject.getString("channelId"));
                    continue;
                }
                if (outObject.has(AndroidConfig.ChannelKey.MI.getKey())) {
                    inObject = outObject.getJSONObject(AndroidConfig.ChannelKey.MI.getKey());
                    if (!inObject.has("channelId")) continue;
                    androidConfig.setChannelIdMi(inObject.getString("channelId"));
                    continue;
                }
                if (outObject.has(AndroidConfig.ChannelKey.OPPO.getKey())) {
                    inObject = outObject.getJSONObject(AndroidConfig.ChannelKey.OPPO.getKey());
                    if (!inObject.has("channelId")) continue;
                    androidConfig.setChannelIdOPPO(inObject.getString("channelId"));
                    continue;
                }
                if (outObject.has(AndroidConfig.ChannelKey.VIVO.getKey())) {
                    inObject = outObject.getJSONObject(AndroidConfig.ChannelKey.VIVO.getKey());
                    if (!inObject.has("classification")) continue;
                    androidConfig.setTypeVivo(inObject.getString("classification"));
                    continue;
                }
                if (!outObject.has("APNS")) continue;
                inObject = outObject.getJSONObject("APNS");
                if (inObject.has("thread-id")) {
                    iosConfig.setThread_id(inObject.getString("thread-id"));
                }
                if (!inObject.has("apns-collapse-id")) continue;
                iosConfig.setApns_collapse_id(inObject.getString("apns-collapse-id"));
            }
            this.androidConfig = androidConfig;
            this.iOSConfig = iosConfig;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static class Builder {
        private String pushTitle;
        private String pushContent;
        private String pushData;
        private boolean forceShowDetailContent;
        private IOSConfig iOSConfig;
        private AndroidConfig androidConfig;

        public Builder setPushTitle(String pushTitle) {
            this.pushTitle = pushTitle;
            return this;
        }

        public Builder setPushContent(String pushContent) {
            this.pushContent = pushContent;
            return this;
        }

        public Builder setPushData(String pushData) {
            this.pushData = pushData;
            return this;
        }

        public Builder setForceShowDetailContent(boolean forceShowDetailContent) {
            this.forceShowDetailContent = forceShowDetailContent;
            return this;
        }

        public Builder setIOSConfig(IOSConfig iOSConfig) {
            this.iOSConfig = iOSConfig;
            return this;
        }

        public Builder setAndroidConfig(AndroidConfig androidConfig) {
            this.androidConfig = androidConfig;
            return this;
        }

        public MessagePushConfig build() {
            MessagePushConfig messagePushConfig = new MessagePushConfig();
            messagePushConfig.setPushTitle(this.pushTitle);
            messagePushConfig.setPushContent(this.pushContent);
            messagePushConfig.setPushData(this.pushData);
            messagePushConfig.setForceShowDetailContent(this.forceShowDetailContent);
            messagePushConfig.setIOSConfig(this.iOSConfig);
            messagePushConfig.setAndroidConfig(this.androidConfig);
            return messagePushConfig;
        }
    }
}

