/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MessageContent
implements Parcelable {
    private static final String TAG = "MessageContent";
    private UserInfo userInfo;
    private MentionedInfo mentionedInfo;
    private boolean isDestruct;
    private long destructTime;

    protected MessageContent() {
    }

    public MessageContent(byte[] data) {
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo info) {
        this.userInfo = info;
    }

    public MentionedInfo getMentionedInfo() {
        return this.mentionedInfo;
    }

    public void setMentionedInfo(MentionedInfo info) {
        this.mentionedInfo = info;
    }

    public boolean isDestruct() {
        return this.destructTime > 0L;
    }

    public long getDestructTime() {
        return this.destructTime;
    }

    public void setDestruct(boolean destruct) {
        this.isDestruct = destruct;
    }

    public void setDestructTime(long destructTime) {
        this.destructTime = destructTime;
    }

    public JSONObject getJSONDestructInfo() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("isBurnAfterRead", this.isDestruct);
            jsonObject.put("burnDuration", this.destructTime);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
        return jsonObject;
    }

    public void parseJsonToDestructInfo(JSONObject jsonObject) {
        try {
            this.isDestruct = jsonObject.getBoolean("isBurnAfterRead");
            this.destructTime = jsonObject.getLong("burnDuration");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject getJSONUserInfo() {
        if (this.getUserInfo() == null || this.getUserInfo().getUserId() == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("id", (Object)this.getUserInfo().getUserId());
            if (!TextUtils.isEmpty((CharSequence)this.getUserInfo().getName())) {
                jsonObject.put("name", (Object)this.getUserInfo().getName());
            }
            if (this.getUserInfo().getPortraitUri() != null) {
                jsonObject.put("portrait", (Object)this.getUserInfo().getPortraitUri());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getUserInfo().getExtra())) {
                jsonObject.put("extra", (Object)this.getUserInfo().getExtra());
            }
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        return jsonObject;
    }

    public UserInfo parseJsonToUserInfo(JSONObject jsonObj) {
        UserInfo info = null;
        String id = jsonObj.optString("id");
        String name = jsonObj.optString("name");
        String icon = jsonObj.optString("portrait");
        String extra = jsonObj.optString("extra");
        if (TextUtils.isEmpty((CharSequence)icon)) {
            icon = jsonObj.optString("icon");
        }
        if (!TextUtils.isEmpty((CharSequence)id) && !TextUtils.isEmpty((CharSequence)name)) {
            Uri portrait = icon != null ? Uri.parse((String)icon) : null;
            info = new UserInfo(id, name, portrait);
            info.setExtra(extra);
        }
        return info;
    }

    protected JSONObject getJsonMentionInfo() {
        if (this.getMentionedInfo() == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("type", this.getMentionedInfo().getType().getValue());
            if (this.getMentionedInfo().getMentionedUserIdList() == null) {
                jsonObject.put("userIdList", null);
            } else {
                JSONArray jsonArray = new JSONArray();
                for (String userId : this.getMentionedInfo().getMentionedUserIdList()) {
                    jsonArray.put((Object)userId);
                }
                jsonObject.put("userIdList", (Object)jsonArray);
            }
            jsonObject.put("mentionedContent", (Object)this.getMentionedInfo().getMentionedContent());
        }
        catch (JSONException e) {
            RLog.e(TAG, "JSONException " + e.getMessage());
        }
        return jsonObject;
    }

    protected MentionedInfo parseJsonToMentionInfo(JSONObject jsonObject) {
        MentionedInfo mentionedInfo;
        MentionedInfo.MentionedType type = MentionedInfo.MentionedType.valueOf(jsonObject.optInt("type"));
        JSONArray userList = jsonObject.optJSONArray("userIdList");
        String mentionContent = jsonObject.optString("mentionedContent");
        if (type.equals((Object)MentionedInfo.MentionedType.NONE)) {
            return null;
        }
        if (type.equals((Object)MentionedInfo.MentionedType.ALL)) {
            mentionedInfo = new MentionedInfo(type, null, mentionContent);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            if (userList == null || userList.length() <= 0) {
                return null;
            }
            try {
                for (int i = 0; i < userList.length(); ++i) {
                    list.add((String)userList.get(i));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            mentionedInfo = new MentionedInfo(type, list, mentionContent);
        }
        return mentionedInfo;
    }

    public List<String> getSearchableWord() {
        return null;
    }

    public abstract byte[] encode();
}

