/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.common.JSONUtils;
import io.rong.common.ParcelUtils;
import io.rong.imlib.NativeObject;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageConfig;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.MessageExpansion;
import io.rong.imlib.model.MessagePushConfig;
import io.rong.imlib.model.ReadReceiptInfo;
import io.rong.imlib.model.UnknownMessage;
import io.rong.push.common.RLog;
import java.util.HashMap;
import java.util.Map;

public class Message
implements Parcelable {
    private static final String TAG = "Message";
    private Conversation.ConversationType conversationType;
    private String targetId;
    private int messageId;
    private MessageDirection messageDirection;
    private String senderUserId;
    private ReceivedStatus receivedStatus;
    private SentStatus sentStatus;
    private long receivedTime;
    private long sentTime;
    private long readTime;
    private String objectName;
    private MessageContent content;
    private String extra;
    private ReadReceiptInfo readReceiptInfo;
    private MessageConfig messageConfig;
    private MessagePushConfig messagePushConfig;
    private boolean canIncludeExpansion;
    private Map<String, String> expansion;
    private Map<String, MessageExpansion> expansionEx;
    private String UId;
    public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

        public Message createFromParcel(Parcel source) {
            return new Message(source);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    };

    public String getUId() {
        return this.UId;
    }

    public void setUId(String UId) {
        this.UId = UId;
    }

    public Message() {
    }

    public Message(NativeObject.Message msg) {
        this.conversationType = Conversation.ConversationType.setValue(msg.getConversationType());
        this.targetId = msg.getTargetId();
        this.messageId = (int)msg.getMessageId();
        this.messageDirection = !msg.getMessageDirection() ? MessageDirection.SEND : MessageDirection.RECEIVE;
        this.senderUserId = msg.getSenderUserId();
        this.receivedStatus = new ReceivedStatus(msg.getReadStatus());
        this.sentStatus = SentStatus.setValue(msg.getSentStatus());
        this.receivedTime = msg.getReceivedTime();
        this.sentTime = msg.getSentTime();
        this.readTime = msg.getReadTime();
        this.objectName = msg.getObjectName();
        this.UId = msg.getUId();
        this.extra = msg.getExtra();
        this.readReceiptInfo = new ReadReceiptInfo(msg.getReadReceiptInfo());
        this.messageConfig = new MessageConfig.Builder().setDisableNotification(msg.isDisableNotification()).build();
        MessagePushConfig messagePushConfig = new MessagePushConfig.Builder().setPushTitle(msg.getPushTitle()).setPushContent(msg.getPushContent()).setForceShowDetailContent(msg.isForcePushDetail()).build();
        messagePushConfig.setChannelFromJson(msg.getPushConfig());
        if (messagePushConfig.getAndroidConfig() != null) {
            messagePushConfig.getAndroidConfig().setNotificationId(msg.getPushId());
        }
        this.messagePushConfig = messagePushConfig;
        this.canIncludeExpansion = msg.isExtSupport();
        this.expansionEx = JSONUtils.jsonToExpansionEx(msg.getExtMsg());
        this.expansion = JSONUtils.expansionExToMap(this.expansionEx);
    }

    public static Message obtain(String targetId, Conversation.ConversationType type, MessageContent content) {
        Message obj = new Message();
        obj.setTargetId(targetId);
        obj.setConversationType(type);
        obj.setContent(content);
        return obj;
    }

    public Conversation.ConversationType getConversationType() {
        return this.conversationType;
    }

    public void setConversationType(Conversation.ConversationType conversationType) {
        this.conversationType = conversationType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
    }

    public MessageDirection getMessageDirection() {
        return this.messageDirection;
    }

    public void setMessageDirection(MessageDirection messageDirection) {
        this.messageDirection = messageDirection;
    }

    public ReceivedStatus getReceivedStatus() {
        return this.receivedStatus;
    }

    public void setReceivedStatus(ReceivedStatus receivedStatus) {
        this.receivedStatus = receivedStatus;
    }

    public SentStatus getSentStatus() {
        return this.sentStatus;
    }

    public void setSentStatus(SentStatus sentStatus) {
        this.sentStatus = sentStatus;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public void setReceivedTime(long receivedTime) {
        this.receivedTime = receivedTime;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public void setSentTime(long sentTime) {
        this.sentTime = sentTime;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public MessageContent getContent() {
        return this.content;
    }

    public void setContent(MessageContent content) {
        this.content = content;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getSenderUserId() {
        return this.senderUserId;
    }

    public void setSenderUserId(String senderUserId) {
        this.senderUserId = senderUserId;
    }

    public ReadReceiptInfo getReadReceiptInfo() {
        return this.readReceiptInfo;
    }

    public void setReadReceiptInfo(ReadReceiptInfo readReceiptInfo) {
        this.readReceiptInfo = readReceiptInfo;
    }

    public MessageConfig getMessageConfig() {
        return this.messageConfig;
    }

    public void setMessageConfig(MessageConfig messageConfig) {
        this.messageConfig = messageConfig;
    }

    public MessagePushConfig getMessagePushConfig() {
        return this.messagePushConfig;
    }

    public void setMessagePushConfig(MessagePushConfig messagePushConfig) {
        this.messagePushConfig = messagePushConfig;
    }

    public boolean isCanIncludeExpansion() {
        return this.canIncludeExpansion;
    }

    public void setCanIncludeExpansion(boolean canIncludeExpansion) {
        if (!Conversation.ConversationType.PRIVATE.equals((Object)this.conversationType) && !Conversation.ConversationType.GROUP.equals((Object)this.conversationType)) {
            this.canIncludeExpansion = false;
        }
        this.canIncludeExpansion = canIncludeExpansion;
    }

    public Map<String, String> getExpansion() {
        return this.expansion;
    }

    public void setExpansion(HashMap<String, String> expansion) {
        this.expansion = expansion;
    }

    public int describeContents() {
        return 0;
    }

    public Message(Parcel in) {
        Class loader;
        String className = ParcelUtils.readFromParcel(in);
        if (className != null) {
            try {
                loader = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                loader = UnknownMessage.class;
                RLog.e(TAG, "Message class catch exception :" + e);
            }
        } else {
            loader = UnknownMessage.class;
            RLog.e(TAG, "ClassName is null! Illegal messageContent");
        }
        this.setTargetId(ParcelUtils.readFromParcel(in));
        this.setMessageId(ParcelUtils.readIntFromParcel(in));
        String sendUserId = ParcelUtils.readFromParcel(in);
        this.setSenderUserId(!TextUtils.isEmpty((CharSequence)sendUserId) ? sendUserId : "");
        this.setReceivedTime(ParcelUtils.readLongFromParcel(in));
        this.setSentTime(ParcelUtils.readLongFromParcel(in));
        this.setReadTime(ParcelUtils.readLongFromParcel(in));
        this.setObjectName(ParcelUtils.readFromParcel(in));
        this.setContent(ParcelUtils.readFromParcel(in, loader));
        this.setExtra(ParcelUtils.readFromParcel(in));
        this.setUId(ParcelUtils.readFromParcel(in));
        this.setConversationType(Conversation.ConversationType.setValue(ParcelUtils.readIntFromParcel(in)));
        this.setMessageDirection(MessageDirection.setValue(ParcelUtils.readIntFromParcel(in)));
        this.setReceivedStatus(new ReceivedStatus(ParcelUtils.readIntFromParcel(in)));
        this.setSentStatus(SentStatus.setValue(ParcelUtils.readIntFromParcel(in)));
        this.setReadReceiptInfo(ParcelUtils.readFromParcel(in, ReadReceiptInfo.class));
        this.setMessageConfig(ParcelUtils.readFromParcel(in, MessageConfig.class));
        this.setMessagePushConfig(ParcelUtils.readFromParcel(in, MessagePushConfig.class));
        this.setCanIncludeExpansion(ParcelUtils.readIntFromParcel(in) == 1);
        this.setExpansion((HashMap)ParcelUtils.readMapFromParcel(in));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel(dest, this.getContent() != null ? this.getContent().getClass().getName() : null);
        ParcelUtils.writeToParcel(dest, this.getTargetId());
        ParcelUtils.writeToParcel(dest, this.getMessageId());
        ParcelUtils.writeToParcel(dest, this.getSenderUserId());
        ParcelUtils.writeToParcel(dest, this.getReceivedTime());
        ParcelUtils.writeToParcel(dest, this.getSentTime());
        ParcelUtils.writeToParcel(dest, this.getReadTime());
        ParcelUtils.writeToParcel(dest, this.getObjectName());
        ParcelUtils.writeToParcel(dest, this.getContent());
        ParcelUtils.writeToParcel(dest, this.getExtra());
        ParcelUtils.writeToParcel(dest, this.getUId());
        ParcelUtils.writeToParcel(dest, this.getConversationType() == null ? 0 : this.getConversationType().getValue());
        ParcelUtils.writeToParcel(dest, this.getMessageDirection() == null ? 0 : this.getMessageDirection().getValue());
        ParcelUtils.writeToParcel(dest, this.getReceivedStatus() == null ? 0 : this.getReceivedStatus().getFlag());
        ParcelUtils.writeToParcel(dest, this.getSentStatus() == null ? 0 : this.getSentStatus().getValue());
        ParcelUtils.writeToParcel(dest, this.getReadReceiptInfo());
        ParcelUtils.writeToParcel(dest, this.getMessageConfig());
        ParcelUtils.writeToParcel(dest, this.getMessagePushConfig());
        ParcelUtils.writeToParcel(dest, this.isCanIncludeExpansion() ? 1 : 0);
        ParcelUtils.writeToParcel(dest, this.getExpansion());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Message) {
            return this.messageId == ((Message)o).getMessageId();
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Message{conversationType=" + (Object)((Object)this.conversationType) + ", targetId='" + this.targetId + '\'' + ", messageId=" + this.messageId + ", messageDirection=" + (Object)((Object)this.messageDirection) + ", senderUserId='" + this.senderUserId + '\'' + ", receivedStatus=" + this.receivedStatus + ", sentStatus=" + (Object)((Object)this.sentStatus) + ", receivedTime=" + this.receivedTime + ", sentTime=" + this.sentTime + ", objectName='" + this.objectName + '\'' + ", content=" + this.content + ", extra='" + this.extra + '\'' + ", readReceiptInfo=" + this.readReceiptInfo + ", messageConfig=" + this.messageConfig + ", messageConfig=" + this.messagePushConfig + ", canIncludeExpansion=" + this.canIncludeExpansion + ", expansionDic=" + this.expansion + ", expansionDicEx=" + this.expansionEx + ", UId='" + this.UId + '\'' + '}';
    }

    public static class ReceivedStatus {
        private static final int READ = 1;
        private static final int LISTENED = 2;
        private static final int DOWNLOADED = 4;
        private static final int RETRIEVED = 8;
        private static final int MULTIPLERECEIVE = 16;
        private int flag;
        private boolean isRead;
        private boolean isListened;
        private boolean isDownload;
        private boolean isRetrieved;
        private boolean isMultipleReceive;

        public ReceivedStatus(int flag) {
            this.flag = flag;
            this.isRead = (flag & 1) == 1;
            this.isListened = (flag & 2) == 2;
            this.isDownload = (flag & 4) == 4;
            this.isRetrieved = (flag & 8) == 8;
            this.isMultipleReceive = (flag & 0x10) == 16;
        }

        public int getFlag() {
            return this.flag;
        }

        public boolean isRead() {
            return this.isRead;
        }

        public void setRead() {
            this.flag |= 1;
            this.isRead = true;
        }

        public boolean isListened() {
            return this.isListened;
        }

        public void setListened() {
            this.flag |= 2;
            this.isListened = true;
        }

        public boolean isDownload() {
            return this.isDownload;
        }

        public void setDownload() {
            this.flag |= 4;
            this.isDownload = true;
        }

        public boolean isRetrieved() {
            return this.isRetrieved;
        }

        public void setRetrieved() {
            this.flag |= 8;
            this.isRetrieved = true;
        }

        public boolean isMultipleReceive() {
            return this.isMultipleReceive;
        }

        public void setMultipleReceive() {
            this.flag |= 0x10;
            this.isMultipleReceive = true;
        }
    }

    public static enum SentStatus {
        SENDING(10),
        FAILED(20),
        SENT(30),
        RECEIVED(40),
        READ(50),
        DESTROYED(60),
        CANCELED(70);

        private final int value;

        private SentStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SentStatus setValue(int code) {
            for (SentStatus c : SentStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return SENDING;
        }
    }

    public static enum MessageDirection {
        SEND(1),
        RECEIVE(2);

        private int value;

        private MessageDirection(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageDirection setValue(int code) {
            for (MessageDirection c : MessageDirection.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return SEND;
        }
    }
}

