/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidConfig
implements Parcelable {
    public static final String OPERATE = "0";
    public static final String SYSTEM = "1";
    private String notificationId;
    private String channelIdMi;
    private String channelIdHW;
    private String channelIdOPPO;
    private String typeVivo;
    public static final Parcelable.Creator<AndroidConfig> CREATOR = new Parcelable.Creator<AndroidConfig>(){

        public AndroidConfig createFromParcel(Parcel source) {
            return new AndroidConfig(source);
        }

        public AndroidConfig[] newArray(int size) {
            return new AndroidConfig[size];
        }
    };

    public AndroidConfig() {
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getChannelIdMi() {
        return this.channelIdMi;
    }

    public void setChannelIdMi(String channelIdMi) {
        this.channelIdMi = channelIdMi;
    }

    public String getChannelIdHW() {
        return this.channelIdHW;
    }

    public void setChannelIdHW(String channelIdHW) {
        this.channelIdHW = channelIdHW;
    }

    public String getChannelIdOPPO() {
        return this.channelIdOPPO;
    }

    public void setChannelIdOPPO(String channelIdOPPO) {
        this.channelIdOPPO = channelIdOPPO;
    }

    public String getTypeVivo() {
        return this.typeVivo;
    }

    public void setTypeVivo(String typeVivo) {
        this.typeVivo = typeVivo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.notificationId);
        dest.writeString(this.channelIdMi);
        dest.writeString(this.channelIdHW);
        dest.writeString(this.channelIdOPPO);
        dest.writeString(this.typeVivo);
    }

    protected AndroidConfig(Parcel in) {
        this.notificationId = in.readString();
        this.channelIdMi = in.readString();
        this.channelIdHW = in.readString();
        this.channelIdOPPO = in.readString();
        this.typeVivo = in.readString();
    }

    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        if (!TextUtils.isEmpty((CharSequence)this.getChannelIdHW())) {
            jsonArray.put((Object)this.getChannelJson(ChannelKey.HW.getKey(), this.getChannelIdHW()));
        }
        if (!TextUtils.isEmpty((CharSequence)this.getChannelIdMi())) {
            jsonArray.put((Object)this.getChannelJson(ChannelKey.MI.getKey(), this.getChannelIdMi()));
        }
        if (!TextUtils.isEmpty((CharSequence)this.getChannelIdOPPO())) {
            jsonArray.put((Object)this.getChannelJson(ChannelKey.OPPO.getKey(), this.getChannelIdOPPO()));
        }
        if (!TextUtils.isEmpty((CharSequence)this.getTypeVivo())) {
            jsonArray.put((Object)this.getChannelJson(ChannelKey.VIVO.getKey(), this.getTypeVivo()));
        }
        return jsonArray;
    }

    private JSONObject getChannelJson(String key, String value) {
        JSONObject outObject = new JSONObject();
        JSONObject inObject = new JSONObject();
        try {
            if (key.equals(ChannelKey.VIVO.getKey())) {
                inObject.put("classification", (Object)value);
            } else {
                inObject.put("channelId", (Object)value);
            }
            outObject.put(key, (Object)inObject);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return outObject;
    }

    public String toString() {
        return "AndroidConfig{channelIdMi='" + this.channelIdMi + '\'' + ", channelIdHW='" + this.channelIdHW + '\'' + ", channelIdOPPO='" + this.channelIdOPPO + '\'' + ", typeVivo='" + this.typeVivo + '\'' + '}';
    }

    public static enum ChannelKey {
        HW("HW"),
        MI("MI"),
        OPPO("OPPO"),
        VIVO("VIVO");

        private String key;

        private ChannelKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class Builder {
        private String notificationId;
        private String channelIdMi;
        private String channelIdHW;
        private String channelIdOPPO;
        private String typeVivo;

        public Builder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        public Builder setChannelIdMi(String channelIdMi) {
            this.channelIdMi = channelIdMi;
            return this;
        }

        public Builder setChannelIdHW(String channelIdHW) {
            this.channelIdHW = channelIdHW;
            return this;
        }

        public Builder setChannelIdOPPO(String channelIdOPPO) {
            this.channelIdOPPO = channelIdOPPO;
            return this;
        }

        public Builder setTypeVivo(String typeVivo) {
            this.typeVivo = typeVivo;
            return this;
        }

        public AndroidConfig build() {
            AndroidConfig androidConfig = new AndroidConfig();
            androidConfig.setNotificationId(this.notificationId);
            androidConfig.setChannelIdHW(this.channelIdHW);
            androidConfig.setChannelIdMi(this.channelIdMi);
            androidConfig.setChannelIdOPPO(this.channelIdOPPO);
            androidConfig.setTypeVivo(this.typeVivo);
            return androidConfig;
        }
    }
}

