/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.location;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Message;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.AppOpsManagerCompat;
import io.rong.common.RLog;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.location.RealTimeLocationObserver;
import io.rong.imlib.location.RealTimeLocationType;
import io.rong.imlib.location.message.RealTimeLocationJoinMessage;
import io.rong.imlib.location.message.RealTimeLocationQuitMessage;
import io.rong.imlib.location.message.RealTimeLocationStartMessage;
import io.rong.imlib.location.message.RealTimeLocationStatusMessage;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.navigation.LocationConfig;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.stateMachine.State;
import io.rong.imlib.stateMachine.StateMachine;
import io.rong.message.InformationNotificationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class RealTimeLocation
extends StateMachine {
    private static final String TAG = RealTimeLocation.class.getSimpleName();
    public static final int RC_REAL_TIME_LOCATION_EVENT_START = 0;
    public static final int RC_REAL_TIME_LOCATION_EVENT_JOIN = 1;
    public static final int RC_REAL_TIME_LOCATION_EVENT_QUIT = 2;
    public static final int RC_REAL_TIME_LOCATION_EVENT_PARTICIPANT_START = 3;
    public static final int RC_REAL_TIME_LOCATION_EVENT_PARTICIPANT_JOIN = 4;
    public static final int RC_REAL_TIME_LOCATION_EVENT_PARTICIPANT_QUIT = 5;
    public static final int RC_REAL_TIME_LOCATION_EVENT_RECEIVE_LOCATION_MESSAGE = 6;
    public static final int RC_REAL_TIME_LOCATION_EVENT_SEND_LOCATION_MESSAGE = 7;
    public static final int RC_REAL_TIME_LOCATION_EVENT_START_FAILURE = 8;
    public static final int RC_REAL_TIME_LOCATION_EVENT_JOIN_FAILURE = 9;
    public static final int RC_REAL_TIME_LOCATION_EVENT_REFRESH_TIME_EXPIRE = 10;
    public static final int RC_REAL_TIME_LOCATION_EVENT_TERMINAL = 11;
    public static final int RC_REAL_TIME_LOCATION_EVENT_PARTICIPANT_NO_RESPONSE = 12;
    public static final int RC_REAL_TIME_LOCATION_EVENT_NETWORK_UNAVAILABLE = 13;
    public static final int RC_REAL_TIME_LOCATION_EVENT_DISABLE_GPS = 14;
    private Conversation.ConversationType mConversationType;
    private String mTargetId;
    private String mSelfId;
    private int mRefreshInterval = 10000;
    private Runnable mRefreshRunnable;
    private int mFilterDistance = 5;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;
    private RealTimeLocationType mRealTimeLocationType = RealTimeLocationType.UNKNOWN;
    private boolean mGpsEnable;
    private LocationManager mLocationManager;
    private LocationListener mLocationListener;
    private ArrayList<String> mParticipants;
    private HashMap<String, ParticipantWatcher> mWatcher;
    private RealTimeLocationObserver mObservers;
    private RealTimeLocationConstant.RealTimeLocationStatus mCurrentState;
    private RongIMClient mClient;
    private RongIMClient.OnReceiveMessageListener mReceiveMessageListener;
    private OnRealTimeLocationQuitListener mOnRealTimeLocationQuitListener;
    private Context mContext;
    private State mOutgoingState = new OutgoingState();
    private State mIncomingState = new IncomingState();
    private State mConnectedState = new ConnectedState();
    private State mTerminalState = new TerminalState();

    public void addListener(final RealTimeLocationObserver listener) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                RealTimeLocation.this.mObservers = listener;
            }
        });
    }

    public void deleteListener() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                RealTimeLocation.this.mObservers = null;
            }
        });
    }

    void setOnRealTimeLocationQuitListener(OnRealTimeLocationQuitListener listener) {
        this.mOnRealTimeLocationQuitListener = listener;
    }

    public RealTimeLocation(Context context, Conversation.ConversationType type, String targetId, RongIMClient.OnReceiveMessageListener listener) {
        super(type == null ? "" : type.getName() + targetId);
        RLog.d(TAG, "RealTimeLocation");
        this.mContext = context;
        this.mConversationType = type;
        this.mTargetId = targetId;
        this.mClient = RongIMClient.getInstance();
        this.mCurrentState = RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE;
        this.mParticipants = new ArrayList();
        this.mWatcher = new HashMap();
        this.mReceiveMessageListener = listener;
        LocationConfig config = NavigationCacheHelper.getLocationConfig(context);
        if (config != null) {
            this.mFilterDistance = config.getDistanceFilter();
            this.mRefreshInterval = config.getRefreshInterval() * 1000;
        }
        this.mRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                RealTimeLocation.this.getHandler().sendEmptyMessage(10);
                RealTimeLocation.this.getHandler().postDelayed(RealTimeLocation.this.mRefreshRunnable, (long)RealTimeLocation.this.mRefreshInterval);
            }
        };
        this.mGpsEnable = this.isGpsEnable(context);
        IdleState mIdleState = new IdleState();
        this.addState(mIdleState);
        this.addState(this.mIncomingState, mIdleState);
        this.addState(this.mOutgoingState, mIdleState);
        this.addState(this.mConnectedState, mIdleState);
        this.addState(this.mTerminalState, mIdleState);
        this.setInitialState(mIdleState);
        this.start();
    }

    private void startTimer() {
        this.getHandler().removeCallbacks(this.mRefreshRunnable);
        this.getHandler().postDelayed(this.mRefreshRunnable, (long)this.mRefreshInterval);
    }

    private void stopTimer() {
        this.getHandler().removeCallbacks(this.mRefreshRunnable);
    }

    public void updateLocation(double latitude, double longitude) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
    }

    public void updateLocationWithType(double latitude, double longitude, RealTimeLocationType realTimeLocationType) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.mRealTimeLocationType = realTimeLocationType;
    }

    public RealTimeLocationConstant.RealTimeLocationStatus getRealTimeLocationCurrentState() {
        return this.mCurrentState;
    }

    public boolean gpsIsAvailable() {
        return this.mGpsEnable;
    }

    public List<String> getParticipants() {
        return this.mParticipants;
    }

    private void gpsInit(Context context) {
        RLog.d(TAG, "gpsInit");
        this.mLocationManager = (LocationManager)context.getSystemService("location");
        if (this.mLocationManager == null || !this.mLocationManager.isProviderEnabled("gps")) {
            RLog.e(TAG, "GSP is disabled");
            return;
        }
        this.mGpsEnable = true;
        this.mLocationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
                RLog.d(TAG, "onLocationChanged");
                if (location != null) {
                    RealTimeLocation.this.mLatitude = location.getLatitude();
                    RealTimeLocation.this.mLongitude = location.getLongitude();
                }
            }

            public void onStatusChanged(String provider, int status, Bundle extras) {
                RLog.d(TAG, "onStatusChanged");
                switch (status) {
                    case 2: {
                        RLog.i(TAG, "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u53ef\u89c1\u72b6\u6001");
                        break;
                    }
                    case 0: {
                        RLog.i(TAG, "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u670d\u52a1\u533a\u5916\u72b6\u6001");
                        break;
                    }
                    case 1: {
                        RLog.i(TAG, "\u5f53\u524dGPS\u72b6\u6001\u4e3a\u6682\u505c\u670d\u52a1\u72b6\u6001");
                    }
                }
            }

            public void onProviderEnabled(String provider) {
                RealTimeLocation.this.mGpsEnable = true;
                if (ActivityCompat.checkSelfPermission((Context)RealTimeLocation.this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)RealTimeLocation.this.mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                    RLog.e(TAG, "permission is not granted");
                    return;
                }
                Location location = RealTimeLocation.this.mLocationManager.getLastKnownLocation(provider);
                if (location != null) {
                    RealTimeLocation.this.mLatitude = location.getLatitude();
                    RealTimeLocation.this.mLongitude = location.getLongitude();
                }
            }

            public void onProviderDisabled(String provider) {
                RealTimeLocation.this.mGpsEnable = false;
                RealTimeLocation.this.getHandler().sendEmptyMessage(14);
            }
        };
        String bestProvider = this.mLocationManager.getBestProvider(this.getCriteria(), true);
        Location location = null;
        if (bestProvider != null) {
            location = this.mLocationManager.getLastKnownLocation(bestProvider);
        }
        if (location != null) {
            this.mLatitude = location.getLatitude();
            this.mLongitude = location.getLongitude();
        }
        RLog.e(TAG, "gpsInit: location = " + (location != null ? "[ " + this.mLatitude + " " + this.mLongitude + " ]" : "null"));
    }

    private Criteria getCriteria() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setSpeedRequired(false);
        criteria.setCostAllowed(false);
        criteria.setBearingRequired(false);
        criteria.setAltitudeRequired(false);
        criteria.setPowerRequirement(1);
        return criteria;
    }

    private void updateSelfLocation() {
        this.onReceiveLocation(this.mLatitude, this.mLongitude, this.mRealTimeLocationType, this.mSelfId);
    }

    private void sendStartMessage() {
        RealTimeLocationStartMessage start = RealTimeLocationStartMessage.obtain("start real time location.");
        String content = "\u6536\u5230\u4e00\u6761\u4f4d\u7f6e\u5171\u4eab\u6d88\u606f";
        this.mClient.sendMessage(this.mConversationType, this.mTargetId, start, content, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(io.rong.imlib.model.Message message) {
                if (RealTimeLocation.this.mReceiveMessageListener != null) {
                    message.setSentStatus(Message.SentStatus.SENT);
                    RealTimeLocation.this.mReceiveMessageListener.onReceived(message, 0);
                }
            }

            @Override
            public void onSuccess(io.rong.imlib.model.Message message) {
                if (RealTimeLocation.this.getHandler() != null) {
                    RealTimeLocation.this.getHandler().sendEmptyMessage(7);
                }
            }

            @Override
            public void onError(io.rong.imlib.model.Message message, RongIMClient.ErrorCode errorCode) {
                if (RealTimeLocation.this.getHandler() != null) {
                    RealTimeLocation.this.getHandler().sendEmptyMessage(8);
                }
            }
        });
    }

    private void sendJoinMessage() {
        RealTimeLocationJoinMessage content = RealTimeLocationJoinMessage.obtain("join real time location.");
        this.mClient.sendMessage(this.mConversationType, this.mTargetId, content, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(io.rong.imlib.model.Message message) {
            }

            @Override
            public void onSuccess(io.rong.imlib.model.Message message) {
                if (RealTimeLocation.this.getHandler() != null) {
                    RealTimeLocation.this.getHandler().sendEmptyMessage(7);
                }
            }

            @Override
            public void onError(io.rong.imlib.model.Message message, RongIMClient.ErrorCode errorCode) {
                if (RealTimeLocation.this.getHandler() != null) {
                    RealTimeLocation.this.getHandler().sendEmptyMessage(9);
                }
            }
        });
    }

    private void sendQuitMessage() {
        RealTimeLocationQuitMessage content = RealTimeLocationQuitMessage.obtain("quit real time location.");
        this.mClient.sendMessage(this.mConversationType, this.mTargetId, content, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(io.rong.imlib.model.Message message) {
            }

            @Override
            public void onSuccess(io.rong.imlib.model.Message message) {
            }

            @Override
            public void onError(io.rong.imlib.model.Message message, RongIMClient.ErrorCode errorCode) {
            }
        });
    }

    private void sendLocationMessage() {
        RealTimeLocationStatusMessage content = RealTimeLocationStatusMessage.obtain(this.mLatitude, this.mLongitude, this.mRealTimeLocationType);
        this.mClient.sendMessage(this.mConversationType, this.mTargetId, content, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(io.rong.imlib.model.Message message) {
            }

            @Override
            public void onSuccess(io.rong.imlib.model.Message message) {
                if (RealTimeLocation.this.getHandler() != null && RealTimeLocation.this.getHandler().hasMessages(13)) {
                    RealTimeLocation.this.getHandler().removeMessages(13);
                }
            }

            @Override
            public void onError(io.rong.imlib.model.Message message, RongIMClient.ErrorCode errorCode) {
                RLog.e(TAG, "sendLocationMessage error = " + (Object)((Object)errorCode));
                if (RealTimeLocation.this.getHandler() != null && !RealTimeLocation.this.getHandler().hasMessages(13)) {
                    RealTimeLocation.this.getHandler().sendEmptyMessageDelayed(13, (long)(RealTimeLocation.this.mRefreshInterval * 3));
                }
            }
        });
    }

    private boolean isGpsEnable(Context context) {
        String opStr = AppOpsManagerCompat.permissionToOp((String)"android.permission.ACCESS_FINE_LOCATION");
        if (opStr == null) {
            return true;
        }
        return context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private void onStatusChanged(RealTimeLocationConstant.RealTimeLocationStatus state) {
        if (this.mObservers != null) {
            this.mObservers.onStatusChange(state);
        }
    }

    private void onParticipantQuit(String id) {
        if (this.mObservers != null) {
            this.mObservers.onParticipantsQuit(id);
        }
    }

    private void onParticipantsJoin(String id) {
        if (this.mObservers != null) {
            this.mObservers.onParticipantsJoin(id);
        }
    }

    private void onReceiveLocation(double latitude, double longitude, RealTimeLocationType type, String id) {
        if (this.mObservers != null) {
            this.mObservers.onReceiveLocationWithType(latitude, longitude, type, id);
        }
    }

    private void onError(RealTimeLocationConstant.RealTimeLocationErrorCode errorCode) {
        if (this.mObservers != null) {
            this.mObservers.onError(errorCode);
        }
    }

    void destroy() {
        RLog.d(TAG, "destroy");
        this.quitNow();
        String str = this.mContext.getResources().getString(this.mContext.getResources().getIdentifier("rc_location_sharing_ended", "string", this.mContext.getPackageName()));
        InformationNotificationMessage msg = InformationNotificationMessage.obtain(str);
        RongIMClient.getInstance().insertIncomingMessage(this.mConversationType, this.mTargetId, RongIMClient.getInstance().getCurrentUserId(), null, msg, System.currentTimeMillis() - RongIMClient.getInstance().getDeltaTime(), new RongIMClient.ResultCallback<io.rong.imlib.model.Message>(){

            @Override
            public void onSuccess(io.rong.imlib.model.Message message) {
                if (RealTimeLocation.this.mReceiveMessageListener != null) {
                    RealTimeLocation.this.mReceiveMessageListener.onReceived(message, 0);
                }
            }

            @Override
            public void onError(RongIMClient.ErrorCode e) {
            }
        });
    }

    static interface OnRealTimeLocationQuitListener {
        public void onRealTimeLocationQuit(Conversation.ConversationType var1, String var2);
    }

    private class ParticipantWatcher {
        Runnable runnable;
        String id;

        ParticipantWatcher(final String id) {
            this.id = id;
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    Message msg = Message.obtain();
                    msg.what = 12;
                    msg.obj = id;
                    RealTimeLocation.this.getHandler().sendMessage(msg);
                }
            };
        }

        public void start() {
            RealTimeLocation.this.getHandler().postDelayed(this.runnable, (long)(RealTimeLocation.this.mRefreshInterval * 3));
        }

        public void stop() {
            RealTimeLocation.this.getHandler().removeCallbacks(this.runnable);
        }

        public void update() {
            RealTimeLocation.this.getHandler().removeCallbacks(this.runnable);
            RealTimeLocation.this.getHandler().postDelayed(this.runnable, (long)(RealTimeLocation.this.mRefreshInterval * 3));
        }
    }

    private class TerminalState
    extends State {
        private TerminalState() {
        }

        @Override
        public void enter() {
            RLog.d(TAG, "terminal enter : current = " + (Object)((Object)RealTimeLocation.this.mCurrentState));
            RealTimeLocation.this.mParticipants.clear();
            RealTimeLocation.this.stopTimer();
            if (RealTimeLocation.this.mWatcher.size() > 0) {
                Collection c = RealTimeLocation.this.mWatcher.values();
                for (ParticipantWatcher participantWatcher : c) {
                    participantWatcher.stop();
                }
                RealTimeLocation.this.mWatcher.clear();
            }
            RealTimeLocation.this.getHandler().sendEmptyMessage(11);
        }

        @Override
        public boolean processMessage(Message msg) {
            RLog.i(TAG, this.getName() + ", msg = " + msg.what);
            switch (msg.what) {
                case 11: {
                    if (RealTimeLocation.this.mOnRealTimeLocationQuitListener == null) break;
                    RealTimeLocation.this.mOnRealTimeLocationQuitListener.onRealTimeLocationQuit(RealTimeLocation.this.mConversationType, RealTimeLocation.this.mTargetId);
                    break;
                }
            }
            return true;
        }
    }

    private class ConnectedState
    extends State {
        private ConnectedState() {
        }

        @Override
        public void enter() {
            RealTimeLocation.this.mCurrentState = RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_CONNECTED;
            RealTimeLocation.this.onStatusChanged(RealTimeLocation.this.mCurrentState);
            RealTimeLocation.this.startTimer();
            RLog.d(TAG, "connected enter : current = " + (Object)((Object)RealTimeLocation.this.mCurrentState));
        }

        @Override
        public boolean processMessage(Message msg) {
            RLog.i(TAG, this.getName() + ", msg = " + msg.what);
            switch (msg.what) {
                case 8: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_START_FAILURE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 9: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_JOIN_FAILURE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 4: {
                    String id = (String)msg.obj;
                    ParticipantWatcher watcher = new ParticipantWatcher(id);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(id, watcher);
                    if (!RealTimeLocation.this.mParticipants.contains(id)) {
                        RealTimeLocation.this.mParticipants.add(id);
                    }
                    RealTimeLocation.this.onParticipantsJoin(id);
                    RealTimeLocation.this.getHandler().sendEmptyMessage(7);
                    break;
                }
                case 5: 
                case 12: {
                    String id = (String)msg.obj;
                    RealTimeLocation.this.mParticipants.remove(id);
                    ParticipantWatcher pw = (ParticipantWatcher)RealTimeLocation.this.mWatcher.get(id);
                    if (pw != null) {
                        pw.stop();
                    }
                    RealTimeLocation.this.mWatcher.remove(id);
                    RealTimeLocation.this.onParticipantQuit(id);
                    if (RealTimeLocation.this.mParticipants.size() != 1) break;
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mOutgoingState);
                    break;
                }
                case 2: {
                    RealTimeLocation.this.sendQuitMessage();
                    RealTimeLocation.this.mParticipants.remove(RealTimeLocation.this.mSelfId);
                    if (RealTimeLocation.this.mParticipants.size() == 0) {
                        RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                        break;
                    }
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mIncomingState);
                    break;
                }
                case 7: 
                case 10: {
                    RealTimeLocation.this.sendLocationMessage();
                    RealTimeLocation.this.updateSelfLocation();
                    break;
                }
                case 6: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String id = message.getSenderUserId();
                    ParticipantWatcher pwTemp = (ParticipantWatcher)RealTimeLocation.this.mWatcher.get(id);
                    if (pwTemp == null) {
                        ParticipantWatcher watcher = new ParticipantWatcher(id);
                        watcher.start();
                        RealTimeLocation.this.mWatcher.put(id, watcher);
                        if (!RealTimeLocation.this.mParticipants.contains(id)) {
                            RealTimeLocation.this.mParticipants.add(id);
                        }
                        RealTimeLocation.this.onParticipantsJoin(id);
                    } else {
                        pwTemp.update();
                    }
                    MessageContent content = message.getContent();
                    RealTimeLocationStatusMessage coor = (RealTimeLocationStatusMessage)content;
                    RealTimeLocation.this.onReceiveLocation(coor.getLatitude(), coor.getLongitude(), coor.getRealTimeLocationType(), id);
                    break;
                }
                case 14: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_GPS_DISABLED);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 13: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_NETWORK_UNAVAILABLE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
            }
            return true;
        }
    }

    private class IncomingState
    extends State {
        private IncomingState() {
        }

        @Override
        public void enter() {
            RealTimeLocation.this.stopTimer();
            RealTimeLocation.this.mCurrentState = RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_INCOMING;
            RealTimeLocation.this.onStatusChanged(RealTimeLocation.this.mCurrentState);
            RLog.d(TAG, "incoming enter : current = " + (Object)((Object)RealTimeLocation.this.mCurrentState));
        }

        @Override
        public boolean processMessage(Message msg) {
            RLog.i(TAG, this.getName() + ", msg = " + msg.what);
            switch (msg.what) {
                case 1: {
                    RealTimeLocation.this.sendJoinMessage();
                    RealTimeLocation.this.mSelfId = RealTimeLocation.this.mClient.getCurrentUserId();
                    RealTimeLocation.this.mParticipants.add(RealTimeLocation.this.mSelfId);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mConnectedState);
                    break;
                }
                case 4: {
                    String userId = (String)msg.obj;
                    ParticipantWatcher watcher = new ParticipantWatcher(userId);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(userId, watcher);
                    RealTimeLocation.this.mParticipants.add(userId);
                    RealTimeLocation.this.onParticipantsJoin(userId);
                    break;
                }
                case 5: 
                case 12: {
                    String id = (String)msg.obj;
                    ParticipantWatcher participantWatcher = (ParticipantWatcher)RealTimeLocation.this.mWatcher.get(id);
                    if (participantWatcher != null) {
                        participantWatcher.stop();
                        RealTimeLocation.this.mWatcher.remove(id);
                        RealTimeLocation.this.mParticipants.remove(id);
                        RealTimeLocation.this.onParticipantQuit(id);
                    }
                    if (RealTimeLocation.this.mParticipants.size() != 0) break;
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 14: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_GPS_DISABLED);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 13: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_NETWORK_UNAVAILABLE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 6: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String id = message.getSenderUserId();
                    ParticipantWatcher pw = (ParticipantWatcher)RealTimeLocation.this.mWatcher.get(id);
                    if (pw == null) {
                        ParticipantWatcher watcher = new ParticipantWatcher(id);
                        watcher.start();
                        RealTimeLocation.this.mWatcher.put(id, watcher);
                        RealTimeLocation.this.mParticipants.add(id);
                        RealTimeLocation.this.onParticipantsJoin(id);
                    } else {
                        pw.update();
                    }
                    MessageContent content = message.getContent();
                    RealTimeLocationStatusMessage coor = (RealTimeLocationStatusMessage)content;
                    RealTimeLocation.this.onReceiveLocation(coor.getLatitude(), coor.getLongitude(), coor.getRealTimeLocationType(), id);
                    break;
                }
            }
            return true;
        }
    }

    private class OutgoingState
    extends State {
        private OutgoingState() {
        }

        @Override
        public void enter() {
            RealTimeLocation.this.mCurrentState = RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_OUTGOING;
            RealTimeLocation.this.onStatusChanged(RealTimeLocation.this.mCurrentState);
            RealTimeLocation.this.startTimer();
            RLog.d(TAG, "outgoing enter : current = " + (Object)((Object)RealTimeLocation.this.mCurrentState));
        }

        @Override
        public boolean processMessage(Message msg) {
            RLog.i(TAG, this.getName() + ", msg = " + msg.what);
            switch (msg.what) {
                case 8: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_START_FAILURE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 4: {
                    String userId = (String)msg.obj;
                    ParticipantWatcher watcher = new ParticipantWatcher(userId);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(userId, watcher);
                    RealTimeLocation.this.mParticipants.add(userId);
                    RealTimeLocation.this.onParticipantsJoin(userId);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mConnectedState);
                    break;
                }
                case 6: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String userId = message.getSenderUserId();
                    if (RealTimeLocation.this.mWatcher.containsKey(userId)) break;
                    ParticipantWatcher watcher = new ParticipantWatcher(userId);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(userId, watcher);
                    RealTimeLocation.this.mParticipants.add(userId);
                    RealTimeLocation.this.onParticipantsJoin(userId);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mConnectedState);
                    break;
                }
                case 2: {
                    RealTimeLocation.this.sendQuitMessage();
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 7: 
                case 10: {
                    RealTimeLocation.this.sendLocationMessage();
                    RealTimeLocation.this.updateSelfLocation();
                    break;
                }
                case 14: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_GPS_DISABLED);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
                case 13: {
                    RealTimeLocation.this.onError(RealTimeLocationConstant.RealTimeLocationErrorCode.RC_REAL_TIME_LOCATION_NETWORK_UNAVAILABLE);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mTerminalState);
                    break;
                }
            }
            return true;
        }
    }

    private class IdleState
    extends State {
        private IdleState() {
        }

        @Override
        public void enter() {
            RealTimeLocation.this.mCurrentState = RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE;
            if (RealTimeLocation.this.mSelfId != null) {
                RealTimeLocation.this.onStatusChanged(RealTimeLocation.this.mCurrentState);
            }
            RLog.d(TAG, "idle enter : current = " + (Object)((Object)RealTimeLocation.this.mCurrentState));
        }

        @Override
        public boolean processMessage(Message msg) {
            RLog.i(TAG, this.getName() + ", msg = " + msg.what);
            switch (msg.what) {
                case 0: {
                    RealTimeLocation.this.sendStartMessage();
                    RealTimeLocation.this.mSelfId = RealTimeLocation.this.mClient.getCurrentUserId();
                    RealTimeLocation.this.mParticipants.add(RealTimeLocation.this.mSelfId);
                    RealTimeLocation.this.updateSelfLocation();
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mOutgoingState);
                    break;
                }
                case 3: {
                    String id = (String)msg.obj;
                    ParticipantWatcher watcher = new ParticipantWatcher(id);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(id, watcher);
                    RealTimeLocation.this.mParticipants.add(id);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mIncomingState);
                    break;
                }
                case 6: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String id = message.getSenderUserId();
                    ParticipantWatcher watcher = new ParticipantWatcher(id);
                    watcher.start();
                    RealTimeLocation.this.mWatcher.put(id, watcher);
                    RealTimeLocation.this.mParticipants.add(id);
                    RealTimeLocation.this.transitionTo(RealTimeLocation.this.mIncomingState);
                    break;
                }
            }
            return true;
        }
    }
}

