/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.ipc;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.Process;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.LibHandlerStub;
import io.rong.imlib.statistics.CrashDetails;

public class RongService
extends Service
implements Thread.UncaughtExceptionHandler {
    private final String TAG = RongService.class.getSimpleName();
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public void onCreate() {
        super.onCreate();
        RLog.d(this.TAG, "onCreate, pid=" + Process.myPid());
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    public IBinder onBind(Intent intent) {
        RLog.d(this.TAG, "onBind, pid=" + Process.myPid());
        String appKey = intent.getStringExtra("appKey");
        String deviceId = intent.getStringExtra("deviceId");
        return new LibHandlerStub((Context)this, appKey, deviceId);
    }

    public boolean onUnbind(Intent intent) {
        RLog.d(this.TAG, "onUnbind, pid=" + Process.myPid());
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        RLog.d(this.TAG, "onDestroy, pid=" + Process.myPid());
        Process.killProcess((int)Process.myPid());
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String reason = e.toString();
        if (!TextUtils.isEmpty((CharSequence)reason) && reason.contains(":")) {
            reason = reason.substring(0, reason.indexOf(":"));
        }
        FwLog.write(0, 1, FwLog.LogTag.L_CRASH_IPC_TRB_F.getTag(), "stacks|reason|env", FwLog.stackToString(e), reason, CrashDetails.getIMCrashData(this.getApplicationContext(), e.toString()));
        this.defaultExceptionHandler.uncaughtException(t, e);
    }
}

