/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.ipc;

import android.content.Context;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class RongExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "RongExceptionHandler";
    private Context mContext;

    public RongExceptionHandler(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        long timeMillis = System.currentTimeMillis();
        Date date = new Date(timeMillis);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
        String formatTime = sdf.format(date);
        String path = FileUtils.getCachePath(this.mContext, "crashlog") + "/crash_" + formatTime + ".log";
        File crashFile = new File(path);
        OutputStream stream = null;
        try {
            boolean isCreated = crashFile.createNewFile();
            if (!isCreated) {
                RLog.e(TAG, "crashFile.createNewFile() failed");
            }
            stream = new FileOutputStream(crashFile);
            PrintStream printStream = new PrintStream(stream);
            ex.printStackTrace(printStream);
            printStream.close();
        }
        catch (Exception e) {
            RLog.e(TAG, "uncaughtException", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "uncaughtException", e);
                }
            }
        }
        RLog.e(TAG, "uncaughtException", ex);
        System.exit(2);
    }
}

