/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.httpdns;

import android.util.Base64;
import io.rong.common.rlog.RLog;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

final class RongHttpDnsUtil {
    private static final String TAG = "RongHttpDnsUtil";
    private static final String IPV4_PATTERN = "^((0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)\\.){3}(0|1\\d?\\d?|2[0-4]?\\d?|25[0-5]?|[3-9]\\d?)$";
    private static Pattern ipv4Pattern;
    private static final String HEX = "0123456789ABCDEF";
    private static final String TRANSFORMATION = "DES/CBC/PKCS5Padding";
    private static final String IVPARAMETERSPEC = "01020304";
    private static final String ALGORITHM = "DES";
    private static final String SHA1PRNG = "SHA1PRNG";
    private static String dynamickey;

    private RongHttpDnsUtil() {
    }

    static boolean validateIpv4(String ip) {
        Matcher matcher = ipv4Pattern.matcher(ip);
        return matcher.matches();
    }

    static boolean validateIpv6(String ip) {
        return RongHttpDnsUtil.isIPv6Std(ip = ip.replaceAll("[\\[\\]]", "")) || RongHttpDnsUtil.isIPV6Compress(ip);
    }

    private static boolean isIPv6Std(String ip) {
        return Pattern.matches("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$", ip);
    }

    private static boolean isIPV6Compress(String ip) {
        return Pattern.matches("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$", ip);
    }

    static String md5(String content) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(content.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            RLog.e(TAG, "md5 NoSuchAlgorithmException", e);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "md5 UnsupportedEncodingException", e);
            return null;
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    private static String generateKey() {
        try {
            SecureRandom localSecureRandom = SecureRandom.getInstance(SHA1PRNG);
            byte[] bytes_key = new byte[20];
            localSecureRandom.nextBytes(bytes_key);
            return RongHttpDnsUtil.toHex(bytes_key);
        }
        catch (Exception e) {
            RLog.e(TAG, "generateKey Exception", e);
            return null;
        }
    }

    private static String toHex(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(2 * buf.length);
        for (byte b : buf) {
            RongHttpDnsUtil.appendHex(result, b);
        }
        return result.toString();
    }

    private static void appendHex(StringBuffer sb, byte b) {
        sb.append(HEX.charAt(b >> 4 & 0xF)).append(HEX.charAt(b & 0xF));
    }

    private static Key getRawKey(String key) throws Exception {
        DESKeySpec dks = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
        return keyFactory.generateSecret(dks);
    }

    static String encode(String data) {
        return RongHttpDnsUtil.encode(dynamickey, data.getBytes());
    }

    private static String encode(String key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec iv = new IvParameterSpec(IVPARAMETERSPEC.getBytes());
            cipher.init(1, RongHttpDnsUtil.getRawKey(key), iv);
            byte[] bytes = cipher.doFinal(data);
            return Base64.encodeToString((byte[])bytes, (int)0);
        }
        catch (Exception e) {
            return null;
        }
    }

    static String decode(String data) {
        return RongHttpDnsUtil.decode(dynamickey, Base64.decode((String)data, (int)0));
    }

    private static String decode(String key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            IvParameterSpec iv = new IvParameterSpec(IVPARAMETERSPEC.getBytes());
            cipher.init(2, RongHttpDnsUtil.getRawKey(key), iv);
            byte[] original = cipher.doFinal(data);
            return new String(original);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        dynamickey = RongHttpDnsUtil.generateKey();
        ipv4Pattern = Pattern.compile(IPV4_PATTERN);
    }
}

