/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.httpdns;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.text.TextUtils;
import io.rong.imlib.httpdns.HostCacheManager;
import io.rong.imlib.httpdns.HttpDnsClient;
import io.rong.imlib.httpdns.HttpDnsCompletion;
import io.rong.imlib.httpdns.Logger;
import io.rong.imlib.httpdns.RongHttpDnsResult;
import io.rong.imlib.httpdns.RongHttpDnsUtil;
import io.rong.imlib.httpdns.RongNetworkStateChangeReceiver;
import io.rong.imlib.httpdns.ThreadPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public final class RongHttpDns {
    private static volatile RongHttpDns httpDns;
    private final HttpDnsClient httpDnsClient;
    private final HostCacheManager httpDnsCache;
    private static final int ACCOUNT_ID_MAX_LEN = 64;
    private static final int SECRET_MAX_LEN = 64;
    private static final int SECRET_MIN_LEN = 8;
    private RongNetworkStateChangeReceiver networkStateChangeReceiver;
    private final Context context;
    private CachePolicy cachePolicy;
    private long preResolveStartTime;
    private long lastReqTimeForExpiredHosts;
    private int preResolveNum;
    private String[] hostWhiteList = new String[]{"nav.cn.ronghub.com", "rtc-info.ronghub.com"};

    private RongHttpDns(Context context) {
        this.httpDnsClient = HttpDnsClient.getInstance();
        this.httpDnsCache = new HostCacheManager("HTTPDNS", false);
        this.cachePolicy = CachePolicy.POLICY_TOLERANT;
        this.context = context;
        this.registerNetworkChangeReceiver();
        this.networkStateChangeReceiver.refreshIpReachable();
        this.lastReqTimeForExpiredHosts = System.currentTimeMillis();
    }

    private void registerNetworkChangeReceiver() {
        this.networkStateChangeReceiver = new RongNetworkStateChangeReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.context.registerReceiver((BroadcastReceiver)this.networkStateChangeReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RongHttpDns getService(Context context) {
        if (httpDns != null) return httpDns;
        Class<RongHttpDns> clazz = RongHttpDns.class;
        synchronized (RongHttpDns.class) {
            if (httpDns != null) return httpDns;
            httpDns = new RongHttpDns(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return httpDns;
        }
    }

    public void setCachePolicy(CachePolicy policy) {
        this.cachePolicy = policy;
        if (policy == CachePolicy.POLICY_STRICT) {
            this.httpDnsCache.setStrictCachePolicy(true);
        } else {
            this.httpDnsCache.setStrictCachePolicy(false);
        }
        Logger.printLog("Set cache policy to %s", policy.name());
    }

    public void setPreResolveTag(String tag) {
        if (tag == null || tag.isEmpty()) {
            Logger.printLog("Set pre resolve hosts error, get empty tag", new Object[0]);
            return;
        }
        ++this.preResolveNum;
        if (this.preResolveNum > 1) {
            Logger.printLog("You have already set PreResolveHosts, it is best to set it only once.", new Object[0]);
        }
        Logger.printLog(" Set preResolve tag : %s", tag);
        HttpDnsCompletion httpDnsCompletion = new HttpDnsCompletion(this.context);
        this.preResolveStartTime = System.currentTimeMillis();
        this.httpDnsClient.asyncSendRequest(tag, HttpDnsClient.RequestParamType.TAG_OF_HOSTS, httpDnsCompletion);
    }

    public void setPreResolveHosts(ArrayList<String> hosts, HttpDnsCompletion completion) {
        Iterator<String> iterator = hosts.iterator();
        while (iterator.hasNext()) {
            String host = iterator.next();
            if (!this.filterHostRequest(host)) continue;
            iterator.remove();
        }
        if (hosts.size() <= 0) {
            Logger.printLog("Set pre resolve hosts error, get empty hosts", new Object[0]);
            return;
        }
        hosts = new ArrayList<String>(new HashSet<String>(hosts));
        int maxHostNum = this.httpDnsClient.getMaxHostNum();
        if (hosts.size() > maxHostNum) {
            Logger.printLog("The current number of hosts is %d, and the max supported size is %s.Please reduce it to %s or less.", hosts.size(), maxHostNum, maxHostNum);
        } else {
            ++this.preResolveNum;
            if (this.preResolveNum > 1) {
                Logger.printLog("You have already set PreResolveHosts, it is best to set it only once.", new Object[0]);
            }
            this.preResolveStartTime = System.currentTimeMillis();
            StringBuilder str = new StringBuilder();
            for (int index = 0; index < hosts.size(); ++index) {
                str.append(hosts.get(index)).append(",");
            }
            if (str.length() > 0) {
                String hostsToSend = str.substring(0, str.length() - 1);
                Logger.printLog("Set pre resolve hosts: %s", hostsToSend);
                HttpDnsCompletion httpDnsCompletion = completion == null ? new HttpDnsCompletion(this.context) : completion;
                this.httpDnsClient.asyncSendRequest(hostsToSend, HttpDnsClient.RequestParamType.DNLIST_HOSTS, httpDnsCompletion);
            }
        }
    }

    public void setNetworkSwitchPolicy(boolean clearCache, boolean httpDnsPrefetch) {
        this.networkStateChangeReceiver.setClearCache(clearCache);
        this.networkStateChangeReceiver.setHttpDnsPrefetch(httpDnsPrefetch);
        Logger.printLog("Set network change policy, clearCache(%b), httpDnsPrefetch(%b)", clearCache, httpDnsPrefetch);
    }

    public void setAccountID(String accountID) {
        if (accountID.length() > 64) {
            throw new IllegalArgumentException("accountID length(" + accountID.length() + ") is bigger than 64");
        }
        this.httpDnsClient.setAccountID(accountID);
    }

    public void setSecret(String secret) {
        int len = secret.length();
        if (len > 64 || len < 8) {
            throw new IllegalArgumentException("secret length(" + secret.length() + ") check failed");
        }
        this.httpDnsClient.setSecret(secret);
    }

    public RongHttpDnsResult syncResolve(String host) {
        if (RongHttpDnsUtil.validateIpv4(host)) {
            ArrayList<String> ipv4List = new ArrayList<String>();
            ipv4List.add(host);
            return new RongHttpDnsResult(RongHttpDnsResult.ResolveType.RESOLVE_NONEED, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, ipv4List, null);
        }
        if (RongHttpDnsUtil.validateIpv6(host)) {
            ArrayList<String> ipv6List = new ArrayList<String>();
            host = host.replaceAll("[\\[\\]]", "");
            ipv6List.add(host);
            return new RongHttpDnsResult(RongHttpDnsResult.ResolveType.RESOLVE_NONEED, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, null, ipv6List);
        }
        RongHttpDnsResult.ResolveType resolveType = RongHttpDnsResult.ResolveType.RESOLVE_NONE;
        HostCacheManager.HostEntry httpDnsEntry = this.httpDnsCache.getHostCacheEntry(host);
        if (httpDnsEntry != null) {
            resolveType = httpDnsEntry.isExpired() ? RongHttpDnsResult.ResolveType.RESOLVE_FROM_HTTPDNS_EXPIRED_CACHE : RongHttpDnsResult.ResolveType.RESOLVE_FROM_HTTPDNS_CACHE;
            Logger.printLog("Sync resolve successful, host(%s) ipv4List(%s) ipv6List(null) resolveType(%s)", host, httpDnsEntry.getIpv4List().toString(), resolveType.toString());
            return new RongHttpDnsResult(resolveType, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, httpDnsEntry.getIpv4List(), httpDnsEntry.getIpv6List(), httpDnsEntry.getClientIp());
        }
        Logger.printLog("Sync resolve failed, host(%s), find no httpdns cache entry", host);
        return new RongHttpDnsResult(resolveType, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveErrorCacheMiss, null, null);
    }

    public void asyncResolve(String host, final CompletionHandler callback, HttpDnsCompletion completion) {
        if (RongHttpDnsUtil.validateIpv4(host)) {
            final ArrayList<String> ipv4List = new ArrayList<String>();
            ipv4List.add(host);
            ThreadPool.getInstance().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    callback.completionHandler(new RongHttpDnsResult(RongHttpDnsResult.ResolveType.RESOLVE_NONEED, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, ipv4List, null));
                }
            });
            return;
        }
        if (RongHttpDnsUtil.validateIpv6(host)) {
            final ArrayList<String> ipv6List = new ArrayList<String>();
            host = host.replaceAll("[\\[\\]]", "");
            ipv6List.add(host);
            ThreadPool.getInstance().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    callback.completionHandler(new RongHttpDnsResult(RongHttpDnsResult.ResolveType.RESOLVE_NONEED, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, null, ipv6List));
                }
            });
            return;
        }
        final HostCacheManager.HostEntry httpDnsEntry = this.httpDnsCache.getHostCacheEntry(host);
        long curTime = System.currentTimeMillis();
        ArrayList<String> hostsToSend = new ArrayList<String>();
        if (this.allowSendRequest(curTime)) {
            if (httpDnsEntry == null || httpDnsEntry.isExpired()) {
                hostsToSend.add(host);
            }
            HttpDnsCompletion httpDnsCompletion = completion == null ? new HttpDnsCompletion(this.context) : completion;
            this.httpDnsClient.splitHostsAndSendRequest(hostsToSend, httpDnsCompletion);
        } else {
            Logger.printLog("please wait a moment to send request for %s, until preResolve finished or has passed 1000ms ", host);
        }
        if (httpDnsEntry != null) {
            final RongHttpDnsResult.ResolveType resolveType = httpDnsEntry.isExpired() ? RongHttpDnsResult.ResolveType.RESOLVE_FROM_HTTPDNS_EXPIRED_CACHE : RongHttpDnsResult.ResolveType.RESOLVE_FROM_HTTPDNS_CACHE;
            Logger.printLog("Async resolve successful, host(%s) ipv4List(%s) resolveType(%s)", host, httpDnsEntry.getIpv4List().toString(), resolveType.toString());
            ThreadPool.getInstance().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    callback.completionHandler(new RongHttpDnsResult(resolveType, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK, httpDnsEntry.getIpv4List(), null));
                }
            });
        } else {
            Logger.printLog("Async resolve failed, host(%s), find no httpdns cache entry ", host);
            ThreadPool.getInstance().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    callback.completionHandler(new RongHttpDnsResult(RongHttpDnsResult.ResolveType.RESOLVE_NONE, RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveErrorCacheMiss, null, null));
                }
            });
        }
    }

    private boolean filterHostRequest(String host) {
        return !TextUtils.isEmpty((CharSequence)host) && !Arrays.asList(this.hostWhiteList).contains(host);
    }

    private boolean allowSendRequest(long curTime) {
        return this.httpDnsClient.getPreResolveFinish() || curTime - this.preResolveStartTime > 1000L && !this.networkStateChangeReceiver.isIPv6Only();
    }

    public void setHttpsRequestEnable(boolean httpsEnabled) {
        this.httpDnsClient.setHttps(httpsEnabled);
        Logger.printLog("Set https enabled to %b", httpsEnabled);
    }

    public void setLogEnable(boolean debugEnabled) {
        Logger.setLogEnable(debugEnabled);
        Logger.printLog("Set debug log enabled to %b", debugEnabled);
    }

    public void setServerIp(String defaultServerIp) {
        this.httpDnsClient.setDefaultServerIp(defaultServerIp);
    }

    RongNetworkStateChangeReceiver getNetworkStateChangeReceiver() {
        return this.networkStateChangeReceiver;
    }

    HostCacheManager getHttpDnsCache() {
        return this.httpDnsCache;
    }

    CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    HttpDnsClient getHttpDnsClient() {
        return this.httpDnsClient;
    }

    int getPreResolveNum() {
        return this.preResolveNum;
    }

    public static interface CompletionHandler {
        public void completionHandler(RongHttpDnsResult var1);
    }

    public static enum CachePolicy {
        POLICY_AGGRESSIVE,
        POLICY_TOLERANT,
        POLICY_STRICT;

    }
}

