/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.httpdns;

import android.content.Context;
import android.util.Log;
import io.rong.imlib.httpdns.HostCacheManager;
import io.rong.imlib.httpdns.HttpDnsClient;
import io.rong.imlib.httpdns.Logger;
import io.rong.imlib.httpdns.RongHttpDns;
import java.util.ArrayList;
import java.util.Map;

public class HttpDnsCompletion
implements HttpDnsClient.AsyncHttpDnsCompletion {
    private static final String TAG = "HttpDnsCompletion";
    private final HostCacheManager httpDnsCache;
    private final RongHttpDns httpDns;
    private final RongHttpDns.CachePolicy cachePolicy;
    private final HttpDnsClient httpDnsClient;

    public HttpDnsCompletion(Context context) {
        this.httpDns = RongHttpDns.getService(context);
        this.httpDnsCache = this.httpDns.getHttpDnsCache();
        this.cachePolicy = this.httpDns.getCachePolicy();
        this.httpDnsClient = this.httpDns.getHttpDnsClient();
    }

    @Override
    public void callback(int ret, HttpDnsClient.RequestParamType requestParamType, Map<String, HttpDnsClient.Result> resultsMap, String hostsOrTag) {
        switch (ret) {
            case 0: {
                for (Map.Entry<String, HttpDnsClient.Result> resultMap : resultsMap.entrySet()) {
                    String singleHost = resultMap.getKey();
                    HttpDnsClient.Result result = resultMap.getValue();
                    if (result != null) {
                        HostCacheManager.HostEntry hostEntry = new HostCacheManager.HostEntry();
                        hostEntry.setTtl(result.getTtl());
                        hostEntry.setQueryTime(System.currentTimeMillis() / 1000L);
                        hostEntry.setIpv4List(result.getIpv4List());
                        hostEntry.setClientIp(result.getClientIp());
                        this.httpDnsCache.setHostCacheEntry(singleHost, hostEntry);
                        this.onSuccess(result.getIpv4List());
                        continue;
                    }
                    if (this.cachePolicy == RongHttpDns.CachePolicy.POLICY_TOLERANT) {
                        this.httpDnsCache.removeExpiredEntry(singleHost);
                    }
                    this.onFailed(-1);
                }
                break;
            }
            case -1: {
                if (requestParamType.equals((Object)HttpDnsClient.RequestParamType.DNLIST_HOSTS) && this.cachePolicy == RongHttpDns.CachePolicy.POLICY_TOLERANT) {
                    String[] hosts;
                    for (String singleHost : hosts = hostsOrTag.split(",")) {
                        this.httpDnsCache.removeExpiredEntry(singleHost);
                    }
                }
                this.onFailed(-1);
                break;
            }
            default: {
                this.onFailed(-1);
                Logger.printLog("Internal error: async httpdns resolve completion get error ret(%d)", ret);
            }
        }
        if (this.httpDns.getPreResolveNum() > 0 && !this.httpDnsClient.getPreResolveFinish()) {
            this.httpDnsClient.setPreResolveFinish(true);
            Logger.printLog("preResolve has finished", new Object[0]);
        }
    }

    protected void onSuccess(ArrayList<String> hosts) {
        Log.i((String)TAG, (String)"onSuccess()");
    }

    protected void onFailed(int code) {
        Log.i((String)TAG, (String)"onFailed()");
    }
}

