/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.httpdns;

import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.httpdns.Logger;
import io.rong.imlib.httpdns.RongHttpDnsUtil;
import io.rong.imlib.httpdns.ThreadPool;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class HttpDnsClient {
    private static final String TAG = "HttpDnsClient";
    private static volatile HttpDnsClient httpDnsClient;
    private static final int timeOut = 3000;
    private static final int kDftSignatureTime = 300;
    private static boolean isSecretEncrypted;
    private String defaultServerIp = "180.76.76.200";
    private static final String serverDomain = "httpdns.baidubce.com";
    private static HttpDnsHostnameVerifier httpDnsHostnameVerifier;
    private boolean isHttps = true;
    private long repairLocalClock = 0L;
    private final HashSet<String> hostsToResolve;
    private final Object hostToResolveLock;
    private final Object hostsExpiredLock = new Object();
    private ArrayList<String> hostsExpired = new ArrayList();
    private String accountID = "";
    private String secret = "";
    private static final String sdkVersion = "1.3";
    private static final String osType = "android";
    static final int HTTPDNS_RESOLVE_OK = 0;
    static final int HTTPDNS_RESOLVE_ERR = -1;
    private static final int RSP_DATA_NULL = 101;
    private static final int SIGN_EXPIRED = 102;
    private static final int RESOLVE_DNS_ERR = 103;
    private boolean preResolveFinish = false;
    private int maxHostNum = 10;

    private HttpDnsClient() {
        this.hostToResolveLock = new Object();
        this.hostsToResolve = new HashSet();
        httpDnsHostnameVerifier = new HttpDnsHostnameVerifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static HttpDnsClient getInstance() {
        if (httpDnsClient != null) return httpDnsClient;
        Class<HttpDnsClient> clazz = HttpDnsClient.class;
        synchronized (HttpDnsClient.class) {
            if (httpDnsClient != null) return httpDnsClient;
            httpDnsClient = new HttpDnsClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpDnsClient;
        }
    }

    private String calcSign(String host, long t) {
        String secret = this.getSecret();
        String origin = String.format("%s-%s-%d", host, secret, t);
        return RongHttpDnsUtil.md5(origin);
    }

    private String getStringFromInputStream(InputStream in, HttpURLConnection conn) {
        String encoding = conn.getContentEncoding();
        try {
            String line;
            if (encoding != null && encoding.contains("gzip")) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                int size = conn.getContentLength();
                if (size > 0) {
                    byte[] buffer = new byte[size];
                    int count = in.read(buffer);
                    if (count != -1) {
                        output.write(buffer, 0, count);
                    }
                } else {
                    int n;
                    size = 1024;
                    byte[] buffer = new byte[size];
                    while (-1 != (n = in.read(buffer))) {
                        output.write(buffer, 0, n);
                    }
                }
                output.flush();
                output.close();
                byte[] gzipBuffer = output.toByteArray();
                return this.getStringFromGzip(gzipBuffer, size);
            }
            BufferedReader streamReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            StringBuilder rspData = new StringBuilder();
            while ((line = streamReader.readLine()) != null) {
                rspData.append(line);
            }
            streamReader.close();
            return rspData.toString();
        }
        catch (UnsupportedEncodingException e) {
            RLog.e(TAG, "getStringFromInputStream UnsupportedEncodingException", e);
            return null;
        }
        catch (IOException e) {
            RLog.e(TAG, "getStringFromInputStream IOException", e);
            return null;
        }
    }

    private String getStringFromGzip(byte[] gzipBuffer, int size) {
        byte[] buffer = new byte[size];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(gzipBuffer);
        try {
            int n;
            GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)inputStream, size);
            do {
                n = gzipInputStream.read(buffer, 0, size);
                out.write(buffer, 0, n);
            } while (n != -1 && !HttpDnsClient.isJson(out.toString()));
            gzipInputStream.close();
            return out.toString();
        }
        catch (IOException e) {
            RLog.e(TAG, "getStringFromGzip IOException", e);
            return null;
        }
    }

    private static boolean isJson(String value) {
        try {
            new JSONObject(value);
        }
        catch (JSONException e) {
            return false;
        }
        return true;
    }

    int getMaxHostNum() {
        return this.maxHostNum;
    }

    private Map checkRspMsg(String rspData, String hostNameOrTag, RequestParamType requestParamType) {
        JSONObject json;
        HashMap<String, Boolean> rspMsgMap = new HashMap<String, Boolean>();
        rspMsgMap.put("isMsgOK", false);
        rspMsgMap.put("isSignExpired", false);
        try {
            json = new JSONObject(rspData);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Logger.printLog("Httpdns request failed for %s(%s), response parse json error", requestParamType.toString(), hostNameOrTag);
            return rspMsgMap;
        }
        String msg = json.optString("msg");
        if (msg == null || msg.isEmpty()) {
            Logger.printLog("Httpdns request failed for %s(%s), response lack of msg", requestParamType.toString(), hostNameOrTag);
            return rspMsgMap;
        }
        if ("SignatureExpired".equals(msg)) {
            int timeStamp = json.optInt("timestamp");
            if (timeStamp == 0) {
                Logger.printLog("Httpdns request failed for %s(%s), response get invalid timestamp", requestParamType.toString(), hostNameOrTag);
            } else {
                this.repairLocalClock = (long)timeStamp - System.currentTimeMillis() / 1000L;
                rspMsgMap.put("isSignExpired", true);
            }
            return rspMsgMap;
        }
        if (!"ok".equals(msg)) {
            Logger.printLog("Httpdns request failed for %s(%s), response msg(%s) is not ok", requestParamType.toString(), hostNameOrTag, msg);
            return rspMsgMap;
        }
        rspMsgMap.put("isMsgOK", true);
        return rspMsgMap;
    }

    private Map parseRspData(String rspData, String hostsOrTag) {
        JSONObject dataObj;
        JSONObject json;
        HashMap<String, Result> resultsMap = new HashMap<String, Result>();
        try {
            json = new JSONObject(rspData);
        }
        catch (JSONException e) {
            e.printStackTrace();
            Logger.printLog("Httpdns request failed, hostsOrTag(%s), response parse data json error", hostsOrTag);
            return null;
        }
        String clientIp = null;
        if (json.has("clientip")) {
            try {
                clientIp = json.getString("clientip");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if ((dataObj = json.optJSONObject("data")) == null) {
            Logger.printLog("Httpdns request failed, hostsOrTag(%s), response has empty data", hostsOrTag);
            return null;
        }
        int totalParsed = 0;
        Iterator iterator = dataObj.keys();
        while (iterator.hasNext()) {
            long ttl;
            String hostKey = (String)iterator.next();
            JSONObject hostObj = dataObj.optJSONObject(hostKey);
            JSONObject ipv4Obj = hostObj.optJSONObject("ipv4");
            JSONArray ips = ipv4Obj.optJSONArray("ip");
            if (ips == null || ips.length() == 0) {
                Logger.printLog("Httpdns request failed, host(%s), response has no ip field", hostKey);
                resultsMap.put(hostKey, null);
                continue;
            }
            ArrayList<String> ipv4List = new ArrayList<String>();
            for (int i = 0; i < ips.length(); ++i) {
                String ip = ips.optString(i);
                if (ip == null || ip.isEmpty()) {
                    Logger.printLog("Httpdns request warning, host(%s), response get ip error", hostKey);
                    continue;
                }
                if (!RongHttpDnsUtil.validateIpv4(ip)) {
                    Logger.printLog("Httpdns request warning, host(%s), response get invalid ip(%s)", hostKey, ip);
                    continue;
                }
                ipv4List.add(ip);
            }
            if (ipv4List.isEmpty()) {
                Logger.printLog("Httpdns request failed, host(%s), response has no valid ip", hostKey);
                resultsMap.put(hostKey, null);
                continue;
            }
            try {
                ttl = ipv4Obj.getLong("ttl");
            }
            catch (JSONException e) {
                e.printStackTrace();
                Logger.printLog("Httpdns request failed, host(%s), response has no ttl", hostKey);
                return null;
            }
            if (ttl < 0L) {
                Logger.printLog("Httpdns request failed, host(%s), response has invalid ttl(%s)", hostKey, ttl);
                resultsMap.put(hostKey, null);
                continue;
            }
            Result result = new Result(ipv4List, ttl, clientIp);
            resultsMap.put(hostKey, result);
            ++totalParsed;
        }
        if (totalParsed == 0) {
            return null;
        }
        return resultsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncSendRequest(String hostsOrTag, RequestParamType requestParamType, AsyncHttpDnsCompletion httpDnsCompletion) {
        if (hostsOrTag == null || hostsOrTag.isEmpty()) {
            return;
        }
        Object object = this.hostToResolveLock;
        synchronized (object) {
            if (requestParamType.equals((Object)RequestParamType.DNLIST_HOSTS)) {
                ArrayList<String> hosts = new ArrayList<String>(Arrays.asList(hostsOrTag.split(",")));
                Iterator it = hosts.iterator();
                while (it.hasNext()) {
                    String singleHost = (String)it.next();
                    if (!this.hostsToResolve.contains(singleHost)) {
                        this.hostsToResolve.add(singleHost);
                        continue;
                    }
                    Logger.printLog("Httpdns request request for host(%s) is in processing\uff0cwill exclude it.", singleHost);
                    it.remove();
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < hosts.size(); ++i) {
                    sb.append((String)hosts.get(i)).append(",");
                }
                String regex = "^,*|,*$";
                hostsOrTag = sb.toString().replaceAll(regex, "");
            }
            if (!hostsOrTag.isEmpty()) {
                try {
                    ThreadPool.getInstance().getExecutor().execute(new AsyncHttpTask(hostsOrTag, requestParamType, httpDnsCompletion));
                }
                catch (RejectedExecutionException e) {
                    RLog.e(TAG, "asyncSendRequest RejectedExecutionException", e);
                    Logger.printLog("Httpdns request failed, host(%s), async tasks has exceed the maximum thread limit.", hostsOrTag);
                }
            }
        }
    }

    void splitHostsAndSendRequest(ArrayList<String> hosts, AsyncHttpDnsCompletion httpDnsCompletion) {
        hosts = new ArrayList<String>(new HashSet<String>(hosts));
        int prefetchNum = 0;
        int currNum = 0;
        while (currNum < hosts.size()) {
            StringBuilder strBuilder = new StringBuilder();
            for (int index = 0; index < this.maxHostNum && (currNum = index + prefetchNum * this.maxHostNum) < hosts.size(); ++index) {
                strBuilder.append(hosts.get(currNum)).append(",");
            }
            String str = strBuilder.toString();
            ++prefetchNum;
            if (str.length() <= 0) continue;
            String hostsToSend = str.substring(0, str.length() - 1);
            Logger.printLog("Hosts for httpdns request is (%s) ", hostsToSend);
            this.asyncSendRequest(hostsToSend, RequestParamType.DNLIST_HOSTS, httpDnsCompletion);
        }
    }

    void setHttps(boolean isHttps) {
        this.isHttps = isHttps;
    }

    boolean isHttps() {
        return this.isHttps;
    }

    void setAccountID(String accountID) {
        this.accountID = accountID;
    }

    String getAccountID() {
        return this.accountID;
    }

    void setSecret(String secret) {
        this.secret = RongHttpDnsUtil.encode(secret);
        if (this.secret == null) {
            this.secret = secret;
            isSecretEncrypted = false;
        }
    }

    void setDefaultServerIp(String defaultServerIp) {
        this.defaultServerIp = defaultServerIp;
    }

    private String getSecret() {
        if (!isSecretEncrypted) {
            return this.secret;
        }
        return RongHttpDnsUtil.decode(this.secret);
    }

    long getRepairLocalClock() {
        return this.repairLocalClock;
    }

    boolean getPreResolveFinish() {
        return this.preResolveFinish;
    }

    void setPreResolveFinish(boolean isFinish) {
        this.preResolveFinish = isFinish;
    }

    static {
        isSecretEncrypted = true;
    }

    private class AsyncHttpTask
    implements Runnable {
        private String hostsOrTag;
        private RequestParamType requestParamType;
        private AsyncHttpDnsCompletion httpDnsCompletion;
        private boolean needRetryBySignExpired;

        AsyncHttpTask(String hostsOrTag, RequestParamType requestParamType, AsyncHttpDnsCompletion httpDnsCompletion) {
            this.hostsOrTag = hostsOrTag;
            this.requestParamType = requestParamType;
            this.httpDnsCompletion = httpDnsCompletion;
            this.needRetryBySignExpired = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String[] hosts;
            this.startResolveRequest();
            if (this.needRetryBySignExpired) {
                Logger.printLog("Retry for %s(%s).", this.requestParamType.toString(), this.hostsOrTag);
                this.startResolveRequest();
            }
            Object object = HttpDnsClient.this.hostToResolveLock;
            synchronized (object) {
                if (!this.requestParamType.equals((Object)RequestParamType.TAG_OF_HOSTS)) {
                    for (String singleHost : hosts = this.hostsOrTag.split(",")) {
                        HttpDnsClient.this.hostsToResolve.remove(singleHost);
                    }
                }
            }
            object = HttpDnsClient.this.hostsExpiredLock;
            synchronized (object) {
                if (this.requestParamType.equals((Object)RequestParamType.DNLIST_HOSTS)) {
                    for (String singleHost : hosts = this.hostsOrTag.split(",")) {
                        HttpDnsClient.this.hostsExpired.remove(singleHost);
                    }
                }
            }
        }

        private void startResolveRequest() {
            String url = this.getHttpDnsUrl(this.hostsOrTag, this.requestParamType);
            if (url == null) {
                this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
                Logger.printLog("Httpdns request failed for  %s(%s), get url error", this.requestParamType.toString(), this.hostsOrTag);
                return;
            }
            this.httpGet(url);
        }

        private String getHttpDnsUrl(String host, RequestParamType requestParamType) {
            long t = System.currentTimeMillis() / 1000L + 300L + HttpDnsClient.this.repairLocalClock;
            String sign = HttpDnsClient.this.calcSign(host, t);
            if (sign == null) {
                return null;
            }
            String serverIP = HttpDnsClient.this.defaultServerIp;
            Logger.printLog("Using BGPServerIp(%s)", HttpDnsClient.this.defaultServerIp);
            String uri = requestParamType.equals((Object)RequestParamType.TAG_OF_HOSTS) ? String.format("%s/v4/resolve?account_id=%s&tag=%s&sign=%s&t=%d&sdk_ver=%s&os_type=%s&alt_server_ip=true", serverIP, HttpDnsClient.this.accountID, host, sign, t, HttpDnsClient.sdkVersion, HttpDnsClient.osType) : String.format("%s/v4/resolve?account_id=%s&dn=%s&sign=%s&t=%d&sdk_ver=%s&os_type=%s&alt_server_ip=true", serverIP, HttpDnsClient.this.accountID, host, sign, t, HttpDnsClient.sdkVersion, HttpDnsClient.osType);
            String url = HttpDnsClient.this.isHttps ? String.format("https://%s", uri) : String.format("http://%s", uri);
            return url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void httpGet(String url) {
            HttpURLConnection conn = null;
            Map<String, Result> resultsMap = new HashMap<String, Result>();
            long preResolveStartTime = 0L;
            try {
                URL mURL = new URL(url);
                if (HttpDnsClient.this.isHttps) {
                    HttpsURLConnection httpsConn = (HttpsURLConnection)mURL.openConnection();
                    httpsConn.setRequestProperty("Host", HttpDnsClient.serverDomain);
                    httpsConn.setHostnameVerifier(httpDnsHostnameVerifier);
                    conn = httpsConn;
                } else {
                    conn = (HttpURLConnection)mURL.openConnection();
                }
                conn.setRequestMethod("GET");
                conn.setReadTimeout(3000);
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("connection", "Keep-Alive");
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                FwLog.write(3, 1, FwLog.LogTag.L_DOH_T.getTag(), "nav", this.hostsOrTag);
                preResolveStartTime = System.currentTimeMillis();
                conn.connect();
                int responseCode = conn.getResponseCode();
                InputStream in = responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream();
                if (in != null) {
                    String rspData = HttpDnsClient.this.getStringFromInputStream(in, conn);
                    if (rspData == null) {
                        Logger.printLog("HttpDns request failed for %s(%s), get empty response data", this.requestParamType.toString(), this.hostsOrTag);
                        long curTime = System.currentTimeMillis();
                        long timeSpan = curTime - preResolveStartTime;
                        FwLog.write(2, 1, FwLog.LogTag.L_DOH_R.getTag(), "error|duration", 101, timeSpan);
                        this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
                        return;
                    }
                    Map rspMsgMap = HttpDnsClient.this.checkRspMsg(rspData, this.hostsOrTag, this.requestParamType);
                    if (rspMsgMap.get("isSignExpired").equals(true)) {
                        long curTime = System.currentTimeMillis();
                        long timeSpan = curTime - preResolveStartTime;
                        FwLog.write(2, 1, FwLog.LogTag.L_DOH_R.getTag(), "error|duration", 102, timeSpan);
                        this.needRetryBySignExpired = true;
                        return;
                    }
                    if (rspMsgMap.get("isMsgOK").equals(true) && responseCode == 200) {
                        resultsMap = HttpDnsClient.this.parseRspData(rspData, this.hostsOrTag);
                    } else {
                        this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
                    }
                } else {
                    Logger.printLog("HttpDns request failed for %s(%s), get null response stream", this.requestParamType.toString(), this.hostsOrTag);
                    this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
                }
            }
            catch (IOException e) {
                RLog.e(HttpDnsClient.TAG, "httpGet IOException", e);
                this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(HttpDnsClient.TAG, "httpGet ArrayIndexOutOfBoundsException", e);
                this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
            }
            catch (IllegalStateException e) {
                RLog.e(HttpDnsClient.TAG, "httpGet IllegalStateException", e);
                this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            long curTime = System.currentTimeMillis();
            long timeSpan = curTime - preResolveStartTime;
            if (resultsMap == null || resultsMap.isEmpty() || resultsMap.get(this.hostsOrTag) == null) {
                FwLog.write(2, 1, FwLog.LogTag.L_DOH_R.getTag(), "error|duration", 103, timeSpan);
                this.httpDnsCompletion.callback(-1, this.requestParamType, null, this.hostsOrTag);
            } else {
                ArrayList<String> ipv4List = ((Result)resultsMap.get(this.hostsOrTag)).getIpv4List();
                if (ipv4List == null || ipv4List.isEmpty()) {
                    FwLog.write(2, 1, FwLog.LogTag.L_DOH_R.getTag(), "error|duration", 103, timeSpan);
                    this.httpDnsCompletion.callback(-1, this.requestParamType, resultsMap, this.hostsOrTag);
                    return;
                }
                FwLog.write(3, 1, FwLog.LogTag.L_DOH_R.getTag(), "nav|ip|duration", this.hostsOrTag, ipv4List.get(0), timeSpan);
                this.httpDnsCompletion.callback(0, this.requestParamType, resultsMap, this.hostsOrTag);
            }
        }
    }

    public class Result {
        private final ArrayList<String> ipv4List;
        private final long ttl;
        private final String clientIp;

        Result(ArrayList<String> ipv4List, long ttl, String clientIp) {
            this.ipv4List = ipv4List;
            this.ttl = ttl;
            this.clientIp = clientIp;
        }

        ArrayList<String> getIpv4List() {
            return this.ipv4List;
        }

        long getTtl() {
            return this.ttl;
        }

        String getClientIp() {
            return this.clientIp;
        }
    }

    private class HttpDnsHostnameVerifier
    implements HostnameVerifier {
        private HttpDnsHostnameVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(HttpDnsClient.serverDomain, sslSession);
        }
    }

    static interface AsyncHttpDnsCompletion {
        public void callback(int var1, RequestParamType var2, Map<String, Result> var3, String var4);
    }

    public static enum RequestParamType {
        DNLIST_HOSTS,
        TAG_OF_HOSTS;

    }
}

