/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer.upload.uploader;

import android.os.Build;
import android.security.NetworkSecurityPolicy;
import io.rong.imlib.NativeObject;
import io.rong.imlib.filetransfer.Call;
import io.rong.imlib.filetransfer.CallDispatcher;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.Request;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.filetransfer.upload.FilePlatformInfo;
import io.rong.imlib.filetransfer.upload.MediaUploadEngine;
import io.rong.imlib.filetransfer.upload.uploader.AliMediaUploader;
import io.rong.imlib.filetransfer.upload.uploader.BDMediaUploader;
import io.rong.imlib.filetransfer.upload.uploader.IMediaUploader;
import io.rong.imlib.filetransfer.upload.uploader.PrivateMediaUploader;
import io.rong.imlib.filetransfer.upload.uploader.QiniuMediaUploader;

public abstract class BaseMediaUploader
implements RequestCallBack,
IMediaUploader {
    private static final String TAG = BaseMediaUploader.class.getSimpleName();
    protected NativeObject nativeObj;
    protected FilePlatformInfo platform;
    protected Configuration configuration;
    public RequestOption.Upload option;
    public MediaUploadEngine.IMediaUploadResultCallback callback;
    private Request request;

    public BaseMediaUploader(BaseBuilder builder) {
        this.platform = builder.platform;
        this.nativeObj = builder.nativeObj;
        this.configuration = this.getConfiguration() != null ? this.getConfiguration() : new Configuration.Builder().connectTimeout(30).readTimeout(60).build();
        this.option = builder.option;
    }

    protected abstract Configuration getConfiguration();

    @Override
    public void run(CallDispatcher dispatcher, MediaUploadEngine.IMediaUploadResultCallback callback) {
        this.callback = callback;
        this.request = this.buildRequest();
        Call call = Call.create(dispatcher, this.request);
        call.enqueue();
    }

    protected String handleURL(String url) {
        if (!url.toLowerCase().startsWith("http")) {
            url = (Build.VERSION.SDK_INT >= 28 && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted() ? "https://" : "http://") + url;
        }
        return url;
    }

    @Override
    public void onError(int code) {
        if (this.callback != null) {
            this.callback.onError(code, this.platform.getHost());
        }
    }

    @Override
    public void onComplete(final String url) {
        this.buildDownloadUrl(url, new IGetUrlResultCallback(){

            @Override
            public void onSuccess(String url2) {
                if (BaseMediaUploader.this.callback != null) {
                    BaseMediaUploader.this.callback.onComplete(url2);
                }
            }

            @Override
            public void onError(int errorCode) {
                if (BaseMediaUploader.this.callback != null) {
                    BaseMediaUploader.this.callback.onError(errorCode, url);
                }
            }
        });
    }

    @Override
    public void onProgress(int progress) {
        if (this.callback != null) {
            this.callback.onProgress(progress);
        }
    }

    @Override
    public void onCanceled(Object tag) {
        if (this.callback != null) {
            this.callback.onCanceled(tag, this.request.serverIp);
        }
    }

    public static class Factory {
        private FilePlatformInfo platform;
        NativeObject nativeObj;
        RequestOption.Upload option;

        public Factory(FilePlatformInfo platform, NativeObject nativeObj, RequestOption.Upload option) {
            this.platform = platform;
            this.nativeObj = nativeObj;
            this.option = option;
        }

        public BaseMediaUploader create(FtConst.ServiceType type) {
            BaseMediaUploader uploader = null;
            switch (type) {
                case QI_NIU: {
                    uploader = QiniuMediaUploader.newBuilder(this.platform, this.nativeObj, this.option).build();
                    break;
                }
                case BAI_DU: {
                    uploader = BDMediaUploader.newBuilder(this.platform, this.nativeObj, this.option).build();
                    break;
                }
                case ALI_OSS: {
                    uploader = AliMediaUploader.newBuilder(this.platform, this.nativeObj, this.option).build();
                    break;
                }
                case PRIVATE_CLOUD: {
                    uploader = PrivateMediaUploader.newBuilder(this.platform, this.nativeObj, this.option).build();
                    break;
                }
            }
            return uploader;
        }

        public static Factory params(FilePlatformInfo platform, NativeObject nativeObj, RequestOption.Upload option) {
            return new Factory(platform, nativeObj, option);
        }
    }

    public static abstract class BaseBuilder<T> {
        private RequestOption.Upload option;
        public FilePlatformInfo platform;
        public NativeObject nativeObj;

        public BaseBuilder(FilePlatformInfo platform, NativeObject nativeObj, RequestOption.Upload option) {
            this.platform = platform;
            this.nativeObj = nativeObj;
            this.option = option;
        }
    }

    public static interface IGetUrlResultCallback {
        public void onSuccess(String var1);

        public void onError(int var1);
    }
}

