/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer.upload.uploader;

import io.rong.common.FileInfo;
import io.rong.common.FileUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.filetransfer.AliUploadRequest;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.Request;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.filetransfer.upload.FilePlatformInfo;
import io.rong.imlib.filetransfer.upload.uploader.BaseMediaUploader;

public class AliMediaUploader
extends BaseMediaUploader {
    private static final String TAG = AliMediaUploader.class.getSimpleName();

    public AliMediaUploader(BaseMediaUploader.BaseBuilder builder) {
        super(builder);
    }

    @Override
    protected Configuration getConfiguration() {
        return null;
    }

    public static Builder newBuilder(FilePlatformInfo platform, NativeObject nativeObj, RequestOption.Upload option) {
        return new Builder(platform, nativeObj, option);
    }

    @Override
    public void buildDownloadUrl(String url, final BaseMediaUploader.IGetUrlResultCallback buildUrlCallback) {
        FileInfo fileInfo = FileUtils.getFileInfoByUri(NativeClient.getApplicationContext(), this.option.fileUri);
        FwLog.write(3, 1, "L-media_url-T", "type", "A");
        this.nativeObj.GetDownloadUrl(this.option.getMimeType().getValue(), this.option.getFileName(), fileInfo.getName(), new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    FwLog.write(3, 1, "L-media_url-R", "type|code", "A", 0);
                    buildUrlCallback.onSuccess(token);
                } else {
                    FwLog.write(3, 1, "L-media_url-R", "type|code", "A", errorCode);
                    RLog.d(TAG, "GetDownloadUrl onError code =" + errorCode);
                    buildUrlCallback.onError(errorCode);
                }
            }
        }, true);
    }

    @Override
    public Request buildRequest() {
        AliUploadRequest request = new AliUploadRequest(this.configuration, this);
        request.setContext(NativeClient.getApplicationContext());
        request.ossAccessKeyId = this.option.authorInfo.getOssAccessKeyId();
        request.signature = this.option.authorInfo.getSignature();
        request.policy = this.option.authorInfo.getPolicy();
        request.mimeType = this.option.getMimeType();
        request.method = "POST";
        request.serverIp = this.handleURL(this.option.authorInfo.getBucketName() + "." + this.option.getServerIp());
        request.fileUri = this.option.fileUri.toString();
        request.tag = this.option.getMessageId();
        request.fileName = this.option.getFileName();
        request.isMessage = true;
        return request;
    }

    public static final class Builder
    extends BaseMediaUploader.BaseBuilder<Builder> {
        private Builder(FilePlatformInfo uploadUrl, NativeObject nativeObj, RequestOption.Upload option) {
            super(uploadUrl, nativeObj, option);
        }

        public AliMediaUploader build() {
            return new AliMediaUploader(this);
        }
    }
}

