/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer.upload;

import android.net.Uri;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import io.rong.common.FileInfo;
import io.rong.common.FileUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.FtUtilities;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.filetransfer.upload.AbstractMediaFileService;
import io.rong.imlib.filetransfer.upload.FilePlatformInfo;
import io.rong.imlib.filetransfer.upload.MediaUploadAuthorInfo;
import io.rong.imlib.filetransfer.upload.uploader.BaseMediaUploader;
import io.rong.imlib.model.Message;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MediaUploadEngine
extends AbstractMediaFileService {
    private static final String TAG = MediaUploadEngine.class.getSimpleName();
    private static MediaUploadEngine mInstance;
    private Hashtable<Integer, Integer> cacheProgress = new Hashtable();

    private MediaUploadEngine() {
    }

    public static MediaUploadEngine getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void uploadMedia(final Handler workHandler, final NativeObject nativeObj, final Message message, final Uri uriToFile, final String enterServer, final NativeClient.IResultProgressCallback<String> callback) {
        final FileInfo fileInfo = FileUtils.getFileInfoByUri(NativeClient.getApplicationContext(), uriToFile);
        if (fileInfo == null) {
            RLog.e(TAG, "Uri error path is " + uriToFile.toString());
            callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            return;
        }
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileInfo.getName());
        final String mimeKey = FtUtilities.generateKey(mimeType.getName()) + FtUtilities.getSuffixName(fileInfo.getName());
        FwLog.write(3, 1, "L-media_auth-T", "", new Object[0]);
        nativeObj.GetUploadToken(mimeType.getValue(), mimeKey, new NativeObject.FileTokenListener(){

            @Override
            public void OnError(int errorCode, final String token, final String alternative, final String date, final String path, final String ossToken, final String ossPolicy, final String ossSignature, final String ossBucketName) {
                if (errorCode == 0) {
                    FwLog.write(3, 1, "L-media_auth-R", "code", 0);
                    workHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            MediaUploadAuthorInfo authorInfo = MediaUploadAuthorInfo.newBuilder().token(token).alternative(alternative).path(path).date(date).ossAccessKeyId(ossToken).ossPolicy(ossPolicy).ossSignature(ossSignature).bucket(ossBucketName).build();
                            List sortedUploaderList = MediaUploadEngine.this.buildUploaderListSorted(nativeObj, enterServer, authorInfo, mimeKey, uriToFile, message, mimeType);
                            if (sortedUploaderList == null || sortedUploaderList.size() == 0) {
                                callback.onError(RongIMClient.ErrorCode.RC_FILE_UPLOAD_FAILED.getValue());
                                return;
                            }
                            MediaUploadEngine.this.doUpload(sortedUploaderList, fileInfo, message, callback);
                        }
                    });
                } else {
                    FwLog.write(2, 1, "L-media_auth-R", "code", errorCode);
                    callback.onError(errorCode);
                }
            }
        });
    }

    private void doUpload(final List<BaseMediaUploader> sortedUploaderList, final FileInfo fileInfo, final Message message, final NativeClient.IResultProgressCallback<String> callback) {
        if (sortedUploaderList == null || sortedUploaderList.size() == 0) {
            return;
        }
        final long startTime = SystemClock.elapsedRealtime();
        sortedUploaderList.remove(0).run(this.dispatcher(), new IMediaUploadResultCallback(){

            @Override
            public void onError(int code, String url) {
                if (sortedUploaderList == null || sortedUploaderList.size() == 0) {
                    long diff = SystemClock.elapsedRealtime() - startTime;
                    FwLog.write(1, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", new Object[]{"upload", FtUtilities.getMimeType(fileInfo.getName()), false, fileInfo.getSize() / 1024L, url, diff, code});
                    RLog.d(TAG, "uploadMedia onError code =" + code);
                    callback.onError(RongIMClient.ErrorCode.RC_FILE_UPLOAD_FAILED.getValue());
                    MediaUploadEngine.this.cacheProgress.remove(message.getMessageId());
                    return;
                }
                MediaUploadEngine.this.doUpload(sortedUploaderList, fileInfo, message, callback);
            }

            @Override
            public void onComplete(String url) {
                callback.onSuccess(url);
                MediaUploadEngine.this.cacheProgress.remove(message.getMessageId());
                long diff = SystemClock.elapsedRealtime() - startTime;
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", new Object[]{"upload", FtUtilities.getMimeType(fileInfo.getName()), false, fileInfo.getSize() / 1024L, url, diff, 0});
            }

            @Override
            public void onProgress(int progress) {
                Integer latestProgressByMessageId = (Integer)MediaUploadEngine.this.cacheProgress.get(message.getMessageId());
                if (latestProgressByMessageId == null || latestProgressByMessageId < progress) {
                    callback.onProgress(progress);
                    MediaUploadEngine.this.cacheProgress.put(message.getMessageId(), progress);
                }
            }

            @Override
            public void onCanceled(Object tag, String url) {
                long diff = startTime - SystemClock.elapsedRealtime();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", new Object[]{"upload", FtUtilities.getMimeType(fileInfo.getName()), true, fileInfo.getSize() / 1024L, url, diff, 0});
                callback.onCanceled((Integer)tag);
                MediaUploadEngine.this.cacheProgress.remove(message.getMessageId());
            }
        });
    }

    private List<BaseMediaUploader> buildUploaderListSorted(NativeObject nativeObj, String enterServer, MediaUploadAuthorInfo authorInfo, String mimeKey, Uri uriToFile, Message message, FtConst.MimeType mimeType) {
        List<Object> sortedPlatforms = new ArrayList<FilePlatformInfo>();
        if (NavigationCacheHelper.getPrivateCloudConfig(NativeClient.getApplicationContext()) && !TextUtils.isEmpty((CharSequence)enterServer)) {
            sortedPlatforms.add(new FilePlatformInfo(enterServer, "0", FtConst.ServiceType.PRIVATE_CLOUD));
            sortedPlatforms.add(new FilePlatformInfo(enterServer, "1", FtConst.ServiceType.QI_NIU));
        } else {
            sortedPlatforms = NavigationClient.getInstance().getMediaServerConfigs(NativeClient.getApplicationContext());
        }
        if (sortedPlatforms == null || sortedPlatforms.size() == 0) {
            return null;
        }
        ArrayList<BaseMediaUploader> sortedUploaderList = new ArrayList<BaseMediaUploader>();
        for (FilePlatformInfo filePlatformInfo : sortedPlatforms) {
            RequestOption.Upload option;
            BaseMediaUploader uploader = BaseMediaUploader.Factory.params(filePlatformInfo, nativeObj, option = RequestOption.Upload.newBuilder(uriToFile, mimeKey, mimeType, message.getMessageId(), authorInfo, filePlatformInfo.getHost()).requestCallback(null).build()).create(filePlatformInfo.getType());
            if (uploader == null) continue;
            sortedUploaderList.add(uploader);
        }
        return sortedUploaderList;
    }

    public static interface IMediaUploadResultCallback {
        public void onError(int var1, String var2);

        public void onComplete(String var1);

        public void onProgress(int var1);

        public void onCanceled(Object var1, String var2);
    }

    private static class SingletonHolder {
        private static final MediaUploadEngine INSTANCE = new MediaUploadEngine();

        private SingletonHolder() {
        }
    }
}

