/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.net.Uri;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.filetransfer.upload.MediaUploadAuthorInfo;

public class RequestOption {
    private FtConst.MimeType mimeType;
    private String serverIp;
    private RequestCallBack requestCallBack;
    private String fileName;
    private int messageId;

    public RequestOption(String fileName, FtConst.MimeType mimeType, RequestCallBack requestCallBack) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.requestCallBack = requestCallBack;
    }

    public RequestOption(String fileName, FtConst.MimeType mimeType, int messageId, RequestCallBack requestCallBack) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.requestCallBack = requestCallBack;
        this.messageId = messageId;
    }

    public RequestOption(String fileName, FtConst.MimeType mimeType, String serverIp, RequestCallBack requestCallBack) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.serverIp = serverIp;
        this.requestCallBack = requestCallBack;
    }

    public RequestOption(String fileName, FtConst.MimeType mimeType, String serverIp, int messageId, RequestCallBack requestCallBack) {
        this.fileName = fileName;
        this.mimeType = mimeType;
        this.serverIp = serverIp;
        this.messageId = messageId;
        this.requestCallBack = requestCallBack;
    }

    public FtConst.MimeType getMimeType() {
        return this.mimeType;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public RequestCallBack getRequestCallBack() {
        return this.requestCallBack;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public static class Upload
    extends RequestOption {
        private int start;
        private int end;
        public Uri fileUri;
        public MediaUploadAuthorInfo authorInfo;

        public Upload(Builder builder) {
            super(builder.key, builder.mimeType, builder.url, builder.messageId, builder.requestCallback);
            this.fileUri = builder.fileUri;
            this.authorInfo = builder.authorInfo;
        }

        public static Builder newBuilder(Uri fileUri, String mimeKey, FtConst.MimeType mimeType, int messageId, MediaUploadAuthorInfo authorInfo, String url) {
            return new Builder(fileUri, mimeKey, mimeType, messageId, authorInfo, url);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public static final class Builder {
            private String url;
            private MediaUploadAuthorInfo authorInfo;
            private Uri fileUri;
            private String key;
            private FtConst.MimeType mimeType;
            private int messageId;
            private RequestCallBack requestCallback;

            private Builder(Uri fileUri, String mimeKey, FtConst.MimeType mimeType, int messageId, MediaUploadAuthorInfo authorInfo, String url) {
                this.fileUri = fileUri;
                this.key = mimeKey;
                this.mimeType = mimeType;
                this.authorInfo = authorInfo;
                this.messageId = messageId;
                this.url = url;
            }

            public Upload build() {
                return new Upload(this);
            }

            public Builder requestCallback(RequestCallBack requestCallBack) {
                this.requestCallback = requestCallBack;
                return this;
            }
        }
    }
}

