/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.common.NetUtils;
import io.rong.imlib.filetransfer.AbstractRequest;
import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.MediaDownloadEngine;
import io.rong.imlib.filetransfer.OnProgressListener;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.model.FileInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Request
extends AbstractRequest {
    private static final String TAG = Request.class.getSimpleName();
    private static final int TIMEOUT = 120000;
    public FtConst.MimeType mimeType;
    public String fileUri;
    public String method;
    public Object tag;
    public String token;
    public int connTimeout;
    public int readTimeout;
    public String serverIp;
    public String fileName;
    public long fileLength;
    public String date;
    public String ossAccessKeyId;
    public String policy;
    public String signature;
    public RequestCallBack requestCallBack;
    public boolean terminated;
    public FileInfo info;
    public OnProgressListener listener;
    public int finished = 0;
    public String pausedPath;
    public int messageId;
    public boolean isMessage;
    public Context mContext;
    private HttpURLConnection conn;

    public void setContext(Context pContext) {
        this.mContext = pContext;
    }

    public Request(Configuration config, RequestCallBack requestCallBack) {
        this.connTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        this.requestCallBack = requestCallBack;
    }

    public Request(FileInfo fileInfo, Configuration config, RequestCallBack requestCallBack, String pausedPath) {
        this.pausedPath = pausedPath;
        this.setFileInfo(fileInfo);
        this.connTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        this.requestCallBack = requestCallBack;
    }

    public void setFileUri(String fileUri) {
        this.fileUri = fileUri;
    }

    public abstract String getContentType();

    public abstract long getContentLength();

    public abstract String getFormData();

    public abstract String getBoundary();

    public abstract String getUploadedUrl(String var1);

    public abstract String getUploadPlatformTag();

    public abstract FtConst.MimeType getMimeType();

    protected abstract void headers(HttpURLConnection var1);

    protected abstract boolean enableEndBoundary();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest() {
        BufferedInputStream responseStream = null;
        ByteArrayOutputStream responseData = null;
        FilterOutputStream os = null;
        FileInputStream is = null;
        boolean supportResumeTransfer = false;
        try {
            if (this.method.equals("POST")) {
                int c;
                int read;
                FwLog.write(3, 1, "L-media_upload-T", "type", this.getUploadPlatformTag());
                this.conn = NetUtils.createURLConnection(this.serverIp);
                if (FileUtils.uriStartWithFile(Uri.parse((String)this.fileUri))) {
                    is = new FileInputStream(new File(this.fileUri.substring(7)));
                } else {
                    ParcelFileDescriptor r = this.mContext.getContentResolver().openFileDescriptor(Uri.parse((String)this.fileUri), "r");
                    is = new FileInputStream(r.getFileDescriptor());
                }
                this.conn.setUseCaches(false);
                this.conn.setDoOutput(true);
                this.conn.setDoInput(true);
                this.conn.setRequestMethod(this.method);
                this.conn.setConnectTimeout(120000);
                this.conn.setRequestProperty("Connection", "close");
                String endBoundary = "\r\n--" + this.getBoundary() + "--";
                if (!this.enableEndBoundary()) {
                    endBoundary = "";
                }
                this.headers(this.conn);
                this.conn.setRequestProperty("Charset", "UTF-8");
                this.conn.setRequestProperty("Content-Type", this.getContentType());
                String formData = this.getFormData();
                int fileSize = is.available();
                if (fileSize < 0) {
                    this.requestCallBack.onError(31002);
                }
                int total = formData.length() + fileSize + endBoundary.length();
                this.conn.setRequestProperty("Content-Length", total + "");
                this.conn.setFixedLengthStreamingMode(total);
                this.conn.connect();
                os = new DataOutputStream(this.conn.getOutputStream());
                ((DataOutputStream)os).writeBytes(formData);
                int current = formData.length();
                int cachedLength = formData.length();
                int progress = 1;
                this.requestCallBack.onProgress(progress);
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) != -1) {
                    ((DataOutputStream)os).write(buffer, 0, read);
                    cachedLength += read;
                    int size = (int)(100L * (long)(current += read) / (long)total);
                    if (size > progress) {
                        progress = size;
                        this.requestCallBack.onProgress(progress);
                    }
                    if (cachedLength > 0x200000) {
                        ((DataOutputStream)os).flush();
                        cachedLength = 0;
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                    this.terminated = true;
                    this.requestCallBack.onCanceled(this.tag);
                    throw new InterruptedIOException();
                }
                ((DataOutputStream)os).writeBytes(endBoundary);
                this.requestCallBack.onProgress(100);
                ((DataOutputStream)os).flush();
                int responseCode = this.conn.getResponseCode();
                responseStream = new BufferedInputStream(this.conn.getInputStream());
                responseData = new ByteArrayOutputStream(1024);
                while ((c = responseStream.read()) != -1) {
                    responseData.write(c);
                }
                FwLog.write(3, 1, "L-media_upload-R", "type|code", this.getUploadPlatformTag(), responseCode);
                if (responseCode < 200 || responseCode >= 300) {
                    this.requestCallBack.onError(responseCode);
                } else {
                    String url = this.getUploadedUrl(responseData.toString());
                    this.requestCallBack.onComplete(url);
                }
            } else if (this.method.equals("GET")) {
                supportResumeTransfer = MediaDownloadEngine.checkSupportResumeTransfer(this.serverIp);
                if (!supportResumeTransfer) {
                    this.sendRequestNotSupportResumeTransfer();
                } else {
                    this.sendRequestSupportResumeTransfer();
                }
            }
        }
        catch (Exception e) {
            if (!this.terminated) {
                this.requestCallBack.onError(30002);
                FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "stacks", FwLog.stackToString(e));
                if (supportResumeTransfer) {
                    MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                }
            }
            RLog.e(TAG, "sendRequest", e);
        }
        finally {
            try {
                if (null != responseData) {
                    responseData.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest_responseData", e);
            }
            try {
                if (null != responseStream) {
                    responseStream.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest_responseStream", e);
            }
            try {
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest_os", e);
            }
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException e) {
                RLog.e(TAG, "sendRequest_is", e);
            }
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }
    }

    private void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                RLog.e(TAG, "closeOutputStream", e);
            }
        }
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                RLog.e(TAG, "closeInputStream", e);
            }
        }
    }

    public void sendRequestForNoneMessage() {
        boolean supportResumeTransfer = false;
        try {
            if (this.method.equals("GET")) {
                supportResumeTransfer = MediaDownloadEngine.checkSupportResumeTransfer(this.serverIp);
                if (!supportResumeTransfer) {
                    this.sendRequestNotSupportResumeTransfer();
                } else {
                    this.sendRequestSupportResumeTransfer();
                }
            }
        }
        catch (Exception e) {
            if (!this.terminated) {
                this.requestCallBack.onError(30002);
                FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "stacks", FwLog.stackToString(e));
                if (supportResumeTransfer) {
                    MediaDownloadEngine.getInstance().addToFileDownloadMap(this.serverIp, false);
                }
            }
            RLog.e(TAG, "sendRequestForNoneMessage", e);
        }
    }

    private void sendRequestSupportResumeTransfer() throws Exception {
        this.getLength();
        int sliceLength = MediaDownloadEngine.getInstance().getDownloadEachSliceLength();
        long start = this.info.getFinished();
        if (start == this.info.getLength()) {
            this.downloadComplete();
        } else if (start + (long)sliceLength - 1L > this.info.getLength()) {
            this.downloadInOnceSlice(start);
        } else {
            this.downloadInMultiSlice(start, sliceLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInMultiSlice(long start, int sliceLength) {
        long finished = start;
        while (finished < this.info.getLength()) {
            long end;
            HttpURLConnection conn = null;
            RandomAccessFile rwd = null;
            try {
                conn = NetUtils.createURLConnection(this.serverIp);
                conn.setRequestMethod(this.method);
                conn.setConnectTimeout(3000);
                end = finished + (long)sliceLength >= this.info.getLength() ? this.info.getLength() - 1L : finished + (long)sliceLength - 1L;
                conn.setRequestProperty("Range", "bytes=" + finished + "-" + end);
                File file = new File(this.info.getFileName());
                rwd = new RandomAccessFile(file, "rwd");
                rwd.seek(finished);
                RLog.d(TAG, "downloadInMultiSlice conn code :" + conn.getResponseCode());
                int responseCode = conn.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    this.requestCallBack.onError(responseCode);
                    FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "responseCode", responseCode);
                    if (this.isMessage) {
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                    } else {
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                    }
                } else if (conn.getResponseCode() == 206) {
                    int len;
                    InputStream inputStream = conn.getInputStream();
                    byte[] buffer = new byte[4096];
                    long total = this.info.getLength();
                    long current = this.info.getFinished();
                    int progress = 0;
                    while ((len = inputStream.read(buffer)) != -1) {
                        String saveString;
                        FileInfo savedFileInfo;
                        rwd.write(buffer, 0, len);
                        this.info.setFinished(finished += (long)len);
                        String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
                        if (!TextUtils.isEmpty((CharSequence)savedFileInfoString) && (savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString)).getFinished() > finished) {
                            return;
                        }
                        int temp = (int)(100L * (current += (long)len) / total);
                        if (progress < temp) {
                            progress = temp;
                            this.requestCallBack.onProgress(progress);
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                            this.terminated = true;
                            this.requestCallBack.onCanceled(this.tag);
                            throw new InterruptedIOException();
                        }
                        if (this.info.isStop()) {
                            this.info.setDownLoading(false);
                            saveString = this.getSaveJsonString();
                            FileUtils.saveFile(saveString, this.pausedPath);
                            if (this.isMessage) {
                                MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                            } else {
                                MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                            }
                            return;
                        }
                        this.info.setDownLoading(true);
                        this.info.setStop(false);
                        saveString = this.getSaveJsonString();
                        FileUtils.saveFile(saveString, this.pausedPath);
                        if (this.isMessage) {
                            MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), true);
                            continue;
                        }
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), true);
                    }
                }
            }
            catch (Exception e) {
                if (!this.terminated) {
                    this.requestCallBack.onError(30002);
                    FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "stacks", FwLog.stackToString(e));
                    if (this.isMessage) {
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                    } else {
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                    }
                }
                RLog.e(TAG, "downloadInMultiSlice", e);
                break;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
                if (rwd != null) {
                    try {
                        rwd.close();
                    }
                    catch (IOException e) {
                        RLog.e(TAG, "downloadInMultiSlice", e);
                    }
                }
            }
            if (end != this.info.getLength() - 1L) continue;
            this.downloadComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadInOnceSlice(long start) {
        RandomAccessFile rwd = null;
        try {
            this.conn = NetUtils.createURLConnection(this.serverIp);
            this.conn.setRequestMethod(this.method);
            this.conn.setConnectTimeout(3000);
            this.conn.setRequestProperty("Range", "bytes=" + start + "-" + (this.info.getLength() - 1L));
            File file = new File(this.info.getFileName());
            rwd = new RandomAccessFile(file, "rwd");
            rwd.seek(start);
            this.finished = (int)((long)this.finished + this.info.getFinished());
            RLog.d(TAG, "downloadInOnceSlice conn code :" + this.conn.getResponseCode());
            int responseCode = this.conn.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                this.requestCallBack.onError(30002);
                FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "responseCode", responseCode);
                if (this.isMessage) {
                    MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                } else {
                    MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                }
            } else if (this.conn.getResponseCode() == 206) {
                int len;
                InputStream inputStream = this.conn.getInputStream();
                byte[] buffer = new byte[4096];
                long total = this.info.getLength();
                long current = this.info.getFinished();
                int progress = 0;
                while ((len = inputStream.read(buffer)) != -1) {
                    String saveString;
                    FileInfo savedFileInfo;
                    rwd.write(buffer, 0, len);
                    this.finished += len;
                    this.info.setFinished(this.finished);
                    String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
                    if (!TextUtils.isEmpty((CharSequence)savedFileInfoString) && (savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString)).getFinished() > (long)this.finished) {
                        return;
                    }
                    int temp = (int)(100L * (current += (long)len) / total);
                    if (progress < temp) {
                        progress = temp;
                        this.requestCallBack.onProgress(temp);
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        RLog.w(TAG, "sendRequest post terminated.tag:" + this.tag);
                        this.terminated = true;
                        this.requestCallBack.onCanceled(this.tag);
                        throw new InterruptedIOException();
                    }
                    if (this.info.isStop()) {
                        this.info.setDownLoading(false);
                        saveString = this.getSaveJsonString();
                        FileUtils.saveFile(saveString, this.pausedPath);
                        if (this.isMessage) {
                            MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), false);
                        } else {
                            MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), false);
                        }
                        return;
                    }
                    this.info.setDownLoading(true);
                    this.info.setStop(false);
                    saveString = this.getSaveJsonString();
                    FileUtils.saveFile(saveString, this.pausedPath);
                    if (this.isMessage) {
                        MediaDownloadEngine.getInstance().addToFileDownloadMap(this.info.getMessageId(), true);
                        continue;
                    }
                    MediaDownloadEngine.getInstance().addToFileDownloadMap(this.tag.toString(), true);
                }
                this.downloadComplete();
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "downloadInOnceSlice", e);
        }
        finally {
            if (rwd != null) {
                try {
                    rwd.close();
                }
                catch (IOException e) {
                    RLog.e(TAG, "downloadInOnceSlice", e);
                }
            }
        }
    }

    private void downloadComplete() {
        this.info.setDownLoading(false);
        this.requestCallBack.onComplete(this.info.getFileName());
        FileUtils.removeFile(this.pausedPath);
        if (this.isMessage) {
            MediaDownloadEngine.getInstance().removeFromFileDownloadMap(this.info.getMessageId());
        } else {
            MediaDownloadEngine.getInstance().removeFromFileDownloadMap(this.tag.toString());
        }
    }

    private void sendRequestNotSupportResumeTransfer() throws Exception {
        this.conn = NetUtils.createURLConnection(this.serverIp);
        this.conn.setConnectTimeout(120000);
        this.conn.setUseCaches(false);
        this.conn.setRequestMethod(this.method);
        this.conn.setDoInput(true);
        this.conn.connect();
        int responseCode = this.conn.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            this.requestCallBack.onError(30002);
            RLog.d("fileTransfer", "download request response code is " + responseCode);
            FwLog.write(2, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "responseCode", responseCode);
        } else {
            int length;
            BufferedInputStream responseStream = new BufferedInputStream(this.conn.getInputStream());
            int total = this.conn.getContentLength();
            int current = 0;
            int cachedLength = 0;
            ByteArrayOutputStream responseData = new ByteArrayOutputStream(1024);
            int progress = 0;
            byte[] buffer = new byte[1024];
            File f = new File(this.fileName);
            FileOutputStream fos = new FileOutputStream(f);
            while ((length = responseStream.read(buffer)) != -1) {
                responseData.write(buffer, 0, length);
                cachedLength += length;
                int temp = (int)(100L * (long)(current += length) / (long)total);
                if (progress < temp) {
                    progress = temp;
                    this.requestCallBack.onProgress(temp);
                }
                if (Thread.currentThread().isInterrupted()) {
                    RLog.w(TAG, "sendRequest terminated.");
                    this.terminated = true;
                    this.requestCallBack.onCanceled(this.tag);
                    throw new InterruptedIOException();
                }
                if (cachedLength <= 0x100000) continue;
                fos.write(responseData.toByteArray(), 0, responseData.size());
                responseData.reset();
                cachedLength = 0;
            }
            fos.write(responseData.toByteArray(), 0, responseData.size());
            fos.close();
            this.requestCallBack.onComplete(this.fileName);
        }
    }

    private String getSaveJsonString() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("filename", (Object)this.info.getFileName());
            jsonObject.put("url", (Object)this.info.getUrl());
            jsonObject.put("length", this.info.getLength());
            jsonObject.put("finish", this.info.getFinished());
            jsonObject.put("isStop", this.info.isStop());
            jsonObject.put("isDownLoading", this.info.isDownLoading());
        }
        catch (JSONException e) {
            RLog.e(TAG, "getSaveJsonString", e);
        }
        return jsonObject.toString();
    }

    private FileInfo getFileInfoFromJsonString(String jsonString) {
        FileInfo fileInfo = new FileInfo();
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            fileInfo.setFileName(jsonObject.optString("filename"));
            fileInfo.setUrl(jsonObject.optString("url"));
            fileInfo.setLength(jsonObject.optLong("length"));
            fileInfo.setFinished(jsonObject.optLong("finish"));
            fileInfo.setStop(jsonObject.optBoolean("isStop", false));
            fileInfo.setDownLoading(jsonObject.optBoolean("isDownLoading", false));
        }
        catch (JSONException e) {
            RLog.e(TAG, "getFileInfoFromJsonString", e);
        }
        return fileInfo;
    }

    private void setFileInfo(FileInfo fileInfo) {
        try {
            this.info = fileInfo;
            FileInfo savedFileInfo = null;
            String savedFileInfoString = FileUtils.getStringFromFile(this.pausedPath);
            if (!TextUtils.isEmpty((CharSequence)savedFileInfoString)) {
                savedFileInfo = this.getFileInfoFromJsonString(savedFileInfoString);
            }
            if (savedFileInfo != null) {
                this.info.setFinished(savedFileInfo.getFinished());
                this.info.setDownLoading(savedFileInfo.isDownLoading());
                this.info.setLength(savedFileInfo.getLength());
                this.info.setFileName(savedFileInfo.getFileName());
                this.info.setUrl(savedFileInfo.getUrl());
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "setFileInfo", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLength() {
        HttpURLConnection connection = null;
        if (this.fileLength > 0L) {
            this.info.setLength(this.fileLength);
        } else {
            try {
                connection = NetUtils.createURLConnection(this.info.getUrl());
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(3000);
                long length = -1L;
                if (connection.getResponseCode() == 200) {
                    length = Long.parseLong(connection.getHeaderField("Content-Length"));
                }
                if (length <= 0L) {
                    RLog.e(TAG, "file length from server is 0. Return directly!");
                }
                this.info.setLength(length);
            }
            catch (Exception e) {
                RLog.e(TAG, "getLength", e);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                catch (Exception e) {
                    RLog.e(TAG, "getLength", e);
                }
            }
        }
    }
}

