/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.filetransfer.Call;
import io.rong.imlib.filetransfer.DownloadRequest;
import io.rong.imlib.filetransfer.PauseCallback;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.filetransfer.upload.AbstractMediaFileService;
import io.rong.imlib.model.FileInfo;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MediaDownloadEngine
extends AbstractMediaFileService {
    private static final String TAG = MediaDownloadEngine.class.getSimpleName();
    private Context mContext = NativeClient.getApplicationContext();
    private Map<String, Boolean> downloadMap = new HashMap<String, Boolean>();

    private MediaDownloadEngine() {
    }

    public static MediaDownloadEngine getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void download(int id, String url, long length, @NonNull RequestOption option) {
        FileInfo info = new FileInfo("", url);
        info.setFileName(option.getFileName());
        info.setStop(false);
        info.setMessageId(option.getMessageId());
        String pausePath = FileUtils.getTempFilePath(this.mContext, id);
        DownloadRequest request = new DownloadRequest(info, this.getConfiguration(), option.getRequestCallBack(), pausePath);
        request.mimeType = option.getMimeType();
        request.method = "GET";
        request.serverIp = url;
        request.tag = id;
        request.fileName = option.getFileName();
        request.fileLength = length;
        request.isMessage = true;
        request.requestCallBack = option.getRequestCallBack();
        Call call = Call.create(this.dispatcher(), request);
        call.enqueue();
    }

    public void download(String uid, String url, @NonNull RequestOption option) {
        FileInfo info = new FileInfo("", url);
        info.setFileName(option.getFileName());
        info.setStop(false);
        info.setMessageId(option.getMessageId());
        String pausePath = FileUtils.getTempFilePath(this.mContext, uid);
        DownloadRequest request = new DownloadRequest(info, this.getConfiguration(), option.getRequestCallBack(), pausePath);
        request.mimeType = option.getMimeType();
        request.method = "GET";
        request.serverIp = url;
        request.tag = uid;
        request.fileName = option.getFileName();
        request.requestCallBack = option.getRequestCallBack();
        request.isMessage = false;
        Call call = Call.create(this.dispatcher(), request);
        call.enqueue();
    }

    public void pause(int id, PauseCallback callback) {
        if (id > 0) {
            this.dispatcher().pause(id, callback);
        }
    }

    public void pause(String tag, PauseCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            this.dispatcher().pause(tag, callback);
        }
    }

    public void cancelAll() {
        this.dispatcher().cancelAll();
        if (this.downloadMap != null) {
            this.downloadMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSupportResumeTransfer(String url) {
        HttpURLConnection conn = null;
        boolean support = true;
        try {
            URL u = new URL(url);
            conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Range", "bytes=0-1");
            if (conn.getResponseCode() != 206) {
                support = false;
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "checkSupportResumeTransfer", e);
            support = false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return support;
    }

    public int getDownloadEachSliceLength() {
        int length = 0;
        if (this.mContext != null) {
            Resources resources = this.mContext.getResources();
            length = resources.getInteger(resources.getIdentifier("rc_resume_file_transfer_size_each_slice", "integer", this.mContext.getPackageName()));
        }
        return length;
    }

    public void addToFileDownloadMap(int messageId, boolean isDownloading) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, messageId);
        this.downloadMap.put(md5, isDownloading);
    }

    public void addToFileDownloadMap(String tag, boolean isDownloading) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, tag);
        this.downloadMap.put(md5, isDownloading);
    }

    public void removeFromFileDownloadMap(int messageId) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, messageId);
        if (this.downloadMap != null) {
            this.downloadMap.remove(md5);
        }
    }

    public void removeFromFileDownloadMap(String tag) {
        String md5 = FileUtils.getTempFileMD5(this.mContext, tag);
        if (this.downloadMap != null) {
            this.downloadMap.remove(md5);
        }
    }

    public boolean getDownloadingFromMap(Context context, int messageId) {
        String md5 = FileUtils.getTempFileMD5(context, messageId);
        if (this.downloadMap != null && this.downloadMap.size() > 0) {
            return this.downloadMap.get(md5);
        }
        return false;
    }

    public boolean getDownloadingFromMap(Context context, String tag) {
        String md5 = FileUtils.getTempFileMD5(context, tag);
        if (this.downloadMap != null && this.downloadMap.size() > 0) {
            return this.downloadMap.get(md5);
        }
        return false;
    }

    private static class SingletonHolder {
        private static final MediaDownloadEngine INSTANCE = new MediaDownloadEngine();

        private SingletonHolder() {
        }
    }
}

