/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.text.TextUtils;
import io.rong.imlib.filetransfer.FtConst;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FtUtilities {
    public static FtConst.MimeType getMimeType(String fileName) {
        FtConst.MimeType mimeType = FtUtilities.isImageFile(fileName) ? FtConst.MimeType.FILE_IMAGE : (FtUtilities.isAudioFile(fileName) ? FtConst.MimeType.FILE_AUDIO : (FtUtilities.isVideoFile(fileName) ? FtConst.MimeType.FILE_VIDEO : (FtUtilities.isHtmlFile(fileName) ? FtConst.MimeType.FILE_HTML : FtConst.MimeType.FILE_TEXT_PLAIN)));
        return mimeType;
    }

    private static boolean isImageFile(String fileName) {
        String[] imageSuffixArray;
        for (String suffix : imageSuffixArray = new String[]{".bmp", ".cod", ".gif", ".ief", ".jpe", ".jpeg", ".jpg", ".jfif", ".svg", ".tif", ".tiff", ".ras", ".ico", ".pnm", ".pbm", ".pgm", ".ppm", ".xbm", ".xpm", ".xwd", ".rgb"}) {
            if (!fileName.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAudioFile(String fileName) {
        String[] audioSuffixArray;
        for (String suffix : audioSuffixArray = new String[]{".au", ".snd", ".mid", ".rmi", ".aif", ".aifc", ".aiff", ".m3u", ".ra", ".ram", ".wav", ".aac"}) {
            if (!fileName.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVideoFile(String fileName) {
        String[] videoSuffixArray;
        for (String suffix : videoSuffixArray = new String[]{".rmvb", ".avi", ".mp4", ".mp2", ".mpa", ".mpe", ".mpeg", ".mpg", ".mpv2", ".mov", ".qt", ".lsf", ".lsx", ".asf", ".asr", ".asx", ".avi", ".movie"}) {
            if (!fileName.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHtmlFile(String fileName) {
        String[] htmlSuffixArray;
        for (String suffix : htmlSuffixArray = new String[]{".html"}) {
            if (!fileName.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String generateKey(String mimeType) {
        String szKey = mimeType.replace("/", "_");
        szKey = szKey + "__RC-";
        long time = System.currentTimeMillis();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        Date mDate = new Date(time);
        szKey = szKey + format.format(mDate);
        int random = (int)(Math.random() * 1000.0) % 10000;
        szKey = szKey + "_" + random;
        szKey = szKey + "_" + time;
        return szKey;
    }

    public static String getMediaDir(int fileType) {
        String mediaPath = "image";
        switch (fileType) {
            case 1: {
                mediaPath = "image";
                break;
            }
            case 2: {
                mediaPath = "audio";
                break;
            }
            case 3: {
                mediaPath = "video";
                break;
            }
            case 4: {
                mediaPath = "file";
            }
        }
        return mediaPath;
    }

    public static String getCateDir(int categoryId) {
        String categoryPath = "private";
        switch (categoryId) {
            case 1: {
                categoryPath = "private";
                break;
            }
            case 2: {
                categoryPath = "discussion";
                break;
            }
            case 3: {
                categoryPath = "group";
                break;
            }
            case 4: {
                categoryPath = "chatroom";
                break;
            }
            case 5: {
                categoryPath = "reception";
                break;
            }
        }
        return categoryPath;
    }

    public static boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static String getFileKey(String fileUri) {
        String fileKey = fileUri;
        int pos = fileKey.indexOf("?");
        if (pos != -1) {
            fileKey = fileKey.substring(0, pos);
        }
        if ((pos = fileKey.lastIndexOf("/")) != -1) {
            fileKey = fileKey.substring(pos + 1);
        }
        fileKey = fileKey.replaceAll("%2F", "_");
        return fileKey;
    }

    public static String getFileName(String cachePath, String fileName) {
        String name;
        String suffix = "";
        if (fileName == null) {
            return "";
        }
        if (fileName.lastIndexOf(".") > 0) {
            suffix = fileName.substring(fileName.lastIndexOf("."));
            name = fileName.substring(0, fileName.lastIndexOf("."));
        } else {
            name = fileName;
        }
        String regEx = "[`!@#$%^&*()+=|{}':;',//[//].<>/?\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f~~]";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(name);
        name = matcher.replaceAll("_");
        File file = new File(cachePath, name + suffix);
        int n = 0;
        while (file.exists()) {
            String increaseName = !TextUtils.isEmpty((CharSequence)suffix) ? name + "(" + n + ")" + suffix : name + "(" + ++n + ")";
            file = new File(cachePath, increaseName);
        }
        return file.getPath();
    }

    public static String getSuffixName(String fileName) {
        String[] splitArray;
        String suffix = "";
        if (!TextUtils.isEmpty((CharSequence)fileName) && (splitArray = fileName.split("\\.")).length > 1) {
            suffix = "." + splitArray[splitArray.length - 1];
        }
        return suffix;
    }
}

