/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

public class FtConst {
    public static final String TEMP_TRANSFER_FILE_DIR = "TempFile";

    public static enum ServiceType {
        PRIVATE_CLOUD(null, "private"),
        QI_NIU("1", "qiniu"),
        BAI_DU("2", "baidu"),
        ALI_OSS("3", "aliyun");

        private String priority;
        private String name;

        public String getPriority() {
            return this.priority;
        }

        public String getName() {
            return this.name;
        }

        private ServiceType(String priority, String name) {
            this.priority = priority;
            this.name = name;
        }

        public static ServiceType reverse(String name) {
            switch (name) {
                case "qiniu": {
                    return QI_NIU;
                }
                case "private": {
                    return PRIVATE_CLOUD;
                }
                case "baidu": {
                    return BAI_DU;
                }
                case "aliyun": {
                    return ALI_OSS;
                }
            }
            return null;
        }
    }

    public static enum MimeType {
        NONE(0, "none"),
        FILE_IMAGE(1, "image/jpeg"),
        FILE_AUDIO(2, "audio/amr"),
        FILE_VIDEO(3, "video/mpeg4"),
        FILE_TEXT_PLAIN(4, "application/octet-stream"),
        FILE_SIGHT(5, "video/mpeg4"),
        FILE_HTML(6, "text/html");

        private int value;
        private String name;

        private MimeType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static MimeType setValue(int code) {
            for (MimeType c : MimeType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NONE;
        }
    }
}

