/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import android.support.annotation.NonNull;
import io.rong.imlib.filetransfer.Call;
import io.rong.imlib.filetransfer.CancelCallback;
import io.rong.imlib.filetransfer.PauseCallback;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CallDispatcher {
    private static final int MAX_RUNNING_TASK = 4;
    private final Deque<Call.AsyncCall> readyCalls = new ArrayDeque<Call.AsyncCall>();
    private final Deque<Call.AsyncCall> runningCalls = new ArrayDeque<Call.AsyncCall>();
    private ExecutorService executorService;

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory());
        }
        return this.executorService;
    }

    private ThreadFactory threadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                Thread result = new Thread(runnable, "HttpEngine Dispatcher");
                result.setDaemon(false);
                return result;
            }
        };
    }

    public synchronized void enqueue(Call.AsyncCall asyncCall) {
        if (this.runningCalls.size() < 4) {
            asyncCall.future = this.getExecutorService().submit(asyncCall);
            this.runningCalls.add(asyncCall);
        } else {
            this.readyCalls.add(asyncCall);
        }
    }

    public synchronized void cancel(Object tag, CancelCallback callback) {
        for (Call.AsyncCall call : this.readyCalls) {
            if (!call.tag().equals(tag)) continue;
            call.cancel(callback);
            this.readyCalls.remove(call);
            return;
        }
        for (Call.AsyncCall call : this.runningCalls) {
            if (!call.tag().equals(tag)) continue;
            call.cancel(callback);
            return;
        }
        callback.onError(-3);
    }

    public synchronized void cancelAll() {
        for (Call.AsyncCall call : this.readyCalls) {
            this.readyCalls.remove(call);
            call.cancel(null);
        }
        this.readyCalls.clear();
        for (Call.AsyncCall call : this.runningCalls) {
            call.cancel(null);
        }
        this.runningCalls.clear();
    }

    public synchronized void pause(Object tag, PauseCallback callback) {
        for (Call.AsyncCall call : this.runningCalls) {
            if (!call.tag().equals(tag)) continue;
            call.pause(callback);
            return;
        }
        callback.onError(-3);
    }

    public synchronized void finish(Call.AsyncCall runnable) {
        if (!this.runningCalls.remove(runnable)) {
            throw new RuntimeException("Not in running list.");
        }
        this.promoteCalls();
    }

    private void promoteCalls() {
        if (this.runningCalls.size() >= 4 || this.readyCalls.isEmpty()) {
            return;
        }
        Iterator<Call.AsyncCall> i = this.readyCalls.iterator();
        while (i.hasNext()) {
            Call.AsyncCall call = i.next();
            this.runningCalls.add(call);
            call.future = this.getExecutorService().submit(call);
            i.remove();
            if (this.runningCalls.size() < 4) continue;
            return;
        }
    }

    public boolean inReadyCalls(Object tag) {
        for (Call.AsyncCall call : this.readyCalls) {
            if (!call.tag().equals(tag)) continue;
            return true;
        }
        return false;
    }
}

