/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.filetransfer;

import io.rong.imlib.filetransfer.Configuration;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.Request;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.model.FileInfo;
import java.io.File;
import java.net.HttpURLConnection;

public class BaiDuUploadRequest
extends Request {
    private static final String Boundary = "--526f6e67436c6f7564";

    public BaiDuUploadRequest(Configuration config, RequestCallBack requestCallBack) {
        super(config, requestCallBack);
    }

    public BaiDuUploadRequest(FileInfo fileInfo, Configuration config, RequestCallBack requestCallBack, String pausedPath) {
        super(fileInfo, config, requestCallBack, pausedPath);
    }

    @Override
    public String getContentType() {
        return this.mimeType.getName();
    }

    @Override
    public long getContentLength() {
        File file = new File(this.fileUri);
        return (long)this.getFormData().length() + file.length();
    }

    @Override
    public FtConst.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getUploadPlatformTag() {
        return "B";
    }

    @Override
    protected void headers(HttpURLConnection conn) {
        conn.setRequestProperty("Authorization", this.token);
        conn.setRequestProperty("x-bce-date", this.date);
        if (!FtConst.MimeType.FILE_HTML.getName().equals(this.getContentType())) {
            conn.setRequestProperty("Content-Disposition", "attachment;filename=" + this.fileName);
        }
    }

    @Override
    protected boolean enableEndBoundary() {
        return false;
    }

    @Override
    public String getBoundary() {
        return Boundary;
    }

    @Override
    public String getFormData() {
        return "";
    }

    @Override
    public String getUploadedUrl(String data) {
        return this.serverIp;
    }
}

