/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.destruct;

import io.rong.common.RLog;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.destruct.DestructCountDownTimer;
import io.rong.imlib.destruct.MessageBufferPool;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.message.DestructionCmdMessage;
import java.util.HashMap;
import java.util.Map;

public class DestructionTaskManager {
    private static final String TAG = "DestructionTaskManager";
    private Map<String, DestructCountDownTimer> mCountDownTimers = new HashMap<String, DestructCountDownTimer>();

    private DestructionTaskManager() {
    }

    public void BeginDestruct(Message pMessage, RongIMClient.DestructCountDownTimerListener pListener) {
        if (pMessage == null || pMessage.getContent() == null || pListener == null) {
            RLog.e(TAG, "BeginDestruct pMessage or content or pListener should not be null!");
            return;
        }
        if (pMessage.getContent().isDestruct() && pMessage.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            this.startCountDown(pMessage, pListener);
            this.sendDestructingMsg(pMessage);
        }
    }

    public void messageStopDestruct(Message pMessage) {
        if (pMessage == null || pMessage.getContent() == null) {
            RLog.e(TAG, "messageStopDestruct pMessage or content should not be null!");
            return;
        }
        if (pMessage.getContent().isDestruct() && pMessage.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            this.cancelCountDown(pMessage.getUId());
            this.resetReadTime(pMessage);
        }
    }

    public static DestructionTaskManager getInstance() {
        return DestructionTaskManagerHolder.instance;
    }

    private void startCountDown(final Message pMessage, final RongIMClient.DestructCountDownTimerListener pListener) {
        DestructCountDownTimer destructCountDownTimer;
        if (this.mCountDownTimers.containsKey(pMessage.getUId())) {
            destructCountDownTimer = this.mCountDownTimers.get(pMessage.getUId());
        } else {
            long destructTime;
            long delay;
            long countDownTime = pMessage.getReadTime() <= 0L ? pMessage.getContent().getDestructTime() * 1000L : ((delay = (destructTime = pMessage.getContent().getDestructTime() * 1000L) - (System.currentTimeMillis() - pMessage.getReadTime())) <= 0L ? 0L : delay);
            destructCountDownTimer = new DestructCountDownTimer(pMessage.getUId(), new RongIMClient.DestructCountDownTimerListener(){

                @Override
                public void onTick(long untilFinished, String messageId) {
                    pListener.onTick(untilFinished, messageId);
                    if (untilFinished <= 0L) {
                        DestructionTaskManager.this.deleteMessage(pMessage);
                        DestructionTaskManager.this.mCountDownTimers.remove(messageId);
                    }
                }

                @Override
                public void onStop(String messageId) {
                    pListener.onStop(messageId);
                    DestructionTaskManager.this.mCountDownTimers.remove(messageId);
                }
            }, countDownTime);
            this.mCountDownTimers.put(pMessage.getUId(), destructCountDownTimer);
        }
        destructCountDownTimer.start();
    }

    private void cancelCountDown(String pMessageId) {
        if (this.mCountDownTimers.containsKey(pMessageId)) {
            DestructCountDownTimer destructCountDownTimer = this.mCountDownTimers.get(pMessageId);
            if (destructCountDownTimer != null) {
                destructCountDownTimer.cancel();
            }
            this.mCountDownTimers.remove(pMessageId);
        }
    }

    public void deleteMessage(Message pMessage) {
        if (pMessage != null) {
            RongIMClient.getInstance().deleteRemoteMessages(pMessage.getConversationType(), pMessage.getTargetId(), new Message[]{pMessage}, null);
            RongIMClient.getInstance().deleteMessages(new int[]{pMessage.getMessageId()}, null);
        }
    }

    public void deleteMessages(Conversation.ConversationType pConversationType, String pTargetId, Message[] pMessages) {
        if (pMessages != null && pMessages.length > 0 && pConversationType != null && pTargetId != null) {
            int[] messageIds = new int[pMessages.length];
            for (int i = 0; i < pMessages.length; ++i) {
                if (pMessages[i] == null) continue;
                messageIds[i] = pMessages[i].getMessageId();
            }
            RongIMClient.getInstance().deleteMessages(messageIds, null);
            RongIMClient.getInstance().deleteRemoteMessages(pConversationType, pTargetId, pMessages, null);
        }
    }

    private void sendDestructingMsg(Message message) {
        if (message.getReadTime() <= 0L) {
            long serviceTime = System.currentTimeMillis();
            RongIMClient.getInstance().setMessageReadTime(message.getMessageId(), serviceTime, null);
            message.setReadTime(serviceTime);
            DestructionCmdMessage destructionCmdMessage = new DestructionCmdMessage();
            destructionCmdMessage.addBurnMessageUId(message.getUId());
            MessageBufferPool.getInstance().putMessageInBuffer(Message.obtain(message.getTargetId(), message.getConversationType(), destructionCmdMessage));
        }
    }

    private void resetReadTime(Message pMessage) {
        RongIMClient.getInstance().setMessageReadTime(pMessage.getMessageId(), 0L, null);
        pMessage.setReadTime(0L);
    }

    private static class DestructionTaskManagerHolder {
        private static DestructionTaskManager instance = new DestructionTaskManager();

        private DestructionTaskManagerHolder() {
        }
    }
}

