/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.destruct;

import io.rong.common.CountDownTimer;
import io.rong.imlib.RongIMClient;

public class DestructCountDownTimer {
    private static final int COUNTDOWN_INTERVAL = 1000;
    private RongIMClient.DestructCountDownTimerListener mListener;
    private CountDownTimer mCountDownTimer;
    private String mMessageId;

    DestructCountDownTimer(String pMessageId, RongIMClient.DestructCountDownTimerListener pListener, long millisInFuture) {
        this.mMessageId = pMessageId;
        this.mListener = pListener;
        this.mCountDownTimer = new CountDownTimer(millisInFuture + millisInFuture / 100L, 1000L){

            @Override
            public void onTick(long millisUntilFinished) {
                if (DestructCountDownTimer.this.mListener != null) {
                    DestructCountDownTimer.this.mListener.onTick(Math.round((float)millisUntilFinished / 1000.0f), DestructCountDownTimer.this.mMessageId);
                }
            }

            @Override
            public void onFinish() {
                if (DestructCountDownTimer.this.mListener != null) {
                    DestructCountDownTimer.this.mListener.onTick(0L, DestructCountDownTimer.this.mMessageId);
                }
            }
        };
    }

    public void start() {
        if (this.mCountDownTimer != null && !this.mCountDownTimer.isStart()) {
            this.mCountDownTimer.start();
        }
    }

    public void cancel() {
        if (this.mCountDownTimer != null) {
            if (this.mListener != null) {
                this.mListener.onStop(this.mMessageId);
            }
            this.mCountDownTimer.cancel();
        }
    }
}

