/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.cs;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.CustomServiceConfig;
import io.rong.imlib.ICustomServiceListener;
import io.rong.imlib.IHandler;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.ModuleManager;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.CSCustomServiceInfo;
import io.rong.imlib.model.CSGroupItem;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.CustomServiceMode;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import io.rong.message.CSChangeModeMessage;
import io.rong.message.CSChangeModeResponseMessage;
import io.rong.message.CSEvaluateMessage;
import io.rong.message.CSHandShakeMessage;
import io.rong.message.CSHandShakeResponseMessage;
import io.rong.message.CSLeaveMessage;
import io.rong.message.CSPullEvaluateMessage;
import io.rong.message.CSPullLeaveMessage;
import io.rong.message.CSSuspendMessage;
import io.rong.message.CSTerminateMessage;
import io.rong.message.CSUpdateMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.TextMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomServiceManager
implements ModuleManager.MessageRouter {
    private static final String TAG = CustomServiceManager.class.getSimpleName();
    private static CustomServiceManager sIns;
    private boolean mInitialized = false;
    private RongIMClient.OnReceiveMessageListener onReceiveMessageListener;
    private HashMap<String, CustomServiceProfile> customServiceCache;
    private List<Class<? extends MessageContent>> csMessages = new ArrayList<Class<? extends MessageContent>>();
    private String failureStr = "";
    private String quitStr = "";
    private IHandler libStub;
    private Handler mainHandler;
    private OnHumanEvaluateListener onHumanEvaluateListener;

    private CustomServiceManager() {
        this.customServiceCache = new HashMap();
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public void init(Context context, RongIMClient.OnReceiveMessageListener onReceiveMessageListener, IHandler stub) {
        RLog.i(TAG, "init " + this.mInitialized);
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.csMessages.add(CSHandShakeMessage.class);
            this.csMessages.add(CSHandShakeResponseMessage.class);
            this.csMessages.add(CSChangeModeMessage.class);
            this.csMessages.add(CSChangeModeResponseMessage.class);
            this.csMessages.add(CSSuspendMessage.class);
            this.csMessages.add(CSTerminateMessage.class);
            this.csMessages.add(CSEvaluateMessage.class);
            this.csMessages.add(CSUpdateMessage.class);
            this.csMessages.add(CSPullEvaluateMessage.class);
            this.csMessages.add(CSPullLeaveMessage.class);
            this.csMessages.add(CSLeaveMessage.class);
            this.onReceiveMessageListener = onReceiveMessageListener;
            try {
                this.failureStr = context.getResources().getString(context.getResources().getIdentifier("rc_init_failed", "string", context.getPackageName()));
                this.quitStr = context.getResources().getString(context.getResources().getIdentifier("rc_quit_custom_service", "string", context.getPackageName()));
            }
            catch (Exception e) {
                RLog.e(TAG, "init ", e);
            }
            ModuleManager.addMessageRouter(this);
        }
        this.libStub = stub;
        this.registerMsg(stub);
    }

    private void registerMsg(IHandler stub) {
        try {
            for (Class<? extends MessageContent> msg : this.csMessages) {
                String v = msg.getAnnotation(MessageTag.class).value();
                stub.registerMessageType(msg.getName());
                stub.registerCmdMsgType(v);
            }
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            RLog.e(TAG, "Exception : \n" + stringWriter.toString());
        }
        catch (IncompatibleClassChangeError error) {
            RLog.e(TAG, "IncompatibleClassChangeError.");
        }
    }

    @Override
    public boolean onReceived(Message message, int left, boolean offline, int cmdLeft) {
        boolean contains = this.csMessages.contains(message.getContent().getClass());
        if (contains) {
            if (message.getContent() instanceof CSHandShakeResponseMessage) {
                String hello;
                final CSHandShakeResponseMessage csHandShakeResponseMessage = (CSHandShakeResponseMessage)message.getContent();
                final int code = csHandShakeResponseMessage.getCode();
                final String msg = csHandShakeResponseMessage.getMsg();
                String kefuId = message.getTargetId();
                final CustomServiceProfile profile = this.customServiceCache.get(kefuId);
                if (profile == null || profile.time == 0L || message.getSentTime() < profile.time) {
                    return true;
                }
                if (code == 0 && profile.customServiceListener.get() != null) {
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ICustomServiceListener iCustomServiceListener = (ICustomServiceListener)profile.customServiceListener.get();
                            if (iCustomServiceListener != null) {
                                iCustomServiceListener.onError(code, TextUtils.isEmpty((CharSequence)msg) ? CustomServiceManager.this.failureStr : msg);
                            }
                        }
                    });
                    return true;
                }
                profile.mode = csHandShakeResponseMessage.getMode();
                profile.sid = csHandShakeResponseMessage.getSid();
                profile.uid = csHandShakeResponseMessage.getUid();
                profile.pid = csHandShakeResponseMessage.getPid();
                profile.groupList = csHandShakeResponseMessage.getGroupList();
                profile.showResolveStatus = csHandShakeResponseMessage.isReportResolveStatus();
                this.customServiceCache.put(kefuId, profile);
                if (profile.customServiceListener.get() != null) {
                    final CustomServiceConfig config = new CustomServiceConfig();
                    config.companyName = csHandShakeResponseMessage.getCompanyName();
                    config.isBlack = csHandShakeResponseMessage.isBlack();
                    config.msg = csHandShakeResponseMessage.getMsg();
                    config.companyIcon = csHandShakeResponseMessage.getCompanyIcon();
                    config.robotSessionNoEva = csHandShakeResponseMessage.getRobotSessionNoEva() != null && csHandShakeResponseMessage.getRobotSessionNoEva().equals("1");
                    config.humanEvaluateList = csHandShakeResponseMessage.getHumanEvaluateList();
                    config.userTipTime = csHandShakeResponseMessage.getUserTipTime();
                    config.userTipWord = csHandShakeResponseMessage.getUserTipWord();
                    config.adminTipTime = csHandShakeResponseMessage.getAdminTipTime();
                    config.adminTipWord = csHandShakeResponseMessage.getAdminTipWord();
                    config.isDisableLocation = csHandShakeResponseMessage.isDisableLocation();
                    config.quitSuspendType = CustomServiceConfig.CSQuitSuspendType.valueOf(csHandShakeResponseMessage.isSuspendWhenQuit());
                    config.evaluateType = csHandShakeResponseMessage.getEvaType() == 0 ? CustomServiceConfig.CSEvaType.EVA_SEPARATELY : CustomServiceConfig.CSEvaType.EVA_UNIFIED;
                    config.evaEntryPoint = CustomServiceConfig.CSEvaEntryPoint.valueOf(csHandShakeResponseMessage.getEntryPoint());
                    config.isReportResolveStatus = csHandShakeResponseMessage.isReportResolveStatus();
                    config.leaveMessageConfigType = csHandShakeResponseMessage.getLeaveMessageConfigType() == 0 ? CustomServiceConfig.CSLeaveMessageType.NATIVE : CustomServiceConfig.CSLeaveMessageType.WEB;
                    config.uri = csHandShakeResponseMessage.getLeaveMessageWebUrl();
                    config.leaveMessageNativeInfo = csHandShakeResponseMessage.getLeaveMessageNativeInfo();
                    boolean announceMsgFlag = csHandShakeResponseMessage.getAnnounceMsgFlag() == 1;
                    config.announceMsg = announceMsgFlag ? csHandShakeResponseMessage.getAnnounceMsg() : "";
                    boolean announceClickFlag = csHandShakeResponseMessage.getAnnounceClickFlag() == 1;
                    config.announceClickUrl = announceClickFlag ? csHandShakeResponseMessage.getAnnounceClickUrl() : "";
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                            if (listener != null) {
                                listener.onSuccess(config);
                            }
                        }
                    });
                }
                String portrait = csHandShakeResponseMessage.getRobotLogo();
                String name = csHandShakeResponseMessage.getRobotName();
                profile.welcome = hello = csHandShakeResponseMessage.getRobotHelloWord();
                profile.name = name;
                profile.portrait = portrait;
                if (csHandShakeResponseMessage.getMode().equals((Object)CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT) || csHandShakeResponseMessage.getMode().equals((Object)CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT_FIRST)) {
                    if (!TextUtils.isEmpty((CharSequence)hello)) {
                        TextMessage textMessage = TextMessage.obtain(hello);
                        if (portrait != null) {
                            textMessage.setUserInfo(new UserInfo(kefuId, name, Uri.parse((String)portrait)));
                        }
                        RongIMClient.getInstance().insertIncomingMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, kefuId, null, textMessage, new RongIMClient.ResultCallback<Message>(){

                            @Override
                            public void onSuccess(Message message) {
                                if (CustomServiceManager.this.onReceiveMessageListener != null) {
                                    CustomServiceManager.this.onReceiveMessageListener.onReceived(message, 0);
                                }
                            }

                            @Override
                            public void onError(RongIMClient.ErrorCode e) {
                                RLog.e(TAG, "insertMessage , error code : " + e.getValue());
                            }
                        });
                    }
                    if (profile.customServiceListener.get() != null) {
                        this.mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                if (listener != null) {
                                    listener.onModeChanged(csHandShakeResponseMessage.getMode());
                                }
                            }
                        });
                    }
                } else if (csHandShakeResponseMessage.isRequiredChangMode()) {
                    this.switchToHumanMode(kefuId);
                } else {
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                            if (listener != null) {
                                listener.onModeChanged(csHandShakeResponseMessage.getMode());
                            }
                        }
                    });
                }
                RLog.d(TAG, csHandShakeResponseMessage.toString());
                return true;
            }
            if (message.getContent() instanceof CSChangeModeResponseMessage) {
                int code;
                final CSChangeModeResponseMessage csChangeModeResponseMessage = (CSChangeModeResponseMessage)message.getContent();
                final CustomServiceProfile profile = this.customServiceCache.get(message.getTargetId());
                if (profile != null && profile.customServiceListener.get() != null && profile.time != 0L && message.getSentTime() > profile.time && (code = csChangeModeResponseMessage.getResult()) == 1) {
                    switch (csChangeModeResponseMessage.getStatus()) {
                        case 1: {
                            profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN;
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN);
                                    }
                                }
                            });
                            break;
                        }
                        case 2: {
                            if (profile.mode == null) break;
                            if (profile.mode.equals((Object)CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN)) {
                                profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_NO_SERVICE;
                                this.mainHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                        if (listener != null) {
                                            listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_NO_SERVICE);
                                        }
                                    }
                                });
                                break;
                            }
                            if (!profile.mode.equals((Object)CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN_FIRST)) break;
                            profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT_FIRST;
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT_FIRST);
                                    }
                                }
                            });
                            if (TextUtils.isEmpty((CharSequence)profile.welcome)) break;
                            TextMessage textMessage = TextMessage.obtain(profile.welcome);
                            if (profile.portrait != null) {
                                textMessage.setUserInfo(new UserInfo(message.getTargetId(), profile.name, Uri.parse((String)profile.portrait)));
                            }
                            RongIMClient.getInstance().insertIncomingMessage(Conversation.ConversationType.CUSTOMER_SERVICE, message.getTargetId(), message.getTargetId(), null, textMessage, new RongIMClient.ResultCallback<Message>(){

                                @Override
                                public void onSuccess(Message message) {
                                    if (CustomServiceManager.this.onReceiveMessageListener != null) {
                                        CustomServiceManager.this.onReceiveMessageListener.onReceived(message, 0);
                                    }
                                }

                                @Override
                                public void onError(RongIMClient.ErrorCode e) {
                                    RLog.e(TAG, "insertMessage , error code : " + e.getValue());
                                }
                            });
                            break;
                        }
                        case 3: {
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    String msg = csChangeModeResponseMessage.getErrMsg();
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onError(3, msg);
                                    }
                                }
                            });
                            break;
                        }
                    }
                    if (this.onHumanEvaluateListener != null && !TextUtils.isEmpty((CharSequence)csChangeModeResponseMessage.getEvaluation())) {
                        JSONObject jsonObject = null;
                        try {
                            JSONObject jsonSaticfaction;
                            JSONObject jsonObjEva;
                            JSONArray jsonArray;
                            jsonObject = new JSONObject(csChangeModeResponseMessage.getEvaluation());
                            if (jsonObject.has("evaluation") && (jsonArray = (jsonObjEva = jsonObject.optJSONObject("evaluation")).getJSONArray("satisfaction")) != null && jsonArray.length() > 0 && (jsonSaticfaction = jsonArray.optJSONObject(0)).has("isQuestionFlag")) {
                                profile.showResolveStatus = jsonSaticfaction.optInt("isQuestionFlag", 0) == 1;
                            }
                        }
                        catch (JSONException e) {
                            RLog.e(TAG, "onReceive ", e);
                        }
                        this.onHumanEvaluateListener.onHumanEvaluate(jsonObject);
                    }
                }
                return true;
            }
            if (message.getContent() instanceof CSTerminateMessage) {
                CSTerminateMessage csTerminateMessage = (CSTerminateMessage)message.getContent();
                final CustomServiceProfile profile = this.customServiceCache.get(message.getTargetId());
                if (profile != null && profile.customServiceListener.get() != null && csTerminateMessage.getsid().equals(profile.sid) && profile.time != 0L && message.getSentTime() > profile.time) {
                    if (csTerminateMessage.getCode() == 0) {
                        final String msg = csTerminateMessage.getMsg();
                        this.mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                if (listener != null) {
                                    listener.onQuit(TextUtils.isEmpty((CharSequence)msg) ? CustomServiceManager.this.quitStr : msg);
                                }
                            }
                        });
                    } else {
                        profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT_FIRST;
                        this.mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                if (listener != null) {
                                    listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT_FIRST);
                                }
                            }
                        });
                    }
                }
                return true;
            }
            if (message.getContent() instanceof CSUpdateMessage) {
                CSUpdateMessage csUpdateMessage = (CSUpdateMessage)message.getContent();
                final CustomServiceProfile profile = this.customServiceCache.get(message.getTargetId());
                if (profile != null && profile.time != 0L && message.getSentTime() > profile.time) {
                    profile.sid = csUpdateMessage.getSid();
                    switch (csUpdateMessage.getServiceStatus()) {
                        case "1": {
                            profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT;
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_ROBOT);
                                    }
                                }
                            });
                            break;
                        }
                        case "2": {
                            profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN;
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN);
                                    }
                                }
                            });
                            break;
                        }
                        case "3": {
                            profile.mode = CustomServiceMode.CUSTOM_SERVICE_MODE_NO_SERVICE;
                            this.mainHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                                    if (listener != null) {
                                        listener.onModeChanged(CustomServiceMode.CUSTOM_SERVICE_MODE_NO_SERVICE);
                                    }
                                }
                            });
                        }
                    }
                }
                return true;
            }
            if (message.getContent() instanceof CSPullEvaluateMessage) {
                final CSPullEvaluateMessage csPullEvaluateMessage = (CSPullEvaluateMessage)message.getContent();
                final CustomServiceProfile profile = this.customServiceCache.get(message.getTargetId());
                if (profile != null && profile.time != 0L && message.getSentTime() > profile.time) {
                    profile.sid = csPullEvaluateMessage.getMsgId();
                    this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                            if (listener != null) {
                                listener.onPullEvaluation(csPullEvaluateMessage.getMsgId());
                            }
                        }
                    });
                }
                return true;
            }
            if (message.getContent() instanceof CSPullLeaveMessage) {
                return false;
            }
        }
        return contains;
    }

    public static CustomServiceManager getInstance() {
        return SingletonHolder.sIns;
    }

    public void startCustomService(final String kefuId, ICustomServiceListener listener, CSCustomServiceInfo customServiceInfo) {
        CustomServiceProfile profile;
        if (TextUtils.isEmpty((CharSequence)kefuId)) {
            RLog.e(TAG, "startCustomService kefuId should not be null!");
            return;
        }
        if (this.customServiceCache != null && (profile = this.customServiceCache.get(kefuId)) != null) {
            this.customServiceCache.remove(kefuId);
        }
        if (customServiceInfo == null) {
            CSCustomServiceInfo.Builder csBuilder = new CSCustomServiceInfo.Builder();
            customServiceInfo = csBuilder.build();
        }
        CSHandShakeMessage csHandShakeMessage = new CSHandShakeMessage();
        csHandShakeMessage.setCustomInfo(customServiceInfo);
        profile = new CustomServiceProfile(listener);
        if (this.customServiceCache != null) {
            this.customServiceCache.put(kefuId, profile);
        }
        try {
            Message message = Message.obtain(kefuId, Conversation.ConversationType.CUSTOMER_SERVICE, csHandShakeMessage);
            if (this.libStub != null) {
                this.libStub.sendMessage(message, "", "", new ISendMessageCallback.Stub(){

                    @Override
                    public void onAttached(Message message) throws RemoteException {
                    }

                    @Override
                    public void onSuccess(Message message) throws RemoteException {
                        CustomServiceProfile serviceProfile = (CustomServiceProfile)CustomServiceManager.this.customServiceCache.get(kefuId);
                        if (serviceProfile != null) {
                            serviceProfile.time = message.getSentTime();
                        }
                    }

                    @Override
                    public void onError(Message message, int errorCode) throws RemoteException {
                        ICustomServiceListener listener;
                        CustomServiceProfile serviceProfile = (CustomServiceProfile)CustomServiceManager.this.customServiceCache.get(kefuId);
                        if (serviceProfile != null && (listener = (ICustomServiceListener)serviceProfile.customServiceListener.get()) != null) {
                            listener.onError(errorCode, CustomServiceManager.this.failureStr);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "startCustomService ", e);
        }
    }

    public void sendChangeModelMessage(final String kefuId, String groupId) {
        if (TextUtils.isEmpty((CharSequence)kefuId)) {
            RLog.e(TAG, "sendChangeModelMessage kefuId should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "sendChangeModelMessage " + kefuId + " is not started yet!");
            return;
        }
        CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        CSChangeModeMessage changeModeMessage = CSChangeModeMessage.obtain(profile.sid, profile.uid, profile.pid, groupId);
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, changeModeMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                InformationNotificationMessage informationNotificationMessage = InformationNotificationMessage.obtain("\u65e0\u4eba\u5de5\u5728\u7ebf");
                RongIMClient.getInstance().insertOutgoingMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, null, informationNotificationMessage, null);
            }
        });
    }

    public void switchToHumanMode(String kefuId) {
        if (TextUtils.isEmpty((CharSequence)kefuId)) {
            RLog.e(TAG, "switchToHumanMode kefuId should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "switchToHumanMode " + kefuId + " is not started yet!");
            return;
        }
        final CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        if (profile.groupList != null && profile.groupList.size() > 0) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    ICustomServiceListener listener = (ICustomServiceListener)profile.customServiceListener.get();
                    if (listener != null && profile.groupList != null && profile.groupList.size() > 0) {
                        listener.onSelectGroup(profile.groupList);
                    }
                }
            });
        } else {
            this.sendChangeModelMessage(kefuId, null);
        }
    }

    public void evaluateCustomService(String kefuId, boolean isRobotResolved, String knowledgeId) {
        if (TextUtils.isEmpty((CharSequence)kefuId)) {
            RLog.e(TAG, "evaluateCustomService kefuId should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "evaluateCustomService " + kefuId + " is not started yet!");
            return;
        }
        CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        CSEvaluateMessage.Builder csBuilder = new CSEvaluateMessage.Builder();
        CSEvaluateMessage csEvaluateMessage = csBuilder.sid(TextUtils.isEmpty((CharSequence)knowledgeId) ? profile.sid : knowledgeId).pid(profile.pid).uid(profile.uid).type(EvaluateType.EVALUATE_ROBOT.getValue()).setSolveStatus(isRobotResolved ? CustomServiceConfig.CSEvaSolveStatus.RESOLVED.getValue() : CustomServiceConfig.CSEvaSolveStatus.UNRESOLVED.getValue()).build();
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, csEvaluateMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RLog.e(TAG, "evaluateCustomService onError " + (Object)((Object)errorCode));
            }
        });
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus solveStatus, String suggest, String dialogId) {
        if (TextUtils.isEmpty((CharSequence)kefuId) || solveStatus == null) {
            RLog.e(TAG, "evaluateCustomService kefuId or solveStatus should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "evaluateCustomService " + kefuId + " is not started yet!");
            return;
        }
        CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        int resloveStatus = !profile.showResolveStatus ? -1 : solveStatus.getValue();
        CSEvaluateMessage.Builder csBuilder = new CSEvaluateMessage.Builder();
        CSEvaluateMessage csEvaluateMessage = csBuilder.sid(TextUtils.isEmpty((CharSequence)dialogId) ? profile.sid : dialogId).pid(profile.pid).uid(profile.uid).source(source).setSolveStatus(resloveStatus).suggest(suggest).type(EvaluateType.EVALUATE_HUMAN.getValue()).build();
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, csEvaluateMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RLog.d(TAG, "onSuccess.");
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RLog.e(TAG, "evaluateCustomService onError " + (Object)((Object)errorCode));
            }
        });
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus solveStatus, String tagtext, String suggest, String dialogId, String extra) {
        if (TextUtils.isEmpty((CharSequence)kefuId) || solveStatus == null) {
            RLog.e(TAG, "evaluateCustomService kefuId or solveStatus should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "evaluateCustomService " + kefuId + " is not started yet!");
            return;
        }
        CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        CSEvaluateMessage.Builder csBuilder = new CSEvaluateMessage.Builder();
        EvaluateType type = profile.mode == CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN || profile.mode == CustomServiceMode.CUSTOM_SERVICE_MODE_HUMAN_FIRST ? EvaluateType.EVALUATE_HUMAN : EvaluateType.EVALUATE_ROBOT;
        int resloveStatus = !profile.showResolveStatus ? -1 : solveStatus.getValue();
        CSEvaluateMessage csEvaluateMessage = csBuilder.sid(TextUtils.isEmpty((CharSequence)dialogId) ? profile.sid : dialogId).pid(profile.pid).uid(profile.uid).source(source).setSolveStatus(resloveStatus).tablets(tagtext).suggest(suggest).type(type.getValue()).extra(extra).build();
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, csEvaluateMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RLog.d(TAG, "onSuccess.");
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RLog.e(TAG, "evaluateCustomService onError " + (Object)((Object)errorCode));
            }
        });
    }

    public void leaveMessageToCustomService(String kefuId, Map<String, String> contentMap, final RongIMClient.OperationCallback operationCallback) {
        CSLeaveMessage csLeaveMessage = new CSLeaveMessage();
        csLeaveMessage.setDataSet(contentMap);
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, csLeaveMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                if (operationCallback != null) {
                    operationCallback.onSuccess();
                }
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                if (operationCallback != null) {
                    operationCallback.onError(errorCode);
                }
            }
        });
    }

    public void stopCustomService(String kefuId) {
        if (TextUtils.isEmpty((CharSequence)kefuId)) {
            RLog.e(TAG, "stopCustomService kefuId should not be null!");
            return;
        }
        if (!this.customServiceCache.containsKey(kefuId)) {
            RLog.e(TAG, "stopCustomService " + kefuId + " is not started yet!");
            return;
        }
        CustomServiceProfile profile = this.customServiceCache.get(kefuId);
        CSSuspendMessage csSuspendMessage = CSSuspendMessage.obtain(profile.sid, profile.uid, profile.pid);
        RongIMClient.getInstance().sendMessage(Conversation.ConversationType.CUSTOMER_SERVICE, kefuId, csSuspendMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
            }

            @Override
            public void onError(Message message, RongIMClient.ErrorCode errorCode) {
                RLog.e(TAG, "stopCustomService onError " + (Object)((Object)errorCode));
            }
        });
        this.customServiceCache.remove(kefuId);
    }

    public void setHumanEvaluateListener(OnHumanEvaluateListener listener) {
        this.onHumanEvaluateListener = listener;
    }

    public static interface OnHumanEvaluateListener {
        public void onHumanEvaluate(JSONObject var1);
    }

    private static enum EvaluateType {
        EVALUATE_ROBOT(0),
        EVALUATE_HUMAN(1);

        int value;

        private EvaluateType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class SingletonHolder {
        static CustomServiceManager sIns = new CustomServiceManager();

        private SingletonHolder() {
        }
    }

    private static class CustomServiceProfile {
        CustomServiceMode mode;
        String pid;
        String uid;
        String sid;
        long time;
        String welcome;
        String name;
        String portrait;
        ArrayList<CSGroupItem> groupList;
        WeakReference<ICustomServiceListener> customServiceListener;
        boolean showResolveStatus;

        CustomServiceProfile(ICustomServiceListener listener) {
            this.customServiceListener = new WeakReference<ICustomServiceListener>(listener);
        }
    }
}

