/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignatureUtils {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getAppSignatureSHA1(Context context, String packageName) {
        Signature[] signature = SignatureUtils.getAppSignature(context, packageName);
        if (signature == null) {
            return null;
        }
        return SignatureUtils.encryptSHA1ToString(signature[0].toByteArray()).replaceAll("(?<=[0-9A-F]{2})[0-9A-F]{2}", ":$0");
    }

    public static String getAppSignatureSHA1(Context context) {
        return SignatureUtils.getAppSignatureSHA1(context, context.getPackageName());
    }

    public static String getAppSignatureSHA1NoSign(Context context) {
        Signature[] signature = SignatureUtils.getAppSignature(context, context.getPackageName());
        if (signature == null) {
            return null;
        }
        return SignatureUtils.encryptSHA1ToString(signature[0].toByteArray());
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static Signature[] getAppSignature(Context context, String packageName) {
        if (SignatureUtils.isNullString(packageName)) {
            return null;
        }
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(packageName, 64);
            return pi == null ? null : pi.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNullString(String str) {
        return str == null || str.length() == 0 || "null".equals(str);
    }

    public static String encryptSHA1ToString(byte[] data) {
        return SignatureUtils.bytes2HexString(SignatureUtils.encryptSHA1(data));
    }

    public static String bytes2HexString(byte[] bytes) {
        char[] ret = new char[bytes.length << 1];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            ret[j++] = HEX_DIGITS[bytes[i] >>> 4 & 0xF];
            ret[j++] = HEX_DIGITS[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] encryptSHA1(byte[] data) {
        return SignatureUtils.encryptAlgorithm(data, "SHA-1");
    }

    private static byte[] encryptAlgorithm(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

