/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.EncryptUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SecureSharedPreferences
implements SharedPreferences {
    private SharedPreferences mSharedPreferences;
    private static final String TAG = SharedPreferences.class.getName();
    private Context mContext;

    public static SecureSharedPreferences get(Context context, String name, int mode) {
        return new SecureSharedPreferences(context, name, mode);
    }

    public static SecureSharedPreferences get(Context context, String name) {
        return SecureSharedPreferences.get(context, name, 0);
    }

    public static SecureSharedPreferences get(Context context) {
        return SecureSharedPreferences.get(context, null, 0);
    }

    public SecureSharedPreferences(Context context, String name, int mode) {
        this.mContext = context.getApplicationContext();
        if (this.mContext == null) {
            this.mContext = context;
        }
        this.mSharedPreferences = TextUtils.isEmpty((CharSequence)name) ? PreferenceManager.getDefaultSharedPreferences((Context)context) : context.getSharedPreferences(name, mode);
    }

    public Map<String, String> getAll() {
        Map encryptMap = this.mSharedPreferences.getAll();
        HashMap<String, String> decryptMap = new HashMap<String, String>();
        for (Map.Entry entry : encryptMap.entrySet()) {
            Object cipherText = entry.getValue();
            if (cipherText == null) continue;
            decryptMap.put((String)entry.getKey(), entry.getValue().toString());
        }
        return decryptMap;
    }

    private String encryptPreference(String plainText) {
        return EncryptUtil.getInstance(this.mContext).encrypt(plainText);
    }

    private String decryptPreference(String cipherText) {
        return EncryptUtil.getInstance(this.mContext).decrypt(cipherText);
    }

    public String getString(String key, String defValue) {
        String result = this.decryptPreference(this.mSharedPreferences.getString(key, null));
        return result == null ? defValue : result;
    }

    public Set<String> getStringSet(String key, Set<String> defValues) {
        Set encryptSet = this.mSharedPreferences.getStringSet(key, null);
        if (encryptSet == null) {
            return defValues;
        }
        HashSet<String> decryptSet = new HashSet<String>();
        for (String encryptValue : encryptSet) {
            decryptSet.add(this.decryptPreference(encryptValue));
        }
        return decryptSet;
    }

    public int getInt(String key, int defValue) {
        try {
            String result = this.decryptPreference(this.mSharedPreferences.getString(key, null));
            Log.d((String)TAG, (String)("int:::key:" + key + ":" + result));
            return result == null ? defValue : Integer.parseInt(result);
        }
        catch (ClassCastException e) {
            RLog.e(TAG, "getInt", e);
            return defValue;
        }
    }

    public long getLong(String key, long defValue) {
        try {
            String result = this.decryptPreference(this.mSharedPreferences.getString(key, null));
            return result == null ? defValue : Long.parseLong(result);
        }
        catch (ClassCastException e) {
            RLog.e(TAG, "getLong", e);
            return defValue;
        }
    }

    public float getFloat(String key, float defValue) {
        try {
            String result = this.decryptPreference(this.mSharedPreferences.getString(key, null));
            return result == null ? defValue : Float.parseFloat(this.decryptPreference(result));
        }
        catch (ClassCastException e) {
            RLog.e(TAG, "getFloat", e);
            return defValue;
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        try {
            String result = this.decryptPreference(this.mSharedPreferences.getString(key, null));
            return result == null ? defValue : Boolean.parseBoolean(result);
        }
        catch (ClassCastException e) {
            RLog.e(TAG, "getBoolean", e);
            return defValue;
        }
    }

    public boolean contains(String key) {
        return this.mSharedPreferences.contains(key);
    }

    public Editor edit() {
        return new Editor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener(listener);
    }

    public void handleTransition() {
        Map oldMap = this.mSharedPreferences.getAll();
        HashMap newMap = new HashMap();
        for (Map.Entry entry : oldMap.entrySet()) {
            newMap.put(entry.getKey(), this.encryptPreference(entry.getValue().toString()));
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.clear().apply();
        for (Map.Entry entry : newMap.entrySet()) {
            editor.putString((String)entry.getKey(), (String)entry.getValue());
        }
        editor.commit();
    }

    public final class Editor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor mEditor;

        private Editor() {
            this.mEditor = SecureSharedPreferences.this.mSharedPreferences.edit();
        }

        public SharedPreferences.Editor putString(String key, String value) {
            this.mEditor.putString(key, SecureSharedPreferences.this.encryptPreference(value));
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            HashSet<String> encryptSet = new HashSet<String>();
            for (String value : values) {
                encryptSet.add(SecureSharedPreferences.this.encryptPreference(value));
            }
            this.mEditor.putStringSet(key, encryptSet);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.mEditor.putString(key, SecureSharedPreferences.this.encryptPreference(Integer.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.mEditor.putString(key, SecureSharedPreferences.this.encryptPreference(Long.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.mEditor.putString(key, SecureSharedPreferences.this.encryptPreference(Float.toString(value)));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.mEditor.putString(key, SecureSharedPreferences.this.encryptPreference(Boolean.toString(value)));
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mEditor.remove(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.mEditor.clear();
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        public void apply() {
            this.mEditor.apply();
        }
    }
}

