/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.text.TextUtils;
import android.util.Log;
import java.io.File;

public class SavePathUtils {
    private static final String TAG = SavePathUtils.class.getSimpleName();
    private static String savePath = "";

    public static String getSavePath() {
        return savePath;
    }

    public static String getSavePath(String defaultPath) {
        return SavePathUtils.isSavePathEmpty() ? defaultPath : savePath;
    }

    public static File getSavePath(File defaultFile) {
        return SavePathUtils.isSavePathEmpty() ? defaultFile : new File(savePath);
    }

    public static void setSavePath(String path) {
        if (SavePathUtils.isDir(path)) {
            savePath = path;
        }
    }

    public static boolean isSavePathEmpty() {
        return TextUtils.isEmpty((CharSequence)savePath);
    }

    public static boolean isDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            Log.e((String)TAG, (String)"SavePath not exists..");
            return false;
        }
        if (!file.isDirectory()) {
            Log.e((String)TAG, (String)"SavePath not Directory..");
            return false;
        }
        return true;
    }
}

