/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import io.rong.common.utils.SSLUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class NetUtils {
    private static final String TAG = NetUtils.class.getSimpleName();
    private static Boolean isLatestNetWorkAvailable = null;

    public static HttpURLConnection createURLConnection(String urlStr) throws IOException {
        HttpURLConnection conn;
        if (urlStr.toLowerCase().startsWith("https")) {
            HostnameVerifier hostnameVerifier;
            URL url = new URL(urlStr);
            HttpsURLConnection c = (HttpsURLConnection)url.openConnection();
            SSLContext sslContext = SSLUtils.getSSLContext();
            if (sslContext != null) {
                c.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            if ((hostnameVerifier = SSLUtils.getHostVerifier()) != null) {
                c.setHostnameVerifier(hostnameVerifier);
            }
            conn = c;
        } else {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
        }
        return conn;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean isNetWorkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        try {
            networkInfo = cm.getActiveNetworkInfo();
            Log.d((String)TAG, (String)("network : " + (networkInfo != null ? networkInfo.isAvailable() + " " + networkInfo.isConnected() : "null")));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"getActiveNetworkInfo Exception", (Throwable)e);
        }
        boolean isNetWorkAvailable = networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        return isNetWorkAvailable;
    }

    public static boolean getCacheNetworkAvailable(Context context) {
        if (isLatestNetWorkAvailable == null) {
            isLatestNetWorkAvailable = NetUtils.isNetWorkAvailable(context);
        }
        return isLatestNetWorkAvailable;
    }

    public static void updateCacheNetworkAvailable(boolean isAvailable) {
        isLatestNetWorkAvailable = isAvailable;
    }
}

