/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.SignatureUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtil {
    private String key;
    private static EncryptUtil instance;
    private static final String TAG;

    private EncryptUtil(Context context) {
        String sha;
        String sha1 = SignatureUtils.getAppSignatureSHA1NoSign(context);
        if (TextUtils.isEmpty((CharSequence)sha1) || sha1.length() < 16) {
            sha1 = this.getAndroidId(context) + "#$ERDTS$D%F^Gojikbh";
        }
        if ((sha = this.SHA(sha1)) != null) {
            this.key = sha.substring(0, 16);
        } else {
            RLog.e(TAG, "key is null");
        }
    }

    public static synchronized EncryptUtil getInstance(Context context) {
        if (instance == null) {
            instance = new EncryptUtil(context);
        }
        return instance;
    }

    private String getAndroidId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private String SHA(String strText) {
        String strResult = null;
        if (strText != null && strText.length() > 0) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                messageDigest.update(strText.getBytes());
                byte[] byteBuffer = messageDigest.digest();
                StringBuffer strHexString = new StringBuffer();
                for (int i = 0; i < byteBuffer.length; ++i) {
                    String hex = Integer.toHexString(0xFF & byteBuffer[i]);
                    if (hex.length() == 1) {
                        strHexString.append('0');
                    }
                    strHexString.append(hex);
                }
                strResult = strHexString.toString();
            }
            catch (NoSuchAlgorithmException e) {
                RLog.e(TAG, "SHA", e);
            }
        }
        return strResult;
    }

    public String encrypt(String plainText) {
        if (plainText == null) {
            return null;
        }
        if (this.key == null) {
            RLog.e(TAG, "key is null");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec keyspec = new SecretKeySpec(this.key.getBytes(), "AES");
            cipher.init(1, keyspec);
            byte[] encrypted = cipher.doFinal(plainText.getBytes());
            return Base64.encodeToString((byte[])encrypted, (int)2);
        }
        catch (Exception e) {
            RLog.e(TAG, "encrypt", e);
            return null;
        }
    }

    public String decrypt(String cipherText) {
        if (cipherText == null) {
            return null;
        }
        if (this.key == null) {
            RLog.e(TAG, "key is null");
            return null;
        }
        try {
            byte[] encrypted1 = Base64.decode((String)cipherText, (int)2);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec keyspec = new SecretKeySpec(this.key.getBytes(), "AES");
            cipher.init(2, keyspec);
            byte[] original = cipher.doFinal(encrypted1);
            String originalString = new String(original);
            return originalString;
        }
        catch (Exception e) {
            RLog.e(TAG, "decrypt", e);
            return null;
        }
    }

    static {
        TAG = EncryptUtil.class.getSimpleName();
    }
}

