/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import io.rong.imlib.common.SharedPreferencesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class DeviceUtils {
    public static synchronized String getDeviceId(Context context, String appKey) {
        SharedPreferences sp = SharedPreferencesUtils.get(context, "Statistics", 0);
        String deviceId = sp.getString("deviceId", "");
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            String[] params = new String[]{DeviceUtils.getDeviceId(context), appKey, context.getPackageName()};
            deviceId = DeviceUtils.ShortMD5(0, params);
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("deviceId", deviceId);
            editor.commit();
        }
        return deviceId;
    }

    public static String getDeviceId(Context context) {
        SharedPreferences sp = SharedPreferencesUtils.get(context, "Statistics", 0);
        String deviceId = sp.getString("ANDROID_ID", "");
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = Settings.Secure.getString((ContentResolver)context.getApplicationContext().getContentResolver(), (String)"android_id");
            if (TextUtils.isEmpty((CharSequence)deviceId)) {
                SecureRandom random = new SecureRandom();
                deviceId = new BigInteger(64, random).toString(16);
            }
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("ANDROID_ID", deviceId);
            editor.commit();
        }
        return deviceId;
    }

    public static String getDeviceIMEI(Context context) {
        return DeviceUtils.getDeviceId(context);
    }

    @Deprecated
    public static String ShortMD5(String ... args) {
        return DeviceUtils.ShortMD5(0, args);
    }

    public static String ShortMD5(int flags, String ... args) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
            }
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(builder.toString().getBytes());
            byte[] mds = mdInst.digest();
            mds = Base64.encode((byte[])mds, (int)flags);
            String result = new String(mds);
            result = result.replace("=", "").replace("+", "-").replace("/", "_").replace("\n", "");
            return result;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getPhoneInformation(Context context) {
        String MCCMNC = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            MCCMNC = telephonyManager.getNetworkOperator();
        }
        catch (SecurityException e) {
            Log.e((String)"DeviceUtils", (String)"SecurityException!!!");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        String network = "";
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager != null ? connectivityManager.getActiveNetworkInfo() : null;
        }
        catch (SecurityException e) {
            Log.e((String)"DeviceUtils", (String)"getPhoneInformation securityException!!!");
        }
        if (networkInfo != null) {
            network = networkInfo.getTypeName();
        }
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (manufacturer == null) {
            manufacturer = "";
        }
        if (model == null) {
            model = "";
        }
        String devInfo = manufacturer;
        devInfo = devInfo + "|";
        devInfo = devInfo + model;
        devInfo = devInfo + "|";
        devInfo = devInfo + String.valueOf(Build.VERSION.SDK_INT);
        devInfo = devInfo + "|";
        devInfo = devInfo + network;
        devInfo = devInfo + "|";
        devInfo = devInfo + MCCMNC;
        devInfo = devInfo + "|";
        devInfo = devInfo + context.getPackageName();
        devInfo = devInfo.replace("-", "_");
        Log.i((String)"DeviceUtils", (String)("getPhoneInformation.the phone information is: " + devInfo));
        return devInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDeviceManufacturer() {
        String manufacturer = Build.MANUFACTURER.replace("-", "_");
        long outTime = 3000L;
        if (!TextUtils.isEmpty((CharSequence)manufacturer)) {
            if ("vivo".equals(manufacturer)) {
                manufacturer = manufacturer.toUpperCase();
            }
            return manufacturer;
        }
        Runtime runtime = Runtime.getRuntime();
        String line = "";
        Worker worker = new Worker(runtime);
        long startTime = System.currentTimeMillis();
        worker.start();
        try {
            worker.join(outTime);
            line = worker.line;
        }
        catch (InterruptedException ex) {
            worker.interrupt();
        }
        finally {
            worker.interrupt();
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime >= outTime) {
            Log.e((String)"DeviceUtils", (String)"getDeviceManufacturer====OutTime");
        }
        if (!TextUtils.isEmpty((CharSequence)line)) {
            return "Xiaomi";
        }
        return "";
    }

    public static String getDeviceBandModelVersion() {
        return Build.BRAND + "|" + Build.MODEL + "|" + Build.VERSION.RELEASE;
    }

    public static boolean isEMUI() {
        return Build.MANUFACTURER.equalsIgnoreCase("HUAWEI");
    }

    public static String getNetworkType(Context context) {
        String strNetworkType = "none";
        if (context == null) {
            return "null";
        }
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
            try {
                if (networkInfo.getType() == 1) {
                    strNetworkType = "WIFI";
                } else if (networkInfo.getType() == 0) {
                    String _strSubTypeName = networkInfo.getSubtypeName();
                    int networkType = networkInfo.getSubtype();
                    switch (networkType) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            strNetworkType = "2G";
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            strNetworkType = "3G";
                            break;
                        }
                        case 13: {
                            strNetworkType = "4G";
                            break;
                        }
                        default: {
                            strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3G" : _strSubTypeName;
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)"DeviceUtils", (String)e.getMessage());
            }
        }
        return strNetworkType;
    }

    private static class Worker
    extends Thread {
        String propName = "ro.miui.ui.version.name";
        Runtime runtime;
        BufferedReader input = null;
        String line;
        Process process;

        private Worker(Runtime runtime) {
            this.runtime = runtime;
        }

        @Override
        public void run() {
            try {
                this.process = this.runtime.exec("getprop " + this.propName);
                this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()), 1024);
                this.line = this.input.readLine();
                this.input.close();
            }
            catch (IOException e) {
                Log.e((String)"DeviceUtils", (String)"Unable to read sysprop ");
            }
            finally {
                if (this.input != null) {
                    try {
                        this.input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.process != null) {
                    this.process.destroy();
                }
            }
        }
    }
}

