/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.rong.common.ExpansionUtils;
import io.rong.common.FileUtils;
import io.rong.common.SystemUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.IFwLogWriter;
import io.rong.common.rlog.RLog;
import io.rong.common.rlog.RLogReporter;
import io.rong.imlib.ConnectChangeReceiver;
import io.rong.imlib.ConversationStatusListener;
import io.rong.imlib.CustomServiceConfig;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IConnectStringCallback;
import io.rong.imlib.IConnectionStatusListener;
import io.rong.imlib.ICustomServiceListener;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IDownloadMediaCallback;
import io.rong.imlib.IDownloadMediaFileCallback;
import io.rong.imlib.IDownloadMediaMessageCallback;
import io.rong.imlib.IGetConversationListWithProcessCallback;
import io.rong.imlib.IGetNotificationQuietHoursCallback;
import io.rong.imlib.IHandler;
import io.rong.imlib.IIntegerCallback;
import io.rong.imlib.ILongCallback;
import io.rong.imlib.IMLibExtensionModuleManager;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IMessageExpansionListener;
import io.rong.imlib.INaviContentUpdateCallBack;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IRLogOtherProgressCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.ISendMediaMessageCallback;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.ISetPushSettingCallback;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.IUploadCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.MessageTag;
import io.rong.imlib.ModuleManager;
import io.rong.imlib.OnReceiveMessageListener;
import io.rong.imlib.RongCommonDefine;
import io.rong.imlib.UserProfileSettingListener;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.SharedPreferencesUtils;
import io.rong.imlib.cs.CustomServiceManager;
import io.rong.imlib.destruct.DestructionTaskManager;
import io.rong.imlib.destruct.MessageBufferPool;
import io.rong.imlib.ipc.IpcCallbackProxy;
import io.rong.imlib.ipc.RongService;
import io.rong.imlib.location.RealTimeLocationConstant;
import io.rong.imlib.location.RealTimeLocationManager;
import io.rong.imlib.location.RealTimeLocationObserver;
import io.rong.imlib.location.RealTimeLocationType;
import io.rong.imlib.model.CSCustomServiceInfo;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.ConversationStatus;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageConfig;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.ReadReceiptInfo;
import io.rong.imlib.model.RemoteHistoryMsgOption;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.model.RongListWrap;
import io.rong.imlib.model.SearchConversationResult;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.rtc.RoomUserStateMessage;
import io.rong.imlib.statistics.Statistics;
import io.rong.imlib.typingmessage.TypingMessageManager;
import io.rong.imlib.typingmessage.TypingStatus;
import io.rong.imlib.typingmessage.TypingStatusMessage;
import io.rong.message.ChatRoomKVNotiMessage;
import io.rong.message.CommandMessage;
import io.rong.message.CommandNotificationMessage;
import io.rong.message.ContactNotificationMessage;
import io.rong.message.DestructionCmdMessage;
import io.rong.message.DiscussionNotificationMessage;
import io.rong.message.FileMessage;
import io.rong.message.GIFMessage;
import io.rong.message.GroupNotificationMessage;
import io.rong.message.HQVoiceMessage;
import io.rong.message.HandshakeMessage;
import io.rong.message.HistoryDividerMessage;
import io.rong.message.ImageMessage;
import io.rong.message.InformationNotificationMessage;
import io.rong.message.LocationMessage;
import io.rong.message.LogCmdMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.MessageExpansionMessage;
import io.rong.message.ProfileNotificationMessage;
import io.rong.message.PublicServiceCommandMessage;
import io.rong.message.PublicServiceMultiRichContentMessage;
import io.rong.message.PublicServiceRichContentMessage;
import io.rong.message.RCEncryptCancelMessage;
import io.rong.message.RCEncryptConfirmMessage;
import io.rong.message.RCEncryptRequestMessage;
import io.rong.message.RCEncryptResponseMessage;
import io.rong.message.RCEncryptTerminateMessage;
import io.rong.message.RCEncryptedMessage;
import io.rong.message.ReadReceiptMessage;
import io.rong.message.ReadReceiptRequestMessage;
import io.rong.message.ReadReceiptResponseMessage;
import io.rong.message.RecallCommandMessage;
import io.rong.message.RecallNotificationMessage;
import io.rong.message.ReferenceMessage;
import io.rong.message.RichContentMessage;
import io.rong.message.SuspendMessage;
import io.rong.message.SyncReadStatusMessage;
import io.rong.message.TextMessage;
import io.rong.message.VoiceMessage;
import io.rong.message.utils.RCDHCodecTool;
import io.rong.push.PushManager;
import io.rong.push.RongPushClient;
import io.rong.push.common.PushCacheHelper;
import io.rong.push.rongpush.PushReceiver;
import io.rong.rtlog.upload.RtFwLogConsolePrinter;
import java.io.File;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RongIMClient {
    private static final String TAG = "RongIMClient";
    private final int CONVERSATION_NUMBER_OF_ONE_BATCH = 10;
    private IHandler mLibHandler;
    private static Handler mHandler;
    private final List<String> mRegCache;
    private Context mContext;
    private volatile String mToken;
    private String mAppKey;
    private String mCurrentUserId;
    private StatusListener mStatusListener;
    private ConnectChangeReceiver mConnectChangeReceiver;
    private ConnectRunnable mConnectRunnable;
    private ConnectionStatusListener.ConnectionStatus mConnectionStatus = ConnectionStatusListener.ConnectionStatus.UNCONNECTED;
    private static ConnectionStatusListener sConnectionListener;
    private static OnReceiveMessageListener sReceiveMessageListener;
    private static ReadReceiptListener sReadReceiptListener;
    private static OnRecallMessageListener sOnRecallMessageListener;
    private SyncConversationReadStatusListener mSyncConversationReadStatusListener;
    private OnReceiveDestructionMessageListener mOnReceiveDestructionMessageListener;
    private Handler mWorkHandler;
    private Handler mUpStreamHandler;
    private AidlConnection mAidlConnection;
    private static String URL_STATISTIC;
    private static String PRIVATE_STATISTIC;
    private static boolean isPushEnabled;
    private Set<String> mCmdObjectNameList;
    private Set<String> mDeleteObjectNameList;
    private ConnectCallback connectCallback;
    private static boolean userPolicy;
    private IMLibExtensionModuleManager imLibExtensionModuleManager;
    private EncryptedSessionConnectionListener mEncSessionConListener;
    private Activity topForegroundActivity;
    private boolean kickReconnectDevice = false;
    private static boolean isInForeground;
    private static volatile boolean needCallBackDBOpen;
    private Timer connectTimeoutTimer;
    private static ConversationStatusListener sConversationStatusListener;
    private static KVStatusListener sKVStatusListener;
    private static volatile boolean cancelSDKHeartBeatEnabled;
    private static MessageExpansionListener messageExpansionListener;
    private static AtomicReference<ChatRoomActionListener> chatRoomActionListener;
    private HashMap<String, ChatRoomCacheRunnable> mRetryCRCache = new HashMap();
    private HashMap<String, ChatRoomCacheRunnable> mChatRoomCache = new HashMap();
    private ConcurrentHashMap<String, Message> signalBuff = new ConcurrentHashMap();
    private static String mNaviServer;
    private static String mFileServer;

    private RongIMClient() {
        RLog.i(TAG, TAG);
        mHandler = new Handler(Looper.getMainLooper());
        this.mRegCache = new ArrayList<String>();
        HandlerThread workThread = new HandlerThread("IPC_WORK");
        workThread.start();
        HandlerThread upThread = new HandlerThread("UP_WORK");
        upThread.start();
        this.mStatusListener = new StatusListener();
        this.mWorkHandler = new Handler(workThread.getLooper());
        this.mUpStreamHandler = new Handler(upThread.getLooper());
        this.mConnectChangeReceiver = new ConnectChangeReceiver();
        this.mAidlConnection = new AidlConnection();
        this.mCmdObjectNameList = new CopyOnWriteArraySet<String>();
        this.mDeleteObjectNameList = new HashSet<String>();
        this.imLibExtensionModuleManager = IMLibExtensionModuleManager.getInstance();
        IMLibRTCClient.getInstance().init(this.mWorkHandler);
    }

    public void setEncryptedSessionConnectionListener(EncryptedSessionConnectionListener encryptedSessionConnectionListener) {
        this.mEncSessionConListener = encryptedSessionConnectionListener;
    }

    public static RongIMClient getInstance() {
        return SingletonHolder.sInstance;
    }

    private void initBindService() {
        if (this.mLibHandler != null) {
            this.initReceiver();
            return;
        }
        if (this.mContext == null || this.mAppKey == null) {
            RLog.d(TAG, "initBindService context or appKey is null,cause by bind before init");
            return;
        }
        try {
            Intent intent = new Intent(this.mContext, RongService.class);
            intent.putExtra("appKey", this.mAppKey);
            intent.putExtra("deviceId", DeviceUtils.getDeviceId(this.mContext, this.mAppKey));
            this.mContext.bindService(intent, (ServiceConnection)this.mAidlConnection, 1);
        }
        catch (SecurityException e) {
            RLog.e(TAG, "initBindService SecurityException");
            RLog.e(TAG, "initBindService", e);
        }
    }

    public ConnectionStatusListener.ConnectionStatus getCurrentConnectionStatus() {
        return this.mConnectionStatus;
    }

    private void registerCmdMsgType() {
        try {
            this.mCmdObjectNameList.add(ReadReceiptMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(ReadReceiptRequestMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(ReadReceiptResponseMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(TypingStatusMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(RecallCommandMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(SyncReadStatusMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(LogCmdMessage.class.getAnnotation(MessageTag.class).value());
            this.mCmdObjectNameList.add(MessageExpansionMessage.class.getAnnotation(MessageTag.class).value());
            List<Class<? extends MessageContent>> messageContents = this.imLibExtensionModuleManager.getCmdMessageContentList();
            if (messageContents != null) {
                for (Class<? extends MessageContent> clazz : messageContents) {
                    this.mCmdObjectNameList.add(clazz.getAnnotation(MessageTag.class).value());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RLog.e(TAG, "Exception when register command messages. e:" + e.getMessage());
        }
        catch (IncompatibleClassChangeError error) {
            RLog.e(TAG, "error when register command message. error message:" + error.getMessage());
        }
    }

    private void registerDeleteMessageType() {
        try {
            this.mDeleteObjectNameList.add(ReadReceiptMessage.class.getAnnotation(MessageTag.class).value());
            this.mDeleteObjectNameList.add(SyncReadStatusMessage.class.getAnnotation(MessageTag.class).value());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            RLog.e(TAG, "Exception when register deleted messages. e:" + e.getMessage());
        }
    }

    private void registerReconnectIntentFilter() {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            this.mContext.registerReceiver((BroadcastReceiver)this.mConnectChangeReceiver, intentFilter);
        }
        catch (Exception e) {
            RLog.e(TAG, "registerReconnectIntentFilter failed: " + e.getMessage());
        }
    }

    private void initStatistics(Context context, String appKey) {
        if (Statistics.sharedInstance().isInitialized()) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)PRIVATE_STATISTIC)) {
            Statistics.sharedInstance().init(context, PRIVATE_STATISTIC, appKey, DeviceUtils.getDeviceId(context, this.mAppKey));
        } else {
            Statistics.sharedInstance().init(context, URL_STATISTIC, appKey, DeviceUtils.getDeviceId(context, this.mAppKey));
        }
        Statistics.sharedInstance().setLoggingEnabled(false);
        Statistics.sharedInstance().onStart();
    }

    public static void init(Application application, String appKey) {
        RongIMClient.init((Context)application, appKey, true);
    }

    private void onAppBackgroundChanged(boolean inForeground) {
        FwLog.write(3, 1, FwLog.LogTag.L_APP_STATE_S.getTag(), "foreground", inForeground);
        isInForeground = inForeground;
        if (this.mLibHandler != null) {
            try {
                if (inForeground) {
                    this.connectServer(this.mToken, true);
                }
                this.mLibHandler.notifyAppBackgroundChanged(!isInForeground);
            }
            catch (Exception e) {
                RLog.e(TAG, "onAppBackgroundChanged", e);
            }
        } else if (inForeground) {
            RLog.e(TAG, "rebind RongService: " + (Object)((Object)this.mConnectionStatus));
            this.initBindService();
        }
    }

    private void initSDK(final Context context, String appKey) {
        block6: {
            String currentProcess = SystemUtils.getCurrentProcessName(context);
            String mainProcess = context.getPackageName();
            RLog.d(TAG, "init : " + currentProcess + ", " + mainProcess + ", " + context);
            if (TextUtils.isEmpty((CharSequence)currentProcess) || TextUtils.isEmpty((CharSequence)mainProcess) || !mainProcess.equals(currentProcess)) {
                RLog.e(TAG, "SDK should init in main process.");
                return;
            }
            if (context instanceof Application) {
                ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    }

                    public void onActivityStarted(Activity activity) {
                    }

                    public void onActivityResumed(Activity activity) {
                        if (RongIMClient.this.topForegroundActivity == null) {
                            RLog.i(RongIMClient.TAG, "in Foreground");
                            RongIMClient.this.onAppBackgroundChanged(true);
                        }
                        RongIMClient.this.topForegroundActivity = activity;
                    }

                    public void onActivityPaused(Activity activity) {
                    }

                    public void onActivityStopped(Activity activity) {
                        if (RongIMClient.this.topForegroundActivity == activity) {
                            RLog.i(RongIMClient.TAG, "in Background");
                            RongIMClient.this.onAppBackgroundChanged(false);
                            RongIMClient.this.topForegroundActivity = null;
                        }
                    }

                    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                        RLog.i(RongIMClient.TAG, "saveInstance");
                    }

                    public void onActivityDestroyed(Activity activity) {
                    }
                });
            }
            this.mContext = context.getApplicationContext();
            if (TextUtils.isEmpty((CharSequence)appKey)) {
                try {
                    ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    this.mAppKey = applicationInfo.metaData.getString("RONG_CLOUD_APP_KEY");
                    if (TextUtils.isEmpty((CharSequence)this.mAppKey) || !SystemUtils.isValidAppKey(this.mAppKey)) {
                        throw new IllegalArgumentException("can't find RONG_CLOUD_APP_KEY in AndroidManifest.xml.");
                    }
                    break block6;
                }
                catch (PackageManager.NameNotFoundException e) {
                    RLog.e(TAG, "*initSDK", e);
                    throw new ExceptionInInitializerError("can't find packageName!");
                }
            }
            this.mAppKey = appKey;
        }
        RLog.init(context, this.mAppKey, "4.1.0");
        FwLog.setLogConsolePrinter(new RtFwLogConsolePrinter(this.mContext));
        FwLog.write(3, 1, FwLog.LogTag.A_INIT_O.getTag(), "appkey|platform|model|sdk", this.mAppKey, "Android-" + Build.VERSION.SDK_INT, Build.MODEL, "4.1.0");
        MessageBufferPool.init(this.mContext);
        this.imLibExtensionModuleManager.onCreate(context, this.mAppKey);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                SharedPreferences sp = SharedPreferencesUtils.get(context, "Statistics", 0);
                sp.edit().putString("appKey", RongIMClient.this.mAppKey).commit();
                RongIMClient.registerMessageType(TextMessage.class);
                RongIMClient.registerMessageType(ReferenceMessage.class);
                RongIMClient.registerMessageType(VoiceMessage.class);
                RongIMClient.registerMessageType(HQVoiceMessage.class);
                RongIMClient.registerMessageType(ImageMessage.class);
                RongIMClient.registerMessageType(GIFMessage.class);
                RongIMClient.registerMessageType(LocationMessage.class);
                RongIMClient.registerMessageType(CommandNotificationMessage.class);
                RongIMClient.registerMessageType(ContactNotificationMessage.class);
                RongIMClient.registerMessageType(RichContentMessage.class);
                RongIMClient.registerMessageType(PublicServiceMultiRichContentMessage.class);
                RongIMClient.registerMessageType(PublicServiceRichContentMessage.class);
                RongIMClient.registerMessageType(PublicServiceCommandMessage.class);
                RongIMClient.registerMessageType(ProfileNotificationMessage.class);
                RongIMClient.registerMessageType(HandshakeMessage.class);
                RongIMClient.registerMessageType(InformationNotificationMessage.class);
                RongIMClient.registerMessageType(DiscussionNotificationMessage.class);
                RongIMClient.registerMessageType(SuspendMessage.class);
                RongIMClient.registerMessageType(ReadReceiptMessage.class);
                RongIMClient.registerMessageType(CommandMessage.class);
                RongIMClient.registerMessageType(TypingStatusMessage.class);
                RongIMClient.registerMessageType(RecallCommandMessage.class);
                RongIMClient.registerMessageType(RecallNotificationMessage.class);
                RongIMClient.registerMessageType(ReadReceiptRequestMessage.class);
                RongIMClient.registerMessageType(ReadReceiptResponseMessage.class);
                RongIMClient.registerMessageType(SyncReadStatusMessage.class);
                RongIMClient.registerMessageType(GroupNotificationMessage.class);
                RongIMClient.registerMessageType(FileMessage.class);
                RongIMClient.registerMessageType(HistoryDividerMessage.class);
                RongIMClient.registerMessageType(RCEncryptedMessage.class);
                RongIMClient.registerMessageType(RCEncryptRequestMessage.class);
                RongIMClient.registerMessageType(RCEncryptResponseMessage.class);
                RongIMClient.registerMessageType(RCEncryptCancelMessage.class);
                RongIMClient.registerMessageType(RCEncryptConfirmMessage.class);
                RongIMClient.registerMessageType(RCEncryptTerminateMessage.class);
                RongIMClient.registerMessageType(DestructionCmdMessage.class);
                RongIMClient.registerMessageType(RoomUserStateMessage.class);
                RongIMClient.registerMessageType(ChatRoomKVNotiMessage.class);
                RongIMClient.registerMessageType(LogCmdMessage.class);
                RongIMClient.registerMessageType(MessageExpansionMessage.class);
                List<Class<? extends MessageContent>> messageContents = RongIMClient.this.imLibExtensionModuleManager.getMessageContentList();
                if (messageContents != null) {
                    ArrayList<Class<? extends MessageContent>> tempMessageContents = new ArrayList<Class<? extends MessageContent>>(messageContents);
                    for (Class clazz : tempMessageContents) {
                        RongIMClient.registerMessageType(clazz);
                    }
                }
                RongIMClient.this.registerCmdMsgType();
                RongIMClient.this.registerDeleteMessageType();
                RongIMClient.this.registerReconnectIntentFilter();
                RongIMClient.this.initBindService();
                RongIMClient.this.initStatistics(context, RongIMClient.this.mAppKey);
                if (isPushEnabled) {
                    if (mNaviServer != null) {
                        RongPushClient.init(context, RongIMClient.this.mAppKey, mNaviServer);
                    } else {
                        RongPushClient.init(context, RongIMClient.this.mAppKey);
                    }
                } else {
                    ComponentName componentName = new ComponentName(context, PushReceiver.class);
                    context.getPackageManager().setComponentEnabledSetting(componentName, 2, 1);
                }
                TypingMessageManager.getInstance().init(context);
            }
        });
    }

    public static void init(Context context) {
        RongIMClient.init(context, null, true);
    }

    public static void init(Context context, String appKey) {
        RongIMClient.init(context, appKey, true);
    }

    public static void init(Context context, String appKey, boolean enablePush) {
        RLog.d(TAG, "isPushEnabled:" + enablePush);
        isPushEnabled = enablePush;
        SingletonHolder.sInstance.initSDK(context, appKey);
    }

    public static RongIMClient connect(String token, ConnectCallback connectCallback) {
        return RongIMClient.connect(token, -1, connectCallback);
    }

    public static RongIMClient connect(String token, int timeLimit, final ConnectCallback connectCallback) {
        FwLog.write(3, 1, "A-connect-T", "token", token);
        ConnectionErrorCode errorCode = null;
        if (TextUtils.isEmpty((CharSequence)token)) {
            errorCode = ConnectionErrorCode.RC_CONN_TOKEN_INCORRECT;
        } else if (SingletonHolder.sInstance.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.CONNECTING) || SingletonHolder.sInstance.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.SUSPEND) || SingletonHolder.sInstance.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.CONNECTED) || SingletonHolder.sInstance.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE)) {
            errorCode = ConnectionErrorCode.RC_CONNECTION_EXIST;
        }
        if (errorCode != null) {
            FwLog.write(3, 1, "A-connect-R", "code", new Object[]{errorCode});
            if (connectCallback != null) {
                connectCallback.onFail(errorCode);
            }
            return SingletonHolder.sInstance;
        }
        needCallBackDBOpen = true;
        SingletonHolder.sInstance.connectCallback = new ConnectCallback(){

            @Override
            public void onDatabaseOpened(DatabaseOpenStatus code) {
                FwLog.write(3, 1, "A-connect-S", "code", code.getValue());
                RLog.i(RongIMClient.TAG, "DatabaseOpenStatus = " + code.getValue());
                if (connectCallback != null) {
                    connectCallback.onDatabaseOpened(code);
                }
            }

            @Override
            public void onSuccess(String userId) {
                FwLog.write(3, 1, "A-connect-R", "code|user_id", 0, userId);
                SingletonHolder.sInstance.stopConnectTimeoutTimer();
                if (connectCallback != null) {
                    connectCallback.onSuccess(userId);
                }
            }

            @Override
            public void onError(ConnectionErrorCode code) {
                FwLog.write(2, 1, "A-connect-R", "code", code.code);
                if (connectCallback != null) {
                    connectCallback.onError(code);
                }
            }
        };
        int interval = timeLimit <= 0 ? 0x7FFFFFFE : timeLimit;
        SingletonHolder.sInstance.startConnectTimeoutTimer(interval);
        SingletonHolder.sInstance.connectServer(token, false);
        return SingletonHolder.sInstance;
    }

    public static void setConnectionStatusListener(ConnectionStatusListener listener) {
        sConnectionListener = listener;
    }

    static void reconnectServer() {
        if (SingletonHolder.sInstance.mLibHandler != null) {
            RLog.d(TAG, "reconnectServer, t = " + SingletonHolder.sInstance.mToken);
            SingletonHolder.sInstance.connectServer(SingletonHolder.sInstance.mToken, true);
        } else {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SingletonHolder.sInstance.connectServer(SingletonHolder.sInstance.mToken, true);
                }
            });
        }
    }

    private synchronized void connectServer(final String token, boolean isReconnect) {
        boolean logType = true;
        if (TextUtils.isEmpty((CharSequence)token)) {
            return;
        }
        this.setToken(token);
        if (this.mLibHandler == null) {
            FwLog.write(3, 1, isReconnect ? "L-reconnect-T" : "L-connect-T", "sequences", 0);
            FwLog.write(2, 1, isReconnect ? "L-reconnect-R" : "L-connect-R", "code|network|sequences", new Object[]{ErrorCode.IPC_DISCONNECT, DeviceUtils.getNetworkType(this.mContext), 0});
            this.mConnectRunnable = new ConnectRunnable(token);
            this.initBindService();
        } else {
            try {
                RLog.d(TAG, "[connect] connect");
                this.mLibHandler.connect(token, isReconnect, isInForeground, new IConnectStringCallback.Stub(){

                    @Override
                    public void onComplete(String userId) {
                        RLog.d(RongIMClient.TAG, "[connect] callback onComplete");
                        SingletonHolder.sInstance.imLibExtensionModuleManager.onConnected(userId, token);
                        RongIMClient.this.mCurrentUserId = userId;
                        SharedPreferences sp = SharedPreferencesUtils.get(RongIMClient.this.mContext, "Statistics", 0);
                        sp.edit().putString("token", token).putString("userId", userId).commit();
                        RongIMClient.this.mConnectRunnable = null;
                        if (RongIMClient.this.connectCallback != null) {
                            RongIMClient.this.connectCallback.onCallback(userId);
                            RongIMClient.this.connectCallback = null;
                        }
                        if (isPushEnabled) {
                            PushManager.getInstance().updatePushServerInfoFromToken(token);
                        }
                        if (isPushEnabled) {
                            PushManager.getInstance().updatePushServerInfoFromToken(token);
                        }
                        if (isPushEnabled) {
                            PushManager.getInstance().updatePushServerInfoFromToken(token);
                        }
                    }

                    @Override
                    public void onFailure(int errorCode) throws RemoteException {
                        RLog.e(RongIMClient.TAG, "[connect] callback onFailure, errorCode = " + errorCode);
                        RongIMClient.this.mConnectRunnable = null;
                        if (RongIMClient.this.connectCallback != null) {
                            RongIMClient.this.connectCallback.onFail(ConnectionErrorCode.valueOf(errorCode));
                            RongIMClient.this.connectCallback = null;
                        }
                        SharedPreferences sp = SharedPreferencesUtils.get(RongIMClient.this.mContext, "Statistics", 0);
                        sp.edit().putString("token", token).commit();
                    }

                    @Override
                    public void OnDatabaseOpened(int code) throws RemoteException {
                        if (needCallBackDBOpen) {
                            if (RongIMClient.this.connectCallback != null) {
                                RongIMClient.this.connectCallback.onDatabaseOpened(DatabaseOpenStatus.valueOf(code));
                            }
                            needCallBackDBOpen = false;
                        }
                    }
                });
            }
            catch (Exception e) {
                if (this.connectCallback != null) {
                    this.connectCallback.onError(ConnectionErrorCode.IPC_DISCONNECT);
                }
                FwLog.write(1, 1, "L-crash_main_ept-F", "stacks", FwLog.stackToString(e));
                RLog.e(TAG, "connectServer", e);
            }
        }
    }

    private void startConnectTimeoutTimer(int interval) {
        this.stopConnectTimeoutTimer();
        this.connectTimeoutTimer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler != null) {
                    try {
                        RongIMClient.this.mLibHandler.setIpcConnectTimeOut();
                    }
                    catch (Exception e) {
                        RongIMClient.this.mStatusListener.onConnectionStatusChange(ConnectionStatusListener.ConnectionStatus.TIMEOUT);
                    }
                } else {
                    RongIMClient.this.mStatusListener.onConnectionStatusChange(ConnectionStatusListener.ConnectionStatus.TIMEOUT);
                }
            }
        };
        this.connectTimeoutTimer.schedule(task, (long)interval * 1000L);
    }

    private void stopConnectTimeoutTimer() {
        if (this.connectTimeoutTimer != null) {
            this.connectTimeoutTimer.cancel();
            this.connectTimeoutTimer = null;
        }
    }

    public static void setOnReceiveMessageListener(OnReceiveMessageListener listener) {
        sReceiveMessageListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void registerMessageType(Class<? extends MessageContent> messageContentClass) {
        if (messageContentClass == null) {
            FwLog.write(2, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "messageContentClass", "null");
            return;
        }
        List<String> list = SingletonHolder.sInstance.mRegCache;
        synchronized (list) {
            if (!SingletonHolder.sInstance.mRegCache.contains(messageContentClass.getName())) {
                SingletonHolder.sInstance.mRegCache.add(messageContentClass.getName());
            }
        }
        if (SingletonHolder.sInstance.mLibHandler != null) {
            try {
                SingletonHolder.sInstance.mLibHandler.registerMessageType(messageContentClass.getName());
            }
            catch (Exception e) {
                RLog.e(TAG, "registerMessageType RemoteException", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMessageType(List<Class<? extends MessageContent>> messageContentClassList) {
        if (messageContentClassList == null || messageContentClassList.size() == 0) {
            FwLog.write(2, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "messageContentClassList", "messageContentClassList is empty");
            return;
        }
        ArrayList<String> classNameList = new ArrayList<String>();
        List<String> list = SingletonHolder.sInstance.mRegCache;
        synchronized (list) {
            for (Class<? extends MessageContent> messageContentClass : messageContentClassList) {
                String className = messageContentClass.getName();
                if (SingletonHolder.sInstance.mRegCache.contains(className)) continue;
                SingletonHolder.sInstance.mRegCache.add(className);
                classNameList.add(className);
            }
        }
        if (SingletonHolder.sInstance.mLibHandler != null) {
            try {
                if (classNameList.size() > 0) {
                    SingletonHolder.sInstance.mLibHandler.registerMessageTypes(classNameList);
                }
            }
            catch (Exception e) {
                RLog.e(TAG, "registerMessageType RemoteException", e);
            }
        }
    }

    public Activity getTopForegroundActivity() {
        return this.topForegroundActivity;
    }

    public void logout() {
        this.disconnect(false);
        this.imLibExtensionModuleManager.onLogout();
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean isReceivePush) {
        FwLog.write(3, 1, FwLog.LogTag.A_DISCONNECT_O.getTag(), "push", isReceivePush);
        if (this.mContext != null && !isReceivePush) {
            SharedPreferences sp = SharedPreferencesUtils.get(this.mContext, "Statistics", 0);
            sp.edit().putString("userId", "").apply();
        }
        this.mStatusListener.onConnectionStatusChange(ConnectionStatusListener.ConnectionStatus.SIGN_OUT);
        if (this.mWorkHandler != null) {
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    RongIMClient.this.mChatRoomCache.clear();
                    for (ChatRoomCacheRunnable runnable : RongIMClient.this.mRetryCRCache.values()) {
                        RongIMClient.this.mWorkHandler.removeCallbacks((Runnable)runnable);
                    }
                    RongIMClient.this.mRetryCRCache.clear();
                    RongIMClient.this.cancelAllDownloadMediaMessage(null);
                }
            });
        }
        try {
            if (this.mLibHandler != null) {
                this.mLibHandler.disconnect(isReceivePush);
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "disconnect", e);
        }
        this.clearToken();
    }

    public void getConversationList(final ResultCallback<List<Conversation>> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getConversationListByBatch(10, new GetConversationListProcessCallBackWrapper(callback));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getConversationList", e);
                        if (callback == null) break block4;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getConversationList(final ResultCallback<List<Conversation>> callback, final Conversation.ConversationType ... conversationTypes) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    if (conversationTypes == null || conversationTypes.length == 0) {
                        callback.onCallback(null);
                        return;
                    }
                    try {
                        int[] typeValues = RongIMClient.this.convertTypes(conversationTypes);
                        RongIMClient.this.mLibHandler.getConversationListOfTypesByBatch(typeValues, 10, new GetConversationListProcessCallBackWrapper(callback));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getConversationList", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getTopConversationList(final ResultCallback<List<Conversation>> callback, final Conversation.ConversationType ... conversationTypes) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block6: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    if (conversationTypes == null || conversationTypes.length == 0) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.PARAMETER_ERROR);
                        }
                        return;
                    }
                    try {
                        int[] typeValues = RongIMClient.this.convertTypes(conversationTypes);
                        RongIMClient.this.mLibHandler.getTopConversationList(typeValues, 10, new GetConversationListProcessCallBackWrapper(callback));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getTopConversationList", e);
                        if (callback == null) break block6;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getConversationListByPage(final ResultCallback<List<Conversation>> callback, final long timeStamp, final int count, final Conversation.ConversationType ... conversationTypes) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    if (conversationTypes == null || conversationTypes.length == 0) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.PARAMETER_ERROR);
                        }
                        return;
                    }
                    try {
                        int[] typeValues = RongIMClient.this.convertTypes(conversationTypes);
                        List<Conversation> conversationList = RongIMClient.this.mLibHandler.getConversationListByPage(typeValues, timeStamp, count);
                        if (callback != null) {
                            callback.onCallback(conversationList);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getConversationListByPage", e);
                        if (callback == null) break block7;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getBlockedConversationList(final ResultCallback<List<Conversation>> callback, final Conversation.ConversationType ... conversationTypes) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    if (conversationTypes == null || conversationTypes.length == 0) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.PARAMETER_ERROR);
                        }
                        return;
                    }
                    try {
                        int[] typeValues = RongIMClient.this.convertTypes(conversationTypes);
                        List<Conversation> conversationList = RongIMClient.this.mLibHandler.getBlockedConversationList(typeValues);
                        if (callback != null) {
                            callback.onCallback(conversationList);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getBlockedConversationList", e);
                        if (callback == null) break block7;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getConversation(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Conversation> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "getConversation. the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        Conversation conversation = RongIMClient.this.mLibHandler.getConversation(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(conversation);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getConversation", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void updateConversationInfo(final Conversation.ConversationType conversationType, final String targetId, final String title, final String portrait, final ResultCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)title) || TextUtils.isEmpty((CharSequence)portrait) || TextUtils.isEmpty((CharSequence)title.trim()) && TextUtils.isEmpty((CharSequence)portrait.trim())) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean result = RongIMClient.this.mLibHandler.updateConversationInfo(conversationType.getValue(), targetId, title, portrait);
                        if (callback != null) {
                            callback.onCallback(result);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "updateConversationInfo", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void removeConversation(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "getConversation. the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (targetId.length() > 64) {
            RLog.e(TAG, "TargetId length exceed the limit!");
        }
        if (conversationType == Conversation.ConversationType.ENCRYPTED) {
            this.quitEncryptedSession(targetId);
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.removeConversation(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "removeConversation", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setConversationToTop(Conversation.ConversationType conversationType, String id, boolean isTop, ResultCallback<Boolean> callback) {
        this.setConversationToTop(conversationType, id, isTop, true, callback);
    }

    public void setConversationToTop(final Conversation.ConversationType conversationType, final String id, final boolean isTop, final boolean needCreate, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)id) || conversationType == null) {
            RLog.e(TAG, "getConversation. the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean result = RongIMClient.this.mLibHandler.setConversationTopStatus(conversationType.getValue(), id, isTop, needCreate);
                        if (callback != null) {
                            callback.onCallback(result);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setConversationToTop", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getTotalUnreadCount(final ResultCallback<Integer> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    if (RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.UNCONNECTED)) {
                        RLog.d(RongIMClient.TAG, "getTotalUnreadCount return 0 as disconnected.");
                        if (callback != null) {
                            callback.onCallback(0);
                        }
                        return;
                    }
                    try {
                        int count = RongIMClient.this.mLibHandler.getTotalUnreadCount();
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block7;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getTotalUnreadCount(final ResultCallback<Integer> callback, final Conversation ... conversations) {
        if (conversations == null) {
            throw new IllegalArgumentException("conversations can't be null !");
        }
        for (Conversation conversation : conversations) {
            if (conversation.getConversationType() != null && !TextUtils.isEmpty((CharSequence)conversation.getTargetId())) continue;
            throw new IllegalArgumentException("ConversationType or targetId can't be empty !");
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int count = RongIMClient.this.mLibHandler.getUnreadCountByConversation(conversations);
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getUnreadCount(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Integer> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "TargetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int count = RongIMClient.this.mLibHandler.getUnreadCountById(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getUnreadCount(final ResultCallback<Integer> callback, final Conversation.ConversationType ... conversationTypes) {
        if (conversationTypes == null || conversationTypes.length == 0) {
            RLog.e(TAG, "conversationTypes is null. Return directly!!!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int[] types = RongIMClient.this.convertTypes(conversationTypes);
                        int count = RongIMClient.this.mLibHandler.getUnreadCount(types);
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getUnreadCount(final Conversation.ConversationType[] conversationTypes, final boolean containBlocked, final ResultCallback<Integer> callback) {
        if (conversationTypes == null || conversationTypes.length == 0) {
            RLog.e(TAG, "conversationTypes is null. Return directly!!!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int[] types = RongIMClient.this.convertTypes(conversationTypes);
                        int count = RongIMClient.this.mLibHandler.getUnreadCountWithDND(types, containBlocked);
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getUnreadCount(Conversation.ConversationType[] conversationTypes, ResultCallback<Integer> callback) {
        this.getUnreadCount(callback, conversationTypes);
    }

    public void getMessageCount(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Integer> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "TargetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int count = RongIMClient.this.mLibHandler.getMessageCount(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(count);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getLatestMessages(final Conversation.ConversationType conversationType, final String targetId, final int count, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getNewestMessages(conversation, count);
                        if (callback != null) {
                            callback.onCallback(messages);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getLatestMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    @Deprecated
    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        final CountDownLatch latch = new CountDownLatch(1);
        final ResultCallback.Result result = new ResultCallback.Result();
        this.getHistoryMessages(conversationType, targetId, oldestMessageId, count, (ResultCallback<List<Message>>)new SyncCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messages) {
                result.t = messages;
                latch.countDown();
            }

            @Override
            public void onError(ErrorCode e) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "getHistoryMessages", e);
            Thread.currentThread().interrupt();
        }
        return (List)result.t;
    }

    @Deprecated
    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, int oldestMessageId, int count) {
        final CountDownLatch latch = new CountDownLatch(1);
        final ResultCallback.Result result = new ResultCallback.Result();
        this.getHistoryMessages(conversationType, targetId, objectName, oldestMessageId, count, (ResultCallback<List<Message>>)new SyncCallback<List<Message>>(){

            @Override
            public void onSuccess(List<Message> messages) {
                result.t = messages;
                latch.countDown();
            }

            @Override
            public void onError(ErrorCode e) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "getHistoryMessages", e);
            Thread.currentThread().interrupt();
        }
        return (List)result.t;
    }

    public void getHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final String objectName, final int oldestMessageId, final int count, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null || TextUtils.isEmpty((CharSequence)objectName)) {
            RLog.e(TAG, "the parameter of targetId or ConversationType or objectName is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getOlderMessagesByObjectName(conversation, objectName, oldestMessageId, count, true);
                        if (callback != null) {
                            callback.onCallback(RongIMClient.this.filterDestructionMessage(conversationType, targetId, messages));
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getHistoryMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final String objectName, final int baseMessageId, final int count, final RongCommonDefine.GetMessageDirection direction, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)objectName) || count <= 0 || direction == null) {
            RLog.e(TAG, "the parameter of objectName, count or direction is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getOlderMessagesByObjectName(conversation, objectName, baseMessageId, count, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        if (callback != null) {
                            callback.onCallback(RongIMClient.this.filterDestructionMessage(conversationType, targetId, messages));
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getHistoryMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final List<String> objectNames, final long timestamp, final int count, final RongCommonDefine.GetMessageDirection direction, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (objectNames.size() == 0 || count <= 0 || direction == null) {
            RLog.e(TAG, "the parameter size of objectNames, count or direction is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getOlderMessagesByObjectNames(conversation, objectNames, timestamp, count, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
                        if (callback != null) {
                            callback.onCallback(RongIMClient.this.filterDestructionMessage(conversationType, targetId, messages));
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getHistoryMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private List<Message> getHistoryMessagesByObjectNamesSync(Conversation.ConversationType conversationType, String targetId, List<String> objectNames, long timestamp, int count, RongCommonDefine.GetMessageDirection direction) {
        if (this.mLibHandler == null) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.setConversationType(conversationType);
        conversation.setTargetId(targetId);
        List<Message> messages = null;
        try {
            messages = this.mLibHandler.getOlderMessagesByObjectNames(conversation, objectNames, timestamp, count, direction.equals((Object)RongCommonDefine.GetMessageDirection.FRONT));
        }
        catch (Exception e) {
            RLog.e(TAG, "getHistoryMessagesByObjectNamesSync", e);
        }
        return messages;
    }

    public void getRemoteHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final long dateTime, final int count, ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<List<Message>>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<List<Message>>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        RongIMClient.this.mLibHandler.getRemoteHistoryMessages(conversation, dateTime, count, new IResultCallback.Stub(){

                            @Override
                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    if (model != null && model.getContent() != null && model.getContent() instanceof RongListWrap) {
                                        RongListWrap rongListWrap = (RongListWrap)model.getContent();
                                        ((ResultCallback)ipcCallbackProxy.callback).onCallback(rongListWrap.getList());
                                    } else {
                                        ((ResultCallback)ipcCallbackProxy.callback).onCallback(null);
                                    }
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getRemoteHistoryMessages", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getRemoteHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final RemoteHistoryMsgOption remoteHistoryMsgOption, ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<List<Message>>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<List<Message>>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        RongIMClient.this.mLibHandler.getRemoteHistoryMessagesOption(conversation, remoteHistoryMsgOption, new IResultCallback.Stub(){

                            @Override
                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    if (model != null && model.getContent() != null && model.getContent() instanceof RongListWrap) {
                                        RongListWrap rongListWrap = (RongListWrap)model.getContent();
                                        ((ResultCallback)ipcCallbackProxy.callback).onCallback(rongListWrap.getList());
                                    } else {
                                        ((ResultCallback)ipcCallbackProxy.callback).onCallback(null);
                                    }
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getRemoteHistoryMessages", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void cleanRemoteHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final long recordTime, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        RLog.e(RongIMClient.TAG, "mLibHandler is null!");
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        RongIMClient.this.mLibHandler.cleanRemoteHistoryMessages(conversation, recordTime, new IOperationCallback.Stub(){

                            @Override
                            public void onComplete() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((OperationCallback)ipcCallbackProxy.callback).onCallback();
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "cleanRemoteHistoryMessages", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void cleanHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final long recordTime, final boolean cleanRemote, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    RLog.e(RongIMClient.TAG, "mLibHandler is null!");
                    return;
                }
                final Conversation conversation = new Conversation();
                conversation.setConversationType(conversationType);
                conversation.setTargetId(targetId);
                if (cleanRemote) {
                    try {
                        RongIMClient.this.mLibHandler.cleanRemoteHistoryMessages(conversation, recordTime, new IOperationCallback.Stub(){

                            @Override
                            public void onComplete() throws RemoteException {
                                RongIMClient.this.cleanLocalHistoryMessages(conversation, recordTime, ipcCallbackProxy);
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                RLog.e(RongIMClient.TAG, "cleanHistoryMessages errorCode :" + errorCode);
                                if (ipcCallbackProxy.callback != null) {
                                    ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "cleanHistoryMessages", e);
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                    }
                } else {
                    RongIMClient.this.cleanLocalHistoryMessages(conversation, recordTime, ipcCallbackProxy);
                }
            }
        });
    }

    private void cleanLocalHistoryMessages(Conversation conversation, long recordTime, final IpcCallbackProxy<OperationCallback> ipcCallbackProxy) {
        block2: {
            try {
                this.mLibHandler.cleanHistoryMessages(conversation, recordTime, new IOperationCallback.Stub(){

                    @Override
                    public void onComplete() throws RemoteException {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onCallback();
                            ipcCallbackProxy.callback = null;
                        }
                    }

                    @Override
                    public void onFailure(int errorCode) throws RemoteException {
                        RLog.e(RongIMClient.TAG, "cleanLocalHistoryMessages errorCode" + errorCode);
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                            ipcCallbackProxy.callback = null;
                        }
                    }
                });
            }
            catch (Exception e) {
                RLog.e(TAG, "cleanLocalHistoryMessages", e);
                if (ipcCallbackProxy.callback == null) break block2;
                ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                ipcCallbackProxy.callback = null;
            }
        }
    }

    public void getChatroomHistoryMessages(final String targetId, final long recordTime, final int count, final TimestampOrder order, IRongCallback.IChatRoomHistoryMessageCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || order == null) {
            RLog.e(TAG, "the parameter of targetId or order is null !");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IChatRoomHistoryMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IChatRoomHistoryMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            RongIMClient.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    ((IRongCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onError(ErrorCode.IPC_DISCONNECT);
                                    ipcCallbackProxy.callback = null;
                                }
                            });
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getChatroomHistoryMessages(targetId, recordTime, count, order.ordinal(), new IChatRoomHistoryMessageCallback.Stub(){

                            @Override
                            public void onComplete(final RemoteModelWrap model, final long syncTime) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (model != null) {
                                                RongListWrap rongListWrap = (RongListWrap)model.getContent();
                                                ((IRongCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onSuccess(rongListWrap.getList(), syncTime);
                                            } else {
                                                ((IRongCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onSuccess(null, syncTime);
                                            }
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onFailure(final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onError(ErrorCode.valueOf(errorCode));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getChatroomHistoryMessages", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        RongIMClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IChatRoomHistoryMessageCallback)ipcCallbackProxy.callback).onError(ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void getHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final int oldestMessageId, final int count, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getOlderMessages(conversation, oldestMessageId, count);
                        if (callback != null) {
                            callback.onCallback(RongIMClient.this.filterDestructionMessage(conversationType, targetId, messages));
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getHistoryMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private List<Message> getHistoryMessagesSync(Conversation.ConversationType conversationType, String targetId, int oldestMessageId, int count) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            return null;
        }
        if (this.mLibHandler == null) {
            return null;
        }
        Conversation conversation = new Conversation();
        conversation.setConversationType(conversationType);
        conversation.setTargetId(targetId);
        List<Message> messages = null;
        try {
            messages = this.mLibHandler.getOlderMessages(conversation, oldestMessageId, count);
        }
        catch (Exception e) {
            RLog.e(TAG, "getHistoryMessagesSync ", e);
        }
        return messages;
    }

    public void deleteMessages(final int[] messageIds, final ResultCallback<Boolean> callback) {
        if (messageIds == null || messageIds.length == 0) {
            RLog.e(TAG, "the messageIds is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        StringBuilder idString = new StringBuilder();
        for (int id : messageIds) {
            if (id <= 0) {
                RLog.e(TAG, "the messageIds contains 0 value!");
                if (callback != null) {
                    callback.onError(ErrorCode.PARAMETER_ERROR);
                }
                return;
            }
            idString.append(id).append("/");
        }
        FwLog.write(4, 1, FwLog.LogTag.A_DELETE_MESSAGES_S.getTag(), "messageIds:", idString.toString());
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.deleteMessage(messageIds);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "deleteMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void deleteMessages(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.deleteConversationMessage(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "deleteMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void deleteRemoteMessages(final Conversation.ConversationType conversationType, final String targetId, final Message[] messages, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null || conversationType.equals((Object)Conversation.ConversationType.CHATROOM)) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (messages == null || messages.length == 0 || messages.length > 100) {
            RLog.e(TAG, "the messages size is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.deleteMessages(conversationType.getValue(), targetId, messages, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "deleteMessages", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void clearMessages(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.clearMessages(conversation);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "clearMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void clearMessagesUnreadStatus(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Conversation conversation = new Conversation();
                    conversation.setConversationType(conversationType);
                    conversation.setTargetId(targetId);
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.clearMessagesUnreadStatus(conversation);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "clearMessagesUnreadStatus", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setMessageExtra(final int messageId, final String value, final ResultCallback<Boolean> callback) {
        if (messageId == 0) {
            RLog.e(TAG, "messageId is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.setMessageExtra(messageId, value);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setMessageExtra", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setMessageReceivedStatus(final int messageId, final Message.ReceivedStatus receivedStatus, final ResultCallback<Boolean> callback) {
        if (messageId == 0 || receivedStatus == null) {
            RLog.e(TAG, "Error.messageid is 0 or receivedStatus is null !");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.setMessageReceivedStatus(messageId, receivedStatus.getFlag());
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setMessageReceivedStatus", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setMessageSentStatus(final Message message, final ResultCallback<Boolean> callback) {
        if (message == null || message.getMessageId() <= 0 || message.getSentStatus() == null) {
            RLog.e(TAG, "setMessageSentStatus Error. message or the sentStatus of message cant't be null , messageId can't <= 0!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.setMessageSentStatus(message.getMessageId(), message.getSentStatus().getValue());
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setMessageSentStatus", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getTextMessageDraft(Conversation.ConversationType conversationType, String targetId, final ResultCallback<String> callback) {
        final Conversation conversation = new Conversation();
        conversation.setConversationType(conversationType);
        conversation.setTargetId(targetId);
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the value of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        String content = RongIMClient.this.mLibHandler.getTextMessageDraft(conversation);
                        if (callback != null) {
                            callback.onCallback(content);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getTextMessageDraft", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void saveTextMessageDraft(Conversation.ConversationType conversationType, String targetId, final String content, final ResultCallback<Boolean> callback) {
        final Conversation conversation = new Conversation();
        conversation.setConversationType(conversationType);
        conversation.setTargetId(targetId);
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the value of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.saveTextMessageDraft(conversation, content);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "saveTextMessageDraft", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void clearTextMessageDraft(Conversation.ConversationType conversationType, String targetId, final ResultCallback<Boolean> callback) {
        final Conversation conversation = new Conversation();
        conversation.setConversationType(conversationType);
        conversation.setTargetId(targetId);
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the value of targetId or ConversationType is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.clearTextMessageDraft(conversation);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "clearTextMessageDraft", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getDiscussion(final String discussionId, ResultCallback<Discussion> callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            RLog.e(TAG, "the discussionId can't be empty!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<Discussion>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<Discussion>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getDiscussion(discussionId, new IResultCallback.Stub(){

                        @Override
                        public void onComplete(RemoteModelWrap model) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                if (model != null && model.getContent() != null && model.getContent() instanceof Discussion) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback((Discussion)model.getContent());
                                } else {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(null);
                                }
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getDiscussion", e);
                }
            }
        });
    }

    public static void setChatRoomActionListener(ChatRoomActionListener listener) {
        chatRoomActionListener.set(listener);
    }

    public void setDiscussionName(final String discussionId, final String name, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)name)) {
            RLog.e(TAG, "discussionId or name is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    String sub = name;
                    if (!TextUtils.isEmpty((CharSequence)name) && name.length() > 40) {
                        sub = name.substring(0, 39);
                    }
                    RongIMClient.this.mLibHandler.setDiscussionName(discussionId, sub, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "setDiscussionName", e);
                }
            }
        });
    }

    public void createDiscussion(final String name, final List<String> userIdList, CreateDiscussionCallback callback) {
        if (TextUtils.isEmpty((CharSequence)name) || userIdList == null || userIdList.size() == 0) {
            RLog.e(TAG, "name or userIdList is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<CreateDiscussionCallback> ipcCallbackProxy = new IpcCallbackProxy<CreateDiscussionCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((CreateDiscussionCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        String sub = name;
                        if (!TextUtils.isEmpty((CharSequence)name) && name.length() > 40) {
                            sub = name.substring(0, 39);
                        }
                        RongIMClient.this.mLibHandler.createDiscussion(sub, userIdList, new IResultCallback.Stub(){

                            @Override
                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    if (model != null && model.getContent() != null && model.getContent() instanceof Discussion) {
                                        ((CreateDiscussionCallback)ipcCallbackProxy.callback).onCallback(((Discussion)model.getContent()).getId());
                                    } else {
                                        ((CreateDiscussionCallback)ipcCallbackProxy.callback).onCallback(null);
                                    }
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((CreateDiscussionCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        if (ipcCallbackProxy.callback == null) break block5;
                        ((CreateDiscussionCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void addMemberToDiscussion(final String discussionId, final List<String> userIdList, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || userIdList == null || userIdList.size() == 0) {
            RLog.e(TAG, "discussionId or userIdList is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.addMemberToDiscussion(discussionId, userIdList, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void removeMemberFromDiscussion(final String discussionId, final String userId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)userId)) {
            RLog.e(TAG, "discussionId or userId is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.removeDiscussionMember(discussionId, userId, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "removeMemberFromDiscussion", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void quitDiscussion(final String discussionId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            RLog.e(TAG, "discussionId is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.quitDiscussion(discussionId, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "quitDiscussion", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getMessage(final int messageId, final ResultCallback<Message> callback) {
        if (messageId <= 0) {
            RLog.e(TAG, "Illegal argument of messageId.");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        Message result = RongIMClient.this.mLibHandler.getMessage(messageId);
                        if (callback != null) {
                            callback.onCallback(result);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getMessage", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void insertOutgoingMessage(Conversation.ConversationType type, String targetId, Message.SentStatus sentStatus, MessageContent content, ResultCallback<Message> resultCallback) {
        this.insertOutgoingMessage(type, targetId, sentStatus, content, System.currentTimeMillis(), resultCallback);
    }

    public void insertOutgoingMessage(final Conversation.ConversationType type, final String targetId, final Message.SentStatus sentStatus, final MessageContent content, final long sentTime, final ResultCallback<Message> resultCallback) {
        if (type == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            RLog.e(TAG, "insertOutgoingMessage::ConversationType or targetId or content is null");
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if ((msgTag.flag() & 1) != 1) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            RLog.e(TAG, "insertMessage Message is missing MessageTag.ISPERSISTED");
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (resultCallback != null) {
                            resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Message message = Message.obtain(targetId, type, content);
                    message.setSentTime(sentTime);
                    message.setSentStatus(sentStatus);
                    message.setSenderUserId(RongIMClient.this.mCurrentUserId);
                    message.setMessageDirection(Message.MessageDirection.SEND);
                    try {
                        Message result = RongIMClient.this.mLibHandler.insertSettingMessage(message);
                        if (resultCallback != null) {
                            if (result.getMessageId() < 0) {
                                if (result.getMessageId() == ErrorCode.PARAMETER_ERROR.getValue()) {
                                    resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                                } else {
                                    resultCallback.onFail(ErrorCode.BIZ_ERROR_DATABASE_ERROR);
                                }
                            } else {
                                resultCallback.onCallback(result);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        RLog.e(RongIMClient.TAG, "insertOutgoingMessage", e);
                        if (resultCallback == null) break block9;
                        resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private void insertSettingMessage(final Message message, final ResultCallback<Message> resultCallback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (resultCallback != null) {
                            resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    message.setSentTime(System.currentTimeMillis());
                    message.setSentStatus(null);
                    message.setSenderUserId(RongIMClient.this.mCurrentUserId);
                    message.setMessageDirection(Message.MessageDirection.SEND);
                    try {
                        Message result = RongIMClient.this.mLibHandler.insertSettingMessage(message);
                        if (resultCallback != null) {
                            if (result.getMessageId() < 0) {
                                if (result.getMessageId() == ErrorCode.PARAMETER_ERROR.getValue()) {
                                    resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                                } else {
                                    resultCallback.onFail(ErrorCode.BIZ_ERROR_DATABASE_ERROR);
                                }
                            } else {
                                resultCallback.onCallback(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "insertOutgoingMessage", e);
                        if (resultCallback == null) break block9;
                        resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void insertIncomingMessage(Conversation.ConversationType type, String targetId, String senderUserId, Message.ReceivedStatus receivedStatus, MessageContent content, ResultCallback<Message> resultCallback) {
        this.insertIncomingMessage(type, targetId, senderUserId, receivedStatus, content, System.currentTimeMillis(), resultCallback);
    }

    public void insertIncomingMessage(final Conversation.ConversationType type, final String targetId, final String senderUserId, final Message.ReceivedStatus receivedStatus, final MessageContent content, final long sentTime, final ResultCallback<Message> resultCallback) {
        if (type == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            RLog.e(TAG, "insertIncomingMessage::ConversationType or targetId or content is null");
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if ((msgTag.flag() & 1) != 1) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            RLog.e(TAG, "insertMessage Message is missing MessageTag.ISPERSISTED");
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (resultCallback != null) {
                            resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    Message message = Message.obtain(targetId, type, content);
                    message.setSentTime(sentTime);
                    message.setReceivedStatus(receivedStatus);
                    message.setSenderUserId(senderUserId);
                    message.setMessageDirection(Message.MessageDirection.RECEIVE);
                    try {
                        Message result = RongIMClient.this.mLibHandler.insertSettingMessage(message);
                        if (resultCallback != null) {
                            if (result.getMessageId() < 0) {
                                if (result.getMessageId() == ErrorCode.PARAMETER_ERROR.getValue()) {
                                    resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                                } else {
                                    resultCallback.onFail(ErrorCode.BIZ_ERROR_DATABASE_ERROR);
                                }
                            } else {
                                resultCallback.onCallback(result);
                            }
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "insertIncomingMessage", e);
                        if (resultCallback == null) break block9;
                        resultCallback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void sendLocationMessage(final Message message, final String pushContent, final String pushData, IRongCallback.ISendMessageCallback sendMessageCallback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null || !(message.getContent() instanceof LocationMessage)) {
            if (sendMessageCallback != null) {
                sendMessageCallback.onError(message, errorCode);
            }
            return;
        }
        if (TypingMessageManager.getInstance().isShowMessageTyping()) {
            TypingMessageManager.getInstance().setTypingEnd(message.getConversationType(), message.getTargetId());
        }
        final IpcCallbackProxy<IRongCallback.ISendMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMessageCallback>(sendMessageCallback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    RongIMClient.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.sendLocationMessage(message, pushContent, pushData, new ISendMessageCallback.Stub(){

                        @Override
                        public void onAttached(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onAttached(msg);
                                    }
                                });
                            }
                        }

                        @Override
                        public void onSuccess(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onSuccess(msg);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onError(final Message msg, final int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(msg, ErrorCode.valueOf(errorCode));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendLocationMessage", e);
                }
            }
        });
    }

    public void sendMessage(Conversation.ConversationType type, String targetId, MessageContent content, String pushContent, String pushData, IRongCallback.ISendMessageCallback callback) {
        Message message = Message.obtain(targetId, type, content);
        this.sendMessage(message, pushContent, pushData, callback);
    }

    private void runOnUiThread(Runnable runnable) {
        mHandler.post(runnable);
    }

    public void sendMessage(Message message, String pushContent, String pushData, IRongCallback.ISendMessageCallback callback) {
        this.sendMessage(message, pushContent, pushData, null, callback);
    }

    public void sendMessage(final Message message, final String pushContent, final String pushData, final SendMessageOption option, IRongCallback.ISendMessageCallback callback) {
        MessageContent content;
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            RLog.e(TAG, "sendMessage \u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
            if (callback != null) {
                callback.onError(message, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TypingMessageManager.getInstance().isShowMessageTyping() && !((content = message.getContent()) instanceof TypingStatusMessage) && !(content instanceof ReadReceiptMessage)) {
            TypingMessageManager.getInstance().setTypingEnd(message.getConversationType(), message.getTargetId());
        }
        final IpcCallbackProxy<IRongCallback.ISendMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    RongIMClient.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.sendMessageOption(message, pushContent, pushData, option, new ISendMessageCallback.Stub(){

                        @Override
                        public void onAttached(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onAttached(msg);
                                    }
                                });
                            }
                        }

                        @Override
                        public void onSuccess(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onSuccess(msg);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onError(final Message msg, final int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(msg, ErrorCode.valueOf(errorCode));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendMessage exception : ", e);
                }
            }
        });
    }

    public void sendDirectionalMessage(Conversation.ConversationType type, String targetId, MessageContent content, final String[] userIds, final String pushContent, final String pushData, IRongCallback.ISendMessageCallback callback) {
        final Message message = Message.obtain(targetId, type, content);
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            RLog.e(TAG, "sendDirectionalMessage \u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
            if (callback != null) {
                callback.onError(message, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TypingMessageManager.getInstance().isShowMessageTyping() && !(content instanceof TypingStatusMessage) && !(content instanceof ReadReceiptMessage)) {
            TypingMessageManager.getInstance().setTypingEnd(message.getConversationType(), message.getTargetId());
        }
        final IpcCallbackProxy<IRongCallback.ISendMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    RongIMClient.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ipcCallbackProxy.callback != null) {
                                ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.sendDirectionalMessage(message, pushContent, pushData, userIds, new ISendMessageCallback.Stub(){

                        @Override
                        public void onAttached(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onAttached(msg);
                                    }
                                });
                            }
                        }

                        @Override
                        public void onSuccess(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onSuccess(msg);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onError(final Message msg, final int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(msg, ErrorCode.valueOf(errorCode));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendDirectionalMessage exception : ", e);
                }
            }
        });
    }

    public void sendImageMessage(Conversation.ConversationType type, String targetId, MessageContent content, String pushContent, String pushData, SendImageMessageCallback callback) {
        Message message = Message.obtain(targetId, type, content);
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(errorCode);
            }
            return;
        }
        this.sendImageMessage(message, pushContent, pushData, callback);
    }

    public void sendImageMessage(Message message, final String pushContent, final String pushData, final SendImageMessageCallback callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(errorCode);
            }
            return;
        }
        final ResultCallback.Result result = new ResultCallback.Result();
        result.t = message;
        final UploadMediaCallback uploadMediaCallback = new UploadMediaCallback(){

            @Override
            public void onProgress(Message message, int progress) {
                if (callback != null) {
                    callback.onProgressCallback(message, progress);
                }
            }

            @Override
            public void onSuccess(Message message) {
                RongIMClient.this.internalSendImageMessage(message, pushContent, pushData, callback);
            }

            @Override
            public void onError(Message message, ErrorCode e) {
                message.setSentStatus(Message.SentStatus.FAILED);
                RongIMClient.this.setMessageSentStatus(message, new ResultCallback<Boolean>(){

                    @Override
                    public void onSuccess(Boolean aBoolean) {
                    }

                    @Override
                    public void onError(ErrorCode e) {
                    }
                });
                if (callback != null) {
                    callback.onFail(message, e);
                }
            }
        };
        ResultCallback<Message> insertCallback = new ResultCallback<Message>(){

            @Override
            public void onSuccess(Message message) {
                if (message != null) {
                    result.t = message;
                    message.setSentStatus(Message.SentStatus.SENDING);
                    RongIMClient.this.setMessageSentStatus(message, null);
                    if (callback != null) {
                        callback.onAttachedCallback(message);
                    }
                } else {
                    throw new IllegalArgumentException("Message Content \u4e3a\u7a7a\uff01");
                }
                RongIMClient.this.uploadMedia(message, uploadMediaCallback);
            }

            @Override
            public void onError(ErrorCode e) {
                if (callback != null) {
                    callback.onFail(e);
                }
            }
        };
        if (message.getMessageId() <= 0) {
            this.insertSettingMessage(message, insertCallback);
        } else {
            message.setSentStatus(Message.SentStatus.SENDING);
            this.setMessageSentStatus(message, new ResultCallback<Boolean>(){

                @Override
                public void onSuccess(Boolean aBoolean) {
                }

                @Override
                public void onError(ErrorCode e) {
                }
            });
            this.uploadMedia(message, uploadMediaCallback);
        }
    }

    public void sendImageMessage(final Message message, final String pushContent, final String pushData, final SendImageMessageWithUploadListenerCallback callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(null, errorCode);
            }
            return;
        }
        if (this.mLibHandler == null) {
            RLog.e(TAG, "sendImageMessage IPC \u8fdb\u7a0b\u5c1a\u672a\u8fd0\u884c\uff01");
            if (callback != null) {
                callback.onError(message, ErrorCode.IPC_DISCONNECT);
            }
            return;
        }
        ResultCallback<Message> insertCallback = new ResultCallback<Message>(){

            @Override
            public void onSuccess(Message message2) {
                if (message2 != null) {
                    message2.setSentStatus(Message.SentStatus.SENDING);
                    RongIMClient.this.setMessageSentStatus(message2, null);
                    if (callback != null) {
                        UploadImageStatusListener watcher = new UploadImageStatusListener(message2, pushContent, pushData, callback);
                        callback.onAttachedCallback(message2, watcher);
                    }
                } else {
                    throw new IllegalArgumentException("Message Content \u4e3a\u7a7a\uff01");
                }
            }

            @Override
            public void onError(ErrorCode e) {
                if (callback != null) {
                    callback.onError(message, e);
                }
            }
        };
        this.insertSettingMessage(message, insertCallback);
    }

    private void internalSendImageMessage(final Message message, final String pushContent, final String pushData, SendImageMessageCallback callback) {
        final IpcCallbackProxy<SendImageMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<SendImageMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        RongIMClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((SendImageMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.sendMediaMessage(message, pushContent, pushData, new ISendMediaMessageCallback.Stub(){

                        @Override
                        public void onAttached(Message message) throws RemoteException {
                        }

                        @Override
                        public void onProgress(Message message, int progress) throws RemoteException {
                        }

                        @Override
                        public void onSuccess(final Message message) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((SendImageMessageCallback)ipcCallbackProxy.callback).onSuccess(message);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onError(final Message message, final int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                RongIMClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((SendImageMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.valueOf(errorCode));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onCanceled(Message message) throws RemoteException {
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "internalSendImageMessage", e);
                }
            }
        });
    }

    private void uploadMedia(final Message message, UploadMediaCallback callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        Uri localPath = null;
        if (message.getContent() instanceof ImageMessage) {
            localPath = ((ImageMessage)message.getContent()).getLocalUri();
        } else if (message.getContent() instanceof GIFMessage) {
            localPath = ((GIFMessage)message.getContent()).getLocalUri();
        }
        if (!FileUtils.isFileExistsWithUri(this.mContext, localPath)) {
            RLog.e(TAG, "uploadMedia Uri :[" + localPath + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            if (callback != null) {
                callback.onError(message, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<UploadMediaCallback> ipcCallbackProxy = new IpcCallbackProxy<UploadMediaCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((UploadMediaCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.uploadMedia(message, new IUploadCallback.Stub(){

                            @Override
                            public void onComplete(String url) throws RemoteException {
                                RLog.i(RongIMClient.TAG, "uploadMedia onComplete url = " + url);
                                MessageContent content = message.getContent();
                                if (content instanceof ImageMessage) {
                                    ((ImageMessage)content).setRemoteUri(Uri.parse((String)url));
                                }
                                if (ipcCallbackProxy.callback != null) {
                                    ((UploadMediaCallback)ipcCallbackProxy.callback).onCallback(message);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                RLog.e(RongIMClient.TAG, "uploadMedia onFailure: " + errorCode);
                                if (ipcCallbackProxy.callback != null) {
                                    ((UploadMediaCallback)ipcCallbackProxy.callback).onFail(message, ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onProgress(int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((UploadMediaCallback)ipcCallbackProxy.callback).onProgressCallback(message, progress);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "uploadMedia", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((UploadMediaCallback)ipcCallbackProxy.callback).onFail(message, ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void downloadMedia(Conversation.ConversationType conversationType, String targetId, final MediaType mediaType, final String imageUrl, DownloadMediaCallback callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || mediaType == null || TextUtils.isEmpty((CharSequence)imageUrl)) {
            RLog.e(TAG, "downloadMedia \u53c2\u6570\u5f02\u5e38\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final Conversation conversation = new Conversation();
        conversation.setTargetId(targetId);
        conversation.setConversationType(conversationType);
        final IpcCallbackProxy<DownloadMediaCallback> ipcCallbackProxy = new IpcCallbackProxy<DownloadMediaCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((DownloadMediaCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.downloadMedia(conversation, mediaType.getValue(), imageUrl, new IDownloadMediaCallback.Stub(){

                            @Override
                            public void onComplete(String url) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((DownloadMediaCallback)ipcCallbackProxy.callback).onCallback(url);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((DownloadMediaCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onProgress(int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((DownloadMediaCallback)ipcCallbackProxy.callback).onProgressCallback(progress);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "downloadMedia", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((DownloadMediaCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void downloadMediaMessage(final Message message, final IRongCallback.IDownloadMediaMessageCallback callback) {
        if (message == null || message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null || !(message.getContent() instanceof MediaMessageContent)) {
            if (callback != null) {
                callback.onError(message, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IDownloadMediaMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IDownloadMediaMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IDownloadMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.downloadMediaMessage(message, new IDownloadMediaMessageCallback.Stub(){

                            @Override
                            public void onComplete(final Message innerMessage) throws RemoteException {
                                message.setContent(innerMessage.getContent());
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaMessageCallback)ipcCallbackProxy.callback).onSuccess(innerMessage);
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onFailure(final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.valueOf(errorCode));
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onProgress(final int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IDownloadMediaMessageCallback)ipcCallbackProxy.callback).onProgress(message, progress);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onCanceled() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaMessageCallback)ipcCallbackProxy.callback).onCanceled(message);
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "downloadMediaMessage", e);
                        if (callback == null) break block4;
                        RongIMClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(message, ErrorCode.IPC_DISCONNECT);
                            }
                        });
                    }
                }
            }
        });
    }

    public void downloadMediaFile(final String fileUniqueId, final String fileUrl, final String fileName, final String path, final IRongCallback.IDownloadMediaFileCallback callback) {
        final IpcCallbackProxy<IRongCallback.IDownloadMediaFileCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IDownloadMediaFileCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IDownloadMediaFileCallback)ipcCallbackProxy.callback).onError(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.downloadMediaFile(fileUniqueId, fileUrl, fileName, path, new IDownloadMediaFileCallback.Stub(){

                            @Override
                            public void onFileNameChanged(String newFileName) {
                                callback.onFileNameChanged(newFileName);
                            }

                            @Override
                            public void onComplete() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaFileCallback)ipcCallbackProxy.callback).onSuccess();
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onFailure(final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaFileCallback)ipcCallbackProxy.callback).onError(ErrorCode.valueOf(errorCode));
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onProgress(final int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IDownloadMediaFileCallback)ipcCallbackProxy.callback).onProgress(progress);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onCanceled() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (ipcCallbackProxy.callback != null) {
                                                ((IRongCallback.IDownloadMediaFileCallback)ipcCallbackProxy.callback).onCanceled();
                                                ipcCallbackProxy.callback = null;
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "downloadMediaFile", e);
                        if (callback == null) break block4;
                        RongIMClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                callback.onError(ErrorCode.IPC_DISCONNECT);
                            }
                        });
                    }
                }
            }
        });
    }

    public void cancelSendMediaMessage(final Message message, OperationCallback callback) {
        if (message == null || message.getMessageId() <= 0 || !(message.getContent() instanceof MediaMessageContent) || ((MediaMessageContent)message.getContent()).getLocalPath() == null) {
            RLog.e(TAG, "cancelSendMediaMessage \u53c2\u6570\u5f02\u5e38\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.cancelSendMediaMessage(message, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "cancelSendMediaMessage", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void cancelDownloadMediaMessage(final Message message, OperationCallback callback) {
        if (message == null || message.getMessageId() <= 0 || !(message.getContent() instanceof MediaMessageContent) || ((MediaMessageContent)message.getContent()).getMediaUrl() == null) {
            RLog.e(TAG, "cancelDownloadMediaMessage \u53c2\u6570\u5f02\u5e38\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.cancelDownloadMediaMessage(message, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "cancelDownloadMediaMessage", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private void cancelAllDownloadMediaMessage(OperationCallback callback) {
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.cancelAllDownloadMediaMessage(new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "cancelAllDownloadMediaMessage", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void pauseDownloadMediaMessage(final Message message, OperationCallback callback) {
        if (message == null || message.getMessageId() <= 0 || !(message.getContent() instanceof MediaMessageContent) || ((MediaMessageContent)message.getContent()).getMediaUrl() == null) {
            RLog.e(TAG, "cancelDownloadMediaMessage \u53c2\u6570\u5f02\u5e38\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.pauseTransferMediaMessage(message, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "pauseDownloadMediaMessage", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void pauseDownloadMediaFile(final String fileUniqueId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)fileUniqueId)) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.pauseTransferMediaFile(fileUniqueId, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "pauseDownloadMediaFile", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getConversationNotificationStatus(final Conversation.ConversationType conversationType, final String targetId, ResultCallback<Conversation.ConversationNotificationStatus> callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            RLog.e(TAG, "Conversation parameter is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (conversationType.equals((Object)Conversation.ConversationType.CHATROOM)) {
            RLog.e(TAG, "Not support ChatRoom ConversationType!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<Conversation.ConversationNotificationStatus>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<Conversation.ConversationNotificationStatus>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getConversationNotificationStatus(conversationType.getValue(), targetId, new ILongCallback.Stub(){

                            @Override
                            public void onComplete(long result) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(Conversation.ConversationNotificationStatus.setValue((int)result));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getConversationNotificationStatus", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setConversationNotificationStatus(final Conversation.ConversationType conversationType, final String targetId, final Conversation.ConversationNotificationStatus notificationStatus, ResultCallback<Conversation.ConversationNotificationStatus> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null || notificationStatus == null) {
            RLog.e(TAG, "Conversation parameter is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (conversationType.equals((Object)Conversation.ConversationType.CHATROOM)) {
            RLog.e(TAG, "Not support ChatRoom ConversationType!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<Conversation.ConversationNotificationStatus>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<Conversation.ConversationNotificationStatus>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.setConversationNotificationStatus(conversationType.getValue(), targetId, notificationStatus.getValue(), new ILongCallback.Stub(){

                            @Override
                            public void onComplete(long result) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(Conversation.ConversationNotificationStatus.setValue((int)result));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setConversationNotificationStatus", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void setDiscussionInviteStatus(final String discussionId, final DiscussionInviteStatus status, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)discussionId) || status == null) {
            RLog.e(TAG, "Parameter is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.setDiscussionInviteStatus(discussionId, status.getValue(), new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setDiscussionInviteStatus", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public String getCurrentUserId() {
        try {
            if (TextUtils.isEmpty((CharSequence)SingletonHolder.sInstance.mCurrentUserId) && this.mLibHandler != null) {
                SingletonHolder.sInstance.mCurrentUserId = this.mLibHandler.getCurrentUserId();
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "getCurrentUserId", e);
        }
        if (SingletonHolder.sInstance.mCurrentUserId == null) {
            RLog.w(TAG, "ipc process does not created");
            if (this.mContext != null) {
                SharedPreferences sp = SharedPreferencesUtils.get(this.mContext, "Statistics", 0);
                SingletonHolder.sInstance.mCurrentUserId = sp.getString("userId", "");
            } else {
                SingletonHolder.sInstance.mCurrentUserId = null;
            }
        }
        return SingletonHolder.sInstance.mCurrentUserId;
    }

    public long getDeltaTime() {
        try {
            return this.mLibHandler == null ? 0L : this.mLibHandler.getDeltaTime();
        }
        catch (Exception e) {
            RLog.e(TAG, "getDeltaTime", e);
            return 0L;
        }
    }

    public void getChatRoomInfo(final String chatRoomId, final int defMemberCount, final ChatRoomInfo.ChatRoomMemberOrder order, ResultCallback<ChatRoomInfo> callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e(TAG, "id is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<ChatRoomInfo>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<ChatRoomInfo>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getChatRoomInfo(chatRoomId, defMemberCount, order.getValue(), new IResultCallback.Stub(){

                            @Override
                            public void onComplete(RemoteModelWrap model) throws RemoteException {
                                ChatRoomInfo info = null;
                                if (model != null) {
                                    info = (ChatRoomInfo)model.getContent();
                                    info.setMemberOrder(order);
                                }
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(info);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getChatRoomInfo", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void joinChatRoom(final String chatRoomId, final int defMessageCount, final OperationCallback callback) {
        FwLog.write(3, 1, FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), "room_id|existed|count", chatRoomId, false, defMessageCount);
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", ErrorCode.PARAMETER_ERROR.code, chatRoomId);
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mToken)) {
            RLog.e(TAG, "joinChatRoom without connect!");
            FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", ErrorCode.APP_NOT_CONNECT.code, chatRoomId);
            if (callback != null) {
                callback.onError(ErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                ChatRoomActionListener listener = (ChatRoomActionListener)chatRoomActionListener.get();
                if (listener != null) {
                    listener.onJoining(chatRoomId);
                }
                if (RongIMClient.this.mLibHandler != null) {
                    try {
                        boolean joinMultiCR = RongIMClient.this.mLibHandler.getJoinMultiChatRoomEnable();
                        JoinChatRoomCallback callback2 = new JoinChatRoomCallback(ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, false, false);
                        RongIMClient.this.mLibHandler.joinChatRoom(chatRoomId, defMessageCount, callback2);
                    }
                    catch (Exception e) {
                        FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id|stacks", ErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString(e));
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                        if (listener != null) {
                            listener.onError(chatRoomId, ErrorCode.IPC_DISCONNECT);
                        }
                    }
                } else {
                    FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", ErrorCode.IPC_DISCONNECT.code, chatRoomId);
                    callback.onFail(ErrorCode.IPC_DISCONNECT);
                    if (listener != null) {
                        listener.onError(chatRoomId, ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private void reJoinChatRoomWithCache() {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                int size = RongIMClient.this.mRetryCRCache.size();
                if (size > 0) {
                    RLog.d(RongIMClient.TAG, "clear retry chatroom cache after connectivity available, cached size = " + size);
                    for (ChatRoomCacheRunnable runnable : RongIMClient.this.mRetryCRCache.values()) {
                        RongIMClient.this.mWorkHandler.removeCallbacks((Runnable)runnable);
                    }
                    RongIMClient.this.mRetryCRCache.clear();
                }
                if ((size = RongIMClient.this.mChatRoomCache.size()) > 0) {
                    RLog.d(RongIMClient.TAG, "re-join chatroom after connectivity available, cached size = " + size);
                    for (ChatRoomCacheRunnable runnable : RongIMClient.this.mChatRoomCache.values()) {
                        RongIMClient.this.mWorkHandler.post((Runnable)runnable);
                    }
                }
            }
        });
    }

    public void joinExistChatRoom(final String chatRoomId, final int defMessageCount, OperationCallback callback) {
        FwLog.write(3, 1, FwLog.LogTag.A_JOIN_CHATROOM_T.getTag(), "room_id|existed|count", chatRoomId, true, defMessageCount);
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", ErrorCode.PARAMETER_ERROR.code, chatRoomId);
            RLog.e(TAG, "id is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mToken)) {
            RLog.e(TAG, "joinExitChatRoom without connect!");
            FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", ErrorCode.APP_NOT_CONNECT.code, chatRoomId);
            if (callback != null) {
                callback.onError(ErrorCode.APP_NOT_CONNECT);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                JoinChatRoomCallback callback = new JoinChatRoomCallback(ipcCallbackProxy, chatRoomId, defMessageCount, false, true, false);
                ChatRoomActionListener listener = (ChatRoomActionListener)chatRoomActionListener.get();
                if (listener != null) {
                    listener.onJoining(chatRoomId);
                }
                if (RongIMClient.this.mLibHandler != null) {
                    try {
                        boolean joinMultiCR = RongIMClient.this.mLibHandler.getJoinMultiChatRoomEnable();
                        RongIMClient.this.mLibHandler.joinExistChatRoom(chatRoomId, defMessageCount, new JoinChatRoomCallback(ipcCallbackProxy, chatRoomId, defMessageCount, joinMultiCR, true, false), false);
                    }
                    catch (Exception e) {
                        FwLog.write(1, 1, FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id|stacks", ErrorCode.IPC_DISCONNECT.getValue(), chatRoomId, FwLog.stackToString(e));
                        RLog.e(RongIMClient.TAG, "joinExistChatRoom", e);
                        callback.onFailure(ErrorCode.IPC_DISCONNECT.getValue());
                    }
                } else {
                    callback.onFailure(ErrorCode.IPC_DISCONNECT.getValue());
                }
            }
        });
    }

    public void quitChatRoom(final String chatRoomId, OperationCallback callback) {
        FwLog.write(3, 1, FwLog.LogTag.A_QUIT_CHATROOM_T.getTag(), "room_id", chatRoomId);
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            FwLog.write(1, 1, FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), "code|room_id", ErrorCode.PARAMETER_ERROR.code, chatRoomId);
            RLog.e(TAG, "id is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block6: {
                    ChatRoomActionListener listener;
                    RongIMClient.this.mChatRoomCache.remove(chatRoomId);
                    Runnable runnable = (Runnable)RongIMClient.this.mRetryCRCache.remove(chatRoomId);
                    if (runnable != null) {
                        RongIMClient.this.mWorkHandler.removeCallbacks(runnable);
                    }
                    if ((listener = (ChatRoomActionListener)chatRoomActionListener.get()) != null) {
                        listener.onQuited(chatRoomId);
                    }
                    if (RongIMClient.this.mLibHandler == null) {
                        FwLog.write(1, 1, FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), "code|room_id", new Object[]{ErrorCode.IPC_DISCONNECT, chatRoomId});
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.quitChatRoom(chatRoomId, new DefaultOperationCallback(ipcCallbackProxy){

                            @Override
                            public void onComplete() {
                                super.onComplete();
                                FwLog.write(3, 1, FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), "code|room_id", 0, chatRoomId);
                            }

                            @Override
                            public void onFailure(int errorCode) {
                                super.onFailure(errorCode);
                                FwLog.write(1, 1, FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), "code|room_id", errorCode, chatRoomId);
                            }
                        });
                    }
                    catch (Exception e) {
                        FwLog.write(1, 1, FwLog.LogTag.A_QUIT_CHATROOM_R.getTag(), "code|room_id|stacks", -1000, chatRoomId, FwLog.stackToString(e));
                        RLog.e(RongIMClient.TAG, "quitChatRoom", e);
                        if (ipcCallbackProxy.callback == null) break block6;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void clearConversations(final ResultCallback callback, final Conversation.ConversationType ... conversationTypes) {
        if (conversationTypes == null || conversationTypes.length == 0) {
            RLog.e(TAG, "conversationTypes is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        int[] types = RongIMClient.this.convertTypes(conversationTypes);
                        boolean result = RongIMClient.this.mLibHandler.clearConversations(types);
                        if (callback != null) {
                            callback.onCallback(result);
                        }
                    }
                    catch (Exception e) {
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void addToBlacklist(final String userId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            RLog.e(TAG, "userId  is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.addToBlacklist(userId, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "addToBlacklist", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void removeFromBlacklist(final String userId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            RLog.e(TAG, "userId  is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.removeFromBlacklist(userId, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "removeFromBlacklist", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getBlacklistStatus(final String userId, ResultCallback<BlacklistStatus> callback) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            RLog.e(TAG, "userId  is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<BlacklistStatus>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<BlacklistStatus>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getBlacklistStatus(userId, new IIntegerCallback.Stub(){

                            @Override
                            public void onComplete(int result) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(BlacklistStatus.setValue(result));
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getBlacklistStatus", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getBlacklist(GetBlacklistCallback callback) {
        final IpcCallbackProxy<GetBlacklistCallback> ipcCallbackProxy = new IpcCallbackProxy<GetBlacklistCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((GetBlacklistCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getBlacklist(new IStringCallback.Stub(){

                            @Override
                            public void onComplete(String result) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    if (result == null) {
                                        ((GetBlacklistCallback)ipcCallbackProxy.callback).onCallback(null);
                                    } else {
                                        ((GetBlacklistCallback)ipcCallbackProxy.callback).onCallback(result.split("\n"));
                                    }
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((GetBlacklistCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getBlacklist", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((GetBlacklistCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void searchPublicService(final SearchType searchType, final String keywords, ResultCallback<PublicServiceProfileList> callback) {
        if (searchType == null) {
            RLog.e(TAG, "searchType  is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<PublicServiceProfileList>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<PublicServiceProfileList>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.searchPublicService(keywords, 0, searchType.getValue(), new IResultCallback.Stub(){

                        @Override
                        public void onComplete(RemoteModelWrap model) throws RemoteException {
                            if (ipcCallbackProxy.callback != null && model != null && model.getContent() != null && model.getContent() instanceof PublicServiceProfileList) {
                                ((ResultCallback)ipcCallbackProxy.callback).onCallback((PublicServiceProfileList)model.getContent());
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "searchPublicService", e);
                }
            }
        });
    }

    public void searchPublicServiceByType(Conversation.PublicServiceType publicServiceType, final SearchType searchType, final String keywords, ResultCallback<PublicServiceProfileList> callback) {
        if (publicServiceType == null || searchType == null) {
            RLog.e(TAG, "searchType  is null!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final int[] businessType = new int[]{0};
        if (publicServiceType == Conversation.PublicServiceType.APP_PUBLIC_SERVICE) {
            businessType[0] = 2;
        } else if (publicServiceType == Conversation.PublicServiceType.PUBLIC_SERVICE) {
            businessType[0] = 1;
        }
        final IpcCallbackProxy<ResultCallback<PublicServiceProfileList>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<PublicServiceProfileList>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.searchPublicService(keywords, businessType[0], searchType.getValue(), new IResultCallback.Stub(){

                        @Override
                        public void onComplete(RemoteModelWrap model) throws RemoteException {
                            if (ipcCallbackProxy.callback != null && model != null && model.getContent() != null && model.getContent() instanceof PublicServiceProfileList) {
                                ((ResultCallback)ipcCallbackProxy.callback).onCallback((PublicServiceProfileList)model.getContent());
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(errorCode);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "searchPublicServiceByType", e);
                }
            }
        });
    }

    public void subscribePublicService(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, OperationCallback callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e(TAG, "Parameter  is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.subscribePublicService(publicServiceId, publicServiceType.getValue(), true, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "subscribePublicService", e);
                }
            }
        });
    }

    public void unsubscribePublicService(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, OperationCallback callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e(TAG, "Parameter  is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.subscribePublicService(publicServiceId, publicServiceType.getValue(), false, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "unsubscribePublicService", e);
                }
            }
        });
    }

    public void getPublicServiceProfile(final Conversation.PublicServiceType publicServiceType, final String publicServiceId, ResultCallback<PublicServiceProfile> callback) {
        if (publicServiceType == null || TextUtils.isEmpty((CharSequence)publicServiceId)) {
            RLog.e(TAG, "Parameter  is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<PublicServiceProfile>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<PublicServiceProfile>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getPublicServiceProfile(publicServiceId, publicServiceType.getValue(), new IResultCallback.Stub(){

                        @Override
                        public void onComplete(RemoteModelWrap model) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                PublicServiceProfile publicServiceProfile = null;
                                if (model != null) {
                                    publicServiceProfile = (PublicServiceProfile)model.getContent();
                                }
                                ((ResultCallback)ipcCallbackProxy.callback).onCallback(publicServiceProfile);
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getPublicServiceProfile", e);
                }
            }
        });
    }

    public void getPublicServiceList(ResultCallback<PublicServiceProfileList> callback) {
        final IpcCallbackProxy<ResultCallback<PublicServiceProfileList>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<PublicServiceProfileList>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getPublicServiceList(new IResultCallback.Stub(){

                        @Override
                        public void onComplete(RemoteModelWrap model) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                PublicServiceProfileList publicServiceInfoList = (PublicServiceProfileList)model.getContent();
                                ((ResultCallback)ipcCallbackProxy.callback).onCallback(publicServiceInfoList);
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getPublicServiceList", e);
                }
            }
        });
    }

    public void setNotificationQuietHours(final String startTime, final int spanMinutes, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)startTime) || spanMinutes <= 0 || spanMinutes >= 1440) {
            RLog.e(TAG, "startTime, spanMinutes \u6216 spanMinutes \u53c2\u6570\u5f02\u5e38\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        Pattern pattern = Pattern.compile("^(([0-1][0-9])|2[0-3]):[0-5][0-9]:([0-5][0-9])$");
        Matcher matcher = pattern.matcher(startTime);
        if (!matcher.find()) {
            RLog.e(TAG, "startTime \u53c2\u6570\u5f02\u5e38\u3002");
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.setNotificationQuietHours(startTime, spanMinutes, new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setNotificationQuietHours", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void removeNotificationQuietHours(OperationCallback callback) {
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.removeNotificationQuietHours(new DefaultOperationCallback(ipcCallbackProxy));
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "removeNotificationQuietHours", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    private void updateMessageReceiptStatus(final Conversation.ConversationType conversationType, final String targetId, final long timestamp, final OperationCallback callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                try {
                    if (RongIMClient.this.mLibHandler.updateMessageReceiptStatus(targetId, conversationType.getValue(), timestamp)) {
                        if (callback != null) {
                            callback.onCallback();
                        }
                    } else if (callback != null) {
                        callback.onFail(ErrorCode.UNKNOWN);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "updateMessageReceiptStatus", e);
                }
            }
        });
    }

    public void clearMessagesUnreadStatus(final Conversation.ConversationType conversationType, final String targetId, final long timestamp, final OperationCallback callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                if (conversationType == null) {
                    RLog.e(RongIMClient.TAG, "clearMessagesUnreadStatus conversationType is null!");
                    if (callback != null) {
                        callback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                try {
                    if (RongIMClient.this.mLibHandler.clearUnreadByReceipt(conversationType.getValue(), targetId, timestamp)) {
                        if (callback != null) {
                            callback.onCallback();
                        }
                    } else if (callback != null) {
                        callback.onFail(ErrorCode.UNKNOWN);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "clearMessagesUnreadStatus", e);
                }
            }
        });
    }

    public long getSendTimeByMessageId(int messageId) {
        try {
            if (this.mLibHandler == null) {
                RLog.e(TAG, "getSendTimeByMessageId mLibHandler is null!");
                return 0L;
            }
            return this.mLibHandler.getSendTimeByMessageId(messageId);
        }
        catch (Exception e) {
            RLog.e(TAG, "getSendTimeByMessageId", e);
            return 0L;
        }
    }

    public void getNotificationQuietHours(GetNotificationQuietHoursCallback callback) {
        final IpcCallbackProxy<GetNotificationQuietHoursCallback> ipcCallbackProxy = new IpcCallbackProxy<GetNotificationQuietHoursCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((GetNotificationQuietHoursCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.getNotificationQuietHours(new IGetNotificationQuietHoursCallback.Stub(){

                            @Override
                            public void onSuccess(String startTime, int spanMin) {
                                if (ipcCallbackProxy.callback != null) {
                                    ((GetNotificationQuietHoursCallback)ipcCallbackProxy.callback).onCallback(startTime, spanMin);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onError(int code) {
                                if (ipcCallbackProxy.callback != null) {
                                    ((GetNotificationQuietHoursCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(code));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getNotificationQuietHours", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((GetNotificationQuietHoursCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    private void clearToken() {
        RLog.d(TAG, "clear token");
        this.mToken = null;
        SharedPreferences sp = SharedPreferencesUtils.get(this.mContext, "Statistics", 0);
        if (sp != null) {
            sp.edit().remove("token").commit();
        }
    }

    private void setToken(String token) {
        RLog.d(TAG, "set token");
        this.mToken = token;
    }

    private void handleReadReceiptMessage(final Message message) {
        if (message.getMessageDirection().equals((Object)Message.MessageDirection.SEND)) {
            this.clearMessagesUnreadStatus(message.getConversationType(), message.getTargetId(), ((ReadReceiptMessage)message.getContent()).getLastMessageSendTime(), null);
            if (this.mSyncConversationReadStatusListener != null) {
                this.mSyncConversationReadStatusListener.onSyncConversationReadStatus(message.getConversationType(), message.getTargetId());
            }
        } else {
            this.updateMessageReceiptStatus(message.getConversationType(), message.getTargetId(), ((ReadReceiptMessage)message.getContent()).getLastMessageSendTime(), new OperationCallback(){

                @Override
                public void onSuccess() {
                    if (sReadReceiptListener != null) {
                        sReadReceiptListener.onReadReceiptReceived(message);
                    }
                }

                @Override
                public void onError(ErrorCode errorCode) {
                    RLog.e(RongIMClient.TAG, "RongIMClient : updateMessageReceiptStatus fail");
                }
            });
        }
    }

    private boolean handleCmdMessages(final Message message, final int left, final boolean hasPackage, final boolean offline, final int cmdLeft) {
        boolean isTypingMessage;
        boolean result = ModuleManager.routeMessage(message, left, offline, cmdLeft);
        boolean isExtensionModuleHandled = false;
        if (!result) {
            isExtensionModuleHandled = this.imLibExtensionModuleManager.onReceiveMessage(message, left, offline, cmdLeft);
        }
        if (result || isExtensionModuleHandled) {
            return true;
        }
        if (TypingMessageManager.getInstance().isShowMessageTyping() && (isTypingMessage = TypingMessageManager.getInstance().onReceiveMessage(message))) {
            return true;
        }
        if (message.getContent() instanceof ReadReceiptMessage) {
            this.handleReadReceiptMessage(message);
            return true;
        }
        if (message.getContent() instanceof SyncReadStatusMessage) {
            if (message.getMessageDirection() == Message.MessageDirection.SEND) {
                this.clearMessagesUnreadStatus(message.getConversationType(), message.getTargetId(), ((SyncReadStatusMessage)message.getContent()).getLastMessageSendTime(), null);
                if (this.mSyncConversationReadStatusListener != null) {
                    this.mSyncConversationReadStatusListener.onSyncConversationReadStatus(message.getConversationType(), message.getTargetId());
                }
            }
            return true;
        }
        if (message.getContent() instanceof ReadReceiptRequestMessage) {
            if (!message.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && !message.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION)) {
                return true;
            }
            ReadReceiptRequestMessage requestMessage = (ReadReceiptRequestMessage)message.getContent();
            try {
                Message msg = this.mLibHandler.getMessageByUid(requestMessage.getMessageUId());
                if (msg != null) {
                    ReadReceiptInfo readReceiptInfo = msg.getReadReceiptInfo();
                    if (readReceiptInfo == null) {
                        readReceiptInfo = new ReadReceiptInfo();
                        msg.setReadReceiptInfo(readReceiptInfo);
                    }
                    readReceiptInfo.setIsReadReceiptMessage(true);
                    readReceiptInfo.setHasRespond(false);
                    this.mLibHandler.updateReadReceiptRequestInfo(requestMessage.getMessageUId(), readReceiptInfo.toJSON().toString());
                    if (sReadReceiptListener != null) {
                        sReadReceiptListener.onMessageReceiptRequest(message.getConversationType(), message.getTargetId(), requestMessage.getMessageUId());
                    }
                }
            }
            catch (Exception e) {
                RLog.e(TAG, "*handleCmdMessages", e);
            }
            return true;
        }
        if (message.getContent() instanceof ReadReceiptResponseMessage) {
            if (message.getMessageDirection().equals((Object)Message.MessageDirection.SEND)) {
                return true;
            }
            if (!message.getConversationType().equals((Object)Conversation.ConversationType.GROUP) && !message.getConversationType().equals((Object)Conversation.ConversationType.DISCUSSION)) {
                return true;
            }
            ReadReceiptResponseMessage responseMessage = (ReadReceiptResponseMessage)message.getContent();
            ArrayList<String> messageUIdList = responseMessage.getMessageUIdListBySenderId(this.getCurrentUserId());
            String senderUserId = message.getSenderUserId();
            if (messageUIdList != null && this.mLibHandler != null) {
                for (String messageUId : messageUIdList) {
                    try {
                        Message msg = this.mLibHandler.getMessageByUid(messageUId);
                        if (msg == null) continue;
                        ReadReceiptInfo readReceiptInfo = msg.getReadReceiptInfo();
                        if (readReceiptInfo == null) {
                            readReceiptInfo = new ReadReceiptInfo();
                            msg.setReadReceiptInfo(readReceiptInfo);
                        }
                        readReceiptInfo.setIsReadReceiptMessage(true);
                        HashMap<String, Long> respondUserIdList = readReceiptInfo.getRespondUserIdList();
                        if (respondUserIdList == null) {
                            respondUserIdList = new HashMap();
                            readReceiptInfo.setRespondUserIdList(respondUserIdList);
                        }
                        respondUserIdList.put(senderUserId, message.getSentTime());
                        this.mLibHandler.updateReadReceiptRequestInfo(messageUId, readReceiptInfo.toJSON().toString());
                        if (sReadReceiptListener == null) continue;
                        sReadReceiptListener.onMessageReceiptResponse(message.getConversationType(), message.getTargetId(), messageUId, respondUserIdList);
                    }
                    catch (Exception e) {
                        RLog.e(TAG, "#handleCmdMessages", e);
                    }
                }
            }
            return true;
        }
        if (message.getContent() instanceof RecallCommandMessage) {
            final RecallCommandMessage recallCommandMessage = (RecallCommandMessage)message.getContent();
            this.getMessageByUid(recallCommandMessage.getMessageUId(), new ResultCallback<Message>(){

                @Override
                public void onSuccess(final Message msg) {
                    if (recallCommandMessage.isDelete()) {
                        if (msg != null) {
                            int[] messageId = new int[]{msg.getMessageId()};
                            FwLog.write(4, 1, FwLog.LogTag.P_DELETE_MSG_S.getTag(), "isDelete|messageId|messageUId", recallCommandMessage.isDelete(), messageId, recallCommandMessage.getMessageUId());
                            RongIMClient.this.deleteMessages(messageId, new ResultCallback<Boolean>(){

                                @Override
                                public void onSuccess(Boolean aBoolean) {
                                    RLog.i(RongIMClient.TAG, "deleteMessage success");
                                    if (sOnRecallMessageListener != null) {
                                        sOnRecallMessageListener.onMessageRecalled(msg, null);
                                    }
                                }

                                @Override
                                public void onError(ErrorCode e) {
                                    RLog.e(RongIMClient.TAG, "deleteMessage when recall, error " + e.code);
                                }
                            });
                        }
                        return;
                    }
                    if (msg == null) {
                        RecallNotificationMessage recallNotificationMessage = new RecallNotificationMessage(message.getSenderUserId(), recallCommandMessage.getSentTime(), message.getObjectName(), recallCommandMessage.isAdmin(), recallCommandMessage.isDelete());
                        recallNotificationMessage.setUserInfo(recallCommandMessage.getUserInfo());
                        Message recallNotificationMsg = Message.obtain(message.getTargetId(), message.getConversationType(), recallNotificationMessage);
                        recallNotificationMsg.setSentTime(recallCommandMessage.getSentTime());
                        recallNotificationMsg.setSenderUserId(message.getSenderUserId());
                        Message.ReceivedStatus receivedStatus = new Message.ReceivedStatus(0);
                        RongIMClient.this.insertIncomingMessage(message.getConversationType(), message.getTargetId(), message.getSenderUserId(), receivedStatus, recallNotificationMessage, recallCommandMessage.getSentTime(), null);
                        if (sReceiveMessageListener != null) {
                            if (sReceiveMessageListener instanceof OnReceiveMessageWrapperListener) {
                                ((OnReceiveMessageWrapperListener)sReceiveMessageListener).onReceived(recallNotificationMsg, left - cmdLeft, hasPackage, offline);
                            } else {
                                sReceiveMessageListener.onReceived(recallNotificationMsg, left - cmdLeft);
                            }
                        }
                    } else {
                        RecallNotificationMessage recallNotificationMessage = new RecallNotificationMessage(message.getSenderUserId(), recallCommandMessage.getSentTime(), msg.getObjectName(), recallCommandMessage.isAdmin(), recallCommandMessage.isDelete());
                        msg.getReceivedStatus().setRead();
                        RongIMClient.this.setMessageReceivedStatus(msg.getMessageId(), msg.getReceivedStatus(), null);
                        if (msg.getContent().getUserInfo() != null) {
                            recallNotificationMessage.setUserInfo(msg.getContent().getUserInfo());
                        }
                        if (msg.getContent() instanceof RecallNotificationMessage) {
                            RecallNotificationMessage msgContent = (RecallNotificationMessage)msg.getContent();
                            if (msgContent.getRecallActionTime() > 0L) {
                                recallNotificationMessage.setRecallActionTime(msgContent.getRecallActionTime());
                            }
                            if (!TextUtils.isEmpty((CharSequence)msgContent.getRecallContent())) {
                                recallNotificationMessage.setRecallContent(msgContent.getRecallContent());
                            }
                        }
                        byte[] data = recallNotificationMessage.encode();
                        try {
                            MessageTag recallNotificationTag = RecallNotificationMessage.class.getAnnotation(MessageTag.class);
                            RongIMClient.this.mLibHandler.setMessageContent(msg.getMessageId(), data, recallNotificationTag.value());
                        }
                        catch (Exception e) {
                            RLog.e(RongIMClient.TAG, "handleCmdMessages", e);
                            return;
                        }
                        if (sOnRecallMessageListener != null) {
                            msg.setContent(recallNotificationMessage);
                            sOnRecallMessageListener.onMessageRecalled(msg, recallNotificationMessage);
                        }
                    }
                }

                @Override
                public void onError(ErrorCode e) {
                    RLog.e(RongIMClient.TAG, "recall message received, but getMessageByUid failed");
                }
            });
            return true;
        }
        if (message.getContent() instanceof DestructionCmdMessage) {
            DestructionCmdMessage destructionCmdMessage = (DestructionCmdMessage)message.getContent();
            List<String> msgUids = destructionCmdMessage.getBurnMessageUIds();
            for (String uid : msgUids) {
                this.getMessageByUid(uid, new ResultCallback<Message>(){

                    @Override
                    public void onSuccess(Message msg) {
                        if (msg != null) {
                            RongIMClient.this.setMessageReadTime(msg.getMessageId(), message.getSentTime(), null);
                            msg.setReadTime(message.getSentTime());
                            RongIMClient.getInstance().deleteRemoteMessages(msg.getConversationType(), msg.getTargetId(), new Message[]{msg}, null);
                            RongIMClient.getInstance().deleteMessages(new int[]{msg.getMessageId()}, null);
                            if (RongIMClient.this.mOnReceiveDestructionMessageListener != null) {
                                RongIMClient.this.mOnReceiveDestructionMessageListener.onReceive(msg);
                            }
                        }
                    }

                    @Override
                    public void onError(ErrorCode e) {
                    }
                });
            }
            return true;
        }
        return this.mCmdObjectNameList.contains(message.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReceiver() {
        RLog.i(TAG, "initMessageReceiver");
        try {
            if (!TextUtils.isEmpty((CharSequence)mNaviServer)) {
                this.mLibHandler.setServerInfo(mNaviServer, TextUtils.isEmpty((CharSequence)mFileServer) ? "" : mFileServer);
            }
            this.mLibHandler.initHttpDns();
            this.mLibHandler.setUserPolicy(userPolicy);
            if (this.mStatusListener == null) {
                this.mStatusListener = new StatusListener();
            }
            this.mLibHandler.setConnectionStatusListener(this.mStatusListener);
            this.mLibHandler.setReconnectKickEnable(this.kickReconnectDevice);
            this.mLibHandler.setOnReceiveMessageListener(new OnReceiveMessageListener.Stub(){

                @Override
                public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                    boolean result;
                    try {
                        result = super.onTransact(code, data, reply, flags);
                    }
                    catch (RuntimeException e) {
                        RLog.e(RongIMClient.TAG, "setOnReceiveMessageListener Unexpected remote exception", e);
                        throw e;
                    }
                    return result;
                }

                @Override
                public boolean onReceived(final Message message, final int left, final boolean offline, final boolean hasPackage, final int cmdLeft) throws RemoteException {
                    RongIMClient.this.mUpStreamHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (message.getContent() == null) {
                                RLog.e(RongIMClient.TAG, "message content is null. Return directly!");
                                return;
                            }
                            MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
                            try {
                                if (msgTag != null && msgTag.value().contains("RC:Encrypt") && RongIMClient.this.handleEncMessageContent(message, left, offline, cmdLeft)) {
                                    return;
                                }
                            }
                            catch (RemoteException e) {
                                RLog.e(RongIMClient.TAG, "message:" + e.getMessage());
                            }
                            if (!hasPackage) {
                                RLog.i(RongIMClient.TAG, "onReceived : " + message.getTargetId() + " " + message.getObjectName() + ", sender = " + message.getSenderUserId() + ", uid = " + message.getUId());
                            }
                            if (!RongIMClient.this.handleCmdMessages(message, left, hasPackage, offline, cmdLeft) && sReceiveMessageListener != null) {
                                if (sReceiveMessageListener instanceof OnReceiveMessageWrapperListener) {
                                    ((OnReceiveMessageWrapperListener)sReceiveMessageListener).onReceived(message, left - cmdLeft, hasPackage, offline);
                                } else {
                                    sReceiveMessageListener.onReceived(message, left - cmdLeft);
                                }
                            }
                        }
                    });
                    return false;
                }
            });
            this.mLibHandler.setUserProfileListener(new UserProfileSettingListener.Stub(){

                @Override
                public void OnPushNotificationChanged(long version) throws RemoteException {
                    RongIMClient.this.getPushContentShowStatus(new ResultCallback<Boolean>(){

                        @Override
                        public void onSuccess(Boolean aBoolean) {
                            RLog.i(RongIMClient.TAG, "OnPushNotificationChanged onSuccess  " + aBoolean);
                            RongPushClient.updatePushContentShowStatus(RongIMClient.this.mContext, aBoolean);
                        }

                        @Override
                        public void onError(ErrorCode e) {
                            RLog.i(RongIMClient.TAG, "OnPushNotificationChanged onError  " + (Object)((Object)e));
                        }
                    });
                }
            });
            this.mLibHandler.setConversationStatusListener(new ConversationStatusListener.Stub(){

                @Override
                public void OnStatusChanged(ConversationStatus[] conversationStatus) {
                    if (sConversationStatusListener != null) {
                        sConversationStatusListener.onStatusChanged(conversationStatus);
                    }
                }
            });
            this.mLibHandler.setMessageExpansionListener(new IMessageExpansionListener.Stub(){

                @Override
                public void onMessageExpansionUpdate(Map expansion, Message message) {
                    if (messageExpansionListener != null) {
                        messageExpansionListener.onMessageExpansionUpdate(expansion, message);
                    }
                }

                @Override
                public void onMessageExpansionRemove(List<String> keyArray, Message message) {
                    if (messageExpansionListener != null) {
                        messageExpansionListener.onMessageExpansionRemove(keyArray, message);
                    }
                }
            });
            List<String> list = this.mRegCache;
            synchronized (list) {
                ArrayList<String> messageTypeList = new ArrayList<String>(this.mRegCache);
                this.mLibHandler.registerMessageTypes(messageTypeList);
            }
            ArrayList<String> cmdMsgTypeList = new ArrayList<String>(this.mCmdObjectNameList);
            this.mLibHandler.registerCmdMsgTypes(cmdMsgTypeList);
            this.mLibHandler.registerDeleteMessageType(new ArrayList<String>(this.mDeleteObjectNameList));
            if (cancelSDKHeartBeatEnabled) {
                try {
                    this.mLibHandler.cancelSDKHeartBeat();
                }
                catch (Exception e) {
                    RLog.e(TAG, "initReceiver", e);
                }
            }
            this.mLibHandler.setKvStatusListener(new KVStatusDataByBatchListener.Stub(){
                Map<String, String> resultChange = new HashMap<String, String>();
                Map<String, String> resultRemove = new HashMap<String, String>();

                @Override
                public void onDataSync(String roomId) throws RemoteException {
                    RLog.i(RongIMClient.TAG, "onChatRoomKVStatusSync roomId =" + roomId);
                    if (sKVStatusListener != null) {
                        sKVStatusListener.onChatRoomKVSync(roomId);
                    }
                }

                @Override
                public void onProgressDataChange(Map data) throws RemoteException {
                    this.resultChange.putAll(data);
                }

                @Override
                public void onCompleteDataChange(String roomId) throws RemoteException {
                    RLog.i(RongIMClient.TAG, "onCompleteDataChange roomId =" + roomId + " size" + this.resultChange.size());
                    if (sKVStatusListener != null) {
                        sKVStatusListener.onChatRoomKVUpdate(roomId, this.resultChange);
                    }
                    this.resultChange.clear();
                }

                @Override
                public void onProgressDataRemove(Map data) throws RemoteException {
                    this.resultRemove.putAll(data);
                }

                @Override
                public void onCompleteDataRemove(String roomId) throws RemoteException {
                    RLog.i(RongIMClient.TAG, "onCompleteDataRemove roomId =" + roomId + " size" + this.resultRemove.size());
                    if (sKVStatusListener != null) {
                        sKVStatusListener.onChatRoomKVRemove(roomId, this.resultRemove);
                    }
                    this.resultRemove.clear();
                }
            });
        }
        catch (Exception e) {
            RLog.e(TAG, "initReceiver", e);
        }
    }

    private void setIPCLogListener() {
        try {
            final IHandler iHandler = this.mLibHandler;
            FwLog.setProxyWriter(new IFwLogWriter(){

                @Override
                public void write(int level, String type, String tag, String metaJson, long timestamp) {
                    try {
                        if (iHandler != null) {
                            iHandler.writeFwLog(level, type, tag, metaJson, timestamp);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            if (iHandler != null) {
                iHandler.setRLogOtherProgressCallback(new IRLogOtherProgressCallback.Stub(){

                    @Override
                    public void write(String log, int level) {
                        RLog.callbackWrite(log, level);
                    }

                    @Override
                    public void setLogLevel(int level) {
                        RLog.setLogLevel(level);
                    }

                    @Override
                    public void uploadRLog() {
                        RLog.uploadRLog();
                    }
                });
                iHandler.setNaviContentUpdateListener(new INaviContentUpdateCallBack.Stub(){

                    @Override
                    public void naviContentUpdate() {
                        RongIMClient.this.mWorkHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RLog.setUploadUrl(iHandler.getOffLineLogServer());
                                }
                                catch (Exception e) {
                                    RLog.e(RongIMClient.TAG, "getUploadLogConfigInfo", e);
                                }
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "setIPCLogListener", e);
        }
    }

    private boolean handleEncMessageContent(Message message, int left, boolean offLine, int cmdLeft) throws RemoteException {
        RLog.d(TAG, "handleEncMsg -> " + message.toString());
        MessageContent content = message.getContent();
        String targetId = message.getTargetId();
        if (content == null) {
            RLog.e(TAG, "messageContent from message is null.");
            return false;
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            RLog.e(TAG, "messageTag is null from -> " + content.getClass());
            return false;
        }
        String value = msgTag.value();
        if (value.contains("RC:Encrypt")) {
            RLog.d(TAG, "cmdLeft -> " + cmdLeft + "left" + left + " value " + value + " isRetriverd = " + message.getReceivedStatus().isRetrieved() + " isMultiRetrived -> " + message.getReceivedStatus().isMultipleReceive());
            if (message.getSenderUserId() != null && message.getSenderUserId().equals(this.getCurrentUserId())) {
                RLog.w(TAG, "received signal msg from the same account of different endpoints , do nothing.");
                return true;
            }
        }
        switch (value) {
            case "RC:EncryptRequestMsg": {
                RCEncryptRequestMessage requestMessage = (RCEncryptRequestMessage)content;
                final String reqeustEncId = requestMessage.getRequesterEncId();
                this.signalBuff.put(reqeustEncId, message);
                RLog.d(TAG, reqeustEncId + " in buff at " + System.currentTimeMillis());
                this.mWorkHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (RongIMClient.this.signalBuff.containsKey(reqeustEncId)) {
                            Message msgBuff = (Message)RongIMClient.this.signalBuff.get(reqeustEncId);
                            String targetId = msgBuff.getTargetId();
                            RCEncryptRequestMessage content = (RCEncryptRequestMessage)msgBuff.getContent();
                            RongIMClient.this.sendResponseMsg(content, targetId);
                            RLog.d(RongIMClient.TAG, "reqEncId ->" + reqeustEncId + " request from buff handled at " + System.currentTimeMillis());
                        }
                    }
                }, 200L);
                break;
            }
            case "RC:EncryptResponseMsg": {
                RCEncryptResponseMessage responseReceiveMsg = (RCEncryptResponseMessage)content;
                if (responseReceiveMsg.getResponserEncId() == null) {
                    RLog.e(TAG, "error RC:EncryptResponseMsg -> responseEncId is null.");
                    return true;
                }
                if (responseReceiveMsg.getRequesterEncId() == null) {
                    RLog.e(TAG, "error RC:EncryptResponseMsg -> requestEncId is null.");
                    return true;
                }
                String encTargetIdInResp = responseReceiveMsg.getRequesterEncId() + ";;;" + targetId;
                RCEncryptedSession session = this.mLibHandler.getEncryptedConversation(encTargetIdInResp);
                if (session == null) {
                    RLog.e(TAG, "getEncryptedConversation returns null when onResponse with -> " + encTargetIdInResp + " isRetrived -> " + message.getReceivedStatus().isRetrieved());
                    return true;
                }
                RLog.d(TAG, "session status -> " + session.getEncStatus());
                if (session.getEncStatus() == 3) {
                    this.sendCancelMessage(targetId, responseReceiveMsg, session);
                    break;
                }
                RCDHCodecTool.RCSecretKey secretKey = this.getRcSecretKey(responseReceiveMsg);
                if (secretKey == null) {
                    RLog.e(TAG, "get secretKey is null, when sending confirmMessage.");
                    return true;
                }
                this.sendConfirmMessage(targetId, responseReceiveMsg, secretKey, session);
                this.updateSessionStateAndCallback(responseReceiveMsg.getRequesterEncId(), targetId, responseReceiveMsg.getResponserEncId(), secretKey, session);
                break;
            }
            case "RC:EncryptConfirmMsg": {
                RCEncryptConfirmMessage confirmMsgRec = (RCEncryptConfirmMessage)content;
                this.handleRetrivedConfirmMessage(message, left, confirmMsgRec);
                String encTargetIdInConfirm = confirmMsgRec.getResponserEncId() + ";;;" + targetId;
                RCEncryptedSession encryptedConversation = this.mLibHandler.getEncryptedConversation(encTargetIdInConfirm);
                if (encryptedConversation == null) {
                    RLog.e(TAG, "getEncryptedConversation return null,there should be error in request codes.");
                    return true;
                }
                if (!this.updateConfirmStatusAndCallback(encTargetIdInConfirm, encryptedConversation)) break;
                return true;
            }
            case "RC:EncryptCancelMsg": {
                RCEncryptCancelMessage cancleMsg = (RCEncryptCancelMessage)content;
                if (this.handleRetrivedCancelMessage(message, left, cancleMsg)) {
                    return true;
                }
                String encTargetIdInCancel = cancleMsg.getResponserEncId() + ";;;" + targetId;
                RCEncryptedSession encSession2Cancel = this.mLibHandler.getEncryptedConversation(encTargetIdInCancel);
                RLog.d(TAG, "cancleResponserEncId -> " + encTargetIdInCancel);
                if (encSession2Cancel == null) {
                    RLog.w(TAG, "can not find encrypted conersation while canceling the session with the targetID -> " + encTargetIdInCancel);
                    return true;
                }
                this.updateCancelStatusAndCallback(encTargetIdInCancel, encSession2Cancel);
                break;
            }
            case "RC:EncryptTerminateMsg": {
                RCEncryptTerminateMessage terminateMessage = (RCEncryptTerminateMessage)content;
                String requesterEncId = terminateMessage.getReceiverEncId();
                String string2 = requesterEncId = requesterEncId == null ? "" : requesterEncId;
                if (this.signalBuff.containsKey(requesterEncId)) {
                    this.signalBuff.remove(requesterEncId);
                    return true;
                }
                String terminateTargetId = terminateMessage.getReceiverEncId() + ";;;" + targetId;
                RCEncryptedSession encSession2Terminate = this.mLibHandler.getEncryptedConversation(terminateTargetId);
                if (encSession2Terminate == null) {
                    RLog.w(TAG, "can not find encrypted conversation with encTargetId ->" + terminateTargetId);
                    return true;
                }
                String senderEncId = terminateMessage.getSenderEncId();
                if (senderEncId == null || !senderEncId.equals(encSession2Terminate.getRemoteEncId())) {
                    return true;
                }
                this.updateTerinateStatusAndCallback(terminateTargetId, encSession2Terminate);
                break;
            }
        }
        return false;
    }

    private boolean updateConfirmStatusAndCallback(String encTargetIdInConfirm, RCEncryptedSession encryptedConversation) throws RemoteException {
        encryptedConversation.setEncStatus(3);
        boolean isEstablished = this.mLibHandler.setEncryptedConversation(encTargetIdInConfirm, encryptedConversation);
        if (!isEstablished) {
            RLog.e(TAG, "setEncryptedConversation failed while updating encStatus.");
            return true;
        }
        this.mEncSessionConListener.onEncryptedSessionEstablished(encTargetIdInConfirm);
        return false;
    }

    private void updateTerinateStatusAndCallback(String terminateTargetId, RCEncryptedSession encSession2Terminate) throws RemoteException {
        encSession2Terminate.setEncStatus(5);
        this.mLibHandler.setEncryptedConversation(terminateTargetId, encSession2Terminate);
        if (this.mEncSessionConListener != null) {
            this.mEncSessionConListener.onEncryptedSessionTerminated(terminateTargetId);
        }
    }

    private void updateCancelStatusAndCallback(String encTargetIdInCancel, RCEncryptedSession encSession2Cancel) throws RemoteException {
        encSession2Cancel.setEncStatus(4);
        if (this.mLibHandler.setEncryptedConversation(encTargetIdInCancel, encSession2Cancel)) {
            if (this.mEncSessionConListener != null) {
                this.mEncSessionConListener.onEncryptedSessionCanceled(encTargetIdInCancel);
            }
        } else {
            RLog.e(TAG, "setEncryptedConversation failed when receive EncryptCancelMsg.");
        }
    }

    private boolean handleRetrivedCancelMessage(Message message, int left, RCEncryptCancelMessage cancleMsg) {
        String requesterEncId = cancleMsg.getRequesterEncId();
        String responserEncId = cancleMsg.getResponserEncId();
        if (this.signalBuff.containsKey(requesterEncId)) {
            this.signalBuff.remove(requesterEncId);
            RLog.d(TAG, "req -> " + requesterEncId + "resp -> " + responserEncId + " cancel from buff at " + System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private boolean handleRetrivedConfirmMessage(Message message, int left, RCEncryptConfirmMessage confirmMsgRec) {
        String requesterEncId = confirmMsgRec.getRequesterEncId();
        if (this.signalBuff.containsKey(requesterEncId)) {
            this.signalBuff.remove(requesterEncId);
            RLog.d(TAG, "confirm from buff at " + System.currentTimeMillis());
            return true;
        }
        return false;
    }

    private RCDHCodecTool.RCSecretKey getRcSecretKey(RCEncryptResponseMessage responseReceiveMsg) {
        String yb = responseReceiveMsg.getResponserKey();
        return RCDHCodecTool.obtainWithEncId(responseReceiveMsg.getRequesterEncId()).genSecretKey(RCDHCodecTool.fromString2RCDHPublicKey(yb));
    }

    private void sendConfirmMessage(String targetId, RCEncryptResponseMessage responseReceiveMsg, RCDHCodecTool.RCSecretKey secretKey, RCEncryptedSession session) {
        RCEncryptConfirmMessage confirmMessage = new RCEncryptConfirmMessage();
        confirmMessage.setRequesterEncId(responseReceiveMsg.getRequesterEncId());
        confirmMessage.setResponserEncId(responseReceiveMsg.getResponserEncId());
        this.sendMessage(Conversation.ConversationType.PRIVATE, targetId, confirmMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RLog.d(RongIMClient.TAG, "confirm message send success.");
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                RLog.w(RongIMClient.TAG, "confirm message send failed ,error occurs with error code : " + (Object)((Object)errorCode));
            }
        });
    }

    private void sendCancelMessage(String targetId, RCEncryptResponseMessage responseReceiveMsg, RCEncryptedSession session) {
        RCEncryptCancelMessage cancelMsg = new RCEncryptCancelMessage();
        cancelMsg.setRequesterEncId(responseReceiveMsg.getRequesterEncId());
        cancelMsg.setResponserEncId(responseReceiveMsg.getResponserEncId());
        RLog.d(TAG, "set respEncIdInResp in cancel msg -> " + responseReceiveMsg.getResponserEncId() + Thread.currentThread().getName());
        this.sendMessage(Conversation.ConversationType.PRIVATE, targetId, cancelMsg, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RLog.d(RongIMClient.TAG, "send cancelMsg successfully.");
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                RLog.d(RongIMClient.TAG, "send cancelMsg error." + Thread.currentThread().getName());
            }
        });
    }

    private void updateSessionStateAndCallback(String requestEncIdInResp, String targetId, String responserEncIdInResp, RCDHCodecTool.RCSecretKey secretKey, RCEncryptedSession session) {
        try {
            String encTargetId = requestEncIdInResp + ";;;" + targetId;
            session.setRemoteEncId(responserEncIdInResp);
            session.setEncKey(secretKey.toString());
            session.setEncStatus(3);
            boolean isStatusSet = this.mLibHandler.setEncryptedConversation(encTargetId, session);
            if (isStatusSet) {
                if (this.mEncSessionConListener != null) {
                    this.mEncSessionConListener.onEncryptedSessionEstablished(encTargetId);
                }
            } else {
                RLog.e(TAG, "setEncryptedConversation failed when send confirm ms");
            }
        }
        catch (Exception e) {
            RLog.e(TAG, "updateSessionStateAndCallback", e);
        }
    }

    private boolean sendResponseMsg(RCEncryptRequestMessage content, final String targetId) {
        RCDHCodecTool.RCSecretKey rcSecretKey;
        String ya = content.getRequesterKey();
        RCDHCodecTool.RCDHPublicKey YA = RCDHCodecTool.fromString2RCDHPublicKey(ya);
        final String requestEncId = content.getRequesterEncId();
        if (requestEncId == null) {
            RLog.e(TAG, "error in onReceived -> RC:EncryptRequestMsg requestEncId is null!");
            return true;
        }
        final String responseEncId = RCDHCodecTool.genEncId();
        final RCDHCodecTool tool = RCDHCodecTool.obtainWithEncId(responseEncId);
        RLog.d(TAG, "responseEncId -> " + responseEncId);
        RCDHCodecTool.RCSecretKey rCSecretKey = rcSecretKey = tool == null ? null : tool.genSecretKey(YA);
        if (rcSecretKey == null) {
            RLog.e(TAG, "genSecretKey is null");
            return true;
        }
        RCEncryptResponseMessage responseMessage = new RCEncryptResponseMessage();
        responseMessage.setRequesterEncId(requestEncId);
        responseMessage.setResponserEncId(responseEncId);
        KeyPair localKeypair = tool.getOrCreateLocalKeyPair(null);
        if (localKeypair == null) {
            RLog.e(TAG, "create localt keyPair failed!");
            return true;
        }
        if (localKeypair.getPublic() != null && localKeypair.getPublic() instanceof RCDHCodecTool.RCDHPublicKey) {
            responseMessage.setResponserKey(tool.getRCPubKey().toString());
        }
        this.sendMessage(Conversation.ConversationType.PRIVATE, targetId, responseMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RCEncryptedSession encryptedSession = new RCEncryptedSession();
                encryptedSession.setTargetId(responseEncId + ";;;" + targetId);
                encryptedSession.setRemoteEncId(requestEncId);
                encryptedSession.setEncXA(tool.getRCPriKey().toString());
                RCDHCodecTool.RCSecretKey secretKeyByencId = RCDHCodecTool.getRCSecretKeyByEncId(responseEncId);
                assert (secretKeyByencId != null);
                encryptedSession.setEncKey(secretKeyByencId.toString());
                encryptedSession.setEncStatus(2);
                try {
                    if (RongIMClient.this.mLibHandler.createEncryptedConversation(responseEncId + ";;;" + targetId, encryptedSession)) {
                        if (RongIMClient.this.mEncSessionConListener != null) {
                            RongIMClient.this.mEncSessionConListener.onEncryptedSessionResponse(responseEncId + ";;;" + targetId);
                        }
                    } else {
                        RLog.e(RongIMClient.TAG, "createEncryptedConversation failed when sending responseMsg!");
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendResponseMsg", e);
                }
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                RLog.w(RongIMClient.TAG, "response message send failed ,error occurs with error code : " + (Object)((Object)errorCode));
            }
        });
        return false;
    }

    public void getMessageByUid(final String uid, final ResultCallback<Message> callback) {
        if (TextUtils.isEmpty((CharSequence)uid)) {
            RLog.e(TAG, "getMessageByUid uid is empty!");
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                try {
                    if (callback != null) {
                        Message message = RongIMClient.this.mLibHandler.getMessageByUid(uid);
                        callback.onCallback(message);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getMessageByUid", e);
                }
            }
        });
    }

    public void switchAppKey(String appKey) {
        RLog.d(TAG, "switchAppKey.");
        if (this.mLibHandler == null) {
            RLog.e(TAG, "IPC_DISCONNECT");
            return;
        }
        try {
            this.mLibHandler.switchAppKey(appKey, DeviceUtils.getDeviceId(this.mContext, appKey));
        }
        catch (Exception e) {
            RLog.e(TAG, "switchAppKey", e);
        }
        mNaviServer = null;
        mFileServer = null;
        if (isPushEnabled) {
            RongPushClient.stopService(this.mContext);
        }
    }

    public RealTimeLocationConstant.RealTimeLocationErrorCode getRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "getRealTimeLocation Type or id is null!");
            return null;
        }
        int code = RealTimeLocationManager.getInstance().setupRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    public RealTimeLocationConstant.RealTimeLocationErrorCode startRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "startRealTimeLocation Type or id is null!");
            return null;
        }
        int code = RealTimeLocationManager.getInstance().startRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    public RealTimeLocationConstant.RealTimeLocationErrorCode joinRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "joinRealTimeLocation Type or id is null!");
            return null;
        }
        int code = RealTimeLocationManager.getInstance().joinRealTimeLocation(conversationType, targetId);
        return RealTimeLocationConstant.RealTimeLocationErrorCode.valueOf(code);
    }

    public void quitRealTimeLocation(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "quitRealTimeLocation Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().quitRealTimeLocation(conversationType, targetId);
    }

    public List<String> getRealTimeLocationParticipants(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null || RealTimeLocationManager.getInstance() == null) {
            RLog.e(TAG, "getRealTimeLocationParticipants Type or id is null!");
            return null;
        }
        return RealTimeLocationManager.getInstance().getRealTimeLocationParticipants(conversationType, targetId);
    }

    public RealTimeLocationConstant.RealTimeLocationStatus getRealTimeLocationCurrentState(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "getRealTimeLocationCurrentState Type or id is null!");
            return RealTimeLocationConstant.RealTimeLocationStatus.RC_REAL_TIME_LOCATION_STATUS_IDLE;
        }
        return RealTimeLocationManager.getInstance().getRealTimeLocationCurrentState(conversationType, targetId);
    }

    public void addRealTimeLocationListener(Conversation.ConversationType conversationType, String targetId, final RealTimeLocationListener listener) {
        if (conversationType == null || targetId == null || RealTimeLocationManager.getInstance() == null) {
            RLog.e(TAG, "addRealTimeLocationListener Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().addListener(conversationType, targetId, new RealTimeLocationObserver(){

            @Override
            public void onStatusChange(final RealTimeLocationConstant.RealTimeLocationStatus status) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onStatusChange(status);
                        }
                    }
                });
            }

            @Override
            public void onReceiveLocation(final double latitude, final double longitude, final String userId) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onReceiveLocation(latitude, longitude, userId);
                        }
                    }
                });
            }

            @Override
            public void onReceiveLocationWithType(final double latitude, final double longitude, final RealTimeLocationType type, final String userId) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onReceiveLocationWithType(latitude, longitude, type, userId);
                        }
                    }
                });
            }

            @Override
            public void onParticipantsJoin(final String userId) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onParticipantsJoin(userId);
                        }
                    }
                });
            }

            @Override
            public void onParticipantsQuit(final String userId) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onParticipantsQuit(userId);
                        }
                    }
                });
            }

            @Override
            public void onError(final RealTimeLocationConstant.RealTimeLocationErrorCode errorCode) {
                mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(errorCode);
                        }
                    }
                });
            }
        });
    }

    public void removeRealTimeLocationObserver(Conversation.ConversationType conversationType, String targetId) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "removeRealTimeLocationObserver Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().removeListener(conversationType, targetId);
    }

    public void updateRealTimeLocationStatus(Conversation.ConversationType conversationType, String targetId, double latitude, double longitude, RealTimeLocationType realTimeLocationType) {
        if (conversationType == null || targetId == null) {
            RLog.e(TAG, "updateRealTimeLocationStatus Type or id is null!");
            return;
        }
        RealTimeLocationManager.getInstance().updateLocation(conversationType, targetId, latitude, longitude, realTimeLocationType);
    }

    public Collection<TypingStatus> getTypingUserListFromConversation(Conversation.ConversationType conversationType, String targetId) {
        return TypingMessageManager.getInstance().getTypingUserListFromConversation(conversationType, targetId);
    }

    public void sendTypingStatus(Conversation.ConversationType conversationType, String targetId, String typingContentType) {
        TypingMessageManager.getInstance().sendTypingMessage(conversationType, targetId, typingContentType);
    }

    public static void setTypingStatusListener(TypingStatusListener listener) {
        TypingMessageManager.getInstance().setTypingMessageStatusListener(listener);
    }

    public static void setRCLogInfoListener(final RCLogInfoListener listener) {
        FwLog.setLogListener(new FwLog.ILogListener(){

            @Override
            public void onLogEvent(String log) {
                listener.onRCLogInfoOccurred(log);
            }
        });
    }

    public void sendReadReceiptMessage(Conversation.ConversationType conversationType, String targetId, long timestamp) {
        if (conversationType != Conversation.ConversationType.PRIVATE && conversationType != Conversation.ConversationType.ENCRYPTED) {
            RLog.e(TAG, "sendReadReceiptMessage conversationType only support PRIVATE and ENCRYPTED");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            RLog.e(TAG, "sendReadReceiptMessage targetId is empty");
            return;
        }
        if (timestamp <= 0L) {
            RLog.e(TAG, "sendReadReceiptMessage timestamp is error");
            return;
        }
        ReadReceiptMessage readRecMsg = new ReadReceiptMessage(timestamp);
        this.sendMessage(conversationType, targetId, readRecMsg, null, null, null);
    }

    public void sendReadReceiptMessage(Conversation.ConversationType conversationType, String targetId, long timestamp, IRongCallback.ISendMessageCallback callback) {
        if (conversationType != Conversation.ConversationType.PRIVATE && conversationType != Conversation.ConversationType.ENCRYPTED) {
            RLog.e(TAG, "sendReadReceiptMessage conversationType only support PRIVATE and ENCRYPTED");
            if (callback != null) {
                callback.onError(null, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            RLog.e(TAG, "sendReadReceiptMessage targetId is empty");
            if (callback != null) {
                callback.onError(null, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (timestamp <= 0L) {
            RLog.e(TAG, "sendReadReceiptMessage timestamp is error");
            if (callback != null) {
                callback.onError(null, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        ReadReceiptMessage readRecMsg = new ReadReceiptMessage(timestamp);
        this.sendMessage(conversationType, targetId, readRecMsg, null, null, callback);
    }

    public static void setReadReceiptListener(ReadReceiptListener listener) {
        sReadReceiptListener = listener;
    }

    public void setOnReceiveDestructionMessageListener(OnReceiveDestructionMessageListener listener) {
        this.mOnReceiveDestructionMessageListener = listener;
    }

    public void startCustomService(String kefuId, ICustomServiceListener listener, CSCustomServiceInfo customServiceInfo) {
        CustomServiceManager.getInstance().startCustomService(kefuId, listener, customServiceInfo);
    }

    public void selectCustomServiceGroup(String kefuId, String groupId) {
        this.sendChangeModelMessage(kefuId, groupId);
    }

    private void sendChangeModelMessage(String kefuId, String groupId) {
        CustomServiceManager.getInstance().sendChangeModelMessage(kefuId, groupId);
    }

    public void switchToHumanMode(String kefuId) {
        CustomServiceManager.getInstance().switchToHumanMode(kefuId);
    }

    public void evaluateCustomService(String kefuId, boolean isRobotResolved, String knowledgeId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, isRobotResolved, knowledgeId);
    }

    public void evaluateCustomService(String kefuId, int source, String suggest, String dialogId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, CustomServiceConfig.CSEvaSolveStatus.RESOLVED, suggest, dialogId);
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus resolvestatus, String tagText, String suggest, String dialogId, String extra) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, resolvestatus, tagText, suggest, dialogId, extra);
    }

    public void evaluateCustomService(String kefuId, int source, CustomServiceConfig.CSEvaSolveStatus solveStatus, String suggest, String dialogId) {
        CustomServiceManager.getInstance().evaluateCustomService(kefuId, source, solveStatus, suggest, dialogId);
    }

    public void leaveMessageCustomService(String kefuId, Map<String, String> contentMap, OperationCallback operationCallback) {
        CustomServiceManager.getInstance().leaveMessageToCustomService(kefuId, contentMap, operationCallback);
    }

    public void stopCustomService(String kefuId) {
        CustomServiceManager.getInstance().stopCustomService(kefuId);
    }

    public void setCustomServiceHumanEvaluateListener(CustomServiceManager.OnHumanEvaluateListener listener) {
        CustomServiceManager.getInstance().setHumanEvaluateListener(listener);
    }

    public static void setServerInfo(String naviServer, String fileServer) {
        RLog.d(TAG, "setServerInfo naviServer :" + naviServer + ", fileServer:" + fileServer);
        if (TextUtils.isEmpty((CharSequence)naviServer)) {
            RLog.e(TAG, "setServerInfo naviServer should not be null.");
            throw new IllegalArgumentException("naviServer should not be null.");
        }
        if (!SystemUtils.isLegalServer(naviServer) || !TextUtils.isEmpty((CharSequence)fileServer) && !SystemUtils.isLegalServer(fileServer)) {
            throw new IllegalArgumentException("Invalid url,check validity of naviServer and fileServer");
        }
        FwLog.write(3, 1, FwLog.LogTag.A_SET_SERVER_O.getTag(), "navi|file", naviServer, fileServer);
        mNaviServer = naviServer.trim();
        if (fileServer != null) {
            mFileServer = fileServer.trim();
        }
    }

    public static void setStatisticDomain(String domain) {
        FwLog.write(3, 1, FwLog.LogTag.A_SET_STATISTIC_SERVER_O.getTag(), "domain", domain);
        String strFormat = "http://%s/active.json";
        if (domain.toLowerCase().startsWith("http")) {
            strFormat = "%s/active.json";
        }
        PRIVATE_STATISTIC = String.format(strFormat, domain);
    }

    public void recallMessage(Message message, final String pushContent, final ResultCallback<RecallNotificationMessage> callback) {
        if (this.mLibHandler == null) {
            RLog.e(TAG, "recallMessage IPC \u8fdb\u7a0b\u5c1a\u672a\u8fd0\u884c\u3002");
            if (callback != null) {
                callback.onError(ErrorCode.IPC_DISCONNECT);
            }
            return;
        }
        this.getMessage(message.getMessageId(), new ResultCallback<Message>(){

            @Override
            public void onSuccess(final Message message) {
                block5: {
                    MessageTag messageTag = RecallCommandMessage.class.getAnnotation(MessageTag.class);
                    String objectName = messageTag.value();
                    if (message == null) {
                        RLog.e(RongIMClient.TAG, "recallMessage message is null");
                        if (callback != null) {
                            callback.onError(ErrorCode.PARAMETER_ERROR);
                        }
                        return;
                    }
                    MessageConfig messageConfig = message.getMessageConfig();
                    boolean isDisableNotification = false;
                    if (messageConfig != null) {
                        isDisableNotification = messageConfig.isDisableNotification();
                    }
                    final RecallCommandMessage recallCommandMessage = new RecallCommandMessage(message.getUId());
                    recallCommandMessage.setConversationType(message.getConversationType().getValue());
                    recallCommandMessage.setTargetId(message.getTargetId());
                    recallCommandMessage.setSentTime(message.getSentTime());
                    recallCommandMessage.setUserInfo(message.getContent().getUserInfo());
                    try {
                        byte[] content = recallCommandMessage.encode();
                        IOperationCallback.Stub mRecallMessageCallback = new IOperationCallback.Stub(){

                            @Override
                            public void onComplete() throws RemoteException {
                                block4: {
                                    RecallNotificationMessage recallNotificationMessage = new RecallNotificationMessage(RongIMClient.this.getCurrentUserId(), message.getSentTime(), message.getObjectName(), recallCommandMessage.isAdmin(), recallCommandMessage.isDelete());
                                    MessageContent msgContent = message.getContent();
                                    if (msgContent instanceof TextMessage) {
                                        TextMessage textMessage = (TextMessage)msgContent;
                                        recallNotificationMessage.setRecallContent(textMessage.getContent());
                                        recallNotificationMessage.setRecallActionTime(System.currentTimeMillis());
                                    }
                                    recallNotificationMessage.setUserInfo(recallCommandMessage.getUserInfo());
                                    byte[] data = recallNotificationMessage.encode();
                                    MessageTag recallNotificationTag = RecallNotificationMessage.class.getAnnotation(MessageTag.class);
                                    try {
                                        RongIMClient.this.mLibHandler.setMessageContent(message.getMessageId(), data, recallNotificationTag.value());
                                        if (callback != null) {
                                            callback.onCallback(recallNotificationMessage);
                                        }
                                    }
                                    catch (Exception e) {
                                        RLog.e(RongIMClient.TAG, "recallMessage", e);
                                        if (callback == null) break block4;
                                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                                    }
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (callback != null) {
                                    callback.onFail(ErrorCode.valueOf(errorCode));
                                }
                            }
                        };
                        RongIMClient.this.mLibHandler.recallMessage(objectName, content, pushContent, 0, message.getTargetId(), message.getConversationType().getValue(), isDisableNotification, mRecallMessageCallback);
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "recallMessage", e);
                        if (callback == null) break block5;
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }

            @Override
            public void onError(ErrorCode e) {
                if (callback != null) {
                    callback.onError(e);
                }
            }
        });
    }

    public void getUnreadMentionedMessages(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<List<Message>> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "the parameter of targetId or ConversationType is error!");
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        List<Message> messages = RongIMClient.this.mLibHandler.getUnreadMentionedMessages(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(messages);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getUnreadMentionedMessages", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public static void setOnRecallMessageListener(OnRecallMessageListener listener) {
        sOnRecallMessageListener = listener;
    }

    public void sendMediaMessage(final Message message, final String pushContent, final String pushData, IRongCallback.ISendMediaMessageCallback callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
        if (mediaMessageContent.getMediaUrl() != null) {
            this.sendMessage(message, pushContent, pushData, callback);
        } else {
            Uri localPath = mediaMessageContent.getLocalPath();
            if (!FileUtils.isFileExistsWithUri(this.mContext, localPath)) {
                RLog.e(TAG, "localPath does not exist!");
                if (callback != null) {
                    callback.onError(message, ErrorCode.PARAMETER_ERROR);
                }
                return;
            }
            final IpcCallbackProxy<IRongCallback.ISendMediaMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMediaMessageCallback>(callback);
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            RongIMClient.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                    ipcCallbackProxy.callback = null;
                                }
                            });
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.sendMediaMessage(message, pushContent, pushData, new ISendMediaMessageCallback.Stub(){

                            @Override
                            public void onAttached(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onAttached(message);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onProgress(final Message message, final int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onProgress(message, progress);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onSuccess(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onSuccess(message);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onError(final Message message, final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.valueOf(errorCode));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onCanceled(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onCanceled(message);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "sendMediaMessage", e);
                    }
                }
            });
        }
    }

    public void sendDirectionalMediaMessage(final Message message, final String[] userIds, final String pushContent, final String pushData, IRongCallback.ISendMediaMessageCallback callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
        if (mediaMessageContent.getMediaUrl() != null) {
            this.sendMessage(message, pushContent, pushData, callback);
        } else {
            if (mediaMessageContent.getLocalPath() == null) {
                RLog.e(TAG, "Media file does not exist!");
                if (callback != null) {
                    callback.onError(message, ErrorCode.PARAMETER_ERROR);
                }
                return;
            }
            String localPath = mediaMessageContent.getLocalPath().toString();
            String abPath = localPath.substring(7);
            if (!localPath.startsWith("file") || !new File(abPath).exists()) {
                RLog.e(TAG, localPath + " does not exist!");
                if (callback != null) {
                    callback.onError(message, ErrorCode.PARAMETER_ERROR);
                }
                return;
            }
            final IpcCallbackProxy<IRongCallback.ISendMediaMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMediaMessageCallback>(callback);
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            RongIMClient.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.IPC_DISCONNECT);
                                    ipcCallbackProxy.callback = null;
                                }
                            });
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.sendDirectionalMediaMessage(message, userIds, pushContent, pushData, new ISendMediaMessageCallback.Stub(){

                            @Override
                            public void onAttached(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onAttached(message);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onProgress(final Message message, final int progress) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onProgress(message, progress);
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onSuccess(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onSuccess(message);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onError(final Message message, final int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onError(message, ErrorCode.valueOf(errorCode));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onCanceled(final Message message) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    RongIMClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.ISendMediaMessageCallback)ipcCallbackProxy.callback).onCanceled(message);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "sendDirectionalMediaMessage", e);
                    }
                }
            });
        }
    }

    public void sendMediaMessage(final Message message, final String pushContent, final String pushData, final IRongCallback.ISendMediaMessageCallbackWithUploader callback) {
        ErrorCode errorCode = this.filterSendMessage(message);
        if (errorCode != null) {
            if (callback != null) {
                callback.onError(message, errorCode);
            }
            return;
        }
        MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
        if (!FileUtils.isFileExistsWithUri(this.mContext, mediaMessageContent.getLocalPath())) {
            RLog.e(TAG, "Media file does not exist!");
            if (callback != null) {
                callback.onError(message, ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        ResultCallback<Message> resultCallback = new ResultCallback<Message>(){

            @Override
            public void onSuccess(Message message2) {
                message2.setSentStatus(Message.SentStatus.SENDING);
                RongIMClient.this.setMessageSentStatus(message2, null);
                if (callback != null) {
                    callback.onAttached(message2, new IRongCallback.MediaMessageUploader(message2, pushContent, pushData, callback));
                }
            }

            @Override
            public void onError(ErrorCode e) {
                if (callback != null) {
                    callback.onError(message, ErrorCode.RC_MSG_SEND_FAIL);
                }
            }
        };
        this.insertSettingMessage(message, resultCallback);
    }

    public void sendReadReceiptRequest(final Message message, final OperationCallback callback) {
        if (message == null) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (!Conversation.ConversationType.GROUP.equals((Object)message.getConversationType()) && !Conversation.ConversationType.DISCUSSION.equals((Object)message.getConversationType())) {
            RLog.w(TAG, "only group and discussion could send read receipt request.");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        ReadReceiptRequestMessage requestMessage = new ReadReceiptRequestMessage(message.getUId());
        this.sendMessage(message.getConversationType(), message.getTargetId(), requestMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message msg) {
            }

            @Override
            public void onSuccess(Message msg) {
                if (RongIMClient.this.mLibHandler == null) {
                    RLog.d(RongIMClient.TAG, "sendReadReceiptRequest mLibHandler is null");
                    if (callback != null) {
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                try {
                    ReadReceiptInfo readReceiptInfo = message.getReadReceiptInfo();
                    if (readReceiptInfo == null) {
                        readReceiptInfo = new ReadReceiptInfo();
                        message.setReadReceiptInfo(readReceiptInfo);
                    }
                    readReceiptInfo.setIsReadReceiptMessage(true);
                    RongIMClient.this.mLibHandler.updateReadReceiptRequestInfo(message.getUId(), readReceiptInfo.toJSON().toString());
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendReadReceiptRequest", e);
                    if (callback != null) {
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(Message msg, ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void sendReadReceiptResponse(Conversation.ConversationType type, String targetId, final List<Message> messageList, final OperationCallback callback) {
        if (!Conversation.ConversationType.GROUP.equals((Object)type) && !Conversation.ConversationType.DISCUSSION.equals((Object)type) || messageList == null || messageList.size() == 0) {
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        ReadReceiptResponseMessage responseMessage = new ReadReceiptResponseMessage(messageList);
        int size = responseMessage.getSenderIdSet().size();
        this.sendDirectionalMessage(type, targetId, responseMessage, responseMessage.getSenderIdSet().toArray(new String[size]), null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                if (RongIMClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                RongIMClient.this.mWorkHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            for (Message msg : messageList) {
                                ReadReceiptInfo readReceiptInfo = msg.getReadReceiptInfo();
                                if (readReceiptInfo == null) {
                                    readReceiptInfo = new ReadReceiptInfo();
                                    msg.setReadReceiptInfo(readReceiptInfo);
                                }
                                readReceiptInfo.setHasRespond(true);
                                RongIMClient.this.mLibHandler.updateReadReceiptRequestInfo(msg.getUId(), readReceiptInfo.toJSON().toString());
                            }
                        }
                        catch (Exception e) {
                            RLog.e(RongIMClient.TAG, "sendReadReceiptResponse", e);
                            if (callback != null) {
                                callback.onFail(ErrorCode.IPC_DISCONNECT);
                            }
                            return;
                        }
                        if (callback != null) {
                            callback.onCallback();
                        }
                    }
                });
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void syncConversationReadStatus(Conversation.ConversationType type, String targetId, long timestamp, final OperationCallback callback) {
        SyncReadStatusMessage syncReadStatusMessage = new SyncReadStatusMessage(timestamp);
        String[] users = new String[]{this.getCurrentUserId()};
        this.sendDirectionalMessage(type, targetId, syncReadStatusMessage, users, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void setSyncConversationReadStatusListener(SyncConversationReadStatusListener listener) {
        this.mSyncConversationReadStatusListener = listener;
    }

    public void searchConversations(final String keyword, final Conversation.ConversationType[] conversationTypes, final String[] objectNames, final ResultCallback<List<SearchConversationResult>> resultCallback) {
        if (TextUtils.isEmpty((CharSequence)keyword) || conversationTypes == null || conversationTypes.length == 0 || objectNames == null || objectNames.length == 0) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (resultCallback != null) {
                        resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                try {
                    int[] types = RongIMClient.this.convertTypes(conversationTypes);
                    List<SearchConversationResult> result = RongIMClient.this.mLibHandler.searchConversations(keyword, types, objectNames);
                    if (resultCallback != null) {
                        resultCallback.onCallback(result);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "searchConversations", e);
                }
            }
        });
    }

    public void searchMessages(final Conversation.ConversationType conversationType, final String targetId, final String keyword, final int count, final long beginTime, final ResultCallback<List<Message>> resultCallback) {
        if (TextUtils.isEmpty((CharSequence)keyword) || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (resultCallback != null) {
                        resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                try {
                    List<Message> result = RongIMClient.this.mLibHandler.searchMessages(targetId, conversationType.getValue(), keyword, count, beginTime);
                    if (resultCallback != null) {
                        resultCallback.onCallback(result);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "searchMessages", e);
                }
            }
        });
    }

    public void searchMessagesByUser(final Conversation.ConversationType conversationType, final String targetId, final String userId, int count, final long beginTime, final ResultCallback<List<Message>> resultCallback) {
        int requestCount;
        if (count <= 0 || conversationType == null) {
            RLog.e(TAG, "searchMessagesByUser : count count <= 0 or conversationType is null !");
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (count > 100) {
            RLog.i(TAG, "searchMessagesByUser : count > 100.");
            requestCount = 100;
        } else {
            requestCount = count;
        }
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)targetId)) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (resultCallback != null) {
                        resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                try {
                    List<Message> result = RongIMClient.this.mLibHandler.searchMessagesByUser(targetId, conversationType.getValue(), userId, requestCount, beginTime);
                    if (resultCallback != null) {
                        resultCallback.onCallback(result);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "searchMessagesByUser", e);
                }
            }
        });
    }

    public void getHistoryMessages(final Conversation.ConversationType conversationType, final String targetId, final long sentTime, final int before, final int after, final ResultCallback<List<Message>> resultCallback) {
        if (sentTime <= 0L || before < 0 || after < 0 || TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            if (resultCallback != null) {
                resultCallback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (resultCallback != null) {
                        resultCallback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                try {
                    List<Message> result = RongIMClient.this.mLibHandler.getMatchedMessages(targetId, conversationType.getValue(), sentTime, before, after);
                    if (resultCallback != null) {
                        resultCallback.onCallback(RongIMClient.this.filterDestructionMessage(conversationType, targetId, result));
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getHistoryMessages", e);
                }
            }
        });
    }

    private List<Message> filterDestructionMessage(Conversation.ConversationType conversationType, String targetId, List<Message> messages) {
        if (messages == null) {
            return null;
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        ArrayList<Message> destructionMessages = new ArrayList<Message>();
        for (Message message : messages) {
            if (message.getContent().isDestruct() && message.getReadTime() > 0L) {
                if (message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
                    long delay = (System.currentTimeMillis() - message.getReadTime()) / 1000L;
                    if (delay >= message.getContent().getDestructTime()) {
                        destructionMessages.add(message);
                        continue;
                    }
                } else {
                    destructionMessages.add(message);
                    continue;
                }
            }
            messageList.add(message);
        }
        if (destructionMessages.size() > 0) {
            Message[] deleteMessages = new Message[destructionMessages.size()];
            destructionMessages.toArray(deleteMessages);
            this.deleteRemoteMessages(conversationType, targetId, deleteMessages, null);
            this.deleteMessages(conversationType, targetId, null);
        }
        return messageList;
    }

    public void getVendorToken(ResultCallback<String> resultCallback) {
        final IpcCallbackProxy<ResultCallback<String>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<String>>(resultCallback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.PARAMETER_ERROR);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getVendorToken(new IStringCallback.Stub(){

                        @Override
                        public void onComplete(String string2) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onCallback(string2);
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getVendorToken", e);
                }
            }
        });
    }

    public void setPushLanguage(PushLanguage language, OperationCallback callback) {
        if (language == null) {
            RLog.d(TAG, "[PushSetting] setPushLanguage language is null");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        this.setPushSetting(PushSettings.PUSH_SETTINGS_LANGUAGE, language.getMsg(), callback);
    }

    public void setPushContentShowStatus(boolean showStatus, OperationCallback callback) {
        PushStatus showPushDetail = showStatus ? PushStatus.STATUS_ON : PushStatus.STATUS_OFF;
        this.setPushSetting(PushSettings.PUSH_SETTINGS_SHOW_CONTENT, showPushDetail.getValue(), callback);
        PushCacheHelper.getInstance().setPushContentShowStatus(this.mContext, showStatus);
    }

    public void setPushReceiveStatus(boolean receiveStatus, OperationCallback callback) {
        PushStatus receivePush = receiveStatus ? PushStatus.STATUS_ON : PushStatus.STATUS_OFF;
        this.setPushSetting(PushSettings.PUSH_SETTINGS_RECEIVE, receivePush.getValue(), callback);
    }

    private void setPushSetting(final PushSettings status, final String value, OperationCallback callback) {
        if (this.mLibHandler == null) {
            RLog.d(TAG, "[PushSetting] setPushSetting mLibHandler is null");
            if (callback != null) {
                callback.onError(ErrorCode.IPC_DISCONNECT);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.setPushSetting(status.getValue(), value, new ISetPushSettingCallback.Stub(){

                            @Override
                            public void onComplete() throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((OperationCallback)ipcCallbackProxy.callback).onCallback();
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setPushSetting", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void getPushLanguage(final ResultCallback<PushLanguage> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                String language = "";
                try {
                    if (RongIMClient.this.mLibHandler != null) {
                        language = RongIMClient.this.mLibHandler.getPushSetting(PushSettings.PUSH_SETTINGS_LANGUAGE.getValue());
                    } else {
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                        RLog.e(RongIMClient.TAG, "getPushLanguage: mLibHandler is null.");
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getPushLanguage", e);
                }
                if (language == null) {
                    callback.onFail(ErrorCode.UNKNOWN);
                } else if (language.equals(PushLanguage.EN_US.getMsg())) {
                    callback.onCallback(PushLanguage.EN_US);
                } else if (language.equals(PushLanguage.AR_SA.getMsg())) {
                    callback.onCallback(PushLanguage.AR_SA);
                } else {
                    callback.onCallback(PushLanguage.ZH_CN);
                }
            }
        });
    }

    public void getPushContentShowStatus(final ResultCallback<Boolean> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                String contentShowStatus = "";
                try {
                    if (RongIMClient.this.mLibHandler != null) {
                        contentShowStatus = RongIMClient.this.mLibHandler.getPushSetting(PushSettings.PUSH_SETTINGS_SHOW_CONTENT.getValue());
                    } else {
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                        RLog.e(RongIMClient.TAG, "getPushContentShowStatus: mLibHandler is null.");
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getPushContentShowStatus", e);
                }
                if (contentShowStatus == null) {
                    callback.onFail(ErrorCode.UNKNOWN);
                } else {
                    callback.onCallback(contentShowStatus.equals(PushStatus.STATUS_ON.getValue()));
                }
            }
        });
    }

    public void getPushReceiveStatus(final ResultCallback<Boolean> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onFail(ErrorCode.PARAMETER_ERROR);
                    }
                    return;
                }
                String receiveStatus = "";
                try {
                    receiveStatus = RongIMClient.this.mLibHandler.getPushSetting(PushSettings.PUSH_SETTINGS_RECEIVE.getValue());
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getPushReceiveStatus", e);
                }
                if (receiveStatus == null) {
                    callback.onFail(ErrorCode.UNKNOWN);
                } else {
                    callback.onCallback(receiveStatus.equals(PushStatus.STATUS_ON.getValue()));
                }
            }
        });
    }

    public void getOfflineMessageDuration(final ResultCallback<String> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                String offLineDuration = "";
                try {
                    offLineDuration = RongIMClient.this.mLibHandler.getOfflineMessageDuration();
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getOfflineMessageDuration", e);
                }
                if (offLineDuration == null) {
                    callback.onFail(ErrorCode.UNKNOWN);
                } else {
                    callback.onCallback(offLineDuration);
                }
            }
        });
    }

    public void setOfflineMessageDuration(final int duration, ResultCallback<Long> callback) {
        if (duration < 1 || duration > 7) {
            RLog.e(TAG, "Parameter is error!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<ResultCallback<Long>> ipcCallbackProxy = new IpcCallbackProxy<ResultCallback<Long>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy.callback != null) {
                            ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        RongIMClient.this.mLibHandler.setOfflineMessageDuration(String.valueOf(duration), new ILongCallback.Stub(){

                            @Override
                            public void onComplete(long result) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onCallback(result);
                                    ipcCallbackProxy.callback = null;
                                }
                            }

                            @Override
                            public void onFailure(int errorCode) throws RemoteException {
                                if (ipcCallbackProxy.callback != null) {
                                    ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.valueOf(errorCode));
                                    ipcCallbackProxy.callback = null;
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setOfflineMessageDuration", e);
                        if (ipcCallbackProxy.callback == null) break block4;
                        ((ResultCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void setAppVer(String appVer) {
        FwLog.write(3, 1, FwLog.LogTag.A_APP_VER_S.getTag(), "ver", appVer);
    }

    public void supportResumeBrokenTransfer(final String url, final ResultCallback<Boolean> callback) {
        if (TextUtils.isEmpty((CharSequence)url) && callback != null) {
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.supportResumeBrokenTransfer(url);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "supportResumeBrokenTransfer", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    private void isFileDownloading(final String uid, final ResultCallback<Boolean> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean bool2 = RongIMClient.this.mLibHandler.getFileDownloadingStatus(uid);
                        if (callback != null) {
                            callback.onCallback(bool2);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "isFileDownloading", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void getTheFirstUnreadMessage(final Conversation.ConversationType conversationType, final String targetId, final ResultCallback<Message> callback) {
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            RLog.e(TAG, "getConversation. the parameter of targetId or ConversationType is error!");
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onFail(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        Message result = RongIMClient.this.mLibHandler.getTheFirstUnreadMessage(conversationType.getValue(), targetId);
                        if (callback != null) {
                            callback.onCallback(result);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "getTheFirstUnreadMessage", e);
                        if (callback == null) break block5;
                        callback.onFail(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public boolean isFileDownloading(int messageId) {
        return this.isFileDownloading(messageId + "");
    }

    public boolean isFileDownloading(String uid) {
        final CountDownLatch latch = new CountDownLatch(1);
        final ResultCallback.Result result = new ResultCallback.Result();
        result.t = false;
        this.isFileDownloading(uid, (ResultCallback<Boolean>)new SyncCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean bool2) {
                if (bool2 != null) {
                    result.t = bool2;
                } else {
                    RLog.e(RongIMClient.TAG, "removeConversation removeConversation is failure!");
                }
                latch.countDown();
            }

            @Override
            public void onError(ErrorCode code) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            RLog.e(TAG, "isFileDownloading", e);
            Thread.currentThread().interrupt();
        }
        return (Boolean)result.t;
    }

    public void setMessageReadTime(final long messageId, final long timestamp, final OperationCallback callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (RongIMClient.this.mLibHandler == null) {
                        if (callback != null) {
                            callback.onError(ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        boolean isSuccess = RongIMClient.this.mLibHandler.setMessageReadTime(messageId, timestamp);
                        if (callback != null) {
                            if (isSuccess) {
                                callback.onCallback();
                            } else {
                                callback.onError(ErrorCode.UNKNOWN);
                            }
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "setMessageReadTime", e);
                        if (callback == null) break block7;
                        callback.onError(ErrorCode.IPC_DISCONNECT);
                    }
                }
            }
        });
    }

    public void startEncryptedSession(String targetId) {
        if (this.mEncSessionConListener == null) {
            RLog.e(TAG, "member of EncSessionConListener in RongIMClient instance is null, can not perform the session creation.");
            return;
        }
        if (targetId == null) {
            RLog.e(TAG, " startEncryptedSession - targetId is null! ");
            return;
        }
        String reqeustEncId = RCDHCodecTool.genEncId();
        RCDHCodecTool rcdhCodecTool = RCDHCodecTool.obtainWithEncId(reqeustEncId);
        rcdhCodecTool.getOrCreateLocalKeyPair(null);
        this.sendRequestMsg(targetId, reqeustEncId, rcdhCodecTool);
    }

    private void sendRequestMsg(final String targetId, final String encId, final RCDHCodecTool tool) {
        RCEncryptRequestMessage rcEncryptRequestMessage = new RCEncryptRequestMessage();
        rcEncryptRequestMessage.setRequesterEncId(encId);
        rcEncryptRequestMessage.setRequesterKey(tool.getRCPubKey().toString());
        this.sendMessage(Conversation.ConversationType.PRIVATE, targetId, rcEncryptRequestMessage, null, null, new IRongCallback.ISendMessageCallback(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                RCEncryptedSession encryptedConversation = new RCEncryptedSession();
                encryptedConversation.setTargetId(encId + ";;;" + targetId);
                encryptedConversation.setRemoteEncId(null);
                encryptedConversation.setEncKey(null);
                encryptedConversation.setEncXA(tool.getRCPriKey().toString());
                encryptedConversation.setEncStatus(1);
                try {
                    if (RongIMClient.this.mLibHandler.createEncryptedConversation(encId + ";;;" + targetId, encryptedConversation) && RongIMClient.this.mEncSessionConListener != null) {
                        RongIMClient.this.mEncSessionConListener.onEncryptedSessionRequest(encId + ";;;" + targetId, true);
                    }
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendRequestMsg", e);
                }
            }

            @Override
            public void onError(Message message, ErrorCode errorCode) {
                RLog.w(RongIMClient.TAG, "request message send failed ,error occurs with error code : " + (Object)((Object)errorCode));
                if (RongIMClient.this.mEncSessionConListener != null) {
                    RongIMClient.this.mEncSessionConListener.onEncryptedSessionRequest(encId + ";;;" + targetId, false);
                }
            }
        });
    }

    public void quitEncryptedSession(final String targetId) {
        if (targetId == null) {
            RLog.e(TAG, "quitEncryptedSession targetId is null! ");
            return;
        }
        try {
            String[] ids = targetId.split(";;;");
            if (ids.length != 2) {
                RLog.e(TAG, "quitEncrypteSession error while parsing the targetId -> " + targetId);
                return;
            }
            if (this.mLibHandler == null) {
                return;
            }
            final RCEncryptedSession encryptedConversation = this.mLibHandler.getEncryptedConversation(targetId);
            if (encryptedConversation == null) {
                RLog.w(TAG, "getEncryptedConversation returns null on call of quitEncryptedSession.");
                return;
            }
            encryptedConversation.setEncStatus(5);
            String remoteEncId = encryptedConversation.getRemoteEncId();
            if (remoteEncId == null) {
                RLog.e(TAG, "removeEncId from encrypted conversaion is null! ");
                return;
            }
            RCEncryptTerminateMessage terminateMessag = new RCEncryptTerminateMessage();
            terminateMessag.setSenderEncId(ids[0]);
            terminateMessag.setReceiverEncId(remoteEncId);
            this.sendMessage(Conversation.ConversationType.PRIVATE, ids[1], terminateMessag, null, null, new IRongCallback.ISendMessageCallback(){

                @Override
                public void onAttached(Message message) {
                }

                @Override
                public void onSuccess(Message message) {
                    try {
                        if (RongIMClient.this.mLibHandler != null && RongIMClient.this.mLibHandler.setEncryptedConversation(targetId, encryptedConversation) && RongIMClient.this.mLibHandler.removeEncryptedConversation(targetId)) {
                            RLog.d(RongIMClient.TAG, "send terminateMsg successfully,remove encConversation of ->" + targetId);
                        }
                    }
                    catch (Exception e) {
                        RLog.e(RongIMClient.TAG, "quitEncryptedSession", e);
                    }
                }

                @Override
                public void onError(Message message, ErrorCode errorCode) {
                    RLog.w(RongIMClient.TAG, "terminateMessage send failed ,error occurs with error code : " + (Object)((Object)errorCode));
                }
            });
        }
        catch (Exception e) {
            RLog.e(TAG, "quitEncryptedSession", e);
        }
    }

    public boolean clearEncryptedConversations() {
        try {
            if (this.mLibHandler != null) {
                return this.mLibHandler.clearEncryptedConversations();
            }
            RLog.e(TAG, "clearEncryptedConversations: mLibHandler is null.");
            return false;
        }
        catch (Exception e) {
            RLog.e(TAG, "clearEncryptedConversations", e);
            return false;
        }
    }

    public int getEncryptedSessionStatus(String targetId) {
        try {
            RCEncryptedSession encryptedConversation = this.mLibHandler.getEncryptedConversation(targetId);
            if (encryptedConversation == null) {
                RLog.w(TAG, "can not find encCoversation by targetId of " + targetId + " while calling getEncryptedSessionStatus()");
                return -1;
            }
            return encryptedConversation.getEncStatus();
        }
        catch (Exception e) {
            RLog.e(TAG, "getEncryptedSessionStatus", e);
            return -2;
        }
    }

    public List<RCEncryptedSession> getAllEncryptedConversations() {
        if (this.mLibHandler != null) {
            try {
                return this.mLibHandler.getAllEncryptedConversations();
            }
            catch (Exception e) {
                RLog.e(TAG, "getAllEncryptedConversations", e);
            }
        }
        return null;
    }

    public int getVideoLimitTime() {
        if (this.mLibHandler != null) {
            try {
                return this.mLibHandler.getVideoLimitTime();
            }
            catch (Exception e) {
                RLog.e(TAG, "getVideoLimitTime", e);
            }
        }
        return -1;
    }

    public int getGIFLimitSize() {
        if (this.mLibHandler != null) {
            try {
                return this.mLibHandler.getGIFLimitSize();
            }
            catch (Exception e) {
                RLog.e(TAG, "getVideoLimitTime", e);
            }
        }
        return -1;
    }

    public void setReconnectKickEnable(boolean enable) {
        this.kickReconnectDevice = enable;
    }

    private void updatePushContentShowStatus() {
        this.getPushContentShowStatus(new ResultCallback<Boolean>(){

            @Override
            public void onSuccess(Boolean aBoolean) {
                RongPushClient.updatePushContentShowStatus(RongIMClient.this.mContext, aBoolean);
            }

            @Override
            public void onError(ErrorCode e) {
                RLog.e(RongIMClient.TAG, "Can't get push content show status!");
            }
        });
    }

    public void appOnStart() {
        if (this.mContext == null) {
            RLog.e(TAG, "Event ignored. Please call this api after init.!");
            return;
        }
        RLog.d(TAG, "appOnStart()");
        this.onAppBackgroundChanged(true);
    }

    public void setRLogLevel(int pLevel) {
        RLog.setLogLevel(pLevel);
    }

    public void setRLogFileMaxSize(long pSize) {
        RLog.setFileMaxSize(pSize);
    }

    public void setUploadCallback(RLogReporter.UploadCallback pCallback) {
        RLog.setUploadCallback(pCallback);
    }

    public void uploadRLog() {
        RLog.uploadRLog();
    }

    public void beginDestructMessage(Message message, DestructCountDownTimerListener pListener) {
        if (message == null || message.getContent() == null) {
            RLog.e(TAG, "beginDestructMessage : message or content can't be null!");
            return;
        }
        if (message.getContent().isDestruct() && message.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            DestructionTaskManager.getInstance().BeginDestruct(message, pListener);
        }
    }

    public void stopDestructMessage(Message message) {
        if (message == null || message.getContent() == null) {
            RLog.e(TAG, "stopDestructMessage : message or content can't be null!");
            return;
        }
        if (message.getContent().isDestruct() && message.getMessageDirection() == Message.MessageDirection.RECEIVE) {
            DestructionTaskManager.getInstance().messageStopDestruct(message);
        }
    }

    private ErrorCode filterSendMessage(Message message) {
        ErrorCode errorCode;
        if (message == null) {
            RLog.e(TAG, "filterSendMessage : message can't be null!");
            errorCode = ErrorCode.PARAMETER_ERROR;
        } else if (message.getConversationType() == null) {
            RLog.e(TAG, "filterSendMessage : conversation type can't be null!");
            errorCode = ErrorCode.PARAMETER_ERROR;
        } else if (message.getConversationType() == Conversation.ConversationType.SYSTEM) {
            RLog.e(TAG, "filterSendMessage : conversation type can't be system!");
            errorCode = ErrorCode.PARAMETER_ERROR;
        } else if (TextUtils.isEmpty((CharSequence)message.getTargetId())) {
            RLog.e(TAG, "filterSendMessage : targetId can't be null!");
            errorCode = ErrorCode.PARAMETER_ERROR;
        } else if (message.getContent() == null) {
            RLog.e(TAG, "filterSendMessage : content can't be null!");
            errorCode = ErrorCode.PARAMETER_ERROR;
        } else {
            errorCode = ExpansionUtils.filterSendMessage(message) != null ? ExpansionUtils.filterSendMessage(message) : null;
        }
        return errorCode;
    }

    private int[] convertTypes(Conversation.ConversationType[] conversationTypes) {
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        for (Conversation.ConversationType conversationType : conversationTypes) {
            if (conversationType == null) continue;
            typeList.add(conversationType.getValue());
        }
        return this.toIntArray(typeList);
    }

    private int[] toIntArray(Collection<Integer> intCollection) {
        if (intCollection != null && intCollection.size() != 0) {
            int index = 0;
            int[] intArray = new int[intCollection.size()];
            for (Integer integer : intCollection) {
                intArray[index++] = integer;
            }
            return intArray;
        }
        return new int[0];
    }

    public void setChatRoomEntry(final String chatRoomId, final String key, final String value, final boolean sendNotification, final boolean autoDelete, final String notificationExtra, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value) || TextUtils.isEmpty((CharSequence)chatRoomId) || !key.matches("^[A-Za-z0-9+_=-]+$")) {
            RLog.e(TAG, "setChatRoomEntry chatRoomId or key or value is empty or key contains illegal characters!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, false, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "setChatRoomEntry", e);
                }
            }
        });
    }

    public void forceSetChatRoomEntry(final String chatRoomId, final String key, final String value, final boolean sendNotification, final boolean autoDelete, final String notificationExtra, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value) || TextUtils.isEmpty((CharSequence)chatRoomId) || !key.matches("^[A-Za-z0-9+_=-]+$")) {
            RLog.e(TAG, "forceSetChatRoomEntry chatRoomId or key or value is empty or key contains illegal characters!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, true, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "forceSetChatRoomEntry", e);
                }
            }
        });
    }

    public void getChatRoomEntry(final String chatRoomId, final String key, final @NonNull ResultCallback<Map<String, String>> callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e(TAG, "getChatRoomEntry Parameter  chatRoomId or key is empty!");
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    callback.onFail(ErrorCode.IPC_DISCONNECT);
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getChatRoomEntry(chatRoomId, key, new IStringCallback.Stub(){

                        @Override
                        public void onComplete(String value) {
                            HashMap<String, String> result = new HashMap<String, String>();
                            result.put(key, value);
                            callback.onSuccess(result);
                        }

                        @Override
                        public void onFailure(int errorCode) {
                            callback.onError(ErrorCode.valueOf(errorCode));
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getChatRoomEntry", e);
                    callback.onFail(ErrorCode.IPC_DISCONNECT);
                }
            }
        });
    }

    public void getAllChatRoomEntries(final String chatRoomId, final @NonNull ResultCallback<Map<String, String>> callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId)) {
            RLog.e(TAG, "getAllChatRoomEntries chatRoomId  is empty!");
            callback.onError(ErrorCode.PARAMETER_ERROR);
            return;
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    callback.onFail(ErrorCode.IPC_DISCONNECT);
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.getAllChatRoomEntries(chatRoomId, new IDataByBatchListener.Stub(){
                        HashMap<String, String> result = new HashMap();

                        @Override
                        public void onProgress(Map data) {
                            this.result.putAll(data);
                        }

                        @Override
                        public void onComplete() {
                            RLog.i(RongIMClient.TAG, "getAllChatRoomEntries size =" + this.result.size());
                            callback.onSuccess(this.result);
                        }

                        @Override
                        public void onError(int status) {
                            callback.onError(ErrorCode.valueOf(status));
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "getAllChatRoomEntries", e);
                    callback.onFail(ErrorCode.IPC_DISCONNECT);
                }
            }
        });
    }

    public void removeChatRoomEntry(final String chatRoomId, final String key, final Boolean sendNotification, final String notificationExtra, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e(TAG, "removeChatRoomEntry chatRoomId or key is empty!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.deleteChatRoomEntry(key, null, chatRoomId, sendNotification, notificationExtra, false, false, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "removeChatRoomEntry", e);
                }
            }
        });
    }

    public void forceRemoveChatRoomEntry(final String chatRoomId, final String key, final Boolean sendNotification, final String notificationExtra, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)chatRoomId) || TextUtils.isEmpty((CharSequence)key)) {
            RLog.e(TAG, "forceRemoveChatRoomEntry chatRoomId or key is empty!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.deleteChatRoomEntry(key, null, chatRoomId, sendNotification, notificationExtra, false, true, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "forceRemoveChatRoomEntry", e);
                }
            }
        });
    }

    public void cancelSDKHeartBeat() {
        RLog.d(TAG, "cancelSDKHeartBeat  " + cancelSDKHeartBeatEnabled);
        cancelSDKHeartBeatEnabled = true;
        RongPushClient.cancelPushHeartBeat(this.mContext);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    RLog.e(RongIMClient.TAG, "mLibHandler is null");
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.cancelSDKHeartBeat();
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "cancelSDKHeartBeat", e);
                }
            }
        });
    }

    public void sendPing() {
        RLog.d(TAG, "sendPing  ");
        if (isPushEnabled) {
            RongPushClient.sendPushPing(this.mContext);
        }
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    RLog.e(RongIMClient.TAG, "mLibHandler is null");
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.sendPing();
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "sendPing", e);
                }
            }
        });
    }

    public void setConversationStatusListener(ConversationStatusListener listener) {
        sConversationStatusListener = listener;
    }

    public void setKVStatusListener(KVStatusListener listener) {
        sKVStatusListener = listener;
    }

    public void setMessageExpansionListener(MessageExpansionListener listener) {
        messageExpansionListener = listener;
    }

    public void updateMessageExpansion(final Map<String, String> expansion, final String messageUId, OperationCallback callback) {
        if (this.judgeMapInvalid(expansion, callback)) {
            return;
        }
        if (this.judgeUIDInvalid(messageUId, callback)) {
            return;
        }
        if (ExpansionUtils.judgeKVExceedLimit(expansion)) {
            if (callback != null) {
                callback.onError(ErrorCode.RC_MSG_EXPANSION_SIZE_LIMIT_EXCEED);
            }
            return;
        }
        if (ExpansionUtils.judgeKVIllegality(expansion)) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.updateMessageExpansion(expansion, messageUId, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "updateMessageExpansion", e);
                }
            }
        });
    }

    private boolean judgeMapInvalid(Map<String, String> expansion, OperationCallback callback) {
        if (!(expansion instanceof HashMap) && callback != null) {
            callback.onError(ErrorCode.PARAMETER_ERROR);
            RLog.e(TAG, "expansion should be HashMap!");
            return true;
        }
        return false;
    }

    private boolean judgeUIDInvalid(String messageUId, OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)messageUId)) {
            RLog.e(TAG, "messageUId is empty!");
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return true;
        }
        return false;
    }

    public void removeMessageExpansion(final List<String> keyArray, final String messageUId, OperationCallback callback) {
        if (this.judgeListInvalid(keyArray, callback)) {
            return;
        }
        if (this.judgeUIDInvalid(messageUId, callback)) {
            return;
        }
        if (keyArray == null || keyArray.size() == 0) {
            if (callback != null) {
                callback.onError(ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RongIMClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy.callback != null) {
                        ((OperationCallback)ipcCallbackProxy.callback).onFail(ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RongIMClient.this.mLibHandler.removeMessageExpansion(keyArray, messageUId, new DefaultOperationCallback(ipcCallbackProxy));
                }
                catch (Exception e) {
                    RLog.e(RongIMClient.TAG, "removeMessageExpansion", e);
                }
            }
        });
    }

    private boolean judgeListInvalid(List<String> keyArray, OperationCallback callback) {
        if (!(keyArray instanceof ArrayList) && callback != null) {
            callback.onError(ErrorCode.PARAMETER_ERROR);
            RLog.e(TAG, "keyArray should be ArrayList!");
            return true;
        }
        return false;
    }

    static {
        URL_STATISTIC = "https://stats.cn.ronghub.com/active.json";
        cancelSDKHeartBeatEnabled = false;
        chatRoomActionListener = new AtomicReference();
    }

    public static interface MessageExpansionListener {
        public void onMessageExpansionUpdate(Map<String, String> var1, Message var2);

        public void onMessageExpansionRemove(List<String> var1, Message var2);
    }

    public static interface KVStatusListener {
        public void onChatRoomKVSync(String var1);

        public void onChatRoomKVUpdate(String var1, Map<String, String> var2);

        public void onChatRoomKVRemove(String var1, Map<String, String> var2);
    }

    public static interface ConversationStatusListener {
        public void onStatusChanged(ConversationStatus[] var1);
    }

    public static interface DestructCountDownTimerListener {
        public void onTick(long var1, String var3);

        public void onStop(String var1);
    }

    private static enum PushStatus {
        STATUS_ON("1"),
        STATUS_OFF("0");

        private String value;

        private PushStatus(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static enum PushSettings {
        PUSH_SETTINGS_LANGUAGE(1),
        PUSH_SETTINGS_SHOW_CONTENT(2),
        PUSH_SETTINGS_RECEIVE(3);

        private int value;

        private PushSettings(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum PushLanguage {
        EN_US(1, "en_us"),
        ZH_CN(2, "zh_cn"),
        AR_SA(3, "ar_sa");

        private int value;
        private String msg;

        private PushLanguage(int value, String msg) {
            this.value = value;
            this.msg = msg;
        }

        public int getValue() {
            return this.value;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static interface SyncConversationReadStatusListener {
        public void onSyncConversationReadStatus(Conversation.ConversationType var1, String var2);
    }

    public static interface OnRecallMessageListener {
        public boolean onMessageRecalled(Message var1, RecallNotificationMessage var2);
    }

    public static interface OnReceiveDestructionMessageListener {
        public void onReceive(Message var1);
    }

    public static interface ReadReceiptListener {
        public void onReadReceiptReceived(Message var1);

        public void onMessageReceiptRequest(Conversation.ConversationType var1, String var2, String var3);

        public void onMessageReceiptResponse(Conversation.ConversationType var1, String var2, String var3, HashMap<String, Long> var4);
    }

    public static interface RCLogInfoListener {
        public void onRCLogInfoOccurred(String var1);
    }

    public static interface TypingStatusListener {
        public void onTypingStatusChanged(Conversation.ConversationType var1, String var2, Collection<TypingStatus> var3);
    }

    public static interface RealTimeLocationListener {
        public void onStatusChange(RealTimeLocationConstant.RealTimeLocationStatus var1);

        public void onReceiveLocation(double var1, double var3, String var5);

        public void onReceiveLocationWithType(double var1, double var3, RealTimeLocationType var5, String var6);

        public void onParticipantsJoin(String var1);

        public void onParticipantsQuit(String var1);

        public void onError(RealTimeLocationConstant.RealTimeLocationErrorCode var1);
    }

    public static abstract class GetBlacklistCallback
    extends ResultCallback<String[]> {
    }

    public static enum SearchType {
        EXACT(0),
        FUZZY(1);

        private int value;

        private SearchType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static abstract class GetNotificationQuietHoursCallback
    extends ResultCallback<String> {
        public abstract void onSuccess(String var1, int var2);

        @Override
        public final void onSuccess(String s) {
            throw new RuntimeException("not support");
        }

        @Override
        public abstract void onError(ErrorCode var1);

        void onCallback(final String startTime, final int spanMinutes) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    GetNotificationQuietHoursCallback.this.onSuccess(startTime, spanMinutes);
                }
            });
        }
    }

    public static enum BlacklistStatus {
        IN_BLACK_LIST(0),
        NOT_IN_BLACK_LIST(1);

        private int value;

        private BlacklistStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BlacklistStatus setValue(int code) {
            for (BlacklistStatus c : BlacklistStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NOT_IN_BLACK_LIST;
        }
    }

    public static enum MediaType {
        IMAGE(1),
        AUDIO(2),
        VIDEO(3),
        FILE(4);

        private int value;

        private MediaType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaType setValue(int code) {
            for (MediaType c : MediaType.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return IMAGE;
        }
    }

    public static abstract class DownloadMediaCallback
    extends ResultCallback<String> {
        public abstract void onProgress(int var1);

        void onProgressCallback(final int progress) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DownloadMediaCallback.this.onProgress(progress);
                }
            });
        }
    }

    public static abstract class UploadMediaCallback
    extends ResultCallback<Message> {
        public abstract void onProgress(Message var1, int var2);

        public abstract void onError(Message var1, ErrorCode var2);

        void onProgressCallback(final Message message, final int progress) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    UploadMediaCallback.this.onProgress(message, progress);
                }
            });
        }

        void onFail(final Message message, final ErrorCode code) {
            mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    UploadMediaCallback.this.onError(message, code);
                }
            }, 100L);
        }

        @Override
        public void onError(ErrorCode e) {
        }
    }

    public static abstract class SendMediaMessageCallback
    extends SendImageMessageCallback {
    }

    public static abstract class SendImageMessageCallback
    extends SendMessageCallback {
        public abstract void onAttached(Message var1);

        public abstract void onError(Message var1, ErrorCode var2);

        @Override
        public abstract void onSuccess(Message var1);

        public abstract void onProgress(Message var1, int var2);

        void onProgressCallback(final Message message, final int progress) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SendImageMessageCallback.this.onProgress(message, progress);
                }
            });
        }

        void onAttachedCallback(final Message message) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SendImageMessageCallback.this.onAttached(message);
                }
            });
        }

        void onFail(final Message message, final ErrorCode code) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SendImageMessageCallback.this.onError(message, code);
                }
            });
        }

        @Override
        public void onSuccess(Integer integer) {
        }

        @Override
        public void onError(Integer messageId, ErrorCode e) {
        }
    }

    public static abstract class SendImageMessageWithUploadListenerCallback {
        public abstract void onAttached(Message var1, UploadImageStatusListener var2);

        public abstract void onError(Message var1, ErrorCode var2);

        public abstract void onSuccess(Message var1);

        public abstract void onProgress(Message var1, int var2);

        void onAttachedCallback(final Message message, final UploadImageStatusListener watcher) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SendImageMessageWithUploadListenerCallback.this.onAttached(message, watcher);
                }
            });
        }

        void onFail(final Message message, final ErrorCode code) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    SendImageMessageWithUploadListenerCallback.this.onError(message, code);
                }
            });
        }
    }

    public class UploadImageStatusListener {
        private SendImageMessageWithUploadListenerCallback callback;
        private Message message;
        private String pushContent;
        private String pushData;

        public UploadImageStatusListener(Message message, String pushContent, String pushData, SendImageMessageWithUploadListenerCallback callback) {
            this.callback = callback;
            this.message = message;
            this.pushContent = pushContent;
            this.pushData = pushData;
        }

        public void update(int progress) {
            if (this.callback != null) {
                this.callback.onProgress(this.message, progress);
            }
        }

        public void error() {
            if (this.callback != null) {
                this.message.setSentStatus(Message.SentStatus.FAILED);
                RongIMClient.this.setMessageSentStatus(this.message, null);
                this.callback.onFail(this.message, ErrorCode.RC_MSG_SEND_FAIL);
            }
        }

        public void success(Uri uploadedUri) {
            if (uploadedUri == null) {
                RLog.e(RongIMClient.TAG, "UploadImageStatusListener uri is null.");
                if (this.callback != null) {
                    this.callback.onFail(this.message, ErrorCode.RC_MSG_SEND_FAIL);
                }
                return;
            }
            MessageContent content = this.message.getContent();
            if (content instanceof ImageMessage) {
                ((ImageMessage)content).setRemoteUri(uploadedUri);
            } else if (content instanceof GIFMessage) {
                ((GIFMessage)content).setRemoteUri(uploadedUri);
            }
            RongIMClient.this.internalSendImageMessage(this.message, this.pushContent, this.pushData, new SendImageMessageCallback(){

                @Override
                public void onAttached(Message message) {
                }

                @Override
                public void onSuccess(Message message) {
                    if (UploadImageStatusListener.this.callback != null) {
                        UploadImageStatusListener.this.callback.onSuccess(message);
                    }
                }

                @Override
                public void onProgress(Message message, int progress) {
                }

                @Override
                void onFail(Message message, ErrorCode code) {
                }

                @Override
                public void onError(Message message, ErrorCode errorCode) {
                    if (UploadImageStatusListener.this.callback != null) {
                        UploadImageStatusListener.this.callback.onError(message, errorCode);
                    }
                }
            });
        }
    }

    public static abstract class CreateDiscussionCallback
    extends ResultCallback<String> {
    }

    public static abstract class SendMessageCallback
    extends ResultCallback<Integer> {
        @Override
        public final void onError(ErrorCode e) {
        }

        @Override
        public final void onFail(int errorCode) {
            super.onFail(errorCode);
        }

        @Override
        public final void onFail(ErrorCode errorCode) {
            super.onFail(errorCode);
        }

        public abstract void onError(Integer var1, ErrorCode var2);

        public final void onFail(final Integer messageId, final int errorCode) {
            mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SendMessageCallback.this.onError(messageId, ErrorCode.valueOf(errorCode));
                }
            }, 100L);
        }

        public final void onFail(final Integer messageId, final ErrorCode errorCode) {
            mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SendMessageCallback.this.onError(messageId, errorCode);
                }
            }, 100L);
        }
    }

    public static abstract class OnReceiveMessageWrapperListener
    implements OnReceiveMessageListener {
        @Override
        public final boolean onReceived(Message message, int left) {
            return this.onReceived(message, left, false, false);
        }

        public abstract boolean onReceived(Message var1, int var2, boolean var3, boolean var4);
    }

    public static interface OnReceiveMessageListener {
        public boolean onReceived(Message var1, int var2);
    }

    public static enum DiscussionInviteStatus {
        CLOSED(1),
        OPENED(0);

        private int value;

        private DiscussionInviteStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DiscussionInviteStatus setValue(int code) {
            for (DiscussionInviteStatus c : DiscussionInviteStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return OPENED;
        }
    }

    public static interface ConnectionStatusListener {
        public void onChanged(ConnectionStatus var1);

        public static enum ConnectionStatus {
            NETWORK_UNAVAILABLE(-1, "Network is unavailable."),
            CONNECTED(0, "Connect Success."),
            CONNECTING(1, "Connecting"),
            UNCONNECTED(2, "UNCONNECTED"),
            KICKED_OFFLINE_BY_OTHER_CLIENT(3, "Login on the other device, and be kicked offline."),
            TOKEN_INCORRECT(4, "Token incorrect."),
            CONN_USER_BLOCKED(6, "User blocked by admin"),
            SIGN_OUT(12, "user sign out"),
            SUSPEND(13, "SUSPEND"),
            TIMEOUT(14, "TIMEOUT");

            private int code;
            private String msg;

            private ConnectionStatus(int code, String msg) {
                this.code = code;
                this.msg = msg;
            }

            public static ConnectionStatus valueOf(int code) {
                ConnectionStatus[] values;
                for (ConnectionStatus status : values = ConnectionStatus.values()) {
                    if (status.code != code) continue;
                    return status;
                }
                RLog.d(RongIMClient.TAG, "valueOf,ErrorCode:" + code);
                return CONNECTING;
            }

            public int getValue() {
                return this.code;
            }

            public String getMessage() {
                return this.msg;
            }
        }
    }

    public static interface EncryptedSessionConnectionListener {
        public void onEncryptedSessionRequest(String var1, boolean var2);

        public void onEncryptedSessionResponse(String var1);

        public void onEncryptedSessionEstablished(String var1);

        public void onEncryptedSessionCanceled(String var1);

        public void onEncryptedSessionTerminated(String var1);
    }

    public static abstract class OperationCallback
    extends Callback {
    }

    public static enum DatabaseOpenStatus {
        DATABASE_OPEN_SUCCESS(0),
        DATABASE_OPEN_ERROR(33002);

        private int code;

        private DatabaseOpenStatus(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }

        public static DatabaseOpenStatus valueOf(int code) {
            for (DatabaseOpenStatus status : DatabaseOpenStatus.values()) {
                if (code != status.getValue()) continue;
                return status;
            }
            return DATABASE_OPEN_ERROR;
        }
    }

    static abstract class SyncCallback<T>
    extends ResultCallback<T> {
        SyncCallback() {
        }

        @Override
        public void onFail(int errorCode) {
            this.onError(ErrorCode.valueOf(errorCode));
        }

        @Override
        public void onFail(ErrorCode errorCode) {
            this.onError(errorCode);
        }

        @Override
        public void onCallback(T t) {
            this.onSuccess(t);
        }
    }

    public static abstract class ConnectCallback {
        public abstract void onSuccess(String var1);

        public abstract void onError(ConnectionErrorCode var1);

        void onFail(final int errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConnectCallback.this.onError(ConnectionErrorCode.valueOf(errorCode));
                }
            });
        }

        void onFail(final ConnectionErrorCode errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConnectCallback.this.onError(errorCode);
                }
            });
        }

        void onCallback(final String t) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ConnectCallback.this.onSuccess(t);
                }
            });
        }

        public abstract void onDatabaseOpened(DatabaseOpenStatus var1);
    }

    public static abstract class ResultCallback<T> {
        public abstract void onSuccess(T var1);

        public abstract void onError(ErrorCode var1);

        void onFail(final int errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ResultCallback.this.onError(ErrorCode.valueOf(errorCode));
                }
            });
        }

        void onFail(final ErrorCode errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ResultCallback.this.onError(errorCode);
                }
            });
        }

        void onCallback(final T t) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ResultCallback.this.onSuccess(t);
                }
            });
        }

        public static class Result<T> {
            public T t;
        }
    }

    public static abstract class Callback {
        public void onCallback() {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Callback.this.onSuccess();
                }
            });
        }

        public void onFail(final int errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Callback.this.onError(ErrorCode.valueOf(errorCode));
                }
            });
        }

        public void onFail(final ErrorCode errorCode) {
            mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Callback.this.onError(errorCode);
                }
            });
        }

        public abstract void onSuccess();

        public abstract void onError(ErrorCode var1);
    }

    public static enum ErrorCode {
        APP_NOT_CONNECT(-4, "APP hasn't call connect function."),
        PARAMETER_ERROR(33003, "the parameter is error."),
        IPC_DISCONNECT(-2, "IPC is not connected"),
        UNKNOWN(-1, "unknown"),
        CONNECTED(0, "connected"),
        MSG_SEND_OVERFREQUENCY(20604, "message send over frequency."),
        RC_OPERATION_BLOCKED(20605, ""),
        RC_OPERATION_NOT_SUPPORT(20606, ""),
        RC_REQUEST_OVERFREQUENCY(20607, ""),
        MSG_ROAMING_SERVICE_UNAVAILABLE(33007, "Message roaming service unavailable"),
        NOT_IN_DISCUSSION(21406, ""),
        RC_MSG_BLOCKED_SENSITIVE_WORD(21501, "word is blocked"),
        RC_MSG_REPLACED_SENSITIVE_WORD(21502, "word is replaced"),
        NOT_IN_GROUP(22406, ""),
        FORBIDDEN_IN_GROUP(22408, ""),
        NOT_IN_CHATROOM(23406, ""),
        FORBIDDEN_IN_CHATROOM(23408, ""),
        KICKED_FROM_CHATROOM(23409, ""),
        RC_CHATROOM_NOT_EXIST(23410, "Chat room does not exist"),
        RC_CHATROOM_IS_FULL(23411, "Chat room is full"),
        RC_CHATROOM_ILLEGAL_ARGUMENT(23412, "illegal argument."),
        RC_SETTING_SYNC_FAILED(26002, ""),
        RC_APP_PUBLICSERVICE_DEFFOLLOWED(29102, ""),
        RC_APP_PUBLICSERVICE_FOLLOWED(29103, ""),
        RC_APP_PUBLICSERVICE_DEFUNFOLLOWED(29104, ""),
        RC_APP_PUBLICSERVICE_UNFOLLOWED(29105, ""),
        RC_APP_PUBLICSERVICE_UNFOLLOW(29106, ""),
        RC_PUBLICSERVICE_ERROR_TYPE(29201, ""),
        RC_PUBLICSERVICE_DEFFOLLOWED(29202, ""),
        RC_PUBLICSERVICE_FOLLOWED(29203, ""),
        RC_PUBLICSERVICE_DEFUNFOLLOWED(29204, ""),
        RC_PUBLICSERVICE_UNFOLLOWED(29205, ""),
        RC_PUBLICSERVICE_UNFOLLOW(29206, ""),
        REJECTED_BY_BLACKLIST(405, "rejected by blacklist"),
        NOT_IN_WHITELIST(407, ""),
        RC_NET_CHANNEL_INVALID(30001, "Socket does not exist"),
        RC_NET_UNAVAILABLE(30002, ""),
        RC_MSG_RESP_TIMEOUT(30003, ""),
        RC_HTTP_SEND_FAIL(30004, ""),
        RC_HTTP_REQ_TIMEOUT(30005, ""),
        RC_HTTP_RECV_FAIL(30006, ""),
        RC_NAVI_RESOURCE_ERROR(30007, ""),
        RC_NODE_NOT_FOUND(30008, ""),
        RC_DOMAIN_NOT_RESOLVE(30009, ""),
        RC_SOCKET_NOT_CREATED(30010, ""),
        RC_SOCKET_DISCONNECTED(30011, ""),
        RC_PING_SEND_FAIL(30012, ""),
        RC_PONG_RECV_FAIL(30013, ""),
        RC_MSG_SEND_FAIL(30014, ""),
        RC_CONN_OVERFREQUENCY(30015, "Connect over frequency."),
        RC_MSG_SIZE_OUT_OF_LIMIT(30016, ""),
        RC_NETWORK_IS_DOWN_OR_UNREACHABLE(30019, ""),
        RC_CONN_ACK_TIMEOUT(31000, ""),
        RC_CONN_PROTO_VERSION_ERROR(31001, ""),
        RC_CONN_ID_REJECT(31002, ""),
        RC_CONN_SERVER_UNAVAILABLE(31003, ""),
        RC_CONN_USER_OR_PASSWD_ERROR(31004, ""),
        RC_CONN_NOT_AUTHRORIZED(31005, ""),
        RC_CONN_REDIRECTED(31006, ""),
        RC_CONN_PACKAGE_NAME_INVALID(31007, ""),
        RC_CONN_APP_BLOCKED_OR_DELETED(31008, ""),
        RC_CONN_USER_BLOCKED(31009, ""),
        RC_DISCONN_KICK(31010, ""),
        RC_DISCONN_USER_BLOCKED(31011, ""),
        RC_CONN_OTHER_DEVICE_LOGIN(31023, ""),
        CONCURRENT_LIMIT_ERROR(31024, ""),
        RC_QUERY_ACK_NO_DATA(32001, ""),
        RC_MSG_DATA_INCOMPLETE(32002, ""),
        RC_CONN_REFUSED(32061, "connection is refused"),
        RC_CONNECTION_RESET_BY_PEER(32054, "connection reset by peer"),
        BIZ_ERROR_CLIENT_NOT_INIT(33001, ""),
        BIZ_ERROR_DATABASE_ERROR(33002, ""),
        BIZ_ERROR_NO_CHANNEL(33004, ""),
        BIZ_ERROR_RECONNECT_SUCCESS(33005, ""),
        BIZ_ERROR_CONNECTING(33006, ""),
        PARAMETER_INVALID_CHATROOM(23412, "invalid parameter"),
        ROAMING_SERVICE_UNAVAILABLE_CHATROOM(23414, ""),
        EXCCED_MAX_KV_SIZE(23423, ""),
        TRY_OVERWRITE_INVALID_KEY(23424, ""),
        EXCCED_MAX_CALL_API_SIZE(23425, ""),
        KV_STORE_NOT_AVAILABLE(23426, ""),
        KEY_NOT_EXIST(23427, ""),
        RC_CONNECTION_EXIST(34001, ""),
        KV_STORE_NOT_SYNC(34004, ""),
        RC_RECALL_PARAMETER_INVALID(25101, ""),
        RC_PUSHSETTING_PARAMETER_INVALID(26001, ""),
        RC_PUSHSETTING_CONFIG_NOT_OPEN(26002, ""),
        RC_SIGHT_SERVICE_UNAVAILABLE(26101, ""),
        RC_SIGHT_MSG_DURATION_LIMIT_EXCEED(34002, ""),
        RC_GIF_MSG_SIZE_LIMIT_EXCEED(34003, ""),
        RC_ENVIRONMENT_ERROR(34005, ""),
        RC_CONNECT_TIMEOUT(34006, "Time out."),
        RC_PUBLIC_SERVICE_PROFILE_NOT_EXIST(34007, ""),
        RC_MESSAGE_CANT_EXPAND(34008, ""),
        RC_MESSAGE_EXPAND_FAIL(34009, ""),
        RC_MSG_EXPANSION_SIZE_LIMIT_EXCEED(34010, ""),
        RC_FILE_UPLOAD_FAILED(34011, "");

        private int code;
        private String msg;

        private ErrorCode(int code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public int getValue() {
            return this.code;
        }

        public String getMessage() {
            return this.msg;
        }

        public static ErrorCode valueOf(int code) {
            for (ErrorCode c : ErrorCode.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            RLog.d(RongIMClient.TAG, "valueOf,ErrorCode:" + code);
            ErrorCode c = UNKNOWN;
            c.code = code;
            c.msg = code + "";
            return c;
        }
    }

    public static enum ConnectionErrorCode {
        IPC_DISCONNECT(ErrorCode.IPC_DISCONNECT.getValue()),
        RC_CONN_ID_REJECT(ErrorCode.RC_CONN_ID_REJECT.getValue()),
        RC_CONN_TOKEN_INCORRECT(ErrorCode.RC_CONN_USER_OR_PASSWD_ERROR.getValue()),
        RC_CONN_NOT_AUTHRORIZED(ErrorCode.RC_CONN_NOT_AUTHRORIZED.getValue()),
        RC_CONN_PACKAGE_NAME_INVALID(ErrorCode.RC_CONN_PACKAGE_NAME_INVALID.getValue()),
        RC_CONN_APP_BLOCKED_OR_DELETED(ErrorCode.RC_CONN_APP_BLOCKED_OR_DELETED.getValue()),
        RC_CONN_USER_BLOCKED(ErrorCode.RC_CONN_USER_BLOCKED.getValue()),
        RC_DISCONN_KICK(ErrorCode.RC_DISCONN_KICK.getValue()),
        RC_CONN_OTHER_DEVICE_LOGIN(ErrorCode.RC_CONN_OTHER_DEVICE_LOGIN.getValue()),
        RC_CLIENT_NOT_INIT(ErrorCode.BIZ_ERROR_CLIENT_NOT_INIT.getValue()),
        RC_INVALID_PARAMETER(ErrorCode.PARAMETER_ERROR.getValue()),
        RC_CONNECTION_EXIST(ErrorCode.RC_CONNECTION_EXIST.getValue()),
        RC_ENVIRONMENT_ERROR(ErrorCode.RC_ENVIRONMENT_ERROR.getValue()),
        RC_CONNECT_TIMEOUT(ErrorCode.RC_CONNECT_TIMEOUT.getValue()),
        UNKNOWN(-1);

        private int code;

        private ConnectionErrorCode(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }

        public static ConnectionErrorCode valueOf(int code) {
            for (ConnectionErrorCode c : ConnectionErrorCode.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            RLog.d(RongIMClient.TAG, "valueOf,ConnectionErrorCode:" + code);
            ConnectionErrorCode c = UNKNOWN;
            c.code = code;
            return c;
        }
    }

    private class StatusListener
    extends IConnectionStatusListener.Stub {
        private StatusListener() {
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            boolean result;
            try {
                result = super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                RLog.e(RongIMClient.TAG, "StatusListener Unexpected remote exception", e);
                throw e;
            }
            return result;
        }

        @Override
        public void onChanged(int status) throws RemoteException {
            ConnectionStatusListener.ConnectionStatus connectionStatus = ConnectionStatusListener.ConnectionStatus.valueOf(status);
            RLog.d(RongIMClient.TAG, "[connect] onChanged cur = " + (Object)((Object)RongIMClient.this.mConnectionStatus) + ", to = " + (Object)((Object)connectionStatus));
            this.onConnectionStatusChange(connectionStatus);
        }

        synchronized void onConnectionStatusChange(final ConnectionStatusListener.ConnectionStatus status) {
            if (status.equals((Object)ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                MessageBufferPool.getInstance().retrySendMessages();
                RongIMClient.getInstance().reJoinChatRoomWithCache();
            }
            ModuleManager.connectivityChanged(status);
            RongIMClient.this.imLibExtensionModuleManager.onConnectStatusChanged(status);
            if (!RongIMClient.this.mConnectionStatus.equals((Object)status)) {
                RongIMClient.this.mConnectionStatus = status;
                RongIMClient.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (sConnectionListener != null) {
                            sConnectionListener.onChanged(status);
                        }
                    }
                });
            }
        }
    }

    private class JoinChatRoomCallback
    extends DefaultOperationCallback {
        private String chatRoomId;
        private int count;
        private boolean chatRoomIdExist;
        private boolean isRejoin;

        JoinChatRoomCallback(IpcCallbackProxy<OperationCallback> ipcCallbackProxy, String chatRoomId, int count, boolean joinMultiCR, boolean chatRoomIdExist, boolean isRejoin) {
            super(ipcCallbackProxy);
            this.chatRoomId = chatRoomId;
            this.count = count;
            this.chatRoomIdExist = chatRoomIdExist;
            this.isRejoin = isRejoin;
            if (!joinMultiCR) {
                RongIMClient.this.mChatRoomCache.clear();
            }
            RongIMClient.this.mChatRoomCache.put(chatRoomId, new ChatRoomCacheRunnable(chatRoomId, count, chatRoomIdExist));
            RLog.d(RongIMClient.TAG, this + "; joinMultiCR = " + joinMultiCR);
        }

        @Override
        public void onFailure(int errorCode) {
            super.onFailure(errorCode);
            FwLog.write(1, 1, this.isRejoin ? FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag() : FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", errorCode, this.chatRoomId);
            ErrorCode ec = ErrorCode.valueOf(errorCode);
            if (!(ec.equals((Object)ErrorCode.RC_CHATROOM_NOT_EXIST) || ec.equals((Object)ErrorCode.RC_CHATROOM_IS_FULL) || ec.equals((Object)ErrorCode.RC_OPERATION_BLOCKED) || ec.equals((Object)ErrorCode.KICKED_FROM_CHATROOM))) {
                RLog.e(RongIMClient.TAG, "join chatroom " + this.chatRoomId + " error: " + errorCode + ", re-join after 2s");
                ChatRoomCacheRunnable runnable = new ChatRoomCacheRunnable(this.chatRoomId, this.count, this.chatRoomIdExist);
                RongIMClient.this.mRetryCRCache.put(this.chatRoomId, runnable);
                long interval = 2000L;
                FwLog.write(4, 1, FwLog.LogTag.A_REJOIN_CHATROOM_S.getTag(), "retry_after", interval);
                RongIMClient.this.mWorkHandler.postDelayed((Runnable)runnable, interval);
            } else {
                RLog.e(RongIMClient.TAG, "join chatroom " + this.chatRoomId + " error : " + (Object)((Object)ec));
            }
            ChatRoomActionListener listener = (ChatRoomActionListener)chatRoomActionListener.get();
            if (listener != null) {
                listener.onError(this.chatRoomId, ErrorCode.valueOf(errorCode));
            }
        }

        @Override
        public void onComplete() {
            ChatRoomActionListener listener;
            super.onComplete();
            FwLog.write(3, 1, this.isRejoin ? FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag() : FwLog.LogTag.A_JOIN_CHATROOM_R.getTag(), "code|room_id", 0, this.chatRoomId);
            RLog.d(RongIMClient.TAG, "onComplete: " + this);
            ChatRoomCacheRunnable runnable = (ChatRoomCacheRunnable)RongIMClient.this.mChatRoomCache.get(this.chatRoomId);
            if (runnable != null) {
                runnable.onceSuccess = true;
            }
            if ((listener = (ChatRoomActionListener)chatRoomActionListener.get()) != null) {
                listener.onJoined(this.chatRoomId);
            }
        }

        public String toString() {
            return "JoinChatRoomCallback{chatRoomId='" + this.chatRoomId + '\'' + ", count=" + this.count + ", chatRoomIdExist=" + this.chatRoomIdExist + '}';
        }
    }

    private class ChatRoomCacheRunnable
    implements Runnable {
        String chatRoomId;
        int count;
        boolean onceSuccess;
        boolean chatRoomIdExist;

        ChatRoomCacheRunnable(String chatRoomId, int count, boolean chatRoomIdExist) {
            this.count = count;
            this.chatRoomId = chatRoomId;
            this.chatRoomIdExist = chatRoomIdExist;
        }

        @Override
        public void run() {
            block6: {
                RLog.d(RongIMClient.TAG, "re-join chatroom " + this);
                RongIMClient.this.mRetryCRCache.remove(this.chatRoomId);
                if (RongIMClient.this.mLibHandler != null && RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                    try {
                        IpcCallbackProxy<Object> ipcCallbackProxy = new IpcCallbackProxy<Object>(null);
                        ChatRoomActionListener listener = (ChatRoomActionListener)chatRoomActionListener.get();
                        if (listener != null) {
                            listener.onJoining(this.chatRoomId);
                        }
                        FwLog.write(3, 1, FwLog.LogTag.A_REJOIN_CHATROOM_T.getTag(), "room_id|existed|count", this.chatRoomId, this.chatRoomIdExist, this.onceSuccess ? -1 : this.count);
                        if (this.chatRoomIdExist) {
                            RongIMClient.this.mLibHandler.joinExistChatRoom(this.chatRoomId, this.onceSuccess ? -1 : this.count, new JoinChatRoomCallback(ipcCallbackProxy, this.chatRoomId, this.count, RongIMClient.this.mLibHandler.getJoinMultiChatRoomEnable(), this.chatRoomIdExist, true), true);
                            break block6;
                        }
                        RongIMClient.this.mLibHandler.reJoinChatRoom(this.chatRoomId, this.onceSuccess ? -1 : this.count, new JoinChatRoomCallback(ipcCallbackProxy, this.chatRoomId, this.count, RongIMClient.this.mLibHandler.getJoinMultiChatRoomEnable(), this.chatRoomIdExist, true));
                    }
                    catch (Exception e) {
                        FwLog.write(1, 1, FwLog.LogTag.A_REJOIN_CHATROOM_R.getTag(), "code|room_id|stacks", -1, this.chatRoomId, FwLog.stackToString(e));
                        RLog.e(RongIMClient.TAG, "ChatRoomCacheRunnable", e);
                        RLog.e(RongIMClient.TAG, "re-join chatroom exception");
                    }
                } else {
                    RLog.e(RongIMClient.TAG, "re-join chatroom error : " + (Object)((Object)RongIMClient.this.mConnectionStatus) + ", mLibHandler = " + RongIMClient.this.mLibHandler);
                }
            }
        }

        public String toString() {
            return "ChatRoomCacheRunnable{chatRoomId='" + this.chatRoomId + '\'' + ", count=" + this.count + ", onceSuccess=" + this.onceSuccess + ", chatRoomIdExist=" + this.chatRoomIdExist + ", state='" + (Object)((Object)RongIMClient.this.mConnectionStatus) + '\'' + '}';
        }
    }

    public static interface ChatRoomActionListener {
        public void onJoining(String var1);

        public void onJoined(String var1);

        public void onQuited(String var1);

        public void onError(String var1, ErrorCode var2);
    }

    private class DefaultOperationCallback
    extends IOperationCallback.Stub {
        private IpcCallbackProxy<OperationCallback> ipcCallbackProxy;

        public DefaultOperationCallback(IpcCallbackProxy<OperationCallback> ipcCallbackProxy) {
            this.ipcCallbackProxy = ipcCallbackProxy;
        }

        @Override
        public void onComplete() {
            if (this.ipcCallbackProxy.callback != null) {
                ((OperationCallback)this.ipcCallbackProxy.callback).onCallback();
                this.ipcCallbackProxy.callback = null;
            }
        }

        @Override
        public void onFailure(int errorCode) {
            if (this.ipcCallbackProxy.callback != null) {
                ((OperationCallback)this.ipcCallbackProxy.callback).onFail(errorCode);
                this.ipcCallbackProxy.callback = null;
            }
        }
    }

    public static enum TimestampOrder {
        RC_TIMESTAMP_DESC,
        RC_TIMESTAMP_ASC;

    }

    private class GetConversationListProcessCallBackWrapper
    extends IGetConversationListWithProcessCallback.Stub {
        private ResultCallback<List<Conversation>> resultCallback;
        private List<Conversation> conversationList = new ArrayList<Conversation>();

        GetConversationListProcessCallBackWrapper(ResultCallback<List<Conversation>> callback) {
            this.resultCallback = callback;
        }

        @Override
        public void onProcess(List<Conversation> list) {
            this.conversationList.addAll(list);
        }

        @Override
        public void onComplete() {
            if (this.resultCallback != null) {
                if (this.conversationList.size() == 0) {
                    this.resultCallback.onCallback(null);
                } else {
                    this.resultCallback.onCallback(this.conversationList);
                }
            }
        }
    }

    private class AidlConnection
    implements ServiceConnection {
        private AidlConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            FwLog.write(3, 1, FwLog.LogTag.BIND_SERVICE_S.getTag(), "bent", true);
            RongIMClient.this.mLibHandler = IHandler.Stub.asInterface(service);
            try {
                RongIMClient.this.mLibHandler.initAppendixModule();
            }
            catch (Exception e) {
                RLog.e(RongIMClient.TAG, "onServiceConnected initAppendix error", e);
            }
            if (TextUtils.isEmpty((CharSequence)RongIMClient.this.mToken) && this.canConnectStatus()) {
                RongIMClient.this.mConnectionStatus = ConnectionStatusListener.ConnectionStatus.UNCONNECTED;
                RLog.i(RongIMClient.TAG, "onServiceConnected token is null\uff1bstatus:" + (Object)((Object)RongIMClient.this.mConnectionStatus));
            }
            try {
                RLog.i(RongIMClient.TAG, "initIPCEnviroment token:" + RongIMClient.this.mToken + " status:" + (Object)((Object)RongIMClient.this.mConnectionStatus));
                RongIMClient.this.mLibHandler.initIPCEnviroment(RongIMClient.this.mToken, RongIMClient.this.mConnectionStatus.getValue());
            }
            catch (Exception e) {
                RLog.e(RongIMClient.TAG, "onServiceConnected initIPCEnviroment error", e);
            }
            RongIMClient.this.setIPCLogListener();
            RongIMClient.this.initReceiver();
            ModuleManager.init(RongIMClient.this.mContext, RongIMClient.this.mLibHandler, sReceiveMessageListener);
            IMLibRTCClient.getInstance().OnServiceConnected(RongIMClient.this.mLibHandler);
            RLog.d(RongIMClient.TAG, "onServiceConnected mConnectionStatus = " + (Object)((Object)RongIMClient.this.mConnectionStatus));
            if (RongIMClient.this.mConnectRunnable != null) {
                mHandler.post((Runnable)RongIMClient.this.mConnectRunnable);
            } else if (RongIMClient.this.mToken != null) {
                RongIMClient.this.connectServer(RongIMClient.this.mToken, true);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            int logLevel = isInForeground ? 2 : 3;
            FwLog.write(logLevel, 1, FwLog.LogTag.BIND_SERVICE_S.getTag(), "bent", false);
            ModuleManager.unInit();
            RongIMClient.this.mLibHandler = null;
            IMLibRTCClient.getInstance().OnServiceDisconnected();
            RLog.d(RongIMClient.TAG, "onServiceDisconnected " + (Object)((Object)RongIMClient.this.mConnectionStatus));
            if (this.canConnectStatus()) {
                RongIMClient.this.mStatusListener.onConnectionStatusChange(ConnectionStatusListener.ConnectionStatus.SUSPEND);
            }
            RongIMClient.this.initBindService();
        }

        private boolean canConnectStatus() {
            return !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.SIGN_OUT) && !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.UNCONNECTED) && !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT) && !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.CONN_USER_BLOCKED) && !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.TOKEN_INCORRECT) && !RongIMClient.this.mConnectionStatus.equals((Object)ConnectionStatusListener.ConnectionStatus.TIMEOUT);
        }
    }

    private class ConnectRunnable
    implements Runnable {
        String token;

        ConnectRunnable(String token) {
            RLog.d(RongIMClient.TAG, "[connect] ConnectRunnable for connect");
            this.token = token;
        }

        @Override
        public void run() {
            RLog.d(RongIMClient.TAG, "[connect] ConnectRunnable do connect!");
            RongIMClient.this.connectServer(this.token, false);
        }
    }

    private static class SingletonHolder {
        static RongIMClient sInstance = new RongIMClient();

        private SingletonHolder() {
        }
    }
}

