/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.common.rlog.IRealTimeLogListener;
import io.rong.imlib.NativeClient;
import io.rong.imlib.model.ChatroomStatus;
import io.rong.imlib.model.ConversationStatus;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.relinker.ReLinker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class NativeObject {
    private static final String TAG = NativeObject.class.getSimpleName();

    NativeObject(Context context) {
        ReLinker.log(new ReLinker.Logger(){

            @Override
            public void log(String message) {
                RLog.d(TAG, "load RongIMLib:" + message);
            }
        }).recursively().loadLibrary(context, "RongIMLib");
    }

    protected native int InitClient(String var1, String var2, String var3, String var4, String var5);

    protected native int RegisterMessageType(String var1, int var2);

    protected native int RegisterMessage(Conversation[] var1);

    protected native int Connect(String var1, ConnectionEntry[] var2, String var3, UserProfile var4);

    protected native void SetConnectionStatusListener(ConnectionStatusListener var1);

    protected native void Disconnect(int var1);

    protected native boolean DeleteMessages(long[] var1);

    protected native void DeleteRemoteMessages(int var1, String var2, Message[] var3, boolean var4, PublishAckListener var5);

    protected native boolean ClearMessages(int var1, String var2, boolean var3);

    protected native void CleanRemoteHistoryMessage(int var1, String var2, long var3, PublishAckListener var5);

    protected native boolean CleanHistoryMessages(int var1, String var2, long var3);

    protected native boolean ClearUnread(int var1, String var2);

    protected native boolean SetMessageExtra(long var1, String var3);

    protected native boolean RemoveConversation(int var1, String var2);

    protected native boolean SetTextMessageDraft(int var1, String var2, String var3);

    protected native boolean SetMessageContent(long var1, byte[] var3, String var4);

    protected native String GetTextMessageDraft(int var1, String var2);

    protected native boolean SetIsTop(int var1, String var2, boolean var3, boolean var4);

    protected native int GetTotalUnreadCount();

    protected native long GetDeltaTime();

    protected native void CreateInviteDiscussion(String var1, String[] var2, CreateDiscussionCallback var3);

    protected native void InviteMemberToDiscussion(String var1, String[] var2, PublishAckListener var3);

    protected native void RemoveMemberFromDiscussion(String var1, String var2, PublishAckListener var3);

    protected native boolean RemoveMemberFromDiscussionSync(String var1, String var2);

    protected native void QuitDiscussion(String var1, PublishAckListener var2);

    protected native long SaveMessage(String var1, int var2, String var3, String var4, byte[] var5, boolean var6, int var7, int var8, long var9, String var11, int var12, String var13, boolean var14, boolean var15, String var16);

    protected native void SendMessage(String var1, int var2, int var3, String var4, byte[] var5, PushConfig var6, long var7, String[] var9, PublishAckListener var10, boolean var11, boolean var12, boolean var13, String var14);

    protected native void sendMessageWithOption(String var1, int var2, int var3, String var4, byte[] var5, PushConfig var6, long var7, String[] var9, PublishAckListener var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, String var16);

    protected native UserInfo GetUserInfoExSync(String var1, int var2);

    protected native void SetMessageListener(ReceiveMessageListener var1);

    protected native boolean SetReadStatus(long var1, int var3);

    protected native boolean SetSendStatus(long var1, int var3);

    protected native int EnvironmentChangeNotify(int var1);

    protected native void GetDiscussionInfo(String var1, DiscussionInfoListener var2);

    protected native DiscussionInfo GetDiscussionInfoSync(String var1);

    protected native void RenameDiscussion(String var1, String var2, PublishAckListener var3);

    protected native Conversation GetConversationEx(String var1, int var2);

    protected native void SetBlockPush(String var1, int var2, boolean var3, PublishAckListener var4);

    protected native int GetBlockPush(String var1, int var2);

    protected native void SetInviteStatus(String var1, int var2, PublishAckListener var3);

    protected native int GetDNDUnreadCount(Conversation[] var1);

    protected native int GetUnreadCount(String var1, int var2);

    protected native int GetMessageCount(String var1, int var2);

    protected native void RecallMessage(String var1, byte[] var2, String var3, long var4, String var6, int var7, PublishAckListener var8, boolean var9);

    protected native Conversation[] GetConversationListEx(int[] var1);

    protected native Conversation[] GetConversationList(int[] var1, long var2, int var4);

    protected native void SyncGroups(String[] var1, String[] var2, PublishAckListener var3);

    protected native void JoinGroup(String var1, String var2, PublishAckListener var3);

    protected native void QuitGroup(String var1, PublishAckListener var2);

    protected native int GetCateUnreadCount(int[] var1, boolean var2);

    protected native void JoinChatRoom(String var1, int var2, int var3, boolean var4, PublishAckListener var5);

    protected native void JoinExistingChatroom(String var1, int var2, int var3, PublishAckListener var4, boolean var5);

    protected native void QuitChatRoom(String var1, int var2, PublishAckListener var3);

    protected native boolean ClearConversations(int[] var1);

    protected native void AddToBlacklist(String var1, PublishAckListener var2);

    protected native void RemoveFromBlacklist(String var1, PublishAckListener var2);

    protected native void GetBlacklistStatus(String var1, BizAckListener var2);

    protected native void GetBlacklist(SetBlacklistListener var1);

    public native void GetUploadToken(int var1, String var2, FileTokenListener var3);

    public native void GetDownloadUrl(int var1, String var2, String var3, TokenListener var4, boolean var5);

    protected native void SubscribeAccount(String var1, int var2, boolean var3, PublishAckListener var4);

    protected native int SetDeviceInfo(String var1, String var2, String var3, String var4, String var5);

    protected native void SearchAccount(String var1, int var2, int var3, AccountInfoListener var4);

    protected native void LoadHistoryMessage(String var1, int var2, long var3, int var5, HistoryMessageListener var6);

    protected native void LoadHistoryMessageOption(String var1, int var2, long var3, int var5, int var6, boolean var7, HistoryMessageListener var8);

    protected native void GetChatroomHistoryMessage(String var1, long var2, int var4, int var5, HistoryMessageListener var6);

    protected int ping() {
        return this.EnvironmentChangeNotify(105);
    }

    protected void networkUnavailable() {
        this.EnvironmentChangeNotify(101);
    }

    protected void sdkBackgroundChanged(boolean isInBackground) {
        if (isInBackground) {
            this.EnvironmentChangeNotify(102);
        } else {
            this.EnvironmentChangeNotify(103);
        }
    }

    protected native AccountInfo[] LoadAccountInfo();

    protected native void AddPushSetting(String var1, int var2, PublishAckListener var3);

    protected native void RemovePushSetting(PublishAckListener var1);

    protected native void QueryPushSetting(PushSettingListener var1);

    protected native void SetUserData(String var1, PublishAckListener var2);

    protected native Message[] GetHistoryMessagesEx(String var1, int var2, String var3, long var4, int var6, boolean var7);

    protected native Message[] GetHistoryMessagesByObjectNames(String var1, int var2, String[] var3, long var4, int var6, boolean var7);

    protected native long GetSendTimeByMessageId(long var1);

    protected native Message GetMessageById(long var1);

    protected native Message GetMessageByUId(String var1);

    protected native boolean UpdateMessageReceiptStatus(String var1, int var2, long var3);

    protected native boolean ClearUnreadByReceipt(String var1, int var2, long var3);

    protected native boolean UpdateConversationInfo(String var1, int var2, String var3, String var4);

    protected native boolean QueryChatroomInfo(String var1, int var2, int var3, ChatroomInfoListener var4);

    protected native void GetVoIPKey(int var1, String var2, String var3, TokenListener var4);

    protected native void SetGetSearchableWordListener(GetSearchableWordListener var1);

    protected native void SetUserStatus(int var1, PublishAckListener var2);

    protected native void GetUserStatus(String var1, CreateDiscussionCallback var2);

    protected native void SetPushSetting(int var1, String var2, SetPushSettingListener var3);

    protected native void SubscribeStatus(String[] var1, PublishAckListener var2);

    protected native void SetSubscribeStatusListener(UserStatusListener var1);

    protected native String GetPushSetting(int var1);

    protected native Message[] SearchMessages(String var1, int var2, String var3, int var4, long var5);

    protected native Message[] SearchMessagesByUser(String var1, int var2, String var3, int var4, long var5);

    protected native Conversation[] SearchConversations(String var1, int[] var2, String[] var3);

    protected native Message[] GetMatchedMessages(String var1, int var2, long var3, int var5, int var6);

    protected native void GetVendorToken(String var1, TokenListener var2);

    protected native Message[] GetMentionMessages(String var1, int var2);

    protected native void SetLogStatus(int var1, NativeLogInfoListener var2);

    protected native boolean UpdateReadReceiptRequestInfo(String var1, String var2);

    protected native int RegisterCmdMsgType(String[] var1);

    protected native int RegisterDeleteMessageType(String[] var1);

    protected native int SetEnvironment(boolean var1);

    protected native void SetOfflineMessageDuration(String var1, SetOfflineMessageDurationListener var2);

    protected native String GetOfflineMessageDuration();

    protected native Conversation[] GetBlockedConversations(int[] var1);

    protected native Message GetTheFirstUnreadMessage(int var1, String var2);

    protected native Conversation[] GetTopConversations(int[] var1);

    protected native boolean SetReadTime(long var1, long var3);

    protected native boolean CreateEncryptedConversation(String var1, String var2, String var3, String var4, String var5, int var6);

    protected native RCEncryptedSession GetEncryptedConversationInfo(String var1);

    protected native boolean SetEncryptedConversationInfo(String var1, String var2, String var3, String var4, String var5, int var6);

    protected native boolean RemoveEncryptedConversation(String var1);

    protected native boolean ClearEncryptedConversations();

    protected native List<RCEncryptedSession> GetEncryptedConversations();

    protected native void SetPushNotificationListener(NativeClient.PushNotificationListener var1);

    protected native void SetRealTimeLogListener(IRealTimeLogListener var1);

    protected native void ExitRTCRoom(String var1, PublishAckListener var2);

    protected native void GetRTCUsers(String var1, int var2, RTCUserInfoListener var3);

    protected native void GetRTCUserData(String var1, int var2, RTCUserInfoListener var3);

    protected native void SendRTCPing(String var1, PublishAckListener var2);

    protected native boolean UseRTCOnly();

    protected native void RTCPutInnerDatum(String var1, int var2, String var3, String var4, String var5, String var6, PublishAckListener var7);

    protected native void RTCPutOuterDatum(String var1, int var2, String var3, String var4, String var5, String var6, PublishAckListener var7);

    protected native void RTCDeleteInnerData(String var1, int var2, String[] var3, String var4, String var5, PublishAckListener var6);

    protected native void RTCDeleteOuterData(String var1, int var2, String[] var3, String var4, String var5, PublishAckListener var6);

    protected native void RTCGetInnerData(String var1, int var2, String[] var3, RTCDataListener var4);

    protected native void RTCGetOuterData(String var1, int var2, String[] var3, RTCDataListener var4);

    protected native void JoinRTCRoomAndGetData(String var1, int var2, int var3, RTCUserInfoListener var4);

    protected native void GetRTCConfig(String var1, String var2, long var3, String var5, RTCConfigListener var6);

    protected native void RTCGetToken(String var1, int var2, int var3, TokenListener var4);

    protected native void RTCSetUserState(String var1, String var2, PublishAckListener var3);

    protected native String GetHttpDnsSecret();

    protected native String GetHttpDnsAccountId();

    protected native void RTCSetUserData(String var1, int var2, Map<String, String> var3, String var4, String var5, PublishAckListener var6);

    protected native void RTCGetUserData(String var1, String[] var2, RTCUserInfoListener var3);

    protected native void SetChatRoomStatus(String var1, StatusData var2, StatusNotification var3, PublishAckListener var4);

    protected native void DeleteChatRoomStatus(String var1, StatusData var2, StatusNotification var3, PublishAckListener var4);

    protected native String GetChatRoomStatusByKey(String var1, String var2);

    protected native HashMap<String, String> GetChatRoomStatus(String var1);

    protected native void SetChatRoomStatusNotificationListener(StatusNotificationListener var1);

    protected native void RTCSetUserResource(String var1, StatusData[] var2, String var3, StatusData[] var4, PublishAckListener var5);

    protected native void SetConversationStatusListener(ConversationStatusListener var1);

    protected native String GetRTCProfile();

    protected native boolean SetExtraMessageAttribute(String var1, int var2, String var3, String var4);

    protected native void SendRTCHeartbeat(String[] var1);

    protected native void SetRTCHeartbeatListener(RTCHeartbeatListener var1);

    protected native void JoinRTCRoomAndGetData(String var1, int var2, int var3, String var4, String var5, RTCUserInfoListener var6);

    protected native void SendRTCLiveInvitation(String var1, String var2, String var3, String var4, String var5, int var6, PublishAckListener var7);

    protected native void CancelRTCLiveInvitation(String var1, String var2, String var3, String var4, String var5, PublishAckListener var6);

    protected native void AnswerRTCLiveInvitation(String var1, int var2, String var3, String var4, String var5, String var6, String var7, String var8, PublishAckListener var9);

    protected native void HangupRTCLiveInvitation(String var1, String var2, String var3, String var4, String[] var5, PublishAckListener var6);

    public static interface RTCHeartbeatListener {
        public void OnRTCHeartbeat(int var1, String var2);
    }

    static interface SetOfflineMessageDurationListener {
        public void onSuccess(long var1);

        public void onError(int var1);
    }

    public static class PushConfig {
        private String notificationId;
        private boolean disablePushTitle;
        private String pushTitle;
        private String pushContent;
        private String pushData;
        private boolean forceShowDetailContent;
        private String channelConfig;

        public String getNotificationId() {
            return this.notificationId;
        }

        public void setNotificationId(String notificationId) {
            this.notificationId = notificationId;
        }

        public boolean isDisablePushTitle() {
            return this.disablePushTitle;
        }

        public void setDisablePushTitle(boolean disablePushTitle) {
            this.disablePushTitle = disablePushTitle;
        }

        public String getPushTitle() {
            return this.pushTitle;
        }

        public void setPushTitle(String pushTitle) {
            this.pushTitle = pushTitle;
        }

        public String getPushContent() {
            return this.pushContent;
        }

        public void setPushContent(String pushContent) {
            this.pushContent = pushContent;
        }

        public String getPushData() {
            return this.pushData;
        }

        public void setPushData(String pushData) {
            this.pushData = pushData;
        }

        public boolean isForceShowDetailContent() {
            return this.forceShowDetailContent;
        }

        public void setForceShowDetailContent(boolean forceShowDetailContent) {
            this.forceShowDetailContent = forceShowDetailContent;
        }

        public String getChannelConfig() {
            return this.channelConfig;
        }

        public void setChannelConfig(String channelConfig) {
            this.channelConfig = channelConfig;
        }
    }

    public static class StatusNotification {
        boolean notifyAll;
        int conversationType;
        int attributeFlag;
        String objectName;
        String messageContent;

        public boolean isNotifyAll() {
            return this.notifyAll;
        }

        public void setNotifyAll(boolean notifyAll) {
            this.notifyAll = notifyAll;
        }

        public int getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(int conversationType) {
            this.conversationType = conversationType;
        }

        public int getAttributeFlag() {
            return this.attributeFlag;
        }

        public void setAttributeFlag(int attributeFlag) {
            this.attributeFlag = attributeFlag;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public String getMessageContent() {
            return this.messageContent;
        }

        public void setMessageContent(String messageContent) {
            this.messageContent = messageContent;
        }
    }

    public static class StatusData {
        String key;
        String value;
        boolean autoDelete;
        boolean overwrite;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isAutoDelete() {
            return this.autoDelete;
        }

        public void setAutoDelete(boolean autoDelete) {
            this.autoDelete = autoDelete;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }
    }

    public static class UserProfile {
        boolean ipv6Preferred;
        boolean publicService;
        boolean pushSetting;
        boolean sdkReconnect;
        boolean kvStorageOpened;
        int groupMessageLimit;
        String clientIp;
        String identification;

        public boolean isKvStorageOpened() {
            return this.kvStorageOpened;
        }

        public void setKvStorageOpened(boolean kvStorageOpened) {
            this.kvStorageOpened = kvStorageOpened;
        }

        public boolean isIpv6Preferred() {
            return this.ipv6Preferred;
        }

        public void setIpv6Preferred(boolean ipv6Preferred) {
            this.ipv6Preferred = ipv6Preferred;
        }

        public boolean isPublicService() {
            return this.publicService;
        }

        public void setPublicService(boolean publicService) {
            this.publicService = publicService;
        }

        public boolean isPushSetting() {
            return this.pushSetting;
        }

        public void setPushSetting(boolean pushSetting) {
            this.pushSetting = pushSetting;
        }

        public boolean isSdkReconnect() {
            return this.sdkReconnect;
        }

        public void setSdkReconnect(boolean sdkReconnect) {
            this.sdkReconnect = sdkReconnect;
        }

        public int getGroupMessageLimit() {
            return this.groupMessageLimit;
        }

        public void setGroupMessageLimit(int groupMessageLimit) {
            this.groupMessageLimit = groupMessageLimit;
        }

        public String getClientIp() {
            return this.clientIp;
        }

        public void setClientIp(String clientIp) {
            this.clientIp = clientIp;
        }

        public String getIdentification() {
            return this.identification;
        }

        public void setIdentification(String identification) {
            this.identification = identification;
        }
    }

    public static class ConnectionEntry {
        private String host;
        private int port;
        private int netType;
        private int duration;
        private int error = -1;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getNetType() {
            return this.netType;
        }

        public void setNetType(int netType) {
            this.netType = netType;
        }

        public int getDuration() {
            return this.duration;
        }

        public void setDuration(int duration) {
            this.duration = duration;
        }

        public int getError() {
            return this.error;
        }

        public void setError(int error) {
            this.error = error;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionEntry that = (ConnectionEntry)o;
            if (this.port != that.port) {
                return false;
            }
            return this.host != null ? this.host.equals(that.host) : that.host == null;
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    public static class ReceiptInfo {
        private byte[] targetId;
        private long timestamp;

        public byte[] getTargetId() {
            return this.targetId;
        }

        public void setTargetId(byte[] targetId) {
            this.targetId = targetId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    public static class AccountInfo {
        private byte[] accountId;
        private byte[] accountName;
        private byte[] accountUri;
        private byte[] extra;
        private int accountType;

        public byte[] getAccountId() {
            return this.accountId;
        }

        public void setAccountId(byte[] accountId) {
            this.accountId = accountId;
        }

        public byte[] getAccountName() {
            return this.accountName;
        }

        public void setAccountName(byte[] accountName) {
            this.accountName = accountName;
        }

        public byte[] getAccountUri() {
            return this.accountUri;
        }

        public void setAccountUri(byte[] accountUri) {
            this.accountUri = accountUri;
        }

        public byte[] getExtra() {
            return this.extra;
        }

        public void setExtra(byte[] extra) {
            this.extra = extra;
        }

        public int getAccountType() {
            return this.accountType;
        }

        public void setAccountType(int accountType) {
            this.accountType = accountType;
        }
    }

    public static class DiscussionInfo {
        private String discussionId;
        private String discussionName;
        private String adminId;
        private String userIds;
        private int inviteStatus;

        public String getDiscussionId() {
            return this.discussionId;
        }

        public void setDiscussionId(String discussionId) {
            this.discussionId = discussionId;
        }

        public String getDiscussionName() {
            return this.discussionName;
        }

        public void setDiscussionName(byte[] data) {
            this.discussionName = new String(data);
        }

        public String getAdminId() {
            return this.adminId;
        }

        public void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        public String getUserIds() {
            return this.userIds;
        }

        public void setUserIds(String userIds) {
            this.userIds = userIds;
        }

        public int getInviteStatus() {
            return this.inviteStatus;
        }

        public void setInviteStatus(int inviteStatus) {
            this.inviteStatus = inviteStatus;
        }
    }

    public static class Conversation {
        private int conversationType;
        private String targetId;
        private String conversationTitle;
        private boolean isTop;
        private String draft;
        private int unreadMessageCount;
        private String objectName;
        private long messageId;
        private int readStatus;
        private int receiveStatus;
        private int sentStatus;
        private long ReceivedTime;
        private long sentTime;
        private String senderUserId;
        private String senderName;
        private boolean messageDirection;
        private String messageContent;
        private boolean blockPush;
        private long lastTime;
        private String userId;
        private String userName;
        private String userPortrait;
        private byte[] content;
        private String extra;
        private String portraitUrl;
        private String UId;
        private int mentionCount;
        private int matchCount;

        public Conversation(String jsonObj) {
        }

        public Conversation() {
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }

        public String getUId() {
            return this.UId;
        }

        public void setUId(String UId) {
            this.UId = UId;
        }

        public long getSentTime() {
            return this.sentTime;
        }

        public void setSentTime(long sentTime) {
            this.sentTime = sentTime;
        }

        public String getSenderUserId() {
            return this.senderUserId;
        }

        public void setSenderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
        }

        public boolean isMessageDirection() {
            return this.messageDirection;
        }

        public void setMessageDirection(boolean messageDirection) {
            this.messageDirection = messageDirection;
        }

        public void setIsTop(boolean isTop) {
            this.isTop = isTop;
        }

        public int getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(int conversationType) {
            this.conversationType = conversationType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public String getConversationTitle() {
            return this.conversationTitle;
        }

        public void setConversationTitle(byte[] conversationTitle) {
            this.conversationTitle = new String(conversationTitle);
        }

        public boolean isTop() {
            return this.isTop;
        }

        public void setTop(boolean isTop) {
            this.isTop = isTop;
        }

        public String getDraft() {
            return this.draft;
        }

        public void setDraft(String draft) {
            this.draft = draft;
        }

        public int getUnreadMessageCount() {
            return this.unreadMessageCount;
        }

        public void setUnreadMessageCount(int unreadMessageCount) {
            this.unreadMessageCount = unreadMessageCount;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public long getMessageId() {
            return this.messageId;
        }

        public void setMessageId(long messageId) {
            this.messageId = messageId;
        }

        public int getReceiveStatus() {
            return this.receiveStatus;
        }

        public void setReceiveStatus(int receiveStatus) {
            this.receiveStatus = receiveStatus;
        }

        public int getSentStatus() {
            return this.sentStatus;
        }

        public void setSentStatus(int sentStatus) {
            this.sentStatus = sentStatus;
        }

        public long getReceivedTime() {
            return this.ReceivedTime;
        }

        public void setReceivedTime(long receivedTime) {
            this.ReceivedTime = receivedTime;
        }

        public String getSenderName() {
            return this.senderName;
        }

        public void setSenderName(String senderName) {
            this.senderName = senderName;
        }

        public String getMessageContent() {
            return this.messageContent;
        }

        public void setMessageContent(String messageContent) {
            this.messageContent = messageContent;
        }

        public boolean isBlockPush() {
            return this.blockPush;
        }

        public void setBlockPush(boolean blockPush) {
            this.blockPush = blockPush;
        }

        public long getLastTime() {
            return this.lastTime;
        }

        public void setLastTime(long lastTime) {
            this.lastTime = lastTime;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUserPortrait() {
            return this.userPortrait;
        }

        public void setUserPortrait(String userPortrait) {
            this.userPortrait = userPortrait;
        }

        public int getReadStatus() {
            return this.readStatus;
        }

        public void setReadStatus(int readStatus) {
            this.readStatus = readStatus;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getPortraitUrl() {
            return this.portraitUrl;
        }

        public void setPortraitUrl(String portraitUrl) {
            this.portraitUrl = portraitUrl;
        }

        public int getMentionCount() {
            return this.mentionCount;
        }

        public void setMentionCount(int mentionCount) {
            this.mentionCount = mentionCount;
        }
    }

    public static class UserInfo {
        private String userId;
        private int categoryId;
        private String userName;
        private String url;
        private String accountExtra;
        private long joinTime;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public int getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(int categoryId) {
            this.categoryId = categoryId;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getAccountExtra() {
            return this.accountExtra;
        }

        public void setAccountExtra(String accountExtra) {
            this.accountExtra = accountExtra;
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public void setJoinTime(long joinTime) {
            this.joinTime = joinTime;
        }
    }

    public static class Message {
        private int conversationType;
        private String targetId;
        private long messageId;
        private boolean messageDirection;
        private String senderUserId;
        private int readStatus;
        private int sentStatus;
        private long receivedTime;
        private long sentTime;
        private long readTime;
        private String objectName;
        private byte[] content;
        private String extra;
        private String pushContent;
        private String UId;
        private String readReceiptInfo;
        private boolean isOffLine;
        private boolean disableNotification;
        private boolean extSupport;
        private String extMsg;
        private boolean disablePushTitle;
        private boolean forcePushDetail;
        private String pushTitle;
        private String pushId;
        private String pushConfig;

        public Message(JSONObject jsonObj) {
            this.conversationType = jsonObj.optInt("conversation_category");
            this.targetId = jsonObj.optString("target_id");
            this.messageId = jsonObj.optLong("id");
            this.messageDirection = jsonObj.optBoolean("message_direction");
            this.senderUserId = jsonObj.optString("sender_user_id");
            this.readStatus = jsonObj.optInt("read_status");
            this.sentStatus = jsonObj.optInt("send_status");
            this.receivedTime = jsonObj.optLong("receive_time");
            this.sentTime = jsonObj.optLong("send_time");
            this.objectName = jsonObj.optString("object_name");
            this.content = jsonObj.optString("content").getBytes();
            this.extra = jsonObj.optString("extra");
            this.pushContent = jsonObj.optString("push");
            this.extSupport = jsonObj.optBoolean("ext_support");
            this.extMsg = jsonObj.optString("ext_msg");
            this.disablePushTitle = jsonObj.optBoolean("disable_push_title");
            this.forcePushDetail = jsonObj.optBoolean("force_push_detail");
            this.pushTitle = jsonObj.optString("push_title");
            this.pushId = jsonObj.optString("push_id");
            this.pushConfig = jsonObj.optString("push_config");
        }

        public Message() {
        }

        public String getUId() {
            return this.UId;
        }

        public void setUId(String UId) {
            this.UId = UId;
        }

        public String getPushContent() {
            return this.pushContent;
        }

        public void setPushContent(String pushContent) {
            this.pushContent = pushContent;
        }

        public int getConversationType() {
            return this.conversationType;
        }

        public void setConversationType(int conversationType) {
            this.conversationType = conversationType;
        }

        public String getTargetId() {
            return this.targetId;
        }

        public void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        public long getMessageId() {
            return this.messageId;
        }

        public void setMessageId(long messageId) {
            this.messageId = messageId;
        }

        public boolean getMessageDirection() {
            return this.messageDirection;
        }

        public void setMessageDirection(boolean messageDirection) {
            this.messageDirection = messageDirection;
        }

        public int getReadStatus() {
            return this.readStatus;
        }

        public void setReadStatus(int readStatus) {
            this.readStatus = readStatus;
        }

        public int getSentStatus() {
            return this.sentStatus;
        }

        public void setSentStatus(int sentStatus) {
            this.sentStatus = sentStatus;
        }

        public long getReceivedTime() {
            return this.receivedTime;
        }

        public void setReceivedTime(long receivedTime) {
            this.receivedTime = receivedTime;
        }

        public long getSentTime() {
            return this.sentTime;
        }

        public void setSentTime(long sentTime) {
            this.sentTime = sentTime;
        }

        public long getReadTime() {
            return this.readTime;
        }

        public void setReadTime(long readTime) {
            this.readTime = readTime;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }

        public String getExtra() {
            return this.extra;
        }

        public void setExtra(String extra) {
            this.extra = extra;
        }

        public String getSenderUserId() {
            return this.senderUserId;
        }

        public void setSenderUserId(String senderUserId) {
            this.senderUserId = senderUserId;
        }

        public String getReadReceiptInfo() {
            return this.readReceiptInfo;
        }

        public void setReadReceiptInfo(String readReceiptInfo) {
            this.readReceiptInfo = readReceiptInfo;
        }

        public boolean isOffLine() {
            return this.isOffLine;
        }

        public void setOffLine(boolean offLine) {
            this.isOffLine = offLine;
        }

        public boolean isDisableNotification() {
            return this.disableNotification;
        }

        public void setDisableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
        }

        public boolean isExtSupport() {
            return this.extSupport;
        }

        public void setExtSupport(boolean extSupport) {
            this.extSupport = extSupport;
        }

        public String getExtMsg() {
            return this.extMsg;
        }

        public void setExtMsg(String extMsg) {
            this.extMsg = extMsg;
        }

        public boolean isDisablePushTitle() {
            return this.disablePushTitle;
        }

        public void setDisablePushTitle(boolean disablePushTitle) {
            this.disablePushTitle = disablePushTitle;
        }

        public boolean isForcePushDetail() {
            return this.forcePushDetail;
        }

        public void setForcePushDetail(boolean forcePushDetail) {
            this.forcePushDetail = forcePushDetail;
        }

        public String getPushTitle() {
            return this.pushTitle;
        }

        public void setPushTitle(String pushTitle) {
            this.pushTitle = pushTitle;
        }

        public String getPushId() {
            return this.pushId;
        }

        public void setPushId(String pushId) {
            this.pushId = pushId;
        }

        public String getPushConfig() {
            return this.pushConfig;
        }

        public void setPushConfig(String pushConfig) {
            this.pushConfig = pushConfig;
        }
    }

    public static interface FileTokenListener {
        public void OnError(int var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);
    }

    public static interface ConversationStatusListener {
        public void OnStatusChanged(ConversationStatus[] var1);
    }

    public static interface StatusNotificationListener {
        public void OnStatusChanged(String var1);

        public void OnKVChanged(ChatroomStatus[] var1);
    }

    public static interface UserStatusListener {
        public void onStatusReceived(String var1, String var2);
    }

    public static interface ChatroomInfoListener {
        public void OnSuccess(int var1, UserInfo[] var2);

        public void OnError(int var1);
    }

    public static interface HistoryMessageListener {
        public void onReceived(Message[] var1, long var2);

        public void onError(int var1);
    }

    public static interface GetUserDataListener {
        public void OnSuccess(String var1);

        public void OnError(int var1);
    }

    public static interface AccountInfoListener {
        public void onReceived(AccountInfo[] var1);

        public void OnError(int var1);
    }

    public static interface TokenListener {
        public void OnError(int var1, String var2);
    }

    public static interface SetBlacklistListener {
        public void OnSuccess(String var1);

        public void OnError(int var1);
    }

    public static interface BizAckListener {
        public void operationComplete(int var1, int var2);
    }

    public static interface DiscussionInfoListener {
        public void onReceived(DiscussionInfo var1);

        public void OnError(int var1);
    }

    public static interface SetPushSettingListener {
        public void onSuccess(long var1);

        public void onError(int var1);
    }

    public static interface PushSettingListener {
        public void OnSuccess(String var1, int var2);

        public void OnError(int var1);
    }

    public static abstract class ReceiveMessageListener {
        public abstract void onReceived(Message var1, int var2, boolean var3, boolean var4, int var5);

        public abstract void onReceived(Message[] var1, boolean var2, int var3);
    }

    public static interface RTCConfigListener {
        public void onSuccess(String var1, long var2);

        public void onError(int var1);
    }

    public static interface RTCDataListener {
        public void OnSuccess(Map<String, String> var1);

        public void OnError(int var1);
    }

    public static interface RTCUserInfoListener {
        public void OnSuccess(RTCUser[] var1, String var2, String var3, HashMap<String, String> var4);

        public void OnError(int var1);
    }

    public static interface NativeLogInfoListener {
        public void OnLogInfo(String var1, boolean var2);
    }

    public static interface GetSearchableWordListener {
        public byte[] getSearchableWord(String var1, byte[] var2);
    }

    public static interface CreateDiscussionCallback {
        public void OnSuccess(String var1);

        public void OnError(int var1);
    }

    public static interface PublishAckListener {
        public void operationComplete(int var1, String var2, long var3);
    }

    public static interface ConnectionStatusListener {
        public void OnTcpComplete(ConnectionEntry var1);

        public void OnRmtpComplete(int var1, String var2, int var3, short var4, String var5);

        public void OnRmtpDisconnected(int var1, int var2, String var3);

        public void OnPongReceived();

        public void OnDatabaseOpened(int var1);
    }
}

