/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.rong.common.FileUtils;
import io.rong.common.JSONUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.common.fwlog.LogSplitUtil;
import io.rong.common.rlog.IRealTimeLogListener;
import io.rong.imlib.ConnectionService;
import io.rong.imlib.HeartBeatManager;
import io.rong.imlib.HttpDnsManager;
import io.rong.imlib.IMessageExpansionListener;
import io.rong.imlib.MessageTag;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.SavePathUtils;
import io.rong.imlib.filetransfer.FtConst;
import io.rong.imlib.filetransfer.FtUtilities;
import io.rong.imlib.filetransfer.MediaDownloadEngine;
import io.rong.imlib.filetransfer.RequestCallBack;
import io.rong.imlib.filetransfer.RequestOption;
import io.rong.imlib.filetransfer.upload.MediaUploadEngine;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.ChatRoomMemberInfo;
import io.rong.imlib.model.ChatroomStatus;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageConfig;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.MessageExpansion;
import io.rong.imlib.model.MessagePushConfig;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.RemoteHistoryMsgOption;
import io.rong.imlib.model.SearchConversationResult;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.model.UnknownMessage;
import io.rong.imlib.model.UserData;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import io.rong.message.ChatRoomKVNotiMessage;
import io.rong.message.DiscussionNotificationMessage;
import io.rong.message.FileMessage;
import io.rong.message.GIFMessage;
import io.rong.message.HQVoiceMessage;
import io.rong.message.IHandleMessageListener;
import io.rong.message.ImageMessage;
import io.rong.message.LocationMessage;
import io.rong.message.LogCmdMessage;
import io.rong.message.MediaMessageContent;
import io.rong.message.MessageExpansionMessage;
import io.rong.message.MessageHandler;
import io.rong.message.RCEncryptedMessage;
import io.rong.message.SightMessage;
import io.rong.message.TextMessage;
import io.rong.message.utils.RCDHCodecTool;
import io.rong.rtlog.upload.RtLogUploadManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class NativeClient {
    private static final String TAG = "NativeClient";
    private static final int EXPANSION_MAX_COUNT = 300;
    private static final int EXPANSION_SINGLE_MAX_COUNT = 20;
    private static Context mContext = null;
    private NativeObject nativeObj;
    private Handler mWorkHandler;
    private String mFileServer;
    private String appKey;
    private String deviceId;
    private String dbPath;
    private String curUserId;
    private HashMap<String, Constructor<? extends MessageContent>> messageContentConstructorMap;
    private HashMap<String, MessageHandler> messageHandlerMap;
    private Set<String> mCmdObjectNameSet;
    private ConcurrentHashMap<String, Boolean> chatRoomStatusMap;
    private ScheduledThreadPoolExecutor executorService;
    private NavigationClient.NaviUpdateListener naviUpdateListener;
    private KVStatusListener mKVStatusListener;
    private static IMessageExpansionListener messageExpansionListener;
    private Executor receiveMessageExecutor;

    private MessageContent renderMessageContent(String objectName, byte[] content, Message message) {
        MessageContent result = this.newMessageContent(objectName, content);
        if (result instanceof UnknownMessage) {
            return result;
        }
        MessageHandler messageHandler = this.getMessageHandler(objectName);
        if (messageHandler != null) {
            messageHandler.decodeMessage(message, result);
        } else {
            io.rong.common.rlog.RLog.e(TAG, "renderMessageContent \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return result;
    }

    private NativeClient() {
        ConnectionService.getInstance();
    }

    public static NativeClient getInstance() {
        return NativeClientHolder.client;
    }

    public static Context getApplicationContext() {
        return mContext;
    }

    public void init(Context context, String appKey, String deviceId) {
        mContext = context.getApplicationContext();
        this.appKey = appKey;
        this.deviceId = deviceId;
        this.nativeObj = new NativeObject(context);
        this.messageHandlerMap = new HashMap();
        this.messageContentConstructorMap = new HashMap();
        this.mCmdObjectNameSet = new TreeSet<String>();
        this.chatRoomStatusMap = new ConcurrentHashMap();
        HandlerThread workThread = new HandlerThread("IPC_WORK");
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
        this.initThreadPool();
        File dbFile = mContext.getFilesDir();
        if (dbFile == null || !dbFile.exists()) {
            if (dbFile == null) {
                dbFile = mContext.getDir("rcdb", 0);
            } else {
                boolean successMkdir = dbFile.mkdirs();
                if (!successMkdir) {
                    RLog.e(TAG, "Created folders UnSuccessfully");
                }
            }
            this.dbPath = dbFile.getPath();
        } else {
            this.dbPath = dbFile.getPath();
        }
        int result = this.nativeObj.InitClient(appKey, context.getPackageName(), deviceId, this.dbPath, "4.1.0");
        ConnectionService.getInstance().initService(mContext, this.nativeObj, appKey);
        HeartBeatManager.getInstance().init(context, this.nativeObj);
        this.nativeObj.SetRealTimeLogListener(new IRealTimeLogListener(){

            @Override
            public void OnLogUpload(String data) {
                try {
                    JsonElement jsonElement = new JsonParser().parse(data);
                    JsonObject JsonObject2 = jsonElement.getAsJsonObject();
                    Set entries = JsonObject2.entrySet();
                    for (Map.Entry entry : entries) {
                        String key = (String)entry.getKey();
                        if (key.equals("level")) {
                            int level = ((JsonElement)entry.getValue()).getAsInt();
                            if (level < 0 || level > 6) continue;
                            io.rong.common.rlog.RLog.setLogLevel(level, false);
                            continue;
                        }
                        if (!key.equals("upload")) continue;
                        io.rong.common.rlog.RLog.uploadRLog(false);
                    }
                }
                catch (Exception e) {
                    io.rong.common.rlog.RLog.e("OnLogUpload", "json error:" + data, e);
                }
            }
        });
        ApplicationInfo info = context.getApplicationInfo();
        boolean isDebugMode = info != null && (info.flags & 2) != 0;
        this.setLogStatus(isDebugMode ? 2 : 3, new NativeObject.NativeLogInfoListener(){

            @Override
            public void OnLogInfo(String log, boolean upload) {
                FwLog.onProtocolLog(log, upload);
                io.rong.common.rlog.RLog.d("OnLogInfo", log);
            }
        });
        NavigationClient.getInstance().setNaviUpdateListener(new NavigationClient.NaviUpdateListener(){

            @Override
            public void onNaviUpdate() {
                RtLogUploadManager.getInstance().updateTimingUploadConfig(NavigationClient.getInstance().getUploadLogConfigInfo(mContext));
                if (NativeClient.this.naviUpdateListener != null) {
                    NativeClient.this.naviUpdateListener.onNaviUpdate();
                }
            }
        });
        FwLog.write(3, 1, FwLog.LogTag.L_INIT_O.getTag(), "appkey|deviceId|dbPath|initResult", appKey, deviceId, this.dbPath, result);
    }

    public void initAppendixModule() {
        RtLogUploadManager.getInstance().init(mContext, "4.1.0", this.deviceId, this.appKey);
        this.setChatRoomStatusNotificationListener();
    }

    private void initThreadPool() {
        this.executorService = new ScheduledThreadPoolExecutor(1, this.threadFactory("Get ChatRoomEntry", false));
        this.executorService.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.executorService.allowCoreThreadTimeOut(true);
        this.receiveMessageExecutor = Executors.newSingleThreadExecutor(this.threadFactory("IPC_RECEIVEMSG_WORK", false));
    }

    private ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    public void registerMessageType(Class<? extends MessageContent> msgType) {
        try {
            MessageTag tag = msgType.getAnnotation(MessageTag.class);
            if (tag != null) {
                String objName = tag.value();
                Constructor<? extends MessageContent> constructor = msgType.getDeclaredConstructor(byte[].class);
                Constructor<? extends MessageHandler> handlerConstructor = tag.messageHandler().getConstructor(Context.class);
                MessageHandler messageHandler = handlerConstructor.newInstance(mContext);
                this.messageHandlerMap.put(objName, messageHandler);
                this.messageContentConstructorMap.put(objName, constructor);
                this.registerMessageType(objName, tag.flag());
            } else {
                FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type" + msgType.getName(), new Object[0]);
            }
        }
        catch (Exception e) {
            FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type|stacks" + msgType.getName(), Arrays.toString(e.getStackTrace()));
        }
    }

    public void registerMessageType(List<Class<? extends MessageContent>> msgTypeList) {
        if (msgTypeList == null || msgTypeList.size() == 0) {
            return;
        }
        for (Class<? extends MessageContent> msgType : msgTypeList) {
            try {
                MessageTag tag = msgType.getAnnotation(MessageTag.class);
                if (tag != null) {
                    String objName = tag.value();
                    Constructor<? extends MessageContent> constructor = msgType.getDeclaredConstructor(byte[].class);
                    Constructor<? extends MessageHandler> handlerConstructor = tag.messageHandler().getConstructor(Context.class);
                    MessageHandler messageHandler = handlerConstructor.newInstance(mContext);
                    this.messageHandlerMap.put(objName, messageHandler);
                    this.messageContentConstructorMap.put(objName, constructor);
                    this.registerMessageType(objName, tag.flag());
                    continue;
                }
                FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type" + msgType.getName(), new Object[0]);
            }
            catch (Exception e) {
                FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type|stacks" + msgType.getName(), Arrays.toString(e.getStackTrace()));
            }
        }
    }

    private void registerMessageType(String objName, int flag) {
        int result = flag;
        if (flag == 16) {
            result = 0;
        }
        this.nativeObj.RegisterMessageType(objName, result);
    }

    void setIpcConnectTimeOut() {
        ConnectionService.getInstance().setIpcConnectTimeOut();
    }

    void initIPCEnviroment(String token, int status) {
        ConnectionService.getInstance().initIPCEnviroment(token, status);
    }

    void connect(String token, boolean isReconnect, boolean inForeground, IConnectResultCallback<String> callback) {
        this.setEnvInfo(mContext);
        RtLogUploadManager.getInstance().startTimingUploadTask();
        ConnectionService.getInstance().connect(token, isReconnect, inForeground, callback);
    }

    public String getCurrentUserId() {
        if (TextUtils.isEmpty((CharSequence)this.curUserId)) {
            this.curUserId = NavigationClient.getInstance().getUserId(mContext);
            return this.curUserId;
        }
        return this.curUserId;
    }

    void setCurrentUserId(String userId) {
        this.curUserId = userId;
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean isReceivePush) {
        ConnectionService.getInstance().disconnect(isReceivePush);
    }

    public List<Conversation> getConversationList() {
        int[] conversationTypes = new int[]{Conversation.ConversationType.PRIVATE.getValue(), Conversation.ConversationType.DISCUSSION.getValue(), Conversation.ConversationType.GROUP.getValue(), Conversation.ConversationType.SYSTEM.getValue()};
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.getConversationList(conversationTypes);
    }

    public List<Conversation> getConversationList(int[] conversationTypeValues) {
        NativeObject.Conversation[] conversations = null;
        try {
            conversations = this.nativeObj.GetConversationListEx(conversationTypeValues);
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "getConversationList Exception", e);
        }
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    public List<Conversation> getBlockedConversationList(int[] conversationTypes) {
        NativeObject.Conversation[] conversations = this.nativeObj.GetBlockedConversations(conversationTypes);
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    public List<Conversation> getTopConversationList(int[] conversationTypes) {
        NativeObject.Conversation[] conversations = null;
        try {
            conversations = this.nativeObj.GetTopConversations(conversationTypes);
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "getTopConversationList Exception", e);
        }
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    public List<Conversation> getConversationListByPage(int[] conversationTypeValues, long timeStamp, int count) {
        NativeObject.Conversation[] conversations = null;
        try {
            conversations = this.nativeObj.GetConversationList(conversationTypeValues, timeStamp, count);
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "getConversationListByPage Exception", e);
        }
        if (conversations == null) {
            return null;
        }
        ArrayList<Conversation> result = new ArrayList<Conversation>();
        for (NativeObject.Conversation item : conversations) {
            result.add(this.renderConversationFromNative(item));
        }
        return result;
    }

    private Conversation renderConversationFromNative(NativeObject.Conversation conversation) {
        Conversation result = new Conversation();
        result.setTargetId(conversation.getTargetId());
        result.setLatestMessageId((int)conversation.getMessageId());
        result.setConversationTitle(conversation.getConversationTitle());
        result.setUnreadMessageCount(conversation.getUnreadMessageCount());
        result.setConversationType(Conversation.ConversationType.setValue(conversation.getConversationType()));
        result.setTop(conversation.isTop());
        result.setObjectName(conversation.getObjectName());
        if (conversation.getMessageId() > 0L) {
            Message message = new Message();
            message.setMessageId((int)conversation.getMessageId());
            message.setSenderUserId(conversation.getSenderUserId());
            result.setLatestMessage(this.renderMessageContent(conversation.getObjectName(), conversation.getContent(), message));
        }
        result.setReceivedStatus(new Message.ReceivedStatus(conversation.getReadStatus()));
        result.setReceivedTime(conversation.getReceivedTime());
        result.setSentTime(conversation.getSentTime());
        result.setSenderUserId(conversation.getSenderUserId());
        result.setSentStatus(Message.SentStatus.setValue(conversation.getSentStatus()));
        result.setSenderUserName(conversation.getSenderName());
        result.setDraft(conversation.getDraft());
        result.setPortraitUrl(conversation.getPortraitUrl());
        result.setNotificationStatus(conversation.isBlockPush() ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB : Conversation.ConversationNotificationStatus.NOTIFY);
        result.setMentionedCount(conversation.getMentionCount());
        return result;
    }

    public Conversation getConversation(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationType \u548c TargetId \u53c2\u6570\u5f02\u5e38");
        }
        NativeObject.Conversation conversation = this.nativeObj.GetConversationEx(targetId, conversationType.getValue());
        if (conversation == null) {
            return null;
        }
        Conversation c = this.renderConversationFromNative(conversation);
        c.setConversationType(conversationType);
        return c;
    }

    public boolean removeConversation(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)targetId.trim())) {
            throw new IllegalArgumentException("ConversationType \u548c TargetId \u53c2\u6570\u5f02\u5e38");
        }
        targetId = targetId.trim();
        return this.nativeObj.RemoveConversation(conversationType.getValue(), targetId);
    }

    public boolean setConversationToTop(Conversation.ConversationType conversationType, String targetId, boolean isTop, boolean needCreate) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38");
        }
        return this.nativeObj.SetIsTop(conversationType.getValue(), targetId, isTop, needCreate);
    }

    private void preCheck(Object ... params) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (params == null) {
            return;
        }
        for (Object param : params) {
            if (param != null && (!(param instanceof String) || !TextUtils.isEmpty((CharSequence)((String)param)))) continue;
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38");
        }
    }

    private String replaceNullStr(String string2) {
        return string2 == null ? "" : string2;
    }

    public boolean createEncryptedConversation(String targetId, RCEncryptedSession chatInfo) {
        this.preCheck(targetId, chatInfo);
        return this.nativeObj.CreateEncryptedConversation(this.replaceNullStr(targetId), this.replaceNullStr(chatInfo.getTargetId()), this.replaceNullStr(chatInfo.getRemoteEncId()), this.replaceNullStr(chatInfo.getEncKey()), this.replaceNullStr(chatInfo.getEncXA()), chatInfo.getEncStatus());
    }

    public RCEncryptedSession getEncryptedConversation(String targetId) {
        this.preCheck(targetId);
        RCEncryptedSession chaInfo = this.nativeObj.GetEncryptedConversationInfo(targetId);
        io.rong.common.rlog.RLog.d(TAG, "getEncryptedConversation --> " + (chaInfo == null ? "null" : chaInfo.toString()));
        return chaInfo;
    }

    public List<RCEncryptedSession> getAllEncryptedConversations() {
        this.preCheck(new Object[0]);
        return this.nativeObj.GetEncryptedConversations();
    }

    public boolean setEncryptedConversation(String targetId, RCEncryptedSession chatInfo) {
        this.preCheck(targetId, chatInfo);
        return this.nativeObj.SetEncryptedConversationInfo(this.replaceNullStr(targetId), this.replaceNullStr(chatInfo.getTargetId()), this.replaceNullStr(chatInfo.getRemoteEncId()), this.replaceNullStr(chatInfo.getEncKey()), this.replaceNullStr(chatInfo.getEncXA()), chatInfo.getEncStatus());
    }

    public boolean removeEncryptedConversation(String targetId) {
        this.preCheck(targetId);
        return this.nativeObj.RemoveEncryptedConversation(this.replaceNullStr(targetId));
    }

    public boolean clearEncryptedConversations() {
        this.preCheck(new Object[0]);
        return this.nativeObj.ClearEncryptedConversations();
    }

    public int getTotalUnreadCount() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.GetTotalUnreadCount();
    }

    public int getUnreadCount(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            throw new IllegalArgumentException("ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38");
        }
        return this.nativeObj.GetUnreadCount(targetId, conversationType.getValue());
    }

    public int getMessageCount(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId) || conversationType == null) {
            throw new IllegalArgumentException("ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38");
        }
        return this.nativeObj.GetMessageCount(targetId, conversationType.getValue());
    }

    public int getTotalUnreadCount(Conversation ... conversations) {
        NativeObject.Conversation[] nativeConversations = new NativeObject.Conversation[conversations.length];
        for (int i = 0; i < conversations.length; ++i) {
            NativeObject.Conversation conversation = new NativeObject.Conversation();
            conversation.setConversationType(conversations[i].getConversationType().getValue());
            conversation.setTargetId(conversations[i].getTargetId());
            nativeConversations[i] = conversation;
        }
        return this.nativeObj.GetDNDUnreadCount(nativeConversations);
    }

    public int getUnreadCount(Conversation.ConversationType ... conversationTypes) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            throw new IllegalArgumentException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.GetCateUnreadCount(conversationTypeValues, true);
    }

    public int getUnreadCount(boolean withDND, Conversation.ConversationType ... conversationTypes) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            throw new IllegalArgumentException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.GetCateUnreadCount(conversationTypeValues, withDND);
    }

    public List<Message> getLatestMessages(Conversation.ConversationType conversationType, String targetId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        return this.getHistoryMessages(conversationType, targetId, -1L, count);
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, long oldestMessageId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] array = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), "", oldestMessageId, count, true);
        ArrayList<Message> list = new ArrayList<Message>();
        if (array == null) {
            return list;
        }
        for (NativeObject.Message item : array) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, long oldestMessageId, int count) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), objectName, oldestMessageId, count, true);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, String objectName, long oldestMessageId, int count, boolean direction) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)objectName)) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesEx(targetId, conversationType.getValue(), objectName, oldestMessageId, count, direction);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public List<Message> getHistoryMessages(Conversation.ConversationType conversationType, String targetId, List<String> objectNames, long timestamp, int count, boolean direction) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || objectNames == null || objectNames.size() == 0) {
            throw new IllegalArgumentException("ConversationTypes, objectName \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        int size = objectNames.size();
        NativeObject.Message[] messages = this.nativeObj.GetHistoryMessagesByObjectNames(targetId, conversationType.getValue(), objectNames.toArray(new String[size]), timestamp, count, direction);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages == null) {
            return null;
        }
        for (NativeObject.Message item : messages) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    public void getRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, long dataTime, int count, final IResultCallback<List<Message>> callback) {
        io.rong.common.rlog.RLog.i(TAG, "getRemoteHistoryMessages call");
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("ConversationTypes\uff0ccallback \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        if (NavigationClient.getInstance().isGetRemoteHistoryEnabled(mContext)) {
            this.nativeObj.LoadHistoryMessage(targetId, conversationType.getValue(), dataTime, count, new NativeObject.HistoryMessageListener(){

                @Override
                public void onReceived(NativeObject.Message[] messages, long timestamp) {
                    ArrayList<Message> list = new ArrayList<Message>();
                    if (messages != null && messages.length > 0) {
                        for (NativeObject.Message item : messages) {
                            Message msg = new Message(item);
                            msg.setContent(NativeClient.this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                            list.add(msg);
                        }
                    }
                    callback.onSuccess(list);
                }

                @Override
                public void onError(int status) {
                    callback.onError(status);
                }
            });
        } else {
            callback.onError(33007);
        }
    }

    public void getRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, RemoteHistoryMsgOption remoteHistoryMsgOption, final IResultCallback<List<Message>> callback) {
        io.rong.common.rlog.RLog.i(TAG, "getRemoteHistoryMessages call");
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("ConversationTypes\uff0ccallback \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        if (NavigationClient.getInstance().isGetRemoteHistoryEnabled(mContext)) {
            this.nativeObj.LoadHistoryMessageOption(targetId, conversationType.getValue(), remoteHistoryMsgOption.getDataTime(), remoteHistoryMsgOption.getCount(), remoteHistoryMsgOption.getOrder(), remoteHistoryMsgOption.isIncludeLocalExistMessage(), new NativeObject.HistoryMessageListener(){

                @Override
                public void onReceived(NativeObject.Message[] messages, long timestamp) {
                    ArrayList<Message> list = new ArrayList<Message>();
                    if (messages != null && messages.length > 0) {
                        for (NativeObject.Message item : messages) {
                            Message msg = new Message(item);
                            msg.setContent(NativeClient.this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                            list.add(msg);
                        }
                    }
                    callback.onSuccess(list);
                }

                @Override
                public void onError(int status) {
                    callback.onError(status);
                }
            });
        } else {
            callback.onError(33007);
        }
    }

    public void getChatroomHistoryMessages(String targetId, long recordTime, int count, int order, final IResultCallbackEx<List<Message>, Long> callback) {
        io.rong.common.rlog.RLog.i(TAG, "getChatroomHistoryMessages");
        if (NavigationClient.getInstance().isChatroomHistoryEnabled(mContext)) {
            this.nativeObj.GetChatroomHistoryMessage(targetId, recordTime, count, order, new NativeObject.HistoryMessageListener(){

                @Override
                public void onReceived(NativeObject.Message[] messages, long timestamp) {
                    ArrayList<Message> list = new ArrayList<Message>();
                    if (messages != null && messages.length > 0) {
                        for (NativeObject.Message item : messages) {
                            Message msg = new Message(item);
                            msg.setContent(NativeClient.this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                            list.add(msg);
                        }
                    }
                    callback.onSuccess(list, timestamp);
                }

                @Override
                public void onError(int status) {
                    callback.onError(status);
                }
            });
        } else {
            callback.onError(23414);
        }
    }

    public void getUserStatus(String userId, final IResultCallbackEx<String, Integer> resultCallbackEx) {
        this.nativeObj.GetUserStatus(userId, new NativeObject.CreateDiscussionCallback(){

            @Override
            public void OnSuccess(String platformInfo) {
                resultCallbackEx.onSuccess(platformInfo, 0);
            }

            @Override
            public void OnError(int errorCode) {
                resultCallbackEx.onError(errorCode);
            }
        });
    }

    public void subscribeStatus(List<String> users, final IResultCallbackEx<Integer, Integer> resultCallbackEx) {
        int userSize = users.size();
        this.nativeObj.SubscribeStatus(users.toArray(new String[userSize]), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int opStatus, String msg_uid, long timestamp) {
                if (opStatus == 0) {
                    resultCallbackEx.onSuccess(opStatus, 0);
                } else {
                    resultCallbackEx.onError(opStatus);
                }
            }
        });
    }

    public void setSubscribeStatusListener(final IResultCallbackEx<String, String> resultCallback) {
        this.nativeObj.SetSubscribeStatusListener(new NativeObject.UserStatusListener(){

            @Override
            public void onStatusReceived(String objName, String content) {
                resultCallback.onSuccess(objName, content);
            }
        });
    }

    public void setPushSetting(int key, String value, final IResultCallback<Long> resultCallback) {
        this.nativeObj.SetPushSetting(key, value, new NativeObject.SetPushSettingListener(){

            @Override
            public void onSuccess(long version) {
                resultCallback.onSuccess(version);
            }

            @Override
            public void onError(int code) {
                resultCallback.onError(code);
            }
        });
    }

    public String getPushSetting(int key) {
        return this.nativeObj.GetPushSetting(key);
    }

    public void setUserStatus(int status, final IResultCallback<Integer> resultCallback) {
        this.nativeObj.SetUserStatus(status, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int errorCode, String token, long timestamp) {
                if (errorCode == 0) {
                    resultCallback.onSuccess(0);
                } else {
                    resultCallback.onError(errorCode);
                }
            }
        });
    }

    public boolean deleteMessages(int[] messageIds) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        int msgLength = messageIds.length;
        if (messageIds == null || msgLength == 0) {
            throw new IllegalArgumentException("MessageIds \u53c2\u6570\u5f02\u5e38\u3002");
        }
        long[] lIds = new long[msgLength];
        for (int i = 0; i < msgLength; ++i) {
            lIds[i] = messageIds[i];
        }
        return this.nativeObj.DeleteMessages(lIds);
    }

    public boolean deleteMessage(Conversation.ConversationType conversationType, String targetId) {
        return this.nativeObj.ClearMessages(conversationType.getValue(), targetId, true);
    }

    public void deleteMessages(Conversation.ConversationType conversationType, String targetId, Message[] messages, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        NativeObject.Message[] nativeMessages = new NativeObject.Message[messages.length];
        StringBuilder uIds = new StringBuilder();
        for (int i = 0; i < messages.length; ++i) {
            nativeMessages[i] = new NativeObject.Message();
            nativeMessages[i].setUId(messages[i].getUId());
            nativeMessages[i].setSentTime(messages[i].getSentTime());
            nativeMessages[i].setMessageDirection(messages[i].getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE));
            uIds.append(messages[i].getUId()).append("/");
        }
        FwLog.write(4, 1, FwLog.LogTag.L_DELETE_MESSAGES_S.getTag(), "messageUIds:", uIds.toString());
        this.nativeObj.DeleteRemoteMessages(conversationType.getValue(), targetId, nativeMessages, true, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public boolean clearMessages(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.ClearMessages(conversationType.getValue(), targetId, false);
    }

    public void cleanRemoteHistoryMessages(Conversation.ConversationType conversationType, String targetId, long recordTime, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.CleanRemoteHistoryMessage(conversationType.getValue(), targetId, recordTime, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int opStatus, String msg_uid, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (opStatus == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(opStatus);
                }
            }
        });
    }

    public void cleanHistoryMessages(Conversation.ConversationType conversationType, String targetId, long recordTime, OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        boolean result = this.nativeObj.CleanHistoryMessages(conversationType.getValue(), targetId, recordTime);
        if (callback != null) {
            if (result) {
                callback.onSuccess();
            } else {
                callback.onError(-1);
            }
        }
    }

    public boolean clearMessagesUnreadStatus(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.ClearUnread(conversationType.getValue(), targetId);
    }

    public boolean setMessageExtra(int messageId, String value) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (messageId == 0) {
            throw new IllegalArgumentException("messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetMessageExtra(messageId, value);
    }

    public boolean setMessageReceivedStatus(int messageId, Message.ReceivedStatus receivedStatus) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (receivedStatus == null || messageId == 0) {
            throw new IllegalArgumentException("receivedStatus \u6216 messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetReadStatus(messageId, receivedStatus.getFlag());
    }

    public boolean setMessageSentStatus(int messageId, Message.SentStatus sentStatus) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (sentStatus == null || messageId == 0) {
            throw new IllegalArgumentException("sentStatus \u6216 messageId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetSendStatus(messageId, sentStatus.getValue());
    }

    public String getTextMessageDraft(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.GetTextMessageDraft(conversationType.getValue(), targetId);
    }

    public boolean saveTextMessageDraft(Conversation.ConversationType conversationType, String targetId, String content) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        return this.nativeObj.SetTextMessageDraft(conversationType.getValue(), targetId, content);
    }

    public boolean clearTextMessageDraft(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String draft = this.getTextMessageDraft(conversationType, targetId);
        if (!TextUtils.isEmpty((CharSequence)draft)) {
            return this.saveTextMessageDraft(conversationType, targetId, "");
        }
        return true;
    }

    public void getDiscussion(String discussionId, final IResultCallback<Discussion> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException(" discussionId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        NativeObject.DiscussionInfo discussionInfo = this.nativeObj.GetDiscussionInfoSync(discussionId);
        if (discussionInfo != null) {
            Discussion discussion = new Discussion(discussionInfo);
            if (discussion.getMemberIdList() == null || discussion.getMemberIdList().size() == 0) {
                this.nativeObj.GetDiscussionInfo(discussionId, new NativeObject.DiscussionInfoListener(){

                    @Override
                    public void onReceived(NativeObject.DiscussionInfo info) {
                        if (callback != null) {
                            callback.onSuccess(new Discussion(info));
                        }
                    }

                    @Override
                    public void OnError(int status) {
                        if (callback != null) {
                            callback.onError(status);
                        }
                    }
                });
            } else if (callback != null) {
                callback.onSuccess(discussion);
            }
        } else {
            this.nativeObj.GetDiscussionInfo(discussionId, new NativeObject.DiscussionInfoListener(){

                @Override
                public void onReceived(NativeObject.DiscussionInfo info) {
                    if (callback != null) {
                        callback.onSuccess(new Discussion(info));
                    }
                }

                @Override
                public void OnError(int status) {
                    if (callback != null) {
                        callback.onError(status);
                    }
                }
            });
        }
    }

    public void setDiscussionName(String discussionId, String name, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)discussionId.trim()) || TextUtils.isEmpty((CharSequence)name) || TextUtils.isEmpty((CharSequence)name.trim())) {
            throw new IllegalArgumentException(" discussionId \u6216 name \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RenameDiscussion(discussionId, name, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void createDiscussion(String name, List<String> userIdList, final IResultCallback<String> callback) {
        if (!TextUtils.isEmpty((CharSequence)this.curUserId)) {
            userIdList.remove(this.curUserId);
        }
        String[] ids = new String[userIdList.size()];
        userIdList.toArray(ids);
        this.nativeObj.CreateInviteDiscussion(name, ids, new NativeObject.CreateDiscussionCallback(){

            @Override
            public void OnError(int errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }

            @Override
            public void OnSuccess(String discussionId) {
                if (callback != null) {
                    callback.onSuccess(discussionId);
                }
            }
        });
    }

    public void searchPublicService(String keyWords, int businessType, int searchType, final IResultCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (keyWords == null) {
            throw new IllegalArgumentException("keyWords \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SearchAccount(keyWords, businessType, searchType, new NativeObject.AccountInfoListener(){

            @Override
            public void onReceived(NativeObject.AccountInfo[] info) {
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                for (NativeObject.AccountInfo accountInfo : info) {
                    PublicServiceProfile item = new PublicServiceProfile();
                    item.setTargetId(new String(accountInfo.getAccountId()));
                    item.setName(new String(accountInfo.getAccountName()));
                    item.setPublicServiceType(Conversation.ConversationType.setValue(accountInfo.getAccountType()));
                    item.setPortraitUri(Uri.parse((String)new String(accountInfo.getAccountUri())));
                    String ss = new String(accountInfo.getExtra());
                    io.rong.common.rlog.RLog.i(NativeClient.TAG, "getPublicAccountInfoList extra:" + ss);
                    item.setExtra(ss);
                    list.add(item);
                }
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void subscribePublicService(String targetId, int categoryId, boolean subscribe, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SubscribeAccount(targetId, categoryId, subscribe, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getPublicServiceProfile(String targetId, int categoryId, IResultCallback<PublicServiceProfile> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (targetId == null) {
            throw new IllegalArgumentException("targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        if (callback != null) {
            PublicServiceProfile serviceInfo = new PublicServiceProfile();
            NativeObject.UserInfo info = this.nativeObj.GetUserInfoExSync(targetId, categoryId);
            if (info != null) {
                serviceInfo.setTargetId(targetId);
                serviceInfo.setName(info.getUserName());
                if (info.getUrl() != null) {
                    serviceInfo.setPortraitUri(Uri.parse((String)info.getUrl()));
                }
                serviceInfo.setPublicServiceType(Conversation.ConversationType.setValue(info.getCategoryId()));
                serviceInfo.setExtra(info.getAccountExtra());
                callback.onSuccess(serviceInfo);
            } else {
                io.rong.common.rlog.RLog.e(TAG, "Public service info is null");
                callback.onError(RongIMClient.ErrorCode.RC_PUBLIC_SERVICE_PROFILE_NOT_EXIST.getValue());
            }
        }
    }

    public void getPublicServiceList(IResultCallback<PublicServiceProfileList> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("RongIMClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback != null) {
            NativeObject.AccountInfo[] info = this.nativeObj.LoadAccountInfo();
            if (info != null && info.length > 0) {
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                for (NativeObject.AccountInfo accountInfo : info) {
                    PublicServiceProfile item = new PublicServiceProfile();
                    item.setTargetId(new String(accountInfo.getAccountId()));
                    item.setName(new String(accountInfo.getAccountName()));
                    item.setPublicServiceType(Conversation.ConversationType.setValue(accountInfo.getAccountType()));
                    item.setPortraitUri(Uri.parse((String)new String(accountInfo.getAccountUri())));
                    String ss = new String(accountInfo.getExtra());
                    item.setExtra(ss);
                    list.add(item);
                }
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            } else {
                io.rong.common.rlog.RLog.e(TAG, "Public service list is empty");
                ArrayList<PublicServiceProfile> list = new ArrayList<PublicServiceProfile>();
                PublicServiceProfileList infoList = new PublicServiceProfileList(list);
                callback.onSuccess(infoList);
            }
        }
    }

    public void addMemberToDiscussion(String discussionId, List<String> userIdList, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || userIdList == null || userIdList.size() == 0) {
            throw new IllegalArgumentException("discussionId \u6216 userIdList \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String[] ids = new String[userIdList.size()];
        userIdList.toArray(ids);
        this.nativeObj.InviteMemberToDiscussion(discussionId, ids, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void removeMemberFromDiscussion(String discussionId, String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId) || TextUtils.isEmpty((CharSequence)userId)) {
            throw new IllegalArgumentException("discussionId \u6216 userId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemoveMemberFromDiscussion(discussionId, userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void quitDiscussion(String discussionId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)discussionId)) {
            throw new IllegalArgumentException("discussionId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QuitDiscussion(discussionId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public Message getMessage(int messageId) {
        NativeObject.Message nativeMsg = this.nativeObj.GetMessageById(messageId);
        if (nativeMsg == null) {
            return null;
        }
        Message message = new Message(nativeMsg);
        MessageContent content = this.renderMessageContent(nativeMsg.getObjectName(), nativeMsg.getContent(), message);
        message.setContent(content);
        return message;
    }

    private String getSearchableWord(MessageContent content) {
        List<String> list;
        String filteredStr = "";
        if (content != null && (list = content.getSearchableWord()) != null && list.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String str : list) {
                builder.append(str).append("\n");
            }
            filteredStr = builder.toString();
        }
        return filteredStr;
    }

    public void sendMessage(Conversation.ConversationType conversationType, String targetId, MessageContent content, String pushContent, String pushData, ISendMessageCallback<Message> callback) {
        Message message = Message.obtain(targetId, conversationType, content);
        this.sendMessage(message, pushContent, pushData, null, callback);
    }

    public void sendMessage(Message message, String pushContent, String pushData, String[] userIds, ISendMessageCallback<Message> callback) {
        boolean isMentioned;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("message, ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            io.rong.common.rlog.RLog.e(TAG, "sendMessage MessageTag is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        boolean supportExtension = message.isCanIncludeExpansion();
        long currentTs = this.timeDisposal(message);
        String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
        String extSend = JSONUtils.hashMapToJson(message.getExpansion());
        byte[] data = new byte[1];
        if ((msgTag.flag() & 1) == 1 && message.getMessageId() <= 0) {
            int id;
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            if ((id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "", isDisableNotification, supportExtension, extMsg)) < 0) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        int type = msgTag.flag() == 16 ? 1 : 3;
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            io.rong.common.rlog.RLog.e(TAG, "sendMessage MessageHandler is null");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.encodeMessage(message);
        data = message.getContent().encode();
        if (callback != null) {
            callback.onAttached(message);
        }
        boolean bl = isMentioned = message.getContent().getMentionedInfo() != null;
        if (message.getMessageId() > 0) {
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        }
        this.internalSendMessage(message, pushContent, pushData, userIds, callback, msgTag, data, type, isMentioned, supportExtension, extSend);
    }

    public void sendMessageOption(Message message, String pushContent, String pushData, SendMessageOption option, String[] userIds, ISendMessageCallback<Message> callback) {
        this.sendMessageOption(message, pushContent, pushData, option, userIds, false, callback);
    }

    public void sendMessageOption(Message message, String pushContent, String pushData, SendMessageOption option, String[] userIds, boolean isFilterBlackList, ISendMessageCallback<Message> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("message, ConversationType \u6216 TargetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        boolean supportExtension = message.isCanIncludeExpansion();
        long currentTs = this.timeDisposal(message);
        String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
        String extSend = JSONUtils.hashMapToJson(message.getExpansion());
        byte[] data = new byte[1];
        if ((msgTag.flag() & 1) == 1 && message.getMessageId() <= 0) {
            int id;
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            if ((id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "", isDisableNotification, supportExtension, extMsg)) < 0) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        int type = msgTag.flag() == 16 ? 1 : 3;
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            io.rong.common.rlog.RLog.e(TAG, "sendMessage MessageHandler is null");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.encodeMessage(message);
        data = message.getContent().encode();
        if (callback != null) {
            callback.onAttached(message);
        }
        boolean isMentioned = message.getContent().getMentionedInfo() != null;
        boolean isVoIPPush = false;
        if (option != null) {
            isVoIPPush = option.isVoIPPush();
        }
        if (message.getMessageId() > 0) {
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        }
        this.internalSendMessage(message, pushContent, pushData, userIds, callback, msgTag, data, type, isMentioned, isVoIPPush, isFilterBlackList, supportExtension, extSend);
    }

    private void internalSendMessage(Message message, String pushContent, String pushData, String[] userIds, ISendMessageCallback<Message> callback, MessageTag msgTag, byte[] data, int type, boolean isMentioned, boolean supportExtension, String extMsg) {
        this.internalSendMessage(message, pushContent, pushData, userIds, callback, msgTag, data, type, isMentioned, false, false, supportExtension, extMsg);
    }

    private void internalSendMessage(final Message message, String pushContent, String pushData, String[] userIds, final ISendMessageCallback<Message> callback, final MessageTag msgTag, byte[] data, int type, boolean isMentioned, boolean isVoIPPush, boolean isFilterBlackList, boolean supportExtension, String extMsg) {
        byte[] encodeData;
        Message waitingToSendMessage;
        if (message.getConversationType() == Conversation.ConversationType.ENCRYPTED) {
            try {
                waitingToSendMessage = this.encryptMessageContentIfNeeded(data, message);
                encodeData = waitingToSendMessage.getContent().encode();
            }
            catch (RuntimeException e) {
                io.rong.common.rlog.RLog.e(TAG, "stop sending message cause exception occurs while calling encrypteMessageContent() -> " + e.getLocalizedMessage());
                return;
            }
        } else {
            waitingToSendMessage = message;
            encodeData = data;
        }
        if (waitingToSendMessage.getContent() instanceof MediaMessageContent) {
            Uri localPath = ((MediaMessageContent)waitingToSendMessage.getContent()).getLocalPath();
            MessageHandler handler = this.getMessageHandler(msgTag.value());
            handler.encodeMessage(message);
            ((MediaMessageContent)waitingToSendMessage.getContent()).setLocalPath(null);
            encodeData = waitingToSendMessage.getContent().encode();
            ((MediaMessageContent)waitingToSendMessage.getContent()).setLocalPath(localPath);
        }
        MessageConfig messageConfig = message.getMessageConfig();
        boolean isDisableNotification = false;
        if (messageConfig != null) {
            isDisableNotification = messageConfig.isDisableNotification();
        }
        NativeObject.PushConfig pushConfig = new NativeObject.PushConfig();
        MessagePushConfig messagePushConfig = message.getMessagePushConfig();
        if (messagePushConfig != null) {
            pushConfig.setPushTitle(messagePushConfig.getPushTitle());
            if (TextUtils.isEmpty((CharSequence)messagePushConfig.getPushContent())) {
                pushConfig.setPushContent(pushContent);
            } else {
                pushConfig.setPushContent(messagePushConfig.getPushContent());
            }
            if (TextUtils.isEmpty((CharSequence)messagePushConfig.getPushData())) {
                pushConfig.setPushData(pushData);
            } else {
                pushConfig.setPushData(messagePushConfig.getPushData());
            }
            pushConfig.setForceShowDetailContent(messagePushConfig.isForceShowDetailContent());
            if (messagePushConfig.getAndroidConfig() != null) {
                pushConfig.setNotificationId(messagePushConfig.getAndroidConfig().getNotificationId());
            }
            pushConfig.setChannelConfig(messagePushConfig.channelToJson());
        } else {
            pushConfig.setPushContent(pushContent);
            pushConfig.setPushData(pushData);
        }
        this.nativeObj.sendMessageWithOption(waitingToSendMessage.getTargetId(), waitingToSendMessage.getConversationType().getValue(), type, msgTag.value(), encodeData, pushConfig, waitingToSendMessage.getMessageId(), userIds, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "sendMessage code = " + code + ", id = " + message.getMessageId() + ", uid = " + msgUId + " " + message.getObjectName());
                if (code == 0) {
                    message.setSentStatus(Message.SentStatus.SENT);
                    message.setSentTime(sendTime);
                    message.setUId(msgUId);
                    if (callback != null) {
                        callback.onSuccess(message);
                    }
                } else {
                    FwLog.write(1, 1, FwLog.LogTag.P_SEND_MSG_S.getTag(), "code|type|id|tag", code, message.getConversationType().getValue(), message.getTargetId(), msgTag.value());
                    if (code == RongIMClient.ErrorCode.RC_MSG_BLOCKED_SENSITIVE_WORD.getValue()) {
                        NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                        message.setSentStatus(Message.SentStatus.FAILED);
                    } else if (code == RongIMClient.ErrorCode.RC_MSG_REPLACED_SENSITIVE_WORD.getValue()) {
                        message.setSentStatus(Message.SentStatus.SENT);
                        message.setSentTime(sendTime);
                        message.setUId(msgUId);
                    } else {
                        message.setSentStatus(Message.SentStatus.FAILED);
                    }
                    if (callback != null) {
                        callback.onError(message, code);
                    }
                }
            }
        }, isMentioned, isVoIPPush, isFilterBlackList, isDisableNotification, supportExtension, extMsg);
    }

    private Message encryptMessageContentIfNeeded(byte[] content, Message message) throws RuntimeException {
        String targetId = message.getTargetId();
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            throw new RuntimeException("error! message TargetId is empty. message -> " + message.toString());
        }
        String[] ids = targetId.split(";;;");
        if (ids.length != 2) {
            throw new RuntimeException("error occurs while spliting targetId -> " + targetId);
        }
        RCEncryptedSession encryptedSession = this.nativeObj.GetEncryptedConversationInfo(targetId);
        if (encryptedSession == null) {
            throw new RuntimeException("error ! getEncryptedConversationInfo is null.");
        }
        String encKeyStr = encryptedSession.getEncKey();
        RCDHCodecTool.RCSecretKey encKey = RCDHCodecTool.fromString2RCSecretKey(encKeyStr);
        if (encKey == null) {
            throw new RuntimeException("error occurs when transfering encKey.");
        }
        byte[] encryptedData = RCDHCodecTool.encrypt(content, encKey);
        String encryptedContent = Base64.encodeToString((byte[])encryptedData, (int)2);
        RCEncryptedMessage encContent = new RCEncryptedMessage();
        encContent.setEncryptedContent(encryptedContent);
        encContent.setOriginalObjName(message.getObjectName());
        encContent.setRemoteEncId(encryptedSession.getRemoteEncId());
        Message encMsg = Message.obtain(ids[1], message.getConversationType(), encContent);
        encMsg.setObjectName(encContent.getClass().getAnnotation(MessageTag.class).value());
        encMsg.setExtra(message.getExtra());
        encMsg.setMessageDirection(message.getMessageDirection());
        encMsg.setMessageId(message.getMessageId());
        encMsg.setUId(message.getUId());
        encMsg.setReadReceiptInfo(message.getReadReceiptInfo());
        encMsg.setReadTime(message.getReadTime());
        encMsg.setSenderUserId(message.getSenderUserId());
        encMsg.setSentStatus(message.getSentStatus());
        encMsg.setReceivedStatus(message.getReceivedStatus());
        encMsg.setSentTime(message.getSentTime());
        encMsg.setReceivedTime(message.getReceivedTime());
        return encMsg;
    }

    public void sendLocationMessage(Message message, final String pushContent, final String pushData, final ISendMessageCallback<Message> callback) {
        int id;
        final MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setMessageDirection(Message.MessageDirection.SEND);
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = message.getContent().encode();
        MessageConfig messageConfig = message.getMessageConfig();
        boolean isDisableNotification = false;
        final boolean supportExtension = message.isCanIncludeExpansion();
        long currentTs = this.timeDisposal(message);
        String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
        final String extSend = JSONUtils.hashMapToJson(message.getExpansion());
        if (messageConfig != null) {
            isDisableNotification = messageConfig.isDisableNotification();
        }
        if ((id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "", isDisableNotification, supportExtension, extMsg)) < 0 && callback != null) {
            message.setSentStatus(Message.SentStatus.FAILED);
            if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            } else {
                callback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
            }
            return;
        }
        message.setMessageId(id);
        if (callback != null) {
            message.setSentStatus(Message.SentStatus.SENDING);
            callback.onAttached(message);
        }
        if (message.getMessageId() == 0) {
            io.rong.common.rlog.RLog.e(TAG, "Location Message saved error");
            if (callback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            io.rong.common.rlog.RLog.e(TAG, "MessageHandler is null");
            if (callback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        handler.setHandleMessageListener(new IHandleMessageListener(){

            @Override
            public void onHandleResult(Message message, int resultCode) {
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "onHandleResult " + ((LocationMessage)message.getContent()).getImgUri());
                if (resultCode == 0) {
                    boolean isMentioned = NativeClient.this.isMentionedMessage(message);
                    byte[] data = message.getContent().encode();
                    NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
                    NativeClient.this.internalSendMessage(message, pushContent, pushData, null, callback, msgTag, data, 3, isMentioned, supportExtension, extSend);
                } else {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                    if (callback != null) {
                        callback.onError(message, 30014);
                    }
                }
            }
        });
        handler.encodeMessage(message);
    }

    public void sendMediaMessage(final Message message, String[] userIds, final String pushContent, final String pushData, final ISendMediaMessageCallback<Message> mediaMessageCallback) {
        final String[] receiverIds = userIds;
        final MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (TextUtils.isEmpty((CharSequence)message.getSenderUserId())) {
            message.setSenderUserId(this.curUserId);
        }
        message.setSentTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        final boolean supportExtension = message.isCanIncludeExpansion();
        long currentTs = this.timeDisposal(message);
        String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
        final String extSend = JSONUtils.hashMapToJson(message.getExpansion());
        byte[] data = new byte[1];
        final boolean isMentioned = message.getContent().getMentionedInfo() != null;
        final MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
        final MessageHandler handler = this.getMessageHandler(msgTag.value());
        if (handler == null) {
            io.rong.common.rlog.RLog.e(TAG, "sendMediaMessage MessageHandler is null");
            if (mediaMessageCallback != null) {
                mediaMessageCallback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        if (message.getMessageId() <= 0) {
            int id;
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            if ((id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), message.getSenderUserId(), data, false, 0, Message.SentStatus.SENDING.getValue(), System.currentTimeMillis(), this.getSearchableWord(message.getContent()), 1, "", isDisableNotification, supportExtension, extMsg)) < 0 && mediaMessageCallback != null) {
                message.setSentStatus(Message.SentStatus.FAILED);
                if (id == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue()) {
                    mediaMessageCallback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
                } else {
                    mediaMessageCallback.onError(message, RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue());
                }
                return;
            }
            message.setMessageId(id);
        }
        message.setSentStatus(Message.SentStatus.SENDING);
        message.setMessageDirection(Message.MessageDirection.SEND);
        handler.encodeMessage(message);
        data = message.getContent().encode();
        this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        if (mediaMessageCallback != null) {
            mediaMessageCallback.onAttached(message);
        }
        if (mediaMessageContent.getMediaUrl() == null || mediaMessageContent.getMediaUrl() != null && TextUtils.isEmpty((CharSequence)mediaMessageContent.getMediaUrl().toString())) {
            IResultProgressCallback<String> progressCallback = new IResultProgressCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    mediaMessageContent.setMediaUrl(Uri.parse((String)s));
                    handler.encodeMessage(message);
                    message.setContent(mediaMessageContent);
                    byte[] finalData = mediaMessageContent.encode();
                    NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), finalData, "");
                    NativeClient.this.internalSendMessage(message, pushContent, pushData, receiverIds, new ISendMessageCallback<Message>(){

                        @Override
                        public void onAttached(Message message) {
                        }

                        @Override
                        public void onSuccess(Message message) {
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onSuccess(message);
                            }
                        }

                        @Override
                        public void onError(Message message, int code) {
                            if (mediaMessageCallback != null) {
                                mediaMessageCallback.onError(message, code);
                            }
                        }
                    }, msgTag, finalData, 3, isMentioned, supportExtension, extSend);
                }

                @Override
                public void onProgress(int progress) {
                    io.rong.common.rlog.RLog.i(NativeClient.TAG, "upload onProgress " + progress);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onProgress(message, progress);
                    }
                }

                @Override
                public void onError(int code) {
                    message.setSentStatus(Message.SentStatus.FAILED);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onError(message, code);
                    }
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.FAILED.getValue());
                }

                @Override
                public void onCanceled(int messageId) {
                    message.setSentStatus(Message.SentStatus.CANCELED);
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onCanceled(message);
                    }
                    NativeClient.this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.CANCELED.getValue());
                }
            };
            this.uploadMedia(message, progressCallback);
        } else {
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            this.internalSendMessage(message, pushContent, pushData, receiverIds, new ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                }

                @Override
                public void onSuccess(Message message) {
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onSuccess(message);
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (mediaMessageCallback != null) {
                        mediaMessageCallback.onError(message, code);
                    }
                }
            }, msgTag, data, 3, isMentioned, supportExtension, extSend);
        }
    }

    public void sendMediaMessage(Message message, String pushContent, String pushData, ISendMediaMessageCallback<Message> mediaMessageCallback) {
        this.sendMediaMessage(message, null, pushContent, pushData, mediaMessageCallback);
    }

    public Message insertMessage(Conversation.ConversationType conversationType, String targetId, String senderUserId, MessageContent content, long sentTime) {
        MessageHandler handler;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if (msgTag.flag() == 16) {
            io.rong.common.rlog.RLog.e(TAG, "insertMessage MessageTag can not be STATUS.");
            return null;
        }
        String sender = senderUserId;
        Message message = new Message();
        message.setConversationType(conversationType);
        message.setTargetId(targetId);
        if (TextUtils.isEmpty((CharSequence)sender)) {
            sender = this.curUserId;
        }
        if (TextUtils.isEmpty((CharSequence)this.curUserId)) {
            message.setMessageDirection(Message.MessageDirection.SEND);
            message.setSentStatus(Message.SentStatus.SENT);
        } else {
            message.setMessageDirection(this.curUserId.equals(sender) ? Message.MessageDirection.SEND : Message.MessageDirection.RECEIVE);
            message.setSentStatus(this.curUserId.equals(sender) ? Message.SentStatus.SENT : Message.SentStatus.RECEIVED);
        }
        message.setSenderUserId(sender);
        message.setReceivedTime(sentTime);
        message.setSentTime(sentTime);
        message.setObjectName(msgTag.value());
        message.setContent(content);
        byte[] data = new byte[1];
        if (message.getMessageId() <= 0) {
            boolean direction = message.getMessageDirection() != null && message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE);
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            boolean supportExtension = message.isCanIncludeExpansion();
            long currentTs = this.timeDisposal(message);
            String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            int id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), sender, data, direction, 0, Message.SentStatus.SENDING.getValue(), message.getSentTime(), this.getSearchableWord(message.getContent()), 1, "", isDisableNotification, supportExtension, extMsg);
            message.setMessageId(id);
        }
        if ((handler = this.getMessageHandler(msgTag.value())) != null) {
            handler.encodeMessage(message);
            data = message.getContent().encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            this.nativeObj.SetSendStatus(message.getMessageId(), Message.SentStatus.SENT.getValue());
            io.rong.common.rlog.RLog.d(TAG, "insertMessage Inserted, id = " + message.getMessageId());
        } else {
            io.rong.common.rlog.RLog.e(TAG, "insertMessage \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return message;
    }

    public Message insertSettingMessage(Message message) {
        MessageHandler handler;
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        MessageTag msgTag = message.getContent().getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            throw new RuntimeException("\u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
        }
        if (msgTag.flag() == 16) {
            io.rong.common.rlog.RLog.e(TAG, "insertMessage MessageTag can not be STATUS.");
            return null;
        }
        String sender = message.getSenderUserId();
        if (TextUtils.isEmpty((CharSequence)sender)) {
            sender = this.curUserId;
        }
        if (TextUtils.isEmpty((CharSequence)this.curUserId)) {
            message.setMessageDirection(Message.MessageDirection.SEND);
            message.setSentStatus(Message.SentStatus.SENT);
        } else if (message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
            message.setSentStatus(Message.SentStatus.RECEIVED);
        }
        message.setReceivedTime(System.currentTimeMillis());
        message.setObjectName(msgTag.value());
        byte[] data = new byte[1];
        if (message.getMessageId() <= 0) {
            boolean direction = message.getMessageDirection() != null && message.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE);
            int markUnread = message.getMessageDirection() == Message.MessageDirection.RECEIVE && message.getReceivedStatus().getFlag() == 0 && msgTag.flag() == 3 ? 0 : 1;
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            boolean supportExtension = message.isCanIncludeExpansion();
            long currentTs = this.timeDisposal(message);
            String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            int id = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), msgTag.value(), sender, data, direction, message.getReceivedStatus().getFlag(), message.getSentStatus().getValue(), message.getSentTime(), this.getSearchableWord(message.getContent()), markUnread, "", isDisableNotification, supportExtension, extMsg);
            message.setMessageId(id);
        }
        if ((handler = this.getMessageHandler(msgTag.value())) != null) {
            handler.encodeMessage(message);
            data = message.getContent().encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            this.nativeObj.SetSendStatus(message.getMessageId(), message.getSentStatus().getValue());
            io.rong.common.rlog.RLog.d(TAG, "insertMessage Inserted, id = " + message.getMessageId());
        } else {
            io.rong.common.rlog.RLog.e(TAG, "insertMessage \u8be5\u6d88\u606f\u672a\u6ce8\u518c\uff0c\u8bf7\u8c03\u7528registerMessageType\u65b9\u6cd5\u6ce8\u518c\u3002");
        }
        return message;
    }

    public void uploadMedia(Message message, IResultProgressCallback<String> callback) {
        if (message == null || message.getConversationType() == null || TextUtils.isEmpty((CharSequence)message.getTargetId()) || message.getContent() == null) {
            io.rong.common.rlog.RLog.e(TAG, "conversation type or targetId or message content can't be null!");
            callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            return;
        }
        Uri localPath = null;
        if (message.getContent() instanceof ImageMessage) {
            localPath = ((ImageMessage)message.getContent()).getLocalUri();
        } else if (message.getContent() instanceof GIFMessage) {
            long length = ((GIFMessage)message.getContent()).getGifDataSize();
            if (length > (long)(this.getGIFLimitSize() * 1024)) {
                io.rong.common.rlog.RLog.e(TAG, "Gif size is too long! ");
                callback.onError(RongIMClient.ErrorCode.RC_GIF_MSG_SIZE_LIMIT_EXCEED.getValue());
                return;
            }
            localPath = ((GIFMessage)message.getContent()).getLocalPath();
        } else if (message.getObjectName() != null && message.getObjectName().equals("RC:SightMsg")) {
            int duration = ((SightMessage)message.getContent()).getDuration();
            if (duration > this.getVideoLimitTime()) {
                io.rong.common.rlog.RLog.e(TAG, "sight duration is too long! ");
                callback.onError(RongIMClient.ErrorCode.RC_SIGHT_MSG_DURATION_LIMIT_EXCEED.getValue());
                return;
            }
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath();
        } else if (message.getContent() instanceof HQVoiceMessage) {
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath();
        } else if (message.getObjectName() != null && message.getObjectName().equals("RC:CombineMsg")) {
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath();
        } else if (message.getContent() instanceof MediaMessageContent) {
            localPath = ((MediaMessageContent)message.getContent()).getLocalPath();
        }
        if (!FileUtils.isFileExistsWithUri(mContext, localPath)) {
            io.rong.common.rlog.RLog.e(TAG, "local path of the media file can't be empty!");
            callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            return;
        }
        MediaUploadEngine.getInstance().uploadMedia(this.mWorkHandler, this.nativeObj, message, localPath, this.mFileServer, callback);
    }

    public void downloadMedia(Conversation.ConversationType conversationType, String targetId, int type, final String imageUrl, final IResultProgressCallback<String> callback) {
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || TextUtils.isEmpty((CharSequence)imageUrl)) {
            throw new IllegalArgumentException("conversationType\uff0cimageUrl \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String path = FileUtils.getCachePath(mContext, "download");
        String fileName = FtUtilities.getFileName(path, DeviceUtils.ShortMD5(2, imageUrl));
        long fileLength = 0L;
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        MediaDownloadEngine.getInstance().setMediaPath(path);
        MediaDownloadEngine.getInstance().download(-1, imageUrl, fileLength, new RequestOption(fileName, FtConst.MimeType.setValue(type), new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(1, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, 0, imageUrl, diff, code);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMedia onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String url) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(url);
                long fileSize = file.length();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, imageUrl, diff, 0);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMedia onComplete fileUri =" + url);
                callback.onSuccess(url);
            }

            @Override
            public void onProgress(int progress) {
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), true, 0, imageUrl, diff, 0);
            }
        }));
    }

    public void downloadMediaMessage(final Message message, final IDownloadMediaMessageCallback<Message> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        String remoteUrl = null;
        String name = "";
        long length = 0L;
        String dir = "media";
        FtConst.MimeType type = FtConst.MimeType.NONE;
        if (message.getContent() instanceof ImageMessage && ((ImageMessage)message.getContent()).getRemoteUri() != null) {
            remoteUrl = ((ImageMessage)message.getContent()).getRemoteUri().toString();
            name = DeviceUtils.ShortMD5(2, remoteUrl);
            type = FtConst.MimeType.FILE_IMAGE;
            dir = "image";
        } else if (message.getContent() instanceof GIFMessage && ((GIFMessage)message.getContent()).getRemoteUri() != null) {
            GIFMessage gifMessage = (GIFMessage)message.getContent();
            remoteUrl = gifMessage.getRemoteUri().toString();
            name = DeviceUtils.ShortMD5(2, remoteUrl) + ".gif";
            length = gifMessage.getGifDataSize();
            type = FtConst.MimeType.FILE_IMAGE;
            dir = "image";
        } else if (message.getContent() instanceof FileMessage && ((FileMessage)message.getContent()).getFileUrl() != null) {
            remoteUrl = ((FileMessage)message.getContent()).getFileUrl().toString();
            FileMessage fileMessage = (FileMessage)message.getContent();
            name = fileMessage.getName();
            if (TextUtils.isEmpty((CharSequence)name)) {
                name = DeviceUtils.ShortMD5(2, remoteUrl);
            }
            length = fileMessage.getSize();
            type = FtUtilities.getMimeType(fileMessage.getType());
            dir = "file";
            MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
            mediaMessageContent.setLocalPath(null);
            byte[] data = mediaMessageContent.encode();
            this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
        } else if (message.getContent() instanceof HQVoiceMessage && ((HQVoiceMessage)message.getContent()).getFileUrl() != null) {
            HQVoiceMessage voiceMessage = (HQVoiceMessage)message.getContent();
            remoteUrl = voiceMessage.getFileUrl().toString();
            name = voiceMessage.getName();
            if (TextUtils.isEmpty((CharSequence)name)) {
                name = DeviceUtils.ShortMD5(2, remoteUrl);
            }
            type = FtConst.MimeType.FILE_AUDIO;
            dir = "audio";
        } else if (message.getContent() instanceof MediaMessageContent && ((MediaMessageContent)message.getContent()).getMediaUrl() != null) {
            remoteUrl = ((MediaMessageContent)message.getContent()).getMediaUrl().toString();
            name = ((MediaMessageContent)message.getContent()).getName();
            if (TextUtils.isEmpty((CharSequence)name)) {
                name = DeviceUtils.ShortMD5(2, remoteUrl);
            }
            type = FtConst.MimeType.FILE_TEXT_PLAIN;
            dir = "file";
            if (message.getContent() instanceof SightMessage) {
                length = ((SightMessage)message.getContent()).getSize();
                dir = "video";
            }
        }
        if (TextUtils.isEmpty((CharSequence)remoteUrl)) {
            io.rong.common.rlog.RLog.e(TAG, "remoteUrl of the media file can't be empty!");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        String path = FileUtils.getMediaDownloadDir(mContext, dir);
        String fileName = FtUtilities.getFileName(path, name);
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        final String finalRemoteUrl = remoteUrl;
        MediaDownloadEngine.getInstance().setMediaPath(path);
        MediaDownloadEngine.getInstance().download(message.getMessageId(), remoteUrl, length, new RequestOption(fileName, type, message.getMessageId(), new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(1, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, 0, finalRemoteUrl, diff, code);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMediaMessage onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String localUrl) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(localUrl);
                long fileSize = file.length();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, finalRemoteUrl, diff, 0);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMediaMessage onComplete fileUri =" + localUrl);
                MediaMessageContent mediaMessageContent = (MediaMessageContent)message.getContent();
                if (!FileUtils.isValidateLocalUri(Uri.parse((String)localUrl))) {
                    localUrl = "file://" + localUrl;
                }
                mediaMessageContent.setLocalPath(Uri.parse((String)localUrl));
                callback.onSuccess(message);
                byte[] data = mediaMessageContent.encode();
                NativeClient.this.nativeObj.SetMessageContent(message.getMessageId(), data, "");
            }

            @Override
            public void onProgress(int progress) {
                io.rong.common.rlog.RLog.i(NativeClient.TAG, "download onProgress " + progress);
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), true, 0, finalRemoteUrl, diff, 0);
                callback.onCanceled();
            }
        }));
    }

    public void downloadMediaFile(String uid, String fileUrl, String fileName, String path, final IDownloadMediaFileCallback<Boolean> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        final FtConst.MimeType mimeType = FtUtilities.getMimeType(fileName);
        final Date start = new Date(System.currentTimeMillis());
        final String finalRemoteUrl = fileUrl;
        String savedPath = FtUtilities.getFileName(path, fileName);
        String pausePath = FileUtils.getTempFilePath(mContext, uid);
        if (!new File(pausePath).exists()) {
            try {
                String newFileName = savedPath.substring(path.length() + 1);
                if (!newFileName.equals(fileName)) {
                    callback.onFileNameChanged(newFileName);
                }
            }
            catch (Exception e) {
                io.rong.common.rlog.RLog.e(TAG, "downloadMediaFile", e);
            }
        }
        MediaDownloadEngine.getInstance().setMediaPath(savedPath);
        MediaDownloadEngine.getInstance().download(uid, fileUrl, new RequestOption(savedPath, mimeType, new RequestCallBack(){

            @Override
            public void onError(int code) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(1, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, 0, finalRemoteUrl, diff, code);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMediaMessage onError code =" + code);
                callback.onError(code);
            }

            @Override
            public void onComplete(String localUrl) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                File file = new File(localUrl);
                long fileSize = file.length();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), false, fileSize / 1024L, finalRemoteUrl, diff, 0);
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "downloadMediaMessage onComplete fileUri =" + localUrl);
                callback.onSuccess(true);
            }

            @Override
            public void onProgress(int progress) {
                io.rong.common.rlog.RLog.i(NativeClient.TAG, "download onProgress " + progress);
                callback.onProgress(progress);
            }

            @Override
            public void onCanceled(Object tag) {
                Date end = new Date(System.currentTimeMillis());
                long diff = end.getTime() - start.getTime();
                FwLog.write(4, 1, FwLog.LogTag.L_MEDIA_S.getTag(), "type|media_type|user_stop|size|fileUri|duration|code", "download", mimeType.getName(), true, 0, finalRemoteUrl, diff, 0);
                callback.onCanceled();
            }
        }));
    }

    public void getConversationNotificationStatus(Conversation.ConversationType conversationType, String targetId, IResultCallback<Integer> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("conversationType \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int status = this.nativeObj.GetBlockPush(targetId, conversationType.getValue());
        callback.onSuccess(status == 100 ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB.getValue() : Conversation.ConversationNotificationStatus.NOTIFY.getValue());
    }

    public void setConversationNotificationStatus(Conversation.ConversationType conversationType, String targetId, final Conversation.ConversationNotificationStatus notificationStatus, final IResultCallback<Integer> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || notificationStatus == null || TextUtils.isEmpty((CharSequence)targetId) || callback == null) {
            throw new IllegalArgumentException("conversationType, notificationStatus \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SetBlockPush(targetId, conversationType.getValue(), notificationStatus == Conversation.ConversationNotificationStatus.DO_NOT_DISTURB, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int status, String uid, long time) {
                if (status == 0) {
                    callback.onSuccess(notificationStatus == Conversation.ConversationNotificationStatus.DO_NOT_DISTURB ? Conversation.ConversationNotificationStatus.DO_NOT_DISTURB.getValue() : Conversation.ConversationNotificationStatus.NOTIFY.getValue());
                } else {
                    io.rong.common.rlog.RLog.d(NativeClient.TAG, "setConversationNotificationStatus operationComplete: status = " + status);
                    callback.onError(status);
                }
            }
        });
    }

    public void setDiscussionInviteStatus(String targetId, int status, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SetInviteStatus(targetId, status, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int statusCode, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (statusCode == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(statusCode);
                }
            }
        });
    }

    public void syncGroup(List<Group> groups, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (groups == null || groups.size() == 0) {
            throw new IllegalArgumentException(" groups \u53c2\u6570\u5f02\u5e38\u3002");
        }
        String[] ids = new String[groups.size()];
        String[] names = new String[groups.size()];
        int i = 0;
        for (Group item : groups) {
            ids[i] = item.getId();
            names[i++] = item.getName();
        }
        this.nativeObj.SyncGroups(ids, names, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void joinGroup(String groupId, String groupName, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)groupId) || TextUtils.isEmpty((CharSequence)groupName)) {
            throw new IllegalArgumentException("groupId \u6216 groupName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        this.nativeObj.JoinGroup(groupId, groupName, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void quitGroup(String groupId, final OperationCallback callback) {
        this.nativeObj.QuitGroup(groupId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (callback == null) {
                    return;
                }
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    private void handleReceivedMessage(NativeObject.Message nativeMessage, int left, boolean offline, boolean hasMsg, int cmdLeft, OnReceiveMessageListener listener) {
        final Message message = new Message(nativeMessage);
        String objectName = message.getObjectName();
        MessageContent content = this.renderMessageContent(nativeMessage.getObjectName(), nativeMessage.getContent(), message);
        if (objectName.equals("RC:EncryptedMsg")) {
            this.handleEncryptedMessage(message, content);
        } else {
            message.setContent(content);
        }
        if (message.getContent() instanceof DiscussionNotificationMessage) {
            DiscussionNotificationMessage discussionNotificationMessage = (DiscussionNotificationMessage)message.getContent();
            if (!this.curUserId.equals(discussionNotificationMessage.getOperator()) && discussionNotificationMessage.getType() == 4) {
                String extension = discussionNotificationMessage.getExtension();
                if (!TextUtils.isEmpty((CharSequence)extension)) {
                    String[] targetIds;
                    for (String targetId : targetIds = extension.split(",")) {
                        this.nativeObj.RemoveMemberFromDiscussionSync(message.getTargetId(), targetId);
                    }
                }
            } else {
                this.nativeObj.GetDiscussionInfo(message.getTargetId(), new NativeObject.DiscussionInfoListener(){

                    @Override
                    public void onReceived(NativeObject.DiscussionInfo info) {
                    }

                    @Override
                    public void OnError(int status) {
                    }
                });
            }
        }
        if (message.getContent() instanceof LogCmdMessage) {
            RtLogUploadManager.getInstance().createFullUploadTask(message);
        }
        if (message.getContent() instanceof MessageExpansionMessage) {
            if (this.mWorkHandler != null) {
                this.mWorkHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NativeClient.this.handleExpansionMsg(message);
                    }
                });
            }
            return;
        }
        if (listener != null) {
            listener.onReceived(message, left, offline, hasMsg, cmdLeft);
        }
    }

    public void setOnReceiveMessageListener(final OnReceiveMessageListener listener) {
        this.nativeObj.SetMessageListener(new NativeObject.ReceiveMessageListener(){

            @Override
            public void onReceived(final NativeObject.Message nativeMessage, final int left, final boolean offline, final boolean hasMsg, final int cmdLeft) {
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "onReceived onLine message:");
                NativeClient.this.receiveMessageExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        NativeClient.this.handleReceivedMessage(nativeMessage, left, offline, hasMsg, cmdLeft, listener);
                    }
                });
            }

            @Override
            public void onReceived(final NativeObject.Message[] nativeMessages, final boolean hasMsg, final int totalCmd) {
                io.rong.common.rlog.RLog.d(NativeClient.TAG, "onReceived batch of messages.");
                NativeClient.this.receiveMessageExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        int total = nativeMessages.length;
                        int cmdLeft = totalCmd;
                        for (int i = 0; i < total; ++i) {
                            int left = total - i - 1;
                            if (NativeClient.this.mCmdObjectNameSet.contains(nativeMessages[i].getObjectName())) {
                                --cmdLeft;
                            }
                            NativeClient.this.handleReceivedMessage(nativeMessages[i], left, nativeMessages[i].isOffLine(), hasMsg, cmdLeft, listener);
                        }
                    }
                });
            }
        });
        this.nativeObj.SetGetSearchableWordListener(new NativeObject.GetSearchableWordListener(){

            @Override
            public byte[] getSearchableWord(String objectName, byte[] content) {
                String filteredStr = "";
                MessageContent result = NativeClient.this.newMessageContent(objectName, content);
                if (result instanceof UnknownMessage) {
                    io.rong.common.rlog.RLog.e(NativeClient.TAG, "result is UnknownMessage");
                } else {
                    filteredStr = NativeClient.getInstance().getSearchableWord(result);
                }
                return filteredStr.getBytes();
            }
        });
    }

    private void handleEncryptedMessage(Message message, MessageContent messageContent) {
        if (message.getSenderUserId() != null && message.getSenderUserId().equals(this.getCurrentUserId())) {
            io.rong.common.rlog.RLog.d(TAG, "encryptedMsg from the same endpoint , do nothing.");
            return;
        }
        if (messageContent == null) {
            io.rong.common.rlog.RLog.e(TAG, "render EncryptedMsgContent returns null.");
            return;
        }
        RCEncryptedMessage encMsgContent = (RCEncryptedMessage)messageContent;
        String encId = encMsgContent.getRemoteEncId();
        String targetId = message.getTargetId();
        RCEncryptedSession encryptedSession = this.nativeObj.GetEncryptedConversationInfo(encId + ";;;" + targetId);
        if (encryptedSession == null) {
            io.rong.common.rlog.RLog.w(TAG, "GetEncryptedConversationInfo of " + encId + ";;;" + targetId + " is null ");
            return;
        }
        String encKey = encryptedSession.getEncKey();
        if (TextUtils.isEmpty((CharSequence)encKey)) {
            io.rong.common.rlog.RLog.w(TAG, "result is null when getEncKey from encryptedSesseion of ->" + encId + ";;;" + targetId);
            return;
        }
        RCDHCodecTool.RCSecretKey secretKey = RCDHCodecTool.fromString2RCSecretKey(encKey);
        if (encMsgContent.getEncryptedContent() == null) {
            io.rong.common.rlog.RLog.e(TAG, "instance of RCEncryptedMessage getEncryptedContent() returns null.");
            return;
        }
        if (secretKey == null) {
            io.rong.common.rlog.RLog.e(TAG, "secretKey is null.");
            return;
        }
        byte[] data2Dec = Base64.decode((String)encMsgContent.getEncryptedContent(), (int)2);
        byte[] decryptContent = RCDHCodecTool.decrypt(data2Dec, secretKey);
        MessageContent originalMsgContent = this.renderMessageContent(encMsgContent.getOriginalObjName(), decryptContent, message);
        message.setContent(originalMsgContent);
        message.setObjectName(encMsgContent.getOriginalObjName());
        message.setTargetId(encId + ";;;" + targetId);
        message.setConversationType(Conversation.ConversationType.ENCRYPTED);
        message.setMessageId(message.getMessageId());
        MessageTag originMsgTag = originalMsgContent.getClass().getAnnotation(MessageTag.class);
        if ((originMsgTag.flag() & 1) == 1) {
            boolean isCount = (originMsgTag.flag() & 3) == 3;
            int markUnread = isCount ? 0 : 1;
            MessageConfig messageConfig = message.getMessageConfig();
            boolean isDisableNotification = false;
            boolean supportExtension = message.isCanIncludeExpansion();
            long currentTs = this.timeDisposal(message);
            String extMsg = JSONUtils.mapTsCombineJson(message.getExpansion(), currentTs);
            if (messageConfig != null) {
                isDisableNotification = messageConfig.isDisableNotification();
            }
            int messageId = (int)this.nativeObj.SaveMessage(message.getTargetId(), message.getConversationType().getValue(), message.getObjectName(), message.getSenderUserId(), decryptContent, true, 0, Message.SentStatus.RECEIVED.getValue(), message.getSentTime(), this.getSearchableWord(originalMsgContent), markUnread, message.getUId(), isDisableNotification, supportExtension, extMsg);
            message.setMessageId(messageId);
        }
    }

    public void setConnectionStatusListener(ICodeListener listener) {
        ConnectionService.getInstance().setMainProgressConnectionStatusListener(listener);
    }

    public long getDeltaTime() {
        return this.nativeObj.GetDeltaTime();
    }

    void queryChatRoomInfo(final String id, int count, int order, final IResultCallback<ChatRoomInfo> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("\u804a\u5929\u5ba4 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QueryChatroomInfo(id, count, order, new NativeObject.ChatroomInfoListener(){

            @Override
            public void OnSuccess(int members, NativeObject.UserInfo[] users) {
                ArrayList<ChatRoomMemberInfo> list = new ArrayList<ChatRoomMemberInfo>();
                if (users != null) {
                    for (NativeObject.UserInfo user : users) {
                        ChatRoomMemberInfo info = new ChatRoomMemberInfo();
                        info.setUserId(user.getUserId());
                        info.setJoinTime(user.getJoinTime());
                        list.add(info);
                    }
                }
                ChatRoomInfo info = new ChatRoomInfo();
                info.setChatRoomId(id);
                info.setTotalMemberCount(members);
                info.setMemberInfo(list);
                callback.onSuccess(info);
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void joinChatRoom(String id, int defMessageCount, final OperationCallback callback) {
        io.rong.common.rlog.RLog.d(TAG, "joinChatRoom id: " + id + ", msgCount : " + defMessageCount);
        if (this.chatRoomStatusMap.get(id) == null) {
            this.chatRoomStatusMap.put(id, false);
        }
        this.nativeObj.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, false, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void reJoinChatRoom(String id, int defMessageCount, final OperationCallback callback) {
        io.rong.common.rlog.RLog.d(TAG, "reJoinChatRoom id: " + id + ", msgCount : " + defMessageCount);
        if (this.chatRoomStatusMap.get(id) == null) {
            this.chatRoomStatusMap.put(id, false);
        }
        this.nativeObj.JoinChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, true, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void joinExistChatRoom(String id, int defMessageCount, final OperationCallback callback, boolean keepMsg) {
        io.rong.common.rlog.RLog.d(TAG, "joinExistChatRoom id: " + id + ", msgCount : " + defMessageCount);
        if (this.chatRoomStatusMap.get(id) == null) {
            this.chatRoomStatusMap.put(id, false);
        }
        this.nativeObj.JoinExistingChatroom(id, Conversation.ConversationType.CHATROOM.getValue(), defMessageCount, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        }, keepMsg);
    }

    public void quitChatRoom(String id, final OperationCallback callback) {
        io.rong.common.rlog.RLog.d(TAG, "quitChatRoom id: " + id);
        this.chatRoomStatusMap.remove(id);
        this.nativeObj.QuitChatRoom(id, Conversation.ConversationType.CHATROOM.getValue(), new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                } else if (callback != null) {
                    callback.onError(code);
                }
            }
        });
        this.clearMessages(Conversation.ConversationType.CHATROOM, id);
    }

    public boolean clearConversations(Conversation.ConversationType ... conversationTypes) throws IllegalAccessException {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationTypes == null || conversationTypes.length == 0) {
            throw new IllegalAccessException("ConversationTypes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int[] conversationTypeValues = new int[conversationTypes.length];
        int i = 0;
        for (Conversation.ConversationType conversationType : conversationTypes) {
            conversationTypeValues[i] = conversationType.getValue();
            ++i;
        }
        return this.nativeObj.ClearConversations(conversationTypeValues);
    }

    public void addToBlacklist(String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.AddToBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void recallMessage(String objectName, byte[] content, String pushContent, int messageId, String targetId, int conversationType, boolean disableNotification, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316");
        }
        this.nativeObj.RecallMessage(objectName, content, pushContent, messageId, targetId, conversationType, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        }, disableNotification);
    }

    public void removeFromBlacklist(String userId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u7528\u6237 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemoveFromBlacklist(userId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (code == 0) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getBlacklistStatus(String userId, final IResultCallback<BlacklistStatus> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)userId) || callback == null) {
            throw new IllegalArgumentException("\u7528\u6237 Id \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetBlacklistStatus(userId, new NativeObject.BizAckListener(){

            @Override
            public void operationComplete(int opStatus, int status) {
                if (opStatus == 0) {
                    if (status == 0) {
                        callback.onSuccess(BlacklistStatus.EXIT_BLACK_LIST);
                    } else if (status == 101) {
                        callback.onSuccess(BlacklistStatus.NOT_EXIT_BLACK_LIST);
                    }
                } else {
                    callback.onError(opStatus);
                }
            }
        });
    }

    public void getBlacklist(final IResultCallback<String> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetBlacklist(new NativeObject.SetBlacklistListener(){

            @Override
            public void OnSuccess(String userIds) {
                if (!TextUtils.isEmpty((CharSequence)userIds)) {
                    callback.onSuccess(userIds);
                } else {
                    callback.onSuccess(null);
                }
            }

            @Override
            public void OnError(int errorCode) {
                callback.onError(errorCode);
            }
        });
    }

    public void setNotificationQuietHours(String startTime, int spanMinutes, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)startTime) || spanMinutes <= 0 || spanMinutes >= 1440 || callback == null) {
            throw new IllegalArgumentException("startTime, spanMinutes \u6216 spanMinutes \u53c2\u6570\u5f02\u5e38\u3002");
        }
        Pattern pattern = Pattern.compile("^(([0-1][0-9])|2[0-3]):[0-5][0-9]:([0-5][0-9])$");
        Matcher matcher = pattern.matcher(startTime);
        if (!matcher.find()) {
            throw new IllegalArgumentException("startTime \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.AddPushSetting(startTime, spanMinutes, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (0 == code) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void removeNotificationQuietHours(final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RemovePushSetting(new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long timestamp) {
                if (0 == code) {
                    callback.onSuccess();
                } else {
                    callback.onError(code);
                }
            }
        });
    }

    public void getNotificationQuietHours(final GetNotificationQuietHoursCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.QueryPushSetting(new NativeObject.PushSettingListener(){

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }

            @Override
            public void OnSuccess(String startTime, int spanMins) {
                callback.onSuccess(startTime, spanMins);
            }
        });
    }

    public void setUserData(UserData userData, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (userData == null) {
            throw new IllegalArgumentException("userData \u53c2\u6570\u5f02\u5e38\u3002");
        }
        JSONObject jsonObj = new JSONObject();
        try {
            if (userData.getPersonalInfo() != null) {
                JSONObject personalInfo = new JSONObject();
                personalInfo.putOpt("realName", (Object)userData.getPersonalInfo().getRealName());
                personalInfo.putOpt("sex", (Object)userData.getPersonalInfo().getSex());
                personalInfo.putOpt("age", (Object)userData.getPersonalInfo().getAge());
                personalInfo.putOpt("birthday", (Object)userData.getPersonalInfo().getBirthday());
                personalInfo.putOpt("job", (Object)userData.getPersonalInfo().getJob());
                personalInfo.putOpt("portraitUri", (Object)userData.getPersonalInfo().getPortraitUri());
                personalInfo.putOpt("comment", (Object)userData.getPersonalInfo().getComment());
                jsonObj.put("personalInfo", (Object)personalInfo);
            }
            if (userData.getAccountInfo() != null) {
                JSONObject accountInfo = new JSONObject();
                accountInfo.putOpt("appUserId", (Object)userData.getAccountInfo().getAppUserId());
                accountInfo.putOpt("userName", (Object)userData.getAccountInfo().getUserName());
                accountInfo.putOpt("nickName", (Object)userData.getAccountInfo().getNickName());
                jsonObj.putOpt("accountInfo", (Object)accountInfo);
            }
            if (userData.getContactInfo() != null) {
                JSONObject contactInfo = new JSONObject();
                contactInfo.putOpt("tel", (Object)userData.getContactInfo().getTel());
                contactInfo.putOpt("email", (Object)userData.getContactInfo().getEmail());
                contactInfo.putOpt("address", (Object)userData.getContactInfo().getAddress());
                contactInfo.putOpt("qq", (Object)userData.getContactInfo().getQQ());
                contactInfo.putOpt("weibo", (Object)userData.getContactInfo().getWeibo());
                contactInfo.putOpt("weixin", (Object)userData.getContactInfo().getWeixin());
                jsonObj.putOpt("contactInfo", (Object)contactInfo);
            }
            if (userData.getClientInfo() != null) {
                JSONObject clientInfo = new JSONObject();
                clientInfo.putOpt("network", (Object)userData.getClientInfo().getNetwork());
                clientInfo.putOpt("carrier", (Object)userData.getClientInfo().getCarrier());
                clientInfo.putOpt("systemVersion", (Object)userData.getClientInfo().getSystemVersion());
                clientInfo.putOpt("os", (Object)userData.getClientInfo().getOs());
                clientInfo.putOpt("device", (Object)userData.getClientInfo().getDevice());
                clientInfo.putOpt("mobilePhoneManufacturers", (Object)userData.getClientInfo().getMobilePhoneManufacturers());
                jsonObj.putOpt("clientInfo", (Object)clientInfo);
            }
            jsonObj.putOpt("appVersion", (Object)userData.getAppVersion());
            jsonObj.putOpt("extra", (Object)userData.getExtra());
            String result = jsonObj.toString();
            io.rong.common.rlog.RLog.d(TAG, "UserData " + result);
            this.nativeObj.SetUserData(result, new NativeObject.PublishAckListener(){

                @Override
                public void operationComplete(int code, String msgUId, long timestamp) {
                    if (callback != null) {
                        if (code == 0) {
                            callback.onSuccess();
                        } else {
                            callback.onError(code);
                        }
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void setEnvInfo(Context context) {
        String network = "";
        String MCCMNC = "";
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager == null) {
                io.rong.common.rlog.RLog.e(TAG, "connectivityManager is null");
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    network = networkInfo.getTypeName();
                }
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                MCCMNC = telephonyManager.getNetworkOperator();
            }
        }
        catch (SecurityException e) {
            io.rong.common.rlog.RLog.e(TAG, "setEnvInfo SecurityException", e);
        }
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        if (manufacturer == null) {
            manufacturer = "";
        }
        if (model == null) {
            model = "";
        }
        this.nativeObj.SetDeviceInfo(manufacturer, model, String.valueOf(Build.VERSION.SDK_INT), network, MCCMNC);
    }

    public Message getMessageByUid(String uid) {
        NativeObject.Message message = this.nativeObj.GetMessageByUId(uid);
        if (message == null) {
            return null;
        }
        Message msg = new Message(message);
        MessageContent content = this.renderMessageContent(message.getObjectName(), message.getContent(), msg);
        msg.setContent(content);
        return msg;
    }

    public boolean updateMessageReceiptStatus(String targetId, int categoryId, long timestamp) {
        return this.nativeObj.UpdateMessageReceiptStatus(targetId, categoryId, timestamp);
    }

    public boolean clearUnreadByReceipt(int conversationType, String targetId, long timestamp) {
        return this.nativeObj.ClearUnreadByReceipt(targetId, conversationType, timestamp);
    }

    public long getSendTimeByMessageId(int messageId) {
        return this.nativeObj.GetSendTimeByMessageId(messageId);
    }

    public boolean updateConversationInfo(Conversation.ConversationType conversationType, String targetId, String title, String portrait) {
        return this.nativeObj.UpdateConversationInfo(targetId, conversationType.getValue(), title, portrait);
    }

    public void getVoIPKey(int engineType, String channelName, String extra, final IResultCallback<String> callback) {
        this.nativeObj.GetVoIPKey(engineType, channelName, extra, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    callback.onSuccess(token);
                } else {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public String getVoIPCallInfo() {
        return NavigationClient.getInstance().getVoIPCallInfo(mContext);
    }

    public Uri obtainMediaFileSavedUri() {
        String key = DeviceUtils.ShortMD5(2, this.appKey, this.curUserId);
        String path = SavePathUtils.getSavePath(mContext.getFilesDir().getAbsolutePath());
        return Uri.parse((String)(path + File.separator + key));
    }

    public void setServerInfo(String naviServer, String fileServer) {
        if (naviServer != null) {
            NavigationClient.getInstance().setNaviDomainList(naviServer);
        }
        if (!TextUtils.isEmpty((CharSequence)fileServer)) {
            this.mFileServer = NavigationClient.getInstance().formatServerAddress(fileServer, "");
        }
    }

    public void initHttpDns() {
        String naviStr = NavigationClient.getInstance().getNaviString();
        HttpDnsManager.getInstance().initHttpDns(mContext, this.nativeObj);
    }

    public boolean setMessageContent(int messageId, byte[] messageContent, String objectName) {
        return this.nativeObj.SetMessageContent(messageId, messageContent, objectName);
    }

    public String getToken() {
        return NavigationCacheHelper.getToken(mContext);
    }

    public int getVideoLimitTime() {
        return NavigationCacheHelper.getVideoLimitTime(mContext);
    }

    public boolean isPhrasesEnabled() {
        return NavigationCacheHelper.isPhraseEnabled(mContext);
    }

    public boolean isKvStorageEnabled() {
        return NavigationCacheHelper.isKvStorageEnabled(mContext);
    }

    public int getGIFLimitSize() {
        return NavigationCacheHelper.getGifSizeLimit(mContext);
    }

    public boolean isDnsEnabled() {
        return NavigationCacheHelper.isDnsEnabled(mContext);
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private boolean isMentionedMessage(Message message) {
        if (message.getContent() instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message.getContent();
            return textMessage.getMentionedInfo() != null;
        }
        return false;
    }

    public List<Message> getUnreadMentionedMessages(Conversation.ConversationType conversationType, String targetId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (conversationType == null || TextUtils.isEmpty((CharSequence)targetId)) {
            throw new IllegalArgumentException("ConversationTypes \u6216 targetId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        targetId = targetId.trim();
        NativeObject.Message[] array = this.nativeObj.GetMentionMessages(targetId, conversationType.getValue());
        ArrayList<Message> list = new ArrayList<Message>();
        if (array == null) {
            return list;
        }
        for (NativeObject.Message item : array) {
            Message msg = new Message(item);
            msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
            list.add(msg);
        }
        return list;
    }

    private void setLogStatus(int level, NativeObject.NativeLogInfoListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetLogStatus(level, listener);
    }

    boolean updateReadReceiptRequestInfo(String msgUId, String info) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.UpdateReadReceiptRequestInfo(msgUId, info);
    }

    void registerCmdMsgType(String objName) {
        if (TextUtils.isEmpty((CharSequence)objName)) {
            io.rong.common.rlog.RLog.d(TAG, "registerCmdMsgType parameter error");
            return;
        }
        this.mCmdObjectNameSet.add(objName);
        this.nativeObj.RegisterCmdMsgType(new String[]{objName});
    }

    void registerCmdMsgType(List<String> objNameList) {
        if (objNameList == null || objNameList.size() == 0) {
            io.rong.common.rlog.RLog.d(TAG, "registerCmdMsgType list is empty");
            return;
        }
        this.mCmdObjectNameSet.addAll(objNameList);
        this.nativeObj.RegisterCmdMsgType(objNameList.toArray(new String[0]));
    }

    void registerDeleteMessageType(List<String> objNames) {
        if (objNames != null && objNames.size() > 0) {
            io.rong.common.rlog.RLog.e(TAG, "registerDeleteMessageType size: " + objNames.size());
            this.nativeObj.RegisterDeleteMessageType(objNames.toArray(new String[0]));
        }
    }

    List<Message> searchMessages(String targetId, Conversation.ConversationType conversationType, String keyword, int count, long timestamp) {
        NativeObject.Message[] messages = this.nativeObj.SearchMessages(targetId, conversationType.getValue(), keyword, count, timestamp);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    List<Message> searchMessagesByUser(String targetId, Conversation.ConversationType conversationType, String userId, int count, long timestamp) {
        NativeObject.Message[] messages = this.nativeObj.SearchMessagesByUser(targetId, conversationType.getValue(), userId, count, timestamp);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    List<SearchConversationResult> searchConversations(String keyword, int[] conversationTypes, String[] objName) {
        NativeObject.Conversation[] conversations = this.nativeObj.SearchConversations(keyword, conversationTypes, objName);
        ArrayList<SearchConversationResult> result = new ArrayList<SearchConversationResult>();
        if (conversations != null) {
            for (NativeObject.Conversation value : conversations) {
                Conversation conversation = this.renderConversationFromNative(value);
                SearchConversationResult searchConversationResult = new SearchConversationResult();
                searchConversationResult.setConversation(conversation);
                searchConversationResult.setMatchCount(value.getMatchCount());
                result.add(searchConversationResult);
            }
        }
        return result;
    }

    List<Message> getMatchedMessages(String targetId, Conversation.ConversationType conversationType, long timestamp, int before, int after) {
        NativeObject.Message[] messages = this.nativeObj.GetMatchedMessages(targetId, conversationType.getValue(), timestamp, before, after);
        ArrayList<Message> list = new ArrayList<Message>();
        if (messages != null) {
            for (NativeObject.Message item : messages) {
                Message msg = new Message(item);
                msg.setContent(this.renderMessageContent(item.getObjectName(), item.getContent(), msg));
                list.add(msg);
            }
        }
        return list;
    }

    void getVendorToken(final IResultCallback<String> resultCallback) {
        this.nativeObj.GetVendorToken("", new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (resultCallback != null) {
                    if (errorCode == 0) {
                        resultCallback.onSuccess(token);
                    } else {
                        resultCallback.onError(errorCode);
                    }
                }
            }
        });
    }

    private MessageHandler getMessageHandler(String objectName) {
        return this.messageHandlerMap.get(objectName);
    }

    private MessageContent newMessageContent(String objectName, byte[] content) {
        MessageContent result;
        Constructor<? extends MessageContent> constructor = this.messageContentConstructorMap.get(objectName);
        if (constructor == null || content == null) {
            FwLog.write(1, 1, FwLog.LogTag.L_DECODE_MSG_E.getTag(), "msg_type", objectName);
            return new UnknownMessage(content);
        }
        try {
            result = constructor.newInstance(new Object[]{content});
        }
        catch (Exception e) {
            result = new UnknownMessage(content);
            FwLog.write(1, 1, FwLog.LogTag.L_DECODE_MSG_E.getTag(), "msg_type|stacks", objectName, FwLog.stackToString(e));
        }
        return result;
    }

    public String getOfflineMessageDuration() {
        return this.nativeObj.GetOfflineMessageDuration();
    }

    public void setOfflineMessageDuration(String duration, final IResultCallback<Long> callback) {
        this.nativeObj.SetOfflineMessageDuration(duration, new NativeObject.SetOfflineMessageDurationListener(){

            @Override
            public void onSuccess(long version) {
                if (callback != null) {
                    callback.onSuccess(version);
                }
            }

            @Override
            public void onError(int code) {
                if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void switchAppKey(String appKey, String deviceId) {
        this.disconnect(false);
        this.appKey = appKey;
        this.deviceId = deviceId;
        NavigationCacheHelper.clearCache(mContext);
        NavigationCacheHelper.clearNaviCache(mContext);
        ConnectionService.getInstance().initService(mContext, this.nativeObj, appKey);
        this.nativeObj.InitClient(appKey, mContext.getPackageName(), deviceId, this.dbPath, FileUtils.getCachePath(mContext, "ronglog"));
        ConnectionService.getInstance().initService(mContext, this.nativeObj, appKey);
        RtLogUploadManager.getInstance().init(mContext, "4.1.0", deviceId, appKey);
        this.mFileServer = null;
    }

    public Message getTheFirstUnreadMessage(int conversationType, String targetId) {
        NativeObject.Message nativeMsg = this.nativeObj.GetTheFirstUnreadMessage(conversationType, targetId);
        if (nativeMsg == null) {
            return null;
        }
        Message message = new Message(nativeMsg);
        MessageContent content = this.renderMessageContent(nativeMsg.getObjectName(), nativeMsg.getContent(), message);
        message.setContent(content);
        return message;
    }

    boolean setMessageReadTime(long messageId, long timestamp) {
        return this.nativeObj.SetReadTime(messageId, timestamp);
    }

    public void setReconnectKickEnable(boolean enable) {
        ConnectionService.getInstance().setReconnectKickEnable(enable);
    }

    public void SetPushNotificationListener(PushNotificationListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetPushNotificationListener(listener);
    }

    public void setConversationStatusListener(NativeObject.ConversationStatusListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetConversationStatusListener(listener);
    }

    public void exitRTCRoom(final String roomId, final OperationCallback callback) {
        FwLog.write(3, 2, "P-leaveRoom-T", "roomId", roomId);
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-leaveRoom-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.ExitRTCRoom(roomId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-leaveRoom-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-leaveRoom-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void getRTCUsers(String roomId, int order, final IResultCallback<List<RTCUser>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetRTCUsers(roomId, order, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token, String sessionId, HashMap<String, String> roomData) {
                callback.onSuccess(new ArrayList<RTCUser>(Arrays.asList(data)));
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void getRTCUserData(String roomId, int order, final IResultCallback<List<RTCUser>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.GetRTCUserData(roomId, order, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token, String sessionId, HashMap<String, String> room_data) {
                callback.onSuccess(new ArrayList<RTCUser>(Arrays.asList(data)));
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void sendRTCPing(String roomId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.SendRTCPing(roomId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code != 0) {
                    FwLog.write(1, 2, "P-RTCPing-E", "code", code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public boolean useRTCOnly() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.UseRTCOnly();
    }

    public void rtcPutInnerData(final String roomId, int type, String key, String value, String objectName, String content, final OperationCallback callback) {
        LogSplitUtil.write(3, "P-RTCPutInnerData-T", "roomId|type|fullValues|increValues", roomId, type, value, content);
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCPutInnerData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCPutInnerData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCPutInnerDatum(roomId, type, key, value, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCPutInnerData-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCPutInnerData-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcPutOuterData(final String roomId, int type, String key, String value, String objectName, String content, final OperationCallback callback) {
        LogSplitUtil.write(3, "P-RTCPutOuterData-T", "roomId|type|fullValues|increValues", roomId, type, value, content);
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCPutOuterData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCPutOuterData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCPutOuterDatum(roomId, type, key, value, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCPutOuterData-R", "roomId|code", roomId, 0);
                } else {
                    FwLog.write(1, 2, "P-RTCPutOuterData-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcDeleteInnerData(final String roomId, int type, String[] keys, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCDeleteInnerData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCDeleteInnerData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        FwLog.write(3, 2, "P-RTCDeleteInnerData-T", "roomId|type", roomId, type);
        this.nativeObj.RTCDeleteInnerData(roomId, type, keys, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCDeleteInnerData-R", "roomId|code", roomId, 0);
                } else {
                    FwLog.write(1, 2, "P-RTCDeleteInnerData-E", "roomId|code|desc", roomId, code, "Protocol Error");
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcDeleteOuterData(final String roomId, int type, String[] keys, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCDeleteOuterData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCDeleteOuterData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        FwLog.write(3, 2, "P-RTCDeleteOuterData-T", "roomId|type", roomId, type);
        this.nativeObj.RTCDeleteOuterData(roomId, type, keys, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCDeleteOuterData-R", "roomId|code", roomId, 0);
                } else {
                    FwLog.write(1, 2, "P-RTCDeleteOuterData-E", "roomId|code|desc", roomId, code, "Protocol Error");
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void rtcGetInnerData(final String roomId, int type, String[] keys, final IResultCallback<Map<String, String>> callback) {
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCGetInnerData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCGetInnerData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        FwLog.write(3, 2, "P-RTCGetInnerData-T", "roomId|type", roomId, type);
        this.nativeObj.RTCGetInnerData(roomId, type, keys, new NativeObject.RTCDataListener(){

            @Override
            public void OnSuccess(Map<String, String> data) {
                FwLog.write(3, 2, "P-RTCGetInnerData-R", "roomId|code", roomId, 0);
                callback.onSuccess(data);
            }

            @Override
            public void OnError(int status) {
                FwLog.write(1, 2, "P-RTCGetInnerData-E", "roomId|code|desc", roomId, status, "Protocol Error");
                callback.onError(status);
            }
        });
    }

    public void rtcGetOuterData(final String roomId, int type, String[] keys, final IResultCallback<Map<String, String>> callback) {
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCGetOuterData-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCGetOuterData-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        FwLog.write(3, 2, "P-RTCGetOuterData-T", "roomId|type", roomId, type);
        this.nativeObj.RTCGetOuterData(roomId, type, keys, new NativeObject.RTCDataListener(){

            @Override
            public void OnSuccess(Map<String, String> data) {
                FwLog.write(3, 2, "P-RTCGetOuterData-R", "roomId|code", roomId, 0);
                callback.onSuccess(data);
            }

            @Override
            public void OnError(int status) {
                FwLog.write(1, 2, "P-RTCGetOuterData-E", "roomId|code|desc", roomId, status, "Protocol Error");
                callback.onError(status);
            }
        });
    }

    public void joinRTCRoomAndGetData(final String roomId, int roomType, int broadcastType, String key, String value, final IResultCallbackEx<List<RTCUser>, Object[]> callback) {
        FwLog.write(3, 2, "P-joinRoom-T", "roomId|uid|roomType|liveType", roomId, this.getCurrentUserId(), roomType, broadcastType);
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-joinRoom-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-joinRoom-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.JoinRTCRoomAndGetData(roomId, roomType, broadcastType, key, value, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token, String sessionId, HashMap<String, String> roomData) {
                String remoteUserInfo = "[]";
                if (data != null && data.length > 0) {
                    JSONArray jsonArray = new JSONArray();
                    for (RTCUser user : data) {
                        JSONObject obj = new JSONObject();
                        try {
                            obj.put("userId", (Object)user.getUid());
                            JSONObject dataObj = new JSONObject();
                            if (user.getData() != null) {
                                Set<Map.Entry<String, String>> entrys = user.getData().entrySet();
                                for (Map.Entry<String, String> entry : entrys) {
                                    dataObj.put(entry.getKey(), (Object)entry.getValue());
                                }
                            }
                            obj.put("streamData", (Object)dataObj);
                            jsonArray.put((Object)obj);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    remoteUserInfo = jsonArray.toString();
                }
                LogSplitUtil.write(3, "P-joinRoom-R", "roomId|code|remoteUserInfo", roomId, 0, remoteUserInfo);
                callback.onSuccess(new ArrayList<RTCUser>(Arrays.asList(data)), new Object[]{token, sessionId, roomData});
            }

            @Override
            public void OnError(int status) {
                FwLog.write(1, 2, "P-joinRoom-E", "roomId|code|desc", roomId, status, "Protocol Error");
                callback.onError(status);
            }
        });
    }

    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, final NativeObject.RTCConfigListener callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.GetRTCConfig(model, osVersion, timestamp, sdkVersion, new NativeObject.RTCConfigListener(){

            @Override
            public void onSuccess(String config, long version) {
                callback.onSuccess(config, version);
            }

            @Override
            public void onError(int status) {
                callback.onError(status);
            }
        });
    }

    void getRTCToken(String roomId, int roomType, int broadcastType, final IResultCallback<String> resultCallback) {
        FwLog.write(3, 2, "P-getRTCToken-T", "roomId|roomType|mediaType", roomId, roomType, broadcastType);
        this.nativeObj.RTCGetToken(roomId, roomType, broadcastType, new NativeObject.TokenListener(){

            @Override
            public void OnError(int errorCode, String token) {
                if (errorCode == 0) {
                    FwLog.write(3, 2, "P-getRTCToken-R", "code|token", 0, token);
                } else {
                    FwLog.write(1, 2, "P-getRTCToken-E", "code", errorCode);
                }
                if (resultCallback != null) {
                    if (errorCode == 0) {
                        resultCallback.onSuccess(token);
                    } else {
                        resultCallback.onError(errorCode);
                    }
                }
            }
        });
    }

    void setRTCUserState(String roomId, String state, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.RTCSetUserState(roomId, state, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void setRTCUserData(String roomId, int type, Map<String, String> data, String objectName, String content, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (!(data instanceof HashMap)) {
            throw new RuntimeException("setRTCUserData data must be HashMap!");
        }
        this.nativeObj.RTCSetUserData(roomId, type, data, objectName, content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void getRTCUserDatas(String roomId, String[] userIds, final IResultCallback<List<RTCUser>> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
        }
        this.nativeObj.RTCGetUserData(roomId, userIds, new NativeObject.RTCUserInfoListener(){

            @Override
            public void OnSuccess(RTCUser[] data, String token, String sessionId, HashMap<String, String> room_data) {
                callback.onSuccess(new ArrayList<RTCUser>(Arrays.asList(data)));
            }

            @Override
            public void OnError(int status) {
                callback.onError(status);
            }
        });
    }

    public void setChatRoomEntry(String key, String value, String chatroomId, Boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, final OperationCallback callback) {
        if (!NavigationCacheHelper.isKvStorageEnabled(mContext) && callback != null) {
            callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
            return;
        }
        NativeObject.StatusData statusData = new NativeObject.StatusData();
        statusData.setKey(key);
        statusData.setValue(value);
        statusData.setAutoDelete(autoDelete);
        statusData.setOverwrite(isOverWrite);
        NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
        statusNotification.setAttributeFlag(0);
        statusNotification.setConversationType(Conversation.ConversationType.CHATROOM.getValue());
        statusNotification.setMessageContent(new String(ChatRoomKVNotiMessage.obtain(key, value, 1, notificationExtra).encode()));
        statusNotification.setNotifyAll(sendNotification);
        statusNotification.setObjectName(ChatRoomKVNotiMessage.class.getAnnotation(MessageTag.class).value());
        this.nativeObj.SetChatRoomStatus(chatroomId, statusData, statusNotification, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void deleteChatRoomEntry(String key, String value, String chatroomId, Boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, final OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)chatroomId)) {
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        if (!NavigationCacheHelper.isKvStorageEnabled(mContext) && callback != null) {
            callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
            return;
        }
        NativeObject.StatusData statusData = new NativeObject.StatusData();
        statusData.setKey(key);
        statusData.setValue(value);
        statusData.setAutoDelete(autoDelete);
        statusData.setOverwrite(isOverWrite);
        NativeObject.StatusNotification statusNotification = new NativeObject.StatusNotification();
        statusNotification.setAttributeFlag(0);
        statusNotification.setConversationType(Conversation.ConversationType.CHATROOM.getValue());
        statusNotification.setMessageContent(new String(ChatRoomKVNotiMessage.obtain(key, value, 2, notificationExtra).encode()));
        statusNotification.setNotifyAll(sendNotification);
        statusNotification.setObjectName(ChatRoomKVNotiMessage.class.getAnnotation(MessageTag.class).value());
        this.nativeObj.DeleteChatRoomStatus(chatroomId, statusData, statusNotification, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    void getChatRoomStatusByKey(final String roomId, final String key, final IResultCallback<String> callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (callback == null) {
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!NavigationCacheHelper.isKvStorageEnabled(mContext)) {
                    callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
                    return;
                }
                if (NativeClient.this.chatRoomStatusMap.get(roomId) == null) {
                    callback.onError(RongIMClient.ErrorCode.NOT_IN_CHATROOM.getValue());
                    return;
                }
                if (!((Boolean)NativeClient.this.chatRoomStatusMap.get(roomId)).booleanValue()) {
                    callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_SYNC.getValue());
                    return;
                }
                String value = NativeClient.this.nativeObj.GetChatRoomStatusByKey(roomId, key);
                if (TextUtils.isEmpty((CharSequence)value)) {
                    callback.onError(RongIMClient.ErrorCode.KEY_NOT_EXIST.getValue());
                } else {
                    callback.onSuccess(value);
                }
            }
        });
    }

    void getAllChatRoomStatus(final String roomId, final IResultCallback<HashMap<String, String>> callback) {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!NavigationCacheHelper.isKvStorageEnabled(mContext)) {
                    callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_AVAILABLE.getValue());
                    return;
                }
                if (NativeClient.this.chatRoomStatusMap.get(roomId) == null) {
                    callback.onError(RongIMClient.ErrorCode.NOT_IN_CHATROOM.getValue());
                    return;
                }
                if (!((Boolean)NativeClient.this.chatRoomStatusMap.get(roomId)).booleanValue()) {
                    callback.onError(RongIMClient.ErrorCode.KV_STORE_NOT_SYNC.getValue());
                    return;
                }
                HashMap<String, String> result = NativeClient.this.nativeObj.GetChatRoomStatus(roomId);
                callback.onSuccess(result);
            }
        });
    }

    private void setChatRoomStatusNotificationListener() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetChatRoomStatusNotificationListener(new NativeObject.StatusNotificationListener(){

            @Override
            public void OnStatusChanged(final String roomId) {
                NativeClient.this.chatRoomStatusMap.put(roomId, true);
                if (NativeClient.this.mKVStatusListener != null) {
                    NativeClient.this.mKVStatusListener.onChatRoomKVStatusSync(roomId);
                }
                NativeClient.this.getAllChatRoomStatus(roomId, new IResultCallback<HashMap<String, String>>(){

                    @Override
                    public void onSuccess(HashMap<String, String> stringStringHashMap) {
                        if (NativeClient.this.mKVStatusListener != null && stringStringHashMap != null) {
                            io.rong.common.rlog.RLog.d(NativeClient.TAG, "OnKVChanged changeInfo: " + stringStringHashMap);
                            NativeClient.this.mKVStatusListener.onChatRoomKVStatusChange(roomId, stringStringHashMap);
                        }
                    }

                    @Override
                    public void onError(int code) {
                        io.rong.common.rlog.RLog.d(NativeClient.TAG, "OnKVChanged sync error: " + code);
                    }
                });
            }

            @Override
            public void OnKVChanged(ChatroomStatus[] chatRoomStatus) {
                if (chatRoomStatus != null) {
                    io.rong.common.rlog.RLog.d(NativeClient.TAG, "OnKVChanged changeInfo: " + Arrays.toString(chatRoomStatus));
                    if (NativeClient.this.mKVStatusListener != null) {
                        HashMap<String, String> changeMap = new HashMap<String, String>();
                        HashMap<String, String> removeMap = new HashMap<String, String>();
                        for (ChatroomStatus status : chatRoomStatus) {
                            if (status.getIsDelete()) {
                                removeMap.put(status.getKey(), status.getValue());
                                continue;
                            }
                            changeMap.put(status.getKey(), status.getValue());
                        }
                        String roomId = chatRoomStatus[0].getRoomId();
                        if (changeMap.size() > 0) {
                            NativeClient.this.mKVStatusListener.onChatRoomKVStatusChange(roomId, changeMap);
                        }
                        if (removeMap.size() > 0) {
                            NativeClient.this.mKVStatusListener.onChatRoomKVStatusRemove(roomId, removeMap);
                        }
                    }
                }
            }
        });
    }

    public String getRTCProfile() {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.GetRTCProfile();
    }

    void setNaviContentUpdateListener(NavigationClient.NaviUpdateListener listener) {
        this.naviUpdateListener = listener;
    }

    String getUploadConfigInfo() {
        return NavigationClient.getInstance().getUploadLogConfigInfo(mContext);
    }

    String getOffLineLogServer() {
        return NavigationCacheHelper.getOfflineLogServer(mContext);
    }

    public void updateVoIPCallInfo(String rtcProfile) {
        NavigationCacheHelper.updateVoIPCallInfo(mContext, rtcProfile);
    }

    void rtcSetUserResource(final String roomId, RTCStatusDate[] kv, String objectName, RTCStatusDate[] content, final OperationCallback callback) {
        NativeObject.StatusData statusData;
        LogSplitUtil.write(3, "P-RTCSetUserResource-T", "roomId", roomId);
        if (this.nativeObj == null) {
            FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code|desc", roomId, -1, "NativeClient is Null");
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code|desc", roomId, -1, "RoomId is Null");
            throw new IllegalArgumentException("roomId \u53c2\u6570\u5f02\u5e38\u3002");
        }
        int kvSize = kv.length;
        int contentSize = content.length;
        NativeObject.StatusData[] statusData_kv = new NativeObject.StatusData[kvSize];
        for (int i = 0; i < kvSize; ++i) {
            statusData = new NativeObject.StatusData();
            statusData.setKey(kv[i].getKey());
            statusData.setValue(kv[i].getValue());
            statusData.setAutoDelete(kv[i].isAutoDelete());
            statusData.setOverwrite(kv[i].isOverwrite());
            statusData_kv[i] = statusData;
        }
        NativeObject.StatusData[] statusData_content = new NativeObject.StatusData[contentSize];
        for (int i = 0; i < contentSize; ++i) {
            statusData = new NativeObject.StatusData();
            statusData.setKey(content[i].getKey());
            statusData.setValue(content[i].getValue());
            statusData.setAutoDelete(content[i].isAutoDelete());
            statusData.setOverwrite(content[i].isOverwrite());
            statusData_content[i] = statusData;
        }
        this.nativeObj.RTCSetUserResource(roomId, statusData_kv, objectName, statusData_content, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCSetUserResource-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void sdkBackgroundChanged(boolean isInBackground) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.sdkBackgroundChanged(isInBackground);
    }

    public void setKVStatusListener(KVStatusListener kVStatusListener) {
        this.mKVStatusListener = kVStatusListener;
    }

    private boolean setMessageExpansion(String targetId, int type, String msgUId, String extMsg) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        return this.nativeObj.SetExtraMessageAttribute(targetId, type, msgUId, extMsg);
    }

    public void updateMessageExpansion(final Map<String, String> expansion, final String messageUId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        final NativeObject.Message nativeMsg = this.nativeObj.GetMessageByUId(messageUId);
        final Message originMsg = this.getMessageByUid(messageUId);
        if (originMsg == null || !originMsg.isCanIncludeExpansion()) {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND.getValue());
            }
            return;
        }
        if (!Conversation.ConversationType.PRIVATE.equals((Object)originMsg.getConversationType()) && !Conversation.ConversationType.GROUP.equals((Object)originMsg.getConversationType())) {
            if (callback != null) {
                io.rong.common.rlog.RLog.e(TAG, "only private or group support expansion");
                callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND.getValue());
            }
            return;
        }
        if (this.judgeExpansionExceedLimit(expansion, nativeMsg)) {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.RC_MSG_EXPANSION_SIZE_LIMIT_EXCEED.getValue());
            }
            return;
        }
        MessageExpansionMessage msgContent = MessageExpansionMessage.obtain(messageUId, expansion);
        Message msg = Message.obtain(originMsg.getTargetId(), originMsg.getConversationType(), msgContent);
        this.sendMessageOption(msg, null, null, null, null, new ISendMessageCallback<Message>(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                String extMsg = NativeClient.this.getMessageExpansion(message, expansion, nativeMsg.getExtMsg());
                boolean success = NativeClient.this.setMessageExpansion(originMsg.getTargetId(), originMsg.getConversationType().getValue(), messageUId, extMsg);
                if (callback != null) {
                    if (success) {
                        callback.onSuccess();
                    } else {
                        callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_EXPAND_FAIL.getValue());
                    }
                }
            }

            @Override
            public void onError(Message message, int code) {
                io.rong.common.rlog.RLog.i(NativeClient.TAG, "updateMessageExpansion onError = " + code);
                if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    private boolean judgeExpansionExceedLimit(Map<String, String> expansion, NativeObject.Message nativeMsg) {
        HashMap<String, MessageExpansion> expansionHashMapEx = JSONUtils.jsonToExpansionEx(nativeMsg.getExtMsg());
        Set<String> keys = expansionHashMapEx.keySet();
        if (expansion.size() > 20 || keys.size() > 300) {
            return true;
        }
        HashSet<String> mergeSet = new HashSet<String>();
        for (String string2 : keys) {
            mergeSet.add(string2);
        }
        for (Object object : expansion.entrySet()) {
            Map.Entry e = (Map.Entry)object;
            mergeSet.add(e.getKey().toString());
            if (mergeSet.size() <= 300) continue;
            return true;
        }
        return false;
    }

    public void removeMessageAllExpansion(String messageUId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        final Message originMsg = this.getMessageByUid(messageUId);
        if (originMsg == null || !originMsg.isCanIncludeExpansion()) {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND.getValue());
            }
            return;
        }
        MessageExpansionMessage msgContent = MessageExpansionMessage.obtain(messageUId, true);
        Message msg = Message.obtain(originMsg.getTargetId(), originMsg.getConversationType(), msgContent);
        this.sendMessageOption(msg, null, null, null, null, new ISendMessageCallback<Message>(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                ArrayList keyArray = new ArrayList();
                NativeClient.this.removeKeysInExpansionEx(-1L, false, keyArray, originMsg, callback);
            }

            @Override
            public void onError(Message message, int code) {
                if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    public void removeMessageExpansion(final List<String> keyArray, String messageUId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        final Message originMsg = this.getMessageByUid(messageUId);
        if (originMsg == null || !originMsg.isCanIncludeExpansion()) {
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_CANT_EXPAND.getValue());
            }
            return;
        }
        MessageExpansionMessage msgContent = MessageExpansionMessage.obtain(messageUId, keyArray);
        Message msg = Message.obtain(originMsg.getTargetId(), originMsg.getConversationType(), msgContent);
        this.sendMessageOption(msg, null, null, null, null, new ISendMessageCallback<Message>(){

            @Override
            public void onAttached(Message message) {
            }

            @Override
            public void onSuccess(Message message) {
                NativeClient.this.removeKeysInExpansionEx(-1L, false, keyArray, originMsg, callback);
            }

            @Override
            public void onError(Message message, int code) {
                if (callback != null) {
                    callback.onError(code);
                }
            }
        });
    }

    private void removeKeysInExpansionEx(long time, boolean isCallback, List<String> keyArray, Message originMsg, OperationCallback callback) {
        NativeObject.Message nativeMsg = this.nativeObj.GetMessageByUId(originMsg.getUId());
        List<Object> keyRemovedList = time == -1L ? JSONUtils.removeKeysInExpansionEx(keyArray, JSONUtils.jsonToExpansionEx(nativeMsg.getExtMsg())) : JSONUtils.removeKeysTSInExpansionEx(time, keyArray, JSONUtils.jsonToExpansionEx(nativeMsg.getExtMsg()));
        boolean FINAL_EXPANSION_EX = false;
        boolean DID_REMOVE_LIST = true;
        HashMap hashMap = (HashMap)keyRemovedList.get(0);
        List removeList = (List)keyRemovedList.get(1);
        String extMsg = JSONUtils.exMapToJson(hashMap);
        boolean success = this.setMessageExpansion(originMsg.getTargetId(), originMsg.getConversationType().getValue(), originMsg.getUId(), extMsg);
        if (callback != null) {
            if (success) {
                callback.onSuccess();
            } else {
                callback.onError(RongIMClient.ErrorCode.RC_MESSAGE_EXPAND_FAIL.getValue());
            }
        }
        if (messageExpansionListener != null && removeList.size() != 0 && isCallback) {
            try {
                originMsg.setExpansion(JSONUtils.expansionExJSONToMap(extMsg));
                messageExpansionListener.onMessageExpansionRemove(removeList, originMsg);
            }
            catch (RemoteException e) {
                io.rong.common.rlog.RLog.e(TAG, e.toString());
            }
        }
    }

    private String getMessageExpansion(Message message, Map<String, String> expansion, String expansionExisted) {
        long currentTs = this.timeDisposal(message);
        String expansionJson = JSONUtils.mapTsCombineJson(expansion, currentTs);
        List<String> mergeMsgList = JSONUtils.mergeJson(expansionJson, expansionExisted);
        String extMsg = "";
        boolean FULL_DATA = false;
        if (mergeMsgList != null && mergeMsgList.size() != 0) {
            extMsg = mergeMsgList.get(0);
        }
        return extMsg;
    }

    private long timeDisposal(Message message) {
        return message.getSentTime() - 1596211200000L;
    }

    private void handleExpansionMsg(Message message) {
        MessageExpansionMessage messageExpansionMessage = (MessageExpansionMessage)message.getContent();
        String originalMsgUId = messageExpansionMessage.getOriginalMsgUId();
        Message originMsg = this.getMessageByUid(originalMsgUId);
        if (originMsg == null) {
            io.rong.common.rlog.RLog.e(TAG, "handleMessageExpansionMsg originMsg is null");
            return;
        }
        NativeObject.Message nativeMsg = this.nativeObj.GetMessageByUId(originalMsgUId);
        Map<String, String> updateExpansion = messageExpansionMessage.getUpdateExpansion();
        List<String> removeExpansionKeyList = messageExpansionMessage.getRemoveExpansionKeyList();
        boolean removeAllKeys = messageExpansionMessage.isRemoveAllKeys();
        long currentTs = this.timeDisposal(message);
        if (removeAllKeys) {
            ArrayList<String> keyArray = new ArrayList<String>();
            this.removeKeysInExpansionEx(currentTs, true, keyArray, originMsg, null);
            return;
        }
        if (updateExpansion != null) {
            MessageExpansionHandle messageExpansion = new MessageExpansionHandle(nativeMsg, updateExpansion, currentTs).invoke();
            String extMsgExpansion = messageExpansion.getExtMsgExpansion();
            String updateStr = messageExpansion.getUpdateStr();
            boolean success = this.setMessageExpansion(originMsg.getTargetId(), originMsg.getConversationType().getValue(), originalMsgUId, extMsgExpansion);
            if (messageExpansionListener != null) {
                try {
                    JSONObject updateStrJson = new JSONObject(updateStr);
                    if (success) {
                        originMsg.setExpansion(JSONUtils.expansionExJSONToMap(extMsgExpansion));
                        if (!TextUtils.isEmpty((CharSequence)updateStr) && updateStrJson.length() != 0) {
                            HashMap<String, String> hashMapUpdate = JSONUtils.expansionExJSONToMap(updateStr);
                            messageExpansionListener.onMessageExpansionUpdate(hashMapUpdate, originMsg);
                        }
                    }
                }
                catch (RemoteException | JSONException e) {
                    io.rong.common.rlog.RLog.e(TAG, e.toString());
                }
            }
        } else {
            this.removeKeysInExpansionEx(currentTs, true, removeExpansionKeyList, originMsg, null);
        }
    }

    public void setMessageExpansionListener(IMessageExpansionListener listener) {
        messageExpansionListener = listener;
    }

    public void SetRTCHeartbeatListener(NativeObject.RTCHeartbeatListener listener) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SetRTCHeartbeatListener(listener);
    }

    public void SendRTCHeartbeat(String[] roomId) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SendRTCHeartbeat(roomId);
    }

    public void SendRTCLiveInvitation(final String roomId, String anchorId, String peerRoomId, String inviteInfo, String sessionId, int timeout, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.SendRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, timeout, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCSetUserResource-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void CancelRTCLiveInvitation(final String roomId, String anchorId, String peerRoomId, String inviteInfo, String sessionId, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.CancelRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCSetUserResource-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void AnswerRTCLiveInvitation(final String roomId, int answer, String anchorId, String peerRoomId, String sessionId, String content, String key, String value, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.AnswerRTCLiveInvitation(roomId, answer, anchorId, peerRoomId, sessionId, content, key, value, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCSetUserResource-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    public void HangupRTCLiveInvitation(final String roomId, String peerRoomId, String sessionId, String content, String[] keys, final OperationCallback callback) {
        if (this.nativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        this.nativeObj.HangupRTCLiveInvitation(roomId, peerRoomId, sessionId, content, keys, new NativeObject.PublishAckListener(){

            @Override
            public void operationComplete(int code, String msgUId, long sendTime) {
                if (code == 0) {
                    FwLog.write(3, 2, "P-RTCSetUserResource-R", "roomId|code", roomId, code);
                } else {
                    FwLog.write(1, 2, "P-RTCSetUserResource-E", "roomId|code", roomId, code);
                }
                if (callback != null) {
                    if (code == 0) {
                        callback.onSuccess();
                    } else {
                        callback.onError(code);
                    }
                }
            }
        });
    }

    private static class MessageExpansionHandle {
        private final NativeObject.Message nativeMsg;
        private final Map<String, String> updateExpansion;
        private final long ts;
        private String extMsgExpansion;
        private String updateStr;

        MessageExpansionHandle(NativeObject.Message nativeMsg, Map<String, String> updateExpansion, long ts) {
            this.nativeMsg = nativeMsg;
            this.updateExpansion = updateExpansion;
            this.ts = ts;
        }

        String getExtMsgExpansion() {
            return this.extMsgExpansion;
        }

        String getUpdateStr() {
            return this.updateStr;
        }

        MessageExpansionHandle invoke() {
            String expansionJson = JSONUtils.mapTsCombineJson(this.updateExpansion, this.ts);
            List<String> mergeMsgList = JSONUtils.mergeJson(expansionJson, this.nativeMsg.getExtMsg());
            boolean FULL_DATA = false;
            boolean UPDATE_DATA = true;
            if (mergeMsgList != null && mergeMsgList.size() != 0) {
                this.extMsgExpansion = mergeMsgList.get(0);
                this.updateStr = mergeMsgList.get(1);
            } else {
                this.extMsgExpansion = "";
                this.updateStr = "";
            }
            return this;
        }
    }

    public static interface PushNotificationListener {
        public void OnPushNotificationChanged(long var1);
    }

    public static interface KVStatusListener {
        public void onChatRoomKVStatusSync(String var1);

        public void onChatRoomKVStatusChange(String var1, Map<String, String> var2);

        public void onChatRoomKVStatusRemove(String var1, Map<String, String> var2);
    }

    public static interface OnReceiveMessageListener {
        public void onReceived(Message var1, int var2, boolean var3, boolean var4, int var5);
    }

    public static interface GetNotificationQuietHoursCallback {
        public void onSuccess(String var1, int var2);

        public void onError(int var1);
    }

    public static interface IDownloadMediaFileCallback<T>
    extends IDownloadMediaMessageCallback<T> {
        public void onFileNameChanged(String var1);
    }

    public static interface IDownloadMediaMessageCallback<T> {
        public void onSuccess(T var1);

        public void onProgress(int var1);

        public void onCanceled();

        public void onError(int var1);
    }

    public static interface ISendMediaMessageCallback<T> {
        public void onAttached(T var1);

        public void onSuccess(T var1);

        public void onProgress(T var1, int var2);

        public void onError(T var1, int var2);

        public void onCanceled(T var1);
    }

    public static interface IResultProgressCallback<T> {
        public void onSuccess(T var1);

        public void onProgress(int var1);

        public void onError(int var1);

        public void onCanceled(int var1);
    }

    public static interface ISendMessageCallback<T> {
        public void onAttached(T var1);

        public void onSuccess(T var1);

        public void onError(T var1, int var2);
    }

    public static interface IResultCallbackEx<T, K> {
        public void onSuccess(T var1, K var2);

        public void onError(int var1);
    }

    public static interface IConnectResultCallback<T>
    extends IResultCallback<T> {
        public void OnDatabaseOpened(int var1);
    }

    public static interface IResultCallback<T> {
        public void onSuccess(T var1);

        public void onError(int var1);
    }

    public static interface OperationCallback {
        public void onSuccess();

        public void onError(int var1);
    }

    public static interface ICodeListener {
        public void onChanged(int var1);
    }

    public static enum BlacklistStatus {
        EXIT_BLACK_LIST(0),
        NOT_EXIT_BLACK_LIST(1);

        private int value;

        private BlacklistStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BlacklistStatus setValue(int code) {
            for (BlacklistStatus c : BlacklistStatus.values()) {
                if (code != c.getValue()) continue;
                return c;
            }
            return NOT_EXIT_BLACK_LIST;
        }
    }

    private static class NativeClientHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final NativeClient client = new NativeClient();

        private NativeClientHolder() {
        }
    }
}

