/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.cs.CustomServiceManager;
import io.rong.imlib.location.RealTimeLocationManager;
import io.rong.imlib.model.Message;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;

@Deprecated
public class ModuleManager {
    private static final String TAG = "ModuleManager";
    private static CopyOnWriteArrayList<MessageRouter> messageRouters = new CopyOnWriteArrayList();
    private static CopyOnWriteArrayList<ConnectivityStateChangedListener> connectivityStateChangedListeners = new CopyOnWriteArrayList();
    private static RongIMClient.OnReceiveMessageListener sListener;
    private static Object rongCallClientInstance;

    static void init(Context context, IHandler stub, RongIMClient.OnReceiveMessageListener listener) {
        RLog.i(TAG, "init");
        sListener = listener;
        try {
            String moduleName = "io.rong.calllib.RongCallClient";
            Class<?> cls = Class.forName(moduleName);
            Constructor<?> constructor = cls.getConstructor(Context.class, IHandler.class);
            rongCallClientInstance = constructor.newInstance(context, stub);
        }
        catch (Exception e) {
            RLog.i(TAG, "Can not find RongCallClient module.");
        }
        RealTimeLocationManager.getInstance().init(context, listener, stub);
        CustomServiceManager.getInstance().init(context, listener, stub);
    }

    static void unInit() {
        if (rongCallClientInstance != null) {
            String moduleName = "io.rong.calllib.RongCallClient";
            try {
                Class<?> cls = Class.forName(moduleName);
                Method method = cls.getMethod("unInit", null);
                method.setAccessible(true);
                method.invoke(rongCallClientInstance, (Object[])null);
            }
            catch (ClassNotFoundException e) {
                RLog.e(TAG, "unInit ClassNotFoundException", e);
            }
            catch (NoSuchMethodException e) {
                RLog.e(TAG, "unInit NoSuchMethodException", e);
            }
            catch (IllegalAccessException e) {
                RLog.e(TAG, "unInit IllegalAccessException", e);
            }
            catch (InvocationTargetException e) {
                RLog.e(TAG, "unInit InvocationTargetException", e);
            }
            rongCallClientInstance = null;
        }
    }

    static boolean routeMessage(Message message, int left, boolean offline, int cmdLeft) {
        for (MessageRouter listener : messageRouters) {
            if (!listener.onReceived(message, left, offline, cmdLeft)) continue;
            return true;
        }
        return false;
    }

    static void connectivityChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus state) {
        for (ConnectivityStateChangedListener listener : connectivityStateChangedListeners) {
            listener.onChanged(state);
        }
    }

    public static void addConnectivityStateChangedListener(ConnectivityStateChangedListener listener) {
        connectivityStateChangedListeners.add(listener);
    }

    public static void addMessageRouter(MessageRouter listener) {
        messageRouters.add(listener);
    }

    public static void removeMessageRouter(MessageRouter router) {
        messageRouters.remove(router);
    }

    public static void removeConnectivityStateChangedListener(ConnectivityStateChangedListener listener) {
        connectivityStateChangedListeners.remove(listener);
    }

    public static RongIMClient.OnReceiveMessageListener getListener() {
        return sListener;
    }

    public static interface ConnectivityStateChangedListener {
        public void onChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus var1);
    }

    public static interface MessageRouter {
        public boolean onReceived(Message var1, int var2, boolean var3, int var4);
    }
}

