/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.ConversationStatusListener;
import io.rong.imlib.HeartBeatManager;
import io.rong.imlib.HttpDnsManager;
import io.rong.imlib.IChatRoomHistoryMessageCallback;
import io.rong.imlib.IConnectStringCallback;
import io.rong.imlib.IConnectionStatusListener;
import io.rong.imlib.IDataByBatchListener;
import io.rong.imlib.IDownloadMediaCallback;
import io.rong.imlib.IDownloadMediaFileCallback;
import io.rong.imlib.IDownloadMediaMessageCallback;
import io.rong.imlib.IGetConversationListWithProcessCallback;
import io.rong.imlib.IGetNotificationQuietHoursCallback;
import io.rong.imlib.IGetUserStatusCallback;
import io.rong.imlib.IHandler;
import io.rong.imlib.IIntegerCallback;
import io.rong.imlib.ILongCallback;
import io.rong.imlib.IMessageExpansionListener;
import io.rong.imlib.INaviContentUpdateCallBack;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IRLogOtherProgressCallback;
import io.rong.imlib.IRTCConfigCallback;
import io.rong.imlib.IRTCHeartbeatListener;
import io.rong.imlib.IRTCJoinRoomCallback;
import io.rong.imlib.IResultCallback;
import io.rong.imlib.IRtcIODataListener;
import io.rong.imlib.ISendMediaMessageCallback;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.ISetPushSettingCallback;
import io.rong.imlib.ISetUserStatusCallback;
import io.rong.imlib.ISolveServerHostsCallBack;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.ISubscribeUserStatusCallback;
import io.rong.imlib.IUploadCallback;
import io.rong.imlib.KVStatusDataByBatchListener;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.OnGetHistoryMessagesCallback;
import io.rong.imlib.OnReceiveMessageListener;
import io.rong.imlib.RTCDataListener;
import io.rong.imlib.UserProfileSettingListener;
import io.rong.imlib.filetransfer.CancelCallback;
import io.rong.imlib.filetransfer.MediaDownloadEngine;
import io.rong.imlib.filetransfer.PauseCallback;
import io.rong.imlib.filetransfer.upload.MediaUploadEngine;
import io.rong.imlib.httpdns.HttpDnsCompletion;
import io.rong.imlib.httpdns.RongHttpDns;
import io.rong.imlib.httpdns.RongHttpDnsResult;
import io.rong.imlib.model.ChatRoomInfo;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.ConversationStatus;
import io.rong.imlib.model.Discussion;
import io.rong.imlib.model.Group;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;
import io.rong.imlib.model.RCEncryptedSession;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.RemoteHistoryMsgOption;
import io.rong.imlib.model.RemoteModelWrap;
import io.rong.imlib.model.RongListWrap;
import io.rong.imlib.model.SearchConversationResult;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.model.UserData;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import io.rong.imlib.statistics.CrashDetails;
import io.rong.rtlog.upload.RtLogUploadManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LibHandlerStub
extends IHandler.Stub {
    private static final String TAG = "LibHandlerStub";
    private Context mContext;
    private String mCurrentUserId;
    private NativeClient mClient;
    private boolean mCancelSDKHeartbeat;

    public LibHandlerStub(Context context, String appKey, String deviceId) {
        this.mContext = context;
        this.mClient = NativeClient.getInstance();
        this.mClient.init(this.mContext, appKey, deviceId);
    }

    @Override
    public String getCurrentUserId() {
        try {
            return this.mClient.getCurrentUserId();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public synchronized void cancelSDKHeartBeat() {
        this.mCancelSDKHeartbeat = true;
        try {
            HeartBeatManager.getInstance().cancelSDKHeartBeat(this.mContext);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendPing() {
        try {
            HeartBeatManager.getInstance().ping(this.mContext);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setUserPolicy(boolean enable) {
        try {
            NavigationCacheHelper.setUserPolicy(enable);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void initAppendixModule() {
        this.mClient.initAppendixModule();
    }

    @Override
    public void connect(String token, boolean isReconnect, boolean inForeground, final IConnectStringCallback callback) {
        try {
            this.mClient.connect(token, isReconnect, inForeground, new NativeClient.IConnectResultCallback<String>(){

                @Override
                public void OnDatabaseOpened(int code) {
                    if (callback != null) {
                        try {
                            callback.OnDatabaseOpened(code);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccess(String userId) {
                    if (callback != null) {
                        LibHandlerStub.this.mCurrentUserId = userId;
                        HeartBeatManager.getInstance().scheduleHeartbeat(LibHandlerStub.this.mContext);
                        try {
                            callback.onComplete(userId);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    HeartBeatManager.getInstance().removeHeartbeatFromAM(LibHandlerStub.this.mContext);
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            NavigationCacheHelper.clearCache(this.mContext);
            try {
                callback.onFailure(-1);
            }
            catch (RemoteException ex) {
                this.handleRemoteException(ex);
            }
        }
    }

    @Override
    public void setIpcConnectTimeOut() {
        this.mClient.setIpcConnectTimeOut();
    }

    @Override
    public void initIPCEnviroment(String token, int status) {
        this.mClient.initIPCEnviroment(token, status);
    }

    @Override
    public void disconnect(boolean isReceivePush) {
        try {
            HeartBeatManager.getInstance().removeHeartbeatFromAM(this.mContext);
            this.mClient.disconnect(isReceivePush);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void registerMessageType(String className) {
        try {
            Class<?> loader = Class.forName(className);
            this.mClient.registerMessageType(loader);
        }
        catch (Exception e) {
            FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type|stacks", className, Arrays.toString(e.getStackTrace()));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            io.rong.common.rlog.RLog.e(TAG, "registerMessageType Exception :\n" + stringWriter.toString());
        }
    }

    @Override
    public void registerMessageTypes(List<String> classNameList) throws RemoteException {
        try {
            if (classNameList == null || classNameList.size() == 0) {
                return;
            }
            ArrayList<Class<? extends MessageContent>> classList = new ArrayList<Class<? extends MessageContent>>();
            for (String className : classNameList) {
                Class<?> loader = Class.forName(className);
                classList.add(loader);
            }
            this.mClient.registerMessageType(classList);
        }
        catch (Exception e) {
            StringBuilder classNamesBuilder = new StringBuilder();
            for (String className : classNameList) {
                classNamesBuilder.append(className).append(",");
            }
            FwLog.write(1, 1, FwLog.LogTag.L_REGTYPE_E.getTag(), "msg_type|stacks", classNamesBuilder.toString(), Arrays.toString(e.getStackTrace()));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            io.rong.common.rlog.RLog.e(TAG, "registerMessageTypeList Exception :\n" + stringWriter.toString());
        }
    }

    @Override
    public void setConnectionStatusListener(final IConnectionStatusListener callback) {
        try {
            this.mClient.setConnectionStatusListener(new NativeClient.ICodeListener(){

                @Override
                public void onChanged(int status) {
                    io.rong.common.rlog.RLog.d(LibHandlerStub.TAG, "[connect] onChanged status:" + status);
                    if (!LibHandlerStub.this.mCancelSDKHeartbeat) {
                        HeartBeatManager.getInstance().replenishPing(LibHandlerStub.this.mContext, status);
                    }
                    if (callback != null) {
                        try {
                            callback.onChanged(status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public int getTotalUnreadCount() {
        try {
            return this.mClient.getTotalUnreadCount();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCount(int[] types) {
        try {
            if (types == null || types.length == 0) {
                return 0;
            }
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.getUnreadCount(conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountWithDND(int[] types, boolean withDND) {
        try {
            if (types == null || types.length == 0) {
                return 0;
            }
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.getUnreadCount(withDND, conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountById(int type, String id) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(type);
            if (conversationType == null || id == null) {
                return 0;
            }
            return this.mClient.getUnreadCount(conversationType, id);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getMessageCount(int type, String id) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(type);
            if (conversationType == null || id == null) {
                return 0;
            }
            return this.mClient.getMessageCount(conversationType, id);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public int getUnreadCountByConversation(Conversation[] conversations) {
        try {
            return this.mClient.getTotalUnreadCount(conversations);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public void setOnReceiveMessageListener(final OnReceiveMessageListener listener) {
        try {
            if (listener != null) {
                NativeClient.OnReceiveMessageListener receiveMessageListener = new NativeClient.OnReceiveMessageListener(){

                    @Override
                    public void onReceived(Message message, int left, boolean offline, boolean hasMsg, int cmdLeft) {
                        try {
                            listener.onReceived(message, left, offline, hasMsg, cmdLeft);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.mClient.setOnReceiveMessageListener(receiveMessageListener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public Message insertMessage(Message message) {
        try {
            return this.mClient.insertMessage(message.getConversationType(), message.getTargetId(), message.getSenderUserId(), message.getContent(), message.getSentTime());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message insertSettingMessage(Message message) {
        try {
            return this.mClient.insertSettingMessage(message);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message getMessage(int messageId) {
        try {
            return this.mClient.getMessage(messageId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Message getMessageByUid(String uid) {
        try {
            return this.mClient.getMessageByUid(uid);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void sendMessage(Message message, String pushContent, String pushData, final ISendMessageCallback callback) {
        try {
            this.mClient.sendMessage(message, pushContent, pushData, null, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendMessageOption(Message message, String pushContent, String pushData, SendMessageOption option, final ISendMessageCallback callback) throws RemoteException {
        try {
            this.mClient.sendMessageOption(message, pushContent, pushData, option, null, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendDirectionalMessage(Message message, String pushContent, String pushData, String[] userIds, final ISendMessageCallback callback) {
        try {
            this.mClient.sendMessage(message, pushContent, pushData, userIds, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendLocationMessage(Message message, String pushContent, String pushData, final ISendMessageCallback callback) {
        try {
            this.mClient.sendLocationMessage(message, pushContent, pushData, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> getNewestMessages(Conversation conversation, int count) {
        try {
            return this.mClient.getLatestMessages(conversation.getConversationType(), conversation.getTargetId(), count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> getOlderMessages(Conversation conversation, long flagId, int count) {
        try {
            return this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), flagId, count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void getOlderMessagesOneWay(Conversation conversation, long flagId, int count, OnGetHistoryMessagesCallback callback) {
        try {
            List<Message> messages = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), flagId, count);
            try {
                callback.onComplete(new RemoteModelWrap(RongListWrap.obtain(messages, Message.class)));
            }
            catch (RemoteException e) {
                io.rong.common.rlog.RLog.e(TAG, "getOlderMessages", e);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getChatroomHistoryMessages(String targetId, long recordTime, int count, int order, final IChatRoomHistoryMessageCallback callback) {
        try {
            this.mClient.getChatroomHistoryMessages(targetId, recordTime, count, order, new NativeClient.IResultCallbackEx<List<Message>, Long>(){

                @Override
                public void onSuccess(List<Message> messages, Long aLong) {
                    if (callback != null) {
                        try {
                            if (messages == null || messages.size() == 0) {
                                callback.onComplete(null, aLong);
                            } else {
                                callback.onComplete(new RemoteModelWrap(RongListWrap.obtain(messages, Message.class)), aLong);
                            }
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getUserStatus(String userId, final IGetUserStatusCallback callback) {
        try {
            this.mClient.getUserStatus(userId, new NativeClient.IResultCallbackEx<String, Integer>(){

                @Override
                public void onSuccess(String platformInfo, Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(platformInfo, status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void subscribeStatus(List<String> users, final IIntegerCallback callback) {
        try {
            this.mClient.subscribeStatus(users, new NativeClient.IResultCallbackEx<Integer, Integer>(){

                @Override
                public void onSuccess(Integer opStatus, Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setSubscribeStatusListener(final ISubscribeUserStatusCallback callback) {
        try {
            this.mClient.setSubscribeStatusListener(new NativeClient.IResultCallbackEx<String, String>(){

                @Override
                public void onSuccess(String objName, String content) {
                    if (callback != null) {
                        try {
                            callback.onStatusReceived(objName, content);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setPushSetting(int key, String value, final ISetPushSettingCallback callback) {
        try {
            this.mClient.setPushSetting(key, value, new NativeClient.IResultCallback<Long>(){

                @Override
                public void onSuccess(Long aLong) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.onFailure(code);
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getPushSetting(int key) {
        try {
            return this.mClient.getPushSetting(key);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setUserStatus(int status, final ISetUserStatusCallback callback) {
        try {
            this.mClient.setUserStatus(status, new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer code) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getRemoteHistoryMessages(Conversation conversation, long dataTime, int count, final IResultCallback callback) {
        try {
            this.mClient.getRemoteHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), dataTime, count, new NativeClient.IResultCallback<List<Message>>(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(List<Message> messages) {
                    if (callback != null) {
                        RemoteModelWrap result = null;
                        try {
                            if (messages == null || messages.size() == 0) {
                                callback.onComplete(result);
                            } else {
                                result = new RemoteModelWrap(RongListWrap.obtain(messages, Message.class));
                                callback.onComplete(result);
                            }
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getRemoteHistoryMessagesOption(Conversation conversation, RemoteHistoryMsgOption remoteHistoryMsgOption, final IResultCallback callback) throws RemoteException {
        try {
            this.mClient.getRemoteHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), remoteHistoryMsgOption, new NativeClient.IResultCallback<List<Message>>(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(List<Message> messages) {
                    if (callback != null) {
                        RemoteModelWrap result = null;
                        try {
                            if (messages == null || messages.size() == 0) {
                                callback.onComplete(result);
                            } else {
                                result = new RemoteModelWrap(RongListWrap.obtain(messages, Message.class));
                                callback.onComplete(result);
                            }
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> getOlderMessagesByObjectName(Conversation conversation, String objectName, long flagId, int count, boolean flag) {
        List<Message> list = null;
        try {
            list = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), objectName, flagId, count, flag);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public List<Message> getOlderMessagesByObjectNames(Conversation conversation, List<String> objectNames, long flagId, int count, boolean flag) {
        List<Message> list = null;
        try {
            list = this.mClient.getHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), objectNames, flagId, count, flag);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public boolean deleteMessage(int[] ids) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        try {
            return this.mClient.deleteMessages(ids);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void deleteMessages(int conversationType, String targetId, Message[] messages, IOperationCallback callback) {
        try {
            Conversation.ConversationType type = Conversation.ConversationType.setValue(conversationType);
            if (type.equals((Object)Conversation.ConversationType.CHATROOM)) {
                io.rong.common.rlog.RLog.e(TAG, "this conversationType isn't supported!");
                return;
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("messages \u53c2\u6570\u5f02\u5e38\u3002");
            }
            this.mClient.deleteMessages(type, targetId, messages, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean deleteConversationMessage(int conversationType, String targetId) {
        try {
            return this.mClient.deleteMessage(Conversation.ConversationType.setValue(conversationType), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearMessages(Conversation conversation) {
        try {
            return this.mClient.clearMessages(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void cleanRemoteHistoryMessages(Conversation conversation, long recordTime, IOperationCallback callback) {
        try {
            this.mClient.cleanRemoteHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), recordTime, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cleanHistoryMessages(Conversation conversation, long recordTime, IOperationCallback callback) {
        try {
            this.mClient.cleanHistoryMessages(conversation.getConversationType(), conversation.getTargetId(), recordTime, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean clearMessagesUnreadStatus(Conversation conversation) {
        try {
            return this.mClient.clearMessagesUnreadStatus(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageExtra(int messageId, String values) {
        try {
            return this.mClient.setMessageExtra(messageId, values);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageReceivedStatus(int messageId, int status) {
        try {
            return this.mClient.setMessageReceivedStatus(messageId, new Message.ReceivedStatus(status));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean setMessageSentStatus(int messageId, int status) {
        try {
            return this.mClient.setMessageSentStatus(messageId, Message.SentStatus.setValue(status));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Conversation> getConversationList() {
        List<Conversation> list = null;
        try {
            list = this.mClient.getConversationList();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void getTopConversationList(int[] types, int countPerBatch, IGetConversationListWithProcessCallback callback) throws RemoteException {
        if (callback == null) {
            return;
        }
        try {
            List<Conversation> list = this.mClient.getTopConversationList(types);
            this.processConversationList(list, countPerBatch, callback);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            callback.onComplete();
        }
    }

    @Override
    public void getConversationListByBatch(int countPerBatch, IGetConversationListWithProcessCallback callback) throws RemoteException {
        if (callback == null) {
            return;
        }
        try {
            List<Conversation> list = this.mClient.getConversationList();
            this.processConversationList(list, countPerBatch, callback);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            callback.onComplete();
        }
    }

    @Override
    public boolean updateConversationInfo(int type, String targetId, String title, String portrait) {
        try {
            return this.mClient.updateConversationInfo(Conversation.ConversationType.setValue(type), targetId, title, portrait);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Conversation> getConversationListByType(int[] types) {
        List<Conversation> list = null;
        try {
            list = this.mClient.getConversationList(types);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void getConversationListOfTypesByBatch(int[] types, int countPerBatch, IGetConversationListWithProcessCallback callback) throws RemoteException {
        if (callback == null) {
            return;
        }
        try {
            List<Conversation> list = this.mClient.getConversationList(types);
            this.processConversationList(list, countPerBatch, callback);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            callback.onComplete();
        }
    }

    @Override
    public List<Conversation> getConversationListByPage(int[] types, long timeStamp, int count) {
        try {
            return this.mClient.getConversationListByPage(types, timeStamp, count);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    private void processConversationList(List<Conversation> conversationList, int processLimit, IGetConversationListWithProcessCallback callback) throws RemoteException {
        if (conversationList != null) {
            int processSize = 0;
            ArrayList<Conversation> processList = new ArrayList<Conversation>();
            for (Conversation conversation : conversationList) {
                processList.add(conversation);
                if (++processSize < processLimit) continue;
                callback.onProcess(processList);
                processSize = 0;
                processList.clear();
            }
            if (processSize > 0) {
                callback.onProcess(processList);
                processList.clear();
            }
        }
        callback.onComplete();
    }

    @Override
    public List<Conversation> getBlockedConversationList(int[] types) {
        try {
            return this.mClient.getBlockedConversationList(types);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public Conversation getConversation(int type, String targetId) {
        try {
            return this.mClient.getConversation(Conversation.ConversationType.setValue(type), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean removeConversation(int typeValue, String targetId) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(typeValue);
            if (conversationType == null) {
                io.rong.common.rlog.RLog.i(TAG, "removeConversation the conversation type is null");
                return false;
            }
            return this.mClient.removeConversation(conversationType, targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearConversations(int[] types) {
        if (types == null || types.length == 0) {
            return false;
        }
        try {
            Conversation.ConversationType[] conversationTypes = new Conversation.ConversationType[types.length];
            for (int i = 0; i < types.length; ++i) {
                conversationTypes[i] = Conversation.ConversationType.setValue(types[i]);
            }
            return this.mClient.clearConversations(conversationTypes);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            io.rong.common.rlog.RLog.e(TAG, "clearConversations", e);
        }
        return false;
    }

    @Override
    public boolean saveConversationDraft(Conversation conversation, String content) {
        try {
            io.rong.common.rlog.RLog.i(TAG, "saveConversationDraft " + content);
            return this.mClient.saveTextMessageDraft(conversation.getConversationType(), conversation.getTargetId(), content);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public String getConversationDraft(Conversation conversation) {
        try {
            return this.mClient.getTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean cleanConversationDraft(Conversation conversation) {
        try {
            return this.mClient.clearTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void getConversationNotificationStatus(int type, String targetId, final ILongCallback callback) {
        try {
            this.mClient.getConversationNotificationStatus(Conversation.ConversationType.setValue(type), targetId, new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status.intValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setConversationNotificationStatus(int type, String targetId, int status, final ILongCallback callback) {
        try {
            this.mClient.setConversationNotificationStatus(Conversation.ConversationType.setValue(type), targetId, Conversation.ConversationNotificationStatus.setValue(status), new NativeClient.IResultCallback<Integer>(){

                @Override
                public void onSuccess(Integer status) {
                    if (callback != null) {
                        try {
                            callback.onComplete(status.intValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean setConversationTopStatus(int typeValue, String targetId, boolean isTop, boolean needCreate) {
        try {
            Conversation.ConversationType conversationType = Conversation.ConversationType.setValue(typeValue);
            if (conversationType == null) {
                io.rong.common.rlog.RLog.e(TAG, "setConversationTopStatus ConversationType is null");
                return false;
            }
            return this.mClient.setConversationToTop(conversationType, targetId, isTop, needCreate);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public int getConversationUnreadCount(Conversation conversation) {
        try {
            return this.mClient.getUnreadCount(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1;
        }
    }

    @Override
    public void getDiscussion(String id, final IResultCallback callback) {
        try {
            this.mClient.getDiscussion(id, new NativeClient.IResultCallback<Discussion>(){

                @Override
                public void onSuccess(Discussion discussion) {
                    if (callback != null) {
                        RemoteModelWrap result = new RemoteModelWrap(discussion);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setDiscussionName(String id, String name, IOperationCallback callback) {
        try {
            this.mClient.setDiscussionName(id, name, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void createDiscussion(final String name, final List<String> userIds, final IResultCallback callback) {
        try {
            this.mClient.createDiscussion(name, userIds, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String discussionId) {
                    if (callback != null) {
                        Discussion model = new Discussion(discussionId, name, LibHandlerStub.this.mCurrentUserId, true, userIds);
                        RemoteModelWrap result = new RemoteModelWrap(model);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void searchPublicService(String keyWords, int businessType, int searchType, final IResultCallback callback) {
        try {
            this.mClient.searchPublicService(keyWords, businessType, searchType, new NativeClient.IResultCallback<PublicServiceProfileList>(){

                @Override
                public void onSuccess(PublicServiceProfileList publicServiceInfoList) {
                    if (callback != null) {
                        RemoteModelWrap result = new RemoteModelWrap(publicServiceInfoList);
                        try {
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void subscribePublicService(String targetId, int categoryId, boolean subscribe, final IOperationCallback callback) {
        try {
            this.mClient.subscribePublicService(targetId, categoryId, subscribe, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getPublicServiceProfile(String targetId, int conversationType, final IResultCallback callback) {
        try {
            this.mClient.getPublicServiceProfile(targetId, conversationType, new NativeClient.IResultCallback<PublicServiceProfile>(){

                @Override
                public void onSuccess(PublicServiceProfile info) {
                    if (callback != null) {
                        RemoteModelWrap mModelWrap = null;
                        if (info != null) {
                            mModelWrap = new RemoteModelWrap(info);
                        }
                        try {
                            callback.onComplete(mModelWrap);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getPublicServiceList(final IResultCallback callback) {
        try {
            this.mClient.getPublicServiceList(new NativeClient.IResultCallback<PublicServiceProfileList>(){

                @Override
                public void onSuccess(PublicServiceProfileList list) {
                    if (callback != null) {
                        RemoteModelWrap mModelWrap = new RemoteModelWrap(list);
                        try {
                            callback.onComplete(mModelWrap);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void addMemberToDiscussion(String id, List<String> userIds, IOperationCallback callback) {
        try {
            this.mClient.addMemberToDiscussion(id, userIds, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeDiscussionMember(String id, String userId, IOperationCallback callback) {
        try {
            this.mClient.removeMemberFromDiscussion(id, userId, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitDiscussion(String id, IOperationCallback callback) {
        try {
            this.mClient.quitDiscussion(id, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void syncGroup(List<Group> groups, IOperationCallback callback) {
        try {
            this.mClient.syncGroup(groups, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinGroup(String id, String name, IOperationCallback callback) {
        try {
            this.mClient.joinGroup(id, name, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitGroup(String id, IOperationCallback callback) {
        try {
            this.mClient.quitGroup(id, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getChatRoomInfo(String id, int count, int order, final IResultCallback callback) {
        try {
            this.mClient.queryChatRoomInfo(id, count, order, new NativeClient.IResultCallback<ChatRoomInfo>(){

                @Override
                public void onSuccess(ChatRoomInfo chatRoomInfo) {
                    if (callback != null) {
                        try {
                            RemoteModelWrap result = new RemoteModelWrap(chatRoomInfo);
                            callback.onComplete(result);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinChatRoom(final String id, int defMessageCount, final IOperationCallback callback) {
        try {
            FwLog.write(3, 1, FwLog.LogTag.L_JOIN_CHATROOM_T.getTag(), "room_id|existed", id, false);
            this.mClient.joinChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(3, 1, FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(1, 1, FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void reJoinChatRoom(final String id, int defMessageCount, final IOperationCallback callback) {
        FwLog.write(3, 1, FwLog.LogTag.L_REJOIN_CHATROOM_T.getTag(), "room_id", id);
        try {
            this.mClient.reJoinChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(3, 1, FwLog.LogTag.L_REJOIN_CHATROOM_R.getTag(), "code|room_id", 0, id);
                    io.rong.common.rlog.RLog.d(LibHandlerStub.TAG, "reJoinChatRoom " + id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(1, 1, FwLog.LogTag.L_REJOIN_CHATROOM_R.getTag(), "code|room_id", errorCode, id);
                    io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "reJoinChatRoom " + errorCode);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void joinExistChatRoom(final String id, int defMessageCount, final IOperationCallback callback, boolean keepMsg) {
        FwLog.write(3, 1, FwLog.LogTag.L_JOIN_CHATROOM_T.getTag(), "room_id|existed", id, true);
        try {
            this.mClient.joinExistChatRoom(id, defMessageCount, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(3, 1, FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(1, 1, FwLog.LogTag.L_JOIN_CHATROOM_R.getTag(), "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            }, keepMsg);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void quitChatRoom(final String id, final IOperationCallback callback) {
        FwLog.write(3, 1, FwLog.LogTag.L_QUIT_CHATROOM_T.getTag(), "room_id", id);
        try {
            this.mClient.quitChatRoom(id, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    FwLog.write(3, 1, FwLog.LogTag.L_QUIT_CHATROOM_R.getTag(), "code|room_id", 0, id);
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    FwLog.write(1, 1, FwLog.LogTag.L_QUIT_CHATROOM_R.getTag(), "code|room_id", errorCode, id);
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setNotificationQuietHours(String startTime, int spanMinutes, final IOperationCallback callback) {
        try {
            this.mClient.setNotificationQuietHours(startTime, spanMinutes, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeNotificationQuietHours(final IOperationCallback callback) {
        try {
            this.mClient.removeNotificationQuietHours(new NativeClient.OperationCallback(){

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getNotificationQuietHours(final IGetNotificationQuietHoursCallback callback) {
        try {
            this.mClient.getNotificationQuietHours(new NativeClient.GetNotificationQuietHoursCallback(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onError(code);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }

                @Override
                public void onSuccess(String start, int min) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(start, min);
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void uploadMedia(Message message, final IUploadCallback callback) {
        try {
            this.mClient.uploadMedia(message, new NativeClient.IResultProgressCallback<String>(){

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(String uri) {
                    if (callback != null) {
                        try {
                            callback.onComplete(uri);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(int messageId) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMedia(Conversation conversation, int type, String imageUrl, final IDownloadMediaCallback callback) {
        try {
            this.mClient.downloadMedia(conversation.getConversationType(), conversation.getTargetId(), type, imageUrl, new NativeClient.IResultProgressCallback<String>(){

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(String localMediaPath) {
                    if (callback != null) {
                        try {
                            callback.onComplete(localMediaPath);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(int messageId) {
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMediaMessage(Message message, final IDownloadMediaMessageCallback callback) {
        try {
            this.mClient.downloadMediaMessage(message, new NativeClient.IDownloadMediaMessageCallback<Message>(){

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onComplete(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled() {
                    if (callback != null) {
                        try {
                            callback.onCanceled();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void downloadMediaFile(String uid, String fileUrl, String fileName, String path, final IDownloadMediaFileCallback callback) {
        try {
            this.mClient.downloadMediaFile(uid, fileUrl, fileName, path, new NativeClient.IDownloadMediaFileCallback<Boolean>(){

                @Override
                public void onFileNameChanged(String newFileName) {
                    if (callback == null) {
                        return;
                    }
                    try {
                        callback.onFileNameChanged(newFileName);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onSuccess(Boolean result) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(int progress) {
                    if (callback != null) {
                        try {
                            callback.onProgress(progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled() {
                    if (callback != null) {
                        try {
                            callback.onCanceled();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cancelSendMediaMessage(Message message, final IOperationCallback callback) throws RemoteException {
        try {
            MediaUploadEngine.getInstance().cancel(message.getMessageId(), new CancelCallback(){

                @Override
                public void onCanceled(Object tag) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cancelDownloadMediaMessage(Message message, final IOperationCallback callback) throws RemoteException {
        try {
            MediaDownloadEngine.getInstance().cancel(message.getMessageId(), new CancelCallback(){

                @Override
                public void onCanceled(Object tag) {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void cancelAllDownloadMediaMessage(IOperationCallback callback) throws RemoteException {
        block5: {
            try {
                MediaDownloadEngine.getInstance().cancelAll();
                if (callback != null) {
                    callback.onComplete();
                }
            }
            catch (Exception e) {
                io.rong.common.rlog.RLog.e(TAG, "cancelAllDownloadMediaMessage", e);
                if (callback == null) break block5;
                try {
                    callback.onFailure(-1);
                }
                catch (RemoteException remoteException) {
                    this.handleRemoteException(remoteException);
                }
            }
        }
    }

    @Override
    public void pauseTransferMediaMessage(Message message, final IOperationCallback callback) throws RemoteException {
        MediaDownloadEngine.getInstance().pause(message.getMessageId(), new PauseCallback(){

            @Override
            public void onPaused(Object tag) {
                try {
                    callback.onComplete();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int code) {
                try {
                    callback.onFailure(code);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void pauseTransferMediaFile(String tag, final IOperationCallback callback) throws RemoteException {
        MediaDownloadEngine.getInstance().pause(tag, new PauseCallback(){

            @Override
            public void onPaused(Object tag) {
                try {
                    callback.onComplete();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int code) {
                try {
                    callback.onFailure(code);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public boolean getFileDownloadingStatus(String uid) {
        return MediaDownloadEngine.getInstance().getDownloadingFromMap(this.mContext, uid);
    }

    @Override
    public boolean supportResumeBrokenTransfer(String url) {
        return MediaDownloadEngine.checkSupportResumeTransfer(url);
    }

    @Override
    public long getDeltaTime() {
        try {
            return this.mClient.getDeltaTime();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public void setDiscussionInviteStatus(String targetId, int status, final IOperationCallback callback) {
        try {
            this.mClient.setDiscussionInviteStatus(targetId, status, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void recallMessage(String objectName, byte[] content, String pushContent, int messageId, String targetId, int conversationType, boolean disableNotification, final IOperationCallback callback) {
        try {
            this.mClient.recallMessage(objectName, content, pushContent, messageId, targetId, conversationType, disableNotification, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void addToBlacklist(String userId, final IOperationCallback callback) {
        try {
            this.mClient.addToBlacklist(userId, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeFromBlacklist(String userId, final IOperationCallback callback) {
        try {
            this.mClient.removeFromBlacklist(userId, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getBlacklistStatus(String userId, final IIntegerCallback callback) {
        try {
            this.mClient.getBlacklistStatus(userId, new NativeClient.IResultCallback<NativeClient.BlacklistStatus>(){

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(NativeClient.BlacklistStatus blacklistStatus) {
                    if (callback != null) {
                        try {
                            callback.onComplete(blacklistStatus.getValue());
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getBlacklist(final IStringCallback callback) {
        try {
            this.mClient.getBlacklist(new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String userIds) {
                    if (callback != null) {
                        try {
                            callback.onComplete(userIds);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getTextMessageDraft(Conversation conversation) {
        try {
            return this.mClient.getTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public boolean saveTextMessageDraft(Conversation conversation, String content) {
        try {
            return this.mClient.saveTextMessageDraft(conversation.getConversationType(), conversation.getTargetId(), content);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearTextMessageDraft(Conversation conversation) {
        try {
            return this.mClient.clearTextMessageDraft(conversation.getConversationType(), conversation.getTargetId());
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void setUserData(UserData userData, final IOperationCallback callback) {
        try {
            this.mClient.setUserData(userData, new NativeClient.OperationCallback(){

                @Override
                public void onSuccess() {
                    if (callback != null) {
                        try {
                            callback.onComplete();
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean updateMessageReceiptStatus(String targetId, int categoryId, long timestamp) {
        try {
            return this.mClient.updateMessageReceiptStatus(targetId, categoryId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean clearUnreadByReceipt(int conversationType, String targetId, long timestamp) {
        try {
            return this.mClient.clearUnreadByReceipt(conversationType, targetId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public long getSendTimeByMessageId(int messageId) {
        try {
            return this.mClient.getSendTimeByMessageId(messageId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public void getVoIPKey(int engineType, String channelName, String extra, final IStringCallback callback) {
        try {
            this.mClient.getVoIPKey(engineType, channelName, extra, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public String getVoIPCallInfo() {
        try {
            return this.mClient.getVoIPCallInfo();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setServerInfo(String naviServer, String fileServer) {
        try {
            this.mClient.setServerInfo(naviServer, fileServer);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void initHttpDns() {
        try {
            this.mClient.initHttpDns();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public long getNaviCachedTime() {
        try {
            return NavigationCacheHelper.getCachedTime();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return -1L;
        }
    }

    @Override
    public boolean setMessageContent(int messageId, byte[] messageContent, String objectName) {
        try {
            return this.mClient.setMessageContent(messageId, messageContent, objectName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public List<Message> getUnreadMentionedMessages(int conversationType, String targetId) {
        List<Message> list = null;
        try {
            list = this.mClient.getUnreadMentionedMessages(Conversation.ConversationType.setValue(conversationType), targetId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    public void sendMediaMessage(Message message, String pushContent, String pushData, final ISendMediaMessageCallback sendMediaMessageCallback) {
        try {
            this.mClient.sendMediaMessage(message, pushContent, pushData, new NativeClient.ISendMediaMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onProgress(Message message, int progress) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onProgress(message, progress);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onCanceled(Message message) {
                    if (sendMediaMessageCallback != null) {
                        try {
                            sendMediaMessageCallback.onCanceled(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void sendDirectionalMediaMessage(Message message, String[] userIds, String pushContent, String pushData, final ISendMediaMessageCallback sendMediaMessageCallback) {
        try {
            this.mClient.sendMediaMessage(message, userIds, pushContent, pushData, new NativeClient.ISendMediaMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onAttached(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onSuccess(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onProgress(Message message, int progress) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onProgress(message, progress);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onError(message, code);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }

                @Override
                public void onCanceled(Message message) {
                    try {
                        if (sendMediaMessageCallback != null) {
                            sendMediaMessageCallback.onCanceled(message);
                        }
                    }
                    catch (RemoteException e) {
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public boolean updateReadReceiptRequestInfo(String msgUId, String info) {
        if (msgUId == null || info == null) {
            io.rong.common.rlog.RLog.d(TAG, "updateReadReceiptRequestInfo parameter error");
            return false;
        }
        try {
            return this.mClient.updateReadReceiptRequestInfo(msgUId, info);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public void registerCmdMsgType(String objName) {
        try {
            this.mClient.registerCmdMsgType(objName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void registerCmdMsgTypes(List<String> objNameList) throws RemoteException {
        try {
            this.mClient.registerCmdMsgType(objNameList);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void registerDeleteMessageType(List<String> objNames) {
        try {
            this.mClient.registerDeleteMessageType(objNames);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public List<Message> searchMessages(String targetId, int conversationType, String keyword, int count, long timestamp) {
        try {
            return this.mClient.searchMessages(targetId, Conversation.ConversationType.setValue(conversationType), keyword, count, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> searchMessagesByUser(String targetId, int conversationType, String userId, int count, long timestamp) {
        try {
            return this.mClient.searchMessagesByUser(targetId, Conversation.ConversationType.setValue(conversationType), userId, count, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<SearchConversationResult> searchConversations(String keyword, int[] conversationTypes, String[] objName) {
        try {
            return this.mClient.searchConversations(keyword, conversationTypes, objName);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public List<Message> getMatchedMessages(String targetId, int conversationType, long timestamp, int before, int after) {
        try {
            return this.mClient.getMatchedMessages(targetId, Conversation.ConversationType.setValue(conversationType), timestamp, before, after);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void getVendorToken(final IStringCallback callback) {
        try {
            this.mClient.getVendorToken(new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void writeFwLog(int level, String type, String tag, String metaJson, long timestamp) {
        FwLog.write(level, type, tag, metaJson, timestamp);
    }

    @Override
    public boolean getJoinMultiChatRoomEnable() {
        try {
            return NavigationCacheHelper.isJoinMChatroomEnabled(this.mContext);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean isPhrasesEnabled() {
        return this.mClient.isPhrasesEnabled();
    }

    @Override
    public boolean isDnsEnabled() throws RemoteException {
        return this.mClient.isDnsEnabled();
    }

    @Override
    public String getOfflineMessageDuration() {
        try {
            return this.mClient.getOfflineMessageDuration();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void setOfflineMessageDuration(String duration, final ILongCallback callback) {
        try {
            this.mClient.setOfflineMessageDuration(duration, new NativeClient.IResultCallback<Long>(){

                @Override
                public void onSuccess(Long version) {
                    if (callback != null) {
                        try {
                            callback.onComplete(version);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int errorCode) {
                    if (callback != null) {
                        try {
                            callback.onFailure(errorCode);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void switchAppKey(String appKey, String deviceId) {
        try {
            this.mClient.switchAppKey(appKey, deviceId);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    private void handleRuntimeException(RuntimeException e) {
        FwLog.write(1, 1, FwLog.LogTag.L_CRASH_IPC_RTM_F.getTag(), "stacks|env", FwLog.stackToString(e), CrashDetails.getIMCrashData(this.mContext, e.toString()));
        throw e;
    }

    private void handleRemoteException(RemoteException e) {
        FwLog.write(1, 1, FwLog.LogTag.L_CRASH_IPC_RMT_E.getTag(), "stacks|env", FwLog.stackToString(e), CrashDetails.getIMCrashData(this.mContext, e.toString()));
        e.printStackTrace();
    }

    @Override
    public Message getTheFirstUnreadMessage(int conversationType, String targetId) {
        return this.mClient.getTheFirstUnreadMessage(conversationType, targetId);
    }

    @Override
    public boolean setMessageReadTime(long messageId, long timestamp) {
        try {
            return this.mClient.setMessageReadTime(messageId, timestamp);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return false;
        }
    }

    @Override
    public boolean createEncryptedConversation(String targetId, RCEncryptedSession encryptedSession) {
        return this.mClient.createEncryptedConversation(targetId, encryptedSession);
    }

    @Override
    public RCEncryptedSession getEncryptedConversation(String targetId) {
        return this.mClient.getEncryptedConversation(targetId);
    }

    @Override
    public boolean setEncryptedConversation(String targetId, RCEncryptedSession chaInfo) {
        return this.mClient.setEncryptedConversation(targetId, chaInfo);
    }

    @Override
    public boolean removeEncryptedConversation(String targetId) {
        return this.mClient.removeEncryptedConversation(targetId);
    }

    @Override
    public boolean clearEncryptedConversations() {
        return this.mClient.clearEncryptedConversations();
    }

    @Override
    public List<RCEncryptedSession> getAllEncryptedConversations() {
        return this.mClient.getAllEncryptedConversations();
    }

    @Override
    public void setReconnectKickEnable(boolean enable) {
        this.mClient.setReconnectKickEnable(enable);
    }

    @Override
    public int getVideoLimitTime() {
        return this.mClient.getVideoLimitTime();
    }

    @Override
    public int getGIFLimitSize() {
        return this.mClient.getGIFLimitSize();
    }

    @Override
    public void setUserProfileListener(final UserProfileSettingListener listener) {
        try {
            if (listener != null) {
                NativeClient.PushNotificationListener pushNotificationListener = new NativeClient.PushNotificationListener(){

                    @Override
                    public void OnPushNotificationChanged(long version) {
                        try {
                            listener.OnPushNotificationChanged(version);
                            LibHandlerStub.this.updateRTCProfile();
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                    }
                };
                this.mClient.SetPushNotificationListener(pushNotificationListener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    private void updateRTCProfile() {
        String rtcProfileJson = this.getRTCProfile();
        if (TextUtils.isEmpty((CharSequence)rtcProfileJson)) {
            io.rong.common.rlog.RLog.e(TAG, "updateRTCProfile,rtcProfile is empty");
            return;
        }
        FwLog.write(3, 1, "L-rtc_setting_changed-S", "value", rtcProfileJson);
        try {
            this.updateVoIPCallInfo(rtcProfileJson);
        }
        catch (RemoteException e) {
            io.rong.common.rlog.RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void setConversationStatusListener(final ConversationStatusListener listener) {
        try {
            if (listener != null) {
                NativeObject.ConversationStatusListener conversationStatusListener = new NativeObject.ConversationStatusListener(){

                    @Override
                    public void OnStatusChanged(ConversationStatus[] conversationStatus) {
                        try {
                            listener.OnStatusChanged(conversationStatus);
                        }
                        catch (RemoteException e) {
                            io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                        }
                    }
                };
                this.mClient.setConversationStatusListener(conversationStatusListener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void exitRTCRoom(String roomId, IOperationCallback callback) {
        try {
            this.mClient.exitRTCRoom(roomId, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCUsers(String roomId, int order, final RTCDataListener listener) {
        try {
            this.mClient.getRTCUsers(roomId, order, new NativeClient.IResultCallback<List<RTCUser>>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers) {
                    try {
                        listener.OnSuccess(rtcUsers);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            io.rong.common.rlog.RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCUserData(String roomId, int order, final RTCDataListener listener) {
        try {
            this.mClient.getRTCUserData(roomId, order, new NativeClient.IResultCallback<List<RTCUser>>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers) {
                    try {
                        listener.OnSuccess(rtcUsers);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            io.rong.common.rlog.RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void sendRTCPing(String roomId, IOperationCallback callback) {
        try {
            this.mClient.sendRTCPing(roomId, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "SendRTCPing - " + e.toString());
        }
    }

    @Override
    public boolean useRTCOnly() {
        try {
            return this.mClient.useRTCOnly();
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "UseRTCOnly - " + e.toString());
            return false;
        }
    }

    @Override
    public void rtcPutInnerData(String roomId, int type, String key, String value, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcPutInnerData(roomId, type, key, value, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcPutInnerDatum - " + e.toString());
        }
    }

    @Override
    public void rtcPutOuterData(String roomId, int type, String key, String value, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcPutOuterData(roomId, type, key, value, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcPutOuterDatum - " + e.toString());
        }
    }

    @Override
    public void rtcDeleteInnerData(String roomId, int type, String[] keys, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcDeleteInnerData(roomId, type, keys, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcDeleteInnerData - " + e.toString());
        }
    }

    @Override
    public void rtcDeleteOuterData(String roomId, int type, String[] keys, String objectName, String content, IOperationCallback callback) {
        try {
            this.mClient.rtcDeleteOuterData(roomId, type, keys, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcDeleteOuterData - " + e.toString());
        }
    }

    @Override
    public void rtcGetInnerData(String roomId, int type, String[] keys, final IRtcIODataListener callback) {
        try {
            this.mClient.rtcGetInnerData(roomId, type, keys, new NativeClient.IResultCallback<Map<String, String>>(){

                @Override
                public void onSuccess(Map<String, String> data) {
                    try {
                        callback.OnSuccess(data);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcGetInnerData - " + e.toString());
        }
    }

    @Override
    public void rtcGetOuterData(String roomId, int type, String[] keys, final IRtcIODataListener callback) {
        try {
            this.mClient.rtcGetOuterData(roomId, type, keys, new NativeClient.IResultCallback<Map<String, String>>(){

                @Override
                public void onSuccess(Map<String, String> data) {
                    try {
                        callback.OnSuccess(data);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        callback.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "rtcGetOuterData - " + e.toString());
        }
    }

    @Override
    public void joinRTCRoomAndGetData(String roomId, int roomType, int broadcastType, String key, String value, final IRTCJoinRoomCallback listener) {
        try {
            this.mClient.joinRTCRoomAndGetData(roomId, roomType, broadcastType, key, value, new NativeClient.IResultCallbackEx<List<RTCUser>, Object[]>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers, Object[] tokenAndSessionId) {
                    try {
                        listener.OnSuccess(rtcUsers, String.valueOf(tokenAndSessionId[0]), String.valueOf(tokenAndSessionId[1]), (Map)tokenAndSessionId[2]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            io.rong.common.rlog.RLog.e(TAG, e.toString());
        }
    }

    @Override
    public void getRTCConfig(String model, String osVersion, long timestamp, String sdkVersion, final IRTCConfigCallback callback) throws RemoteException {
        this.mClient.getRTCConfig(model, osVersion, timestamp, sdkVersion, new NativeObject.RTCConfigListener(){

            @Override
            public void onSuccess(String config, long version) {
                try {
                    callback.onSuccess(config, version);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                }
            }

            @Override
            public void onError(int status) {
                try {
                    callback.onError(status);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                }
            }
        });
    }

    @Override
    public void getRTCToken(String roomId, int roomType, int mediaType, final IStringCallback callback) {
        try {
            this.mClient.getRTCToken(roomId, roomType, mediaType, new NativeClient.IResultCallback<String>(){

                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        try {
                            callback.onComplete(s);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(int code) {
                    if (callback != null) {
                        try {
                            callback.onFailure(code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setRLogOtherProgressCallback(final IRLogOtherProgressCallback callback) throws RemoteException {
        try {
            io.rong.common.rlog.RLog.setRlogOtherProgressCallBack(new RLog.IRlogOtherProgressCallback(){

                @Override
                public void write(String log, int level) {
                    try {
                        callback.write(log, level);
                    }
                    catch (RemoteException pE) {
                        pE.printStackTrace();
                    }
                }

                @Override
                public void setLogLevel(int level) {
                    try {
                        callback.setLogLevel(level);
                    }
                    catch (RemoteException pE) {
                        pE.printStackTrace();
                    }
                }

                @Override
                public void uploadRLog() {
                    try {
                        callback.uploadRLog();
                    }
                    catch (RemoteException pE) {
                        pE.printStackTrace();
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setRTCUserData(String roomId, String state, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.setRTCUserState(roomId, state, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "setRTCUserData - " + e.toString());
        }
    }

    @Override
    public void solveServerHosts(String server, final ISolveServerHostsCallBack callback) throws RemoteException {
        HttpDnsManager.getInstance().asyncSolveDnsIp(this.mContext, server, new RongHttpDns.CompletionHandler(){

            @Override
            public void completionHandler(RongHttpDnsResult result) {
                if (result.getResolveStatus() == RongHttpDnsResult.ResolveStatus.BDHttpDnsResolveOK) {
                    try {
                        if (callback != null) {
                            callback.onSuccess(result.getIpv4List());
                        }
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "solveServerHosts:" + (Object)((Object)e));
                    }
                }
            }
        }, new HttpDnsCompletion(this.mContext){

            @Override
            protected void onSuccess(ArrayList<String> hosts) {
                try {
                    if (callback != null) {
                        callback.onSuccess(hosts);
                    }
                }
                catch (RemoteException e) {
                    io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "solveServerHosts:" + (Object)((Object)e));
                }
            }

            @Override
            protected void onFailed(int code) {
                try {
                    if (callback != null) {
                        callback.onFailed(code);
                    }
                }
                catch (RemoteException e) {
                    io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "solveServerHosts:" + (Object)((Object)e));
                }
            }
        });
    }

    @Override
    public void setRTCUserDatas(String roomId, int type, Map data, String objectName, String content, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.setRTCUserData(roomId, type, data, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "setRTCUserDatas - " + e.toString());
        }
    }

    @Override
    public void getRTCUserDatas(String roomId, String[] userIds, final RTCDataListener listener) throws RemoteException {
        try {
            this.mClient.getRTCUserDatas(roomId, userIds, new NativeClient.IResultCallback<List<RTCUser>>(){

                @Override
                public void onSuccess(List<RTCUser> rtcUsers) {
                    try {
                        listener.OnSuccess(rtcUsers);
                    }
                    catch (Exception e) {
                        RLog.e(LibHandlerStub.TAG, "getRTCUserDatas onSuccess", e);
                    }
                }

                @Override
                public void onError(int code) {
                    try {
                        listener.OnError(code);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            io.rong.common.rlog.RLog.e(TAG, "getRTCUserDatas - " + e.toString());
        }
    }

    @Override
    public void sendRTCDirectionalMessage(Message message, String pushContent, String pushData, String[] userIds, SendMessageOption option, boolean isFilterBlackList, final ISendMessageCallback callback) throws RemoteException {
        try {
            this.mClient.sendMessageOption(message, pushContent, pushData, option, userIds, isFilterBlackList, new NativeClient.ISendMessageCallback<Message>(){

                @Override
                public void onAttached(Message message) {
                    if (callback != null) {
                        try {
                            callback.onAttached(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onSuccess(Message message) {
                    if (callback != null) {
                        try {
                            callback.onSuccess(message);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }

                @Override
                public void onError(Message message, int code) {
                    if (callback != null) {
                        try {
                            callback.onError(message, code);
                        }
                        catch (RemoteException e) {
                            LibHandlerStub.this.handleRemoteException(e);
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setChatRoomEntry(String key, String value, String chatRoomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.setChatRoomEntry(key, value, chatRoomId, sendNotification, notificationExtra, autoDelete, isOverWrite, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e(TAG, "setChatRoomEntry - " + e.toString());
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void getChatRoomEntry(String chatRoomId, String key, final IStringCallback callback) throws RemoteException {
        this.mClient.getChatRoomStatusByKey(chatRoomId, key, new NativeClient.IResultCallback<String>(){

            @Override
            public void onSuccess(String value) {
                if (callback != null) {
                    try {
                        callback.onComplete(value);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "getChatRoomEntry - " + e.toString());
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }

            @Override
            public void onError(int code) {
                if (callback != null) {
                    try {
                        callback.onFailure(code);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "getChatRoomEntry - " + e.toString());
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }
        });
    }

    @Override
    public void getAllChatRoomEntries(String chatroomId, final IDataByBatchListener callback) throws RemoteException {
        this.mClient.getAllChatRoomStatus(chatroomId, new NativeClient.IResultCallback<HashMap<String, String>>(){

            @Override
            public void onSuccess(HashMap<String, String> map) {
                if (callback != null) {
                    try {
                        HashMap<String, String> transferMap = new HashMap<String, String>();
                        if (map != null && map.size() > 0) {
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                transferMap.put(entry.getKey(), entry.getValue());
                                if (transferMap.size() % 50 != 0) continue;
                                callback.onProgress(transferMap);
                                transferMap.clear();
                            }
                            if (transferMap.size() > 0) {
                                callback.onProgress(transferMap);
                                transferMap.clear();
                            }
                        }
                        callback.onComplete();
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "getAllChatRoomEntries success ", e);
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }

            @Override
            public void onError(int code) {
                if (callback != null) {
                    try {
                        callback.onError(code);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "getAllChatRoomEntries error ", e);
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }
        });
    }

    @Override
    public void deleteChatRoomEntry(String key, String value, String chatroomId, boolean sendNotification, String notificationExtra, boolean autoDelete, boolean isOverWrite, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.deleteChatRoomEntry(key, value, chatroomId, sendNotification, notificationExtra, autoDelete, isOverWrite, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            io.rong.common.rlog.RLog.e(TAG, "deleteChatRoomEntry ", e);
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setNaviContentUpdateListener(final INaviContentUpdateCallBack callback) throws RemoteException {
        this.mClient.setNaviContentUpdateListener(new NavigationClient.NaviUpdateListener(){

            @Override
            public void onNaviUpdate() {
                try {
                    callback.naviContentUpdate();
                }
                catch (RemoteException e) {
                    LibHandlerStub.this.handleRemoteException(e);
                }
            }
        });
    }

    @Override
    public String getUploadLogConfigInfo() throws RemoteException {
        try {
            return this.mClient.getUploadConfigInfo();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public String getOffLineLogServer() throws RemoteException {
        try {
            return this.mClient.getOffLineLogServer();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return null;
        }
    }

    @Override
    public void notifyAppBackgroundChanged(boolean isInBackground) throws RemoteException {
        RtLogUploadManager.getInstance().setIsBackgroundMode(isInBackground);
        HeartBeatManager.getInstance().setIsBackgroundMode(this.mContext, isInBackground);
    }

    @Override
    public String getRTCProfile() {
        try {
            return this.mClient.getRTCProfile();
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
            return "";
        }
    }

    @Override
    public void updateVoIPCallInfo(String rtcProfile) throws RemoteException {
        try {
            this.mClient.updateVoIPCallInfo(rtcProfile);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void rtcSetUserResource(String roomId, RTCStatusDate[] kv, String objectName, RTCStatusDate[] content, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.rtcSetUserResource(roomId, kv, objectName, content, new OperationCallback(callback));
        }
        catch (Exception e) {
            e.printStackTrace();
            io.rong.common.rlog.RLog.e(TAG, "RTCSetUserResource - " + e.toString());
        }
    }

    @Override
    public void setKvStatusListener(final KVStatusDataByBatchListener kVStatusListener) throws RemoteException {
        this.mClient.setKVStatusListener(new NativeClient.KVStatusListener(){

            @Override
            public void onChatRoomKVStatusSync(String roomId) {
                if (kVStatusListener != null) {
                    try {
                        kVStatusListener.onDataSync(roomId);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onChatRoomKVStatusChange(String roomId, Map<String, String> chatRoomKvMap) {
                if (kVStatusListener != null) {
                    try {
                        HashMap<String, String> transferMap = new HashMap<String, String>();
                        if (chatRoomKvMap != null && chatRoomKvMap.size() > 0) {
                            for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
                                transferMap.put(entry.getKey(), entry.getValue());
                                if (transferMap.size() % 50 != 0) continue;
                                kVStatusListener.onProgressDataChange(transferMap);
                                transferMap.clear();
                            }
                            if (transferMap.size() > 0) {
                                kVStatusListener.onProgressDataChange(transferMap);
                                transferMap.clear();
                            }
                        }
                        kVStatusListener.onCompleteDataChange(roomId);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "setKvStatusListener StatusDidChange Exception ", e);
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }

            @Override
            public void onChatRoomKVStatusRemove(String roomId, Map<String, String> chatRoomKvMap) {
                if (kVStatusListener != null) {
                    try {
                        HashMap<String, String> transferMap = new HashMap<String, String>();
                        if (chatRoomKvMap != null && chatRoomKvMap.size() > 0) {
                            for (Map.Entry<String, String> entry : chatRoomKvMap.entrySet()) {
                                transferMap.put(entry.getKey(), entry.getValue());
                                if (transferMap.size() % 50 != 0) continue;
                                kVStatusListener.onProgressDataRemove(transferMap);
                                transferMap.clear();
                            }
                            if (transferMap.size() > 0) {
                                kVStatusListener.onProgressDataRemove(transferMap);
                                transferMap.clear();
                            }
                        }
                        kVStatusListener.onCompleteDataRemove(roomId);
                    }
                    catch (RemoteException e) {
                        io.rong.common.rlog.RLog.e(LibHandlerStub.TAG, "setKvStatusListener StatusDidRemove Exception ", e);
                        LibHandlerStub.this.handleRemoteException(e);
                    }
                }
            }
        });
    }

    @Override
    public void updateMessageExpansion(Map expansion, String messageUId, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.updateMessageExpansion(expansion, messageUId, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeMessageExpansion(List<String> keyArray, String messageUId, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.removeMessageExpansion(keyArray, messageUId, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void removeMessageAllExpansion(String messageUId, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.removeMessageAllExpansion(messageUId, new OperationCallback(callback));
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void setMessageExpansionListener(IMessageExpansionListener listener) throws RemoteException {
        try {
            if (listener != null) {
                this.mClient.setMessageExpansionListener(listener);
            }
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
    }

    @Override
    public void SetRTCHeartbeatListener(final IRTCHeartbeatListener listener) throws RemoteException {
        if (listener != null) {
            NativeObject.RTCHeartbeatListener rtcHeartbeatListener = new NativeObject.RTCHeartbeatListener(){

                @Override
                public void OnRTCHeartbeat(int code, String roomId) {
                    try {
                        if (listener != null) {
                            listener.OnRTCHeartbeat(code, roomId);
                        }
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            };
            this.mClient.SetRTCHeartbeatListener(rtcHeartbeatListener);
        }
    }

    @Override
    public void SendRTCHeartbeat(String[] roomId) throws RemoteException {
        try {
            this.mClient.SendRTCHeartbeat(roomId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void SendRTCLiveInvitation(String roomId, String anchorId, String peerRoomId, String inviteInfo, String sessionId, int timeout, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.SendRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, timeout, new OperationCallback(callback));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void CancelRTCLiveInvitation(String roomId, String anchorId, String peerRoomId, String inviteInfo, String sessionId, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.CancelRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, new OperationCallback(callback));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void AnswerRTCLiveInvitation(String roomId, int answer, String anchorId, String peerRoomId, String sessionId, String content, String key, String value, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.AnswerRTCLiveInvitation(roomId, answer, anchorId, peerRoomId, sessionId, content, key, value, new OperationCallback(callback));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void HangupRTCLiveInvitation(String roomId, String peerRoomId, String sessionId, String content, String[] keys, IOperationCallback callback) throws RemoteException {
        try {
            this.mClient.HangupRTCLiveInvitation(roomId, peerRoomId, sessionId, content, keys, new OperationCallback(callback));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class OperationCallback
    implements NativeClient.OperationCallback {
        IOperationCallback callback;

        public OperationCallback(IOperationCallback callback) {
            this.callback = callback;
        }

        @Override
        public void onSuccess() {
            if (this.callback != null) {
                try {
                    this.callback.onComplete();
                }
                catch (RemoteException e) {
                    LibHandlerStub.this.handleRemoteException(e);
                }
            }
        }

        @Override
        public void onError(int code) {
            if (this.callback != null) {
                try {
                    this.callback.onFailure(code);
                }
                catch (RemoteException e) {
                    LibHandlerStub.this.handleRemoteException(e);
                }
            }
        }
    }
}

