/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.IOperationCallback;
import io.rong.imlib.IRTCConfigCallback;
import io.rong.imlib.IRTCHeartbeatListener;
import io.rong.imlib.IRTCJoinRoomCallback;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.IRtcIODataListener;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.ISolveServerHostsCallBack;
import io.rong.imlib.IStringCallback;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RTCDataListener;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.ipc.IpcCallbackProxy;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.RTCStatusDate;
import io.rong.imlib.model.RTCUser;
import io.rong.imlib.model.SendMessageOption;
import io.rong.imlib.typingmessage.TypingMessageManager;
import io.rong.imlib.typingmessage.TypingStatusMessage;
import io.rong.message.ReadReceiptMessage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IMLibRTCClient {
    private static final String TAG = "IMLibRTCClient";
    private Handler mWorkHandler;
    private IHandler mLibHandler;
    private static Handler mHandler;
    private static RTCRoomActionListener rtcRoomActionListener;

    private IMLibRTCClient() {
        mHandler = new Handler(Looper.getMainLooper());
    }

    public static IMLibRTCClient getInstance() {
        return SingletonHolder.sInstance;
    }

    public void init(Handler mWorkHandler) {
        this.mWorkHandler = mWorkHandler;
    }

    public void OnServiceConnected(IHandler mLibHandler) {
        this.mLibHandler = mLibHandler;
    }

    public void OnServiceDisconnected() {
        this.mLibHandler = null;
    }

    public static void setRtcRoomActionListener(RTCRoomActionListener roomActionListener) {
        rtcRoomActionListener = roomActionListener;
    }

    public String getVoIPInfo() {
        try {
            if (this.mLibHandler == null) {
                RLog.e(TAG, "IPC disconnected.");
            }
            return this.mLibHandler == null ? "" : this.mLibHandler.getVoIPCallInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exitRTCRoom(final String roomId, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    RLog.d(IMLibRTCClient.TAG, "exitRTCRoom roomId = " + roomId);
                    IMLibRTCClient.this.mLibHandler.exitRTCRoom(roomId, new RTCExitRoomCallback(ipcCallbackProxy));
                    if (rtcRoomActionListener != null) {
                        rtcRoomActionListener.onExited(roomId);
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void getRTCUsers(final String roomId, final int order, IRongCallback.IRTCDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCDataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCDataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.getRTCUsers(roomId, order, new RTCDataListener.Stub(){

                            @Override
                            public void OnSuccess(final List data) {
                                if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void OnError(final int status) {
                                if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy == null || ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void getRTCUserData(final String roomId, final int order, IRongCallback.IRTCDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FwLog.write(1, 2, "L-getRTCUserData-E", "code|desc", RongIMClient.ErrorCode.PARAMETER_ERROR.getValue(), "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        FwLog.write(3, 2, "L-getRTCUserData-T", "roomId", roomId);
        final IpcCallbackProxy<IRongCallback.IRTCDataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCDataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        FwLog.write(1, 2, "L-getRTCUserData-E", "roomId|code|desc", roomId, RongIMClient.ErrorCode.IPC_DISCONNECT.getValue(), "LibHandler is Null");
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.getRTCUserData(roomId, order, new RTCDataListener.Stub(){

                            @Override
                            public void OnSuccess(final List data) {
                                FwLog.write(3, 2, "L-getRTCUserData-R", "roomId", roomId);
                                if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void OnError(final int status) {
                                FwLog.write(1, 2, "L-getRTCUserData-E", "roomId|code", roomId, status);
                                if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        FwLog.write(1, 2, "L-getRTCUserData-E", "roomId|code|desc", roomId, RongIMClient.ErrorCode.IPC_DISCONNECT.getValue(), e.toString());
                        if (ipcCallbackProxy == null || ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void sendRTCPing(final String roomId, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.sendRTCPing(roomId, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setUseRTCOnly(final RongIMClient.ResultCallback<Boolean> callback) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (callback != null) {
                        callback.onCallback(false);
                    }
                    return;
                }
                try {
                    boolean isUseRTCOnly = IMLibRTCClient.this.mLibHandler.useRTCOnly();
                    if (callback != null) {
                        callback.onCallback(isUseRTCOnly);
                    }
                }
                catch (RemoteException e) {
                    if (callback != null) {
                        callback.onCallback(false);
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcPutInnerDatum(final String roomId, final int type, final String key, final String value, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcPutInnerData(roomId, type, key, value, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcPutOuterDatum(final String roomId, final int type, final String key, final String value, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.rtcPutOuterData(roomId, type, key, value, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                        if (ipcCallbackProxy == null || ipcCallbackProxy.callback == null) break block4;
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.UNKNOWN);
                        ipcCallbackProxy.callback = null;
                    }
                }
            }
        });
    }

    public void rtcDeleteInnerData(final String roomId, final int type, final String[] keys, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcDeleteInnerData(roomId, type, keys == null ? new String[]{} : keys, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcDeleteOuterData(final String roomId, final int type, final String[] keys, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcDeleteOuterData(roomId, type, keys == null ? new String[]{} : keys, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcGetInnerData(final String roomId, final int type, final String[] keys, IRongCallback.IRtcIODataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRtcIODataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRtcIODataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcGetInnerData(roomId, type, keys == null ? new String[]{} : keys, new IRtcIODataListener.Stub(){

                        @Override
                        public void OnSuccess(final Map data) throws RemoteException {
                            if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void OnError(final int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "rtcGetInnerData errorCode =  " + status);
                            if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void rtcGetOuterData(final String roomId, final int type, final String[] keys, IRongCallback.IRtcIODataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRtcIODataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRtcIODataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcGetOuterData(roomId, type, keys == null ? new String[]{} : keys, new IRtcIODataListener.Stub(){

                        @Override
                        public void OnSuccess(final Map data) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void OnError(final int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "rtcGetOuterData errorCode =  " + status);
                            if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.IRtcIODataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void joinRTCRoomAndGetData(String roomId, final IRongCallback.IRTCJoinRoomCallback callback) {
        this.joinRTCRoomAndGetData(roomId, 0, 1, "", "", new IRongCallback.IRTCJoinRoomCallbackEx<Object[]>(){

            @Override
            public void onSuccess(List<RTCUser> rtcUsers, Object[] exParams) {
                if (callback != null) {
                    callback.onSuccess(rtcUsers, exParams != null && exParams.length >= 1 ? exParams[0] : null);
                }
            }

            @Override
            public void onError(RongIMClient.ErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode);
                }
            }
        });
    }

    public void joinRTCRoomAndGetData(final String roomId, final int roomType, final int broadcastType, final String key, final String value, IRongCallback.IRTCJoinRoomCallbackEx<Object[]> callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallbackEx<Object[]>> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallbackEx<Object[]>>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((IRongCallback.IRTCJoinRoomCallbackEx)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        }
                        return;
                    }
                    try {
                        IMLibRTCClient.this.mLibHandler.joinRTCRoomAndGetData(roomId, roomType, broadcastType, key, value, new JoinRTCRoomCallback(ipcCallbackProxy, roomId, roomType, broadcastType));
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy.callback == null) break block4;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCJoinRoomCallbackEx)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    @Deprecated
    public void getRTCConfig(String model, String osVersion, long timestamp, IRongCallback.IRTCConfigCallback callback) {
        RLog.w(TAG, "getRTCConfig has already Deprecated");
    }

    public void getRTCConfig(final String model, final String osVersion, final long timestamp, final String sdkVersion, final IRongCallback.IRTCConfigCallback callback) {
        if (callback == null) {
            RLog.d(TAG, "getRTCConfig error =   callback is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)model) || TextUtils.isEmpty((CharSequence)osVersion)) {
            RLog.e(TAG, "getRTCConfig parameter error, roomid=|model=" + model + "|osVersion=" + osVersion);
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCConfigCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCConfigCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        RLog.d(IMLibRTCClient.TAG, "getRTCConfig error =  ipcCallbackProxy or callback is null");
                        ((IRongCallback.IRTCConfigCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.getRTCConfig(model, osVersion, timestamp, sdkVersion, new IRTCConfigCallback.Stub(){

                        @Override
                        public void onSuccess(String config, long version) throws RemoteException {
                            callback.onSuccess(config, version);
                        }

                        @Override
                        public void onError(int status) throws RemoteException {
                            RLog.d(IMLibRTCClient.TAG, "getRTCConfig errorCode =  " + status);
                            callback.onError(RongIMClient.ErrorCode.valueOf(status));
                        }
                    });
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runOnUiThread(Runnable runnable) {
        mHandler.post(runnable);
    }

    public void getRTCToken(final String roomId, final int roomType, final int mediaType, RongIMClient.ResultCallback<String> resultCallback) {
        FwLog.write(3, 2, "L-getRTCToken-T", "roomId|roomType|mediaType", roomId, roomType, mediaType);
        final IpcCallbackProxy<RongIMClient.ResultCallback<String>> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.ResultCallback<String>>(resultCallback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        FwLog.write(1, 2, "L-getRTCToken-E", "code|desc", RongIMClient.ErrorCode.IPC_DISCONNECT.getValue(), "IM LibHandler is Null");
                        if (ipcCallbackProxy.callback != null) {
                            ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    IMLibRTCClient.this.mLibHandler.getRTCToken(roomId, roomType, mediaType, new IStringCallback.Stub(){

                        @Override
                        public void onComplete(String string2) throws RemoteException {
                            FwLog.write(3, 2, "L-getRTCToken-R", "code|token", 0, string2);
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onCallback(string2);
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            FwLog.write(1, 2, "L-getRTCToken-E", "code", errorCode);
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.ResultCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    RLog.e(IMLibRTCClient.TAG, "getRTCToken", e);
                }
            }
        });
    }

    public void setRTCUserState(final String roomId, final String state, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    IMLibRTCClient.this.mLibHandler.setRTCUserData(roomId, state, new IOperationCallback.Stub(){

                        @Override
                        public void onComplete() throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    RLog.e(IMLibRTCClient.TAG, "setRTCUserState", e);
                }
            }
        });
    }

    public void solveServerHosts(String host, final RongIMClient.ResultCallback<List<String>> callback) {
        if (this.mLibHandler == null) {
            if (callback != null) {
                callback.onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
            }
            return;
        }
        boolean enabled = false;
        try {
            enabled = this.mLibHandler.isDnsEnabled();
        }
        catch (RemoteException e) {
            RLog.e(TAG, "isDnsEnabled", e);
        }
        if (!enabled) {
            if (callback != null) {
                callback.onFail(RongIMClient.ErrorCode.RC_OPERATION_NOT_SUPPORT);
            }
            return;
        }
        try {
            this.mLibHandler.solveServerHosts(host, new ISolveServerHostsCallBack.Stub(){

                @Override
                public void onSuccess(List<String> hosts) throws RemoteException {
                    callback.onSuccess(hosts);
                }

                @Override
                public void onFailed(int code) throws RemoteException {
                    callback.onFail(code);
                }
            });
        }
        catch (RemoteException e) {
            RLog.e(TAG, "sloveServerHosts", e);
        }
    }

    public void setRTCUserData(final String id, final int type, final HashMap data, final String objectName, final String content, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                            ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                            ipcCallbackProxy.callback = null;
                        }
                        return;
                    }
                    IMLibRTCClient.this.mLibHandler.setRTCUserDatas(id, type, data, objectName, content, new IOperationCallback.Stub(){

                        @Override
                        public void onComplete() throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onCallback();
                                ipcCallbackProxy.callback = null;
                            }
                        }

                        @Override
                        public void onFailure(int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.valueOf(errorCode));
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                }
                catch (RemoteException e) {
                    RLog.e(IMLibRTCClient.TAG, "setRTCUserState", e);
                }
            }
        });
    }

    public void getRTCUserData(final String roomId, final List<String> userIds, IRongCallback.IRTCDataCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<IRongCallback.IRTCDataCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.IRTCDataCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (IMLibRTCClient.this.mLibHandler == null) {
                            if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                            }
                            return;
                        }
                        String[] array = new String[]{};
                        if (userIds != null && !userIds.isEmpty()) {
                            array = userIds.toArray(new String[0]);
                        }
                        IMLibRTCClient.this.mLibHandler.getRTCUserDatas(roomId, array, new RTCDataListener.Stub(){

                            @Override
                            public void OnSuccess(final List data) {
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onSuccess(data);
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void OnError(final int status) {
                                RLog.d(IMLibRTCClient.TAG, "getRTCUserData errorCode =  " + status);
                                if (ipcCallbackProxy.callback != null) {
                                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(status));
                                            ipcCallbackProxy.callback = null;
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (RemoteException e) {
                        RLog.e(IMLibRTCClient.TAG, e.toString());
                        if (ipcCallbackProxy == null || ipcCallbackProxy.callback == null) break block5;
                        IMLibRTCClient.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                ((IRongCallback.IRTCDataCallback)ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        });
                    }
                }
            }
        });
    }

    public void sendRTCDirectMessage(String targetId, MessageContent content, final String[] userIds, final String pushContent, final String pushData, final SendMessageOption option, final boolean isFilterBlackList, IRongCallback.ISendMessageCallback callback) {
        final Message message = Message.obtain(targetId, Conversation.ConversationType.RTC_ROOM, content);
        Conversation.ConversationType type = message.getConversationType();
        if (type == null || TextUtils.isEmpty((CharSequence)targetId) || content == null) {
            RLog.e(TAG, "sendDirectionalMessage : conversation type or targetId or content can't be null!");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        MessageTag msgTag = content.getClass().getAnnotation(MessageTag.class);
        if (msgTag == null) {
            RLog.e(TAG, "sendDirectionalMessage \u81ea\u5b9a\u4e49\u6d88\u606f\u6ca1\u6709\u52a0\u6ce8\u89e3\u4fe1\u606f\u3002");
            if (callback != null) {
                callback.onError(message, RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        if (TypingMessageManager.getInstance().isShowMessageTyping() && !(content instanceof TypingStatusMessage) && !(content instanceof ReadReceiptMessage)) {
            TypingMessageManager.getInstance().setTypingEnd(message.getConversationType(), message.getTargetId());
        }
        final IpcCallbackProxy<IRongCallback.ISendMessageCallback> ipcCallbackProxy = new IpcCallbackProxy<IRongCallback.ISendMessageCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    IMLibRTCClient.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                                ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(message, RongIMClient.ErrorCode.IPC_DISCONNECT);
                                ipcCallbackProxy.callback = null;
                            }
                        }
                    });
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.sendRTCDirectionalMessage(message, pushContent, pushData, userIds, option, isFilterBlackList, new ISendMessageCallback.Stub(){

                        @Override
                        public void onAttached(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onAttached(msg);
                                    }
                                });
                            }
                        }

                        @Override
                        public void onSuccess(final Message msg) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onSuccess(msg);
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }

                        @Override
                        public void onError(final Message msg, final int errorCode) throws RemoteException {
                            if (ipcCallbackProxy.callback != null) {
                                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((IRongCallback.ISendMessageCallback)ipcCallbackProxy.callback).onError(msg, RongIMClient.ErrorCode.valueOf(errorCode));
                                        ipcCallbackProxy.callback = null;
                                    }
                                });
                            }
                        }
                    });
                }
                catch (Exception e) {
                    RLog.e(IMLibRTCClient.TAG, "sendDirectionalMessage exception : ", e);
                }
            }
        });
    }

    public void rtcSetUserResource(final String roomId, final RTCStatusDate[] kv, final String objectName, final RTCStatusDate[] content, RongIMClient.OperationCallback callback) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            RLog.e(TAG, "RTC_Room_ID is empty.");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR);
            }
            return;
        }
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.rtcSetUserResource(roomId, kv, objectName, content, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void SetRTCHeartbeatListener(final IRTCHeartbeatListener.Stub listener) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        RLog.d(IMLibRTCClient.TAG, "SetRTCHeartbeatListener. mLibHandler == null");
                        return;
                    }
                    IMLibRTCClient.this.mLibHandler.SetRTCHeartbeatListener(listener);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void SendRTCHeartbeat(final String[] roomId) {
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (IMLibRTCClient.this.mLibHandler == null) {
                        RLog.d(IMLibRTCClient.TAG, "SendRTCHeartbeat. mLibHandler == null");
                        return;
                    }
                    IMLibRTCClient.this.mLibHandler.SendRTCHeartbeat(roomId);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void SendRTCLiveInvitation(final String roomId, final String anchorId, final String peerRoomId, final String inviteInfo, final String sessionId, final int timeout, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.SendRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, timeout, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void CancelRTCLiveInvitation(final String roomId, final String anchorId, final String peerRoomId, final String inviteInfo, final String sessionId, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.CancelRTCLiveInvitation(roomId, anchorId, peerRoomId, inviteInfo, sessionId, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void AnswerRTCLiveInvitation(final String roomId, final int answer, final String anchorId, final String peerRoomId, final String sessionId, final String content, final String key, final String value, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.AnswerRTCLiveInvitation(roomId, answer, anchorId, peerRoomId, sessionId, content, key, value, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void HangupRTCLiveInvitation(final String roomId, final String peerRoomId, final String sessionId, final String content, final String[] keys, RongIMClient.OperationCallback callback) {
        final IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy = new IpcCallbackProxy<RongIMClient.OperationCallback>(callback);
        this.mWorkHandler.post(new Runnable(){

            @Override
            public void run() {
                if (IMLibRTCClient.this.mLibHandler == null) {
                    if (ipcCallbackProxy != null && ipcCallbackProxy.callback != null) {
                        ((RongIMClient.OperationCallback)ipcCallbackProxy.callback).onFail(RongIMClient.ErrorCode.IPC_DISCONNECT);
                        ipcCallbackProxy.callback = null;
                    }
                    return;
                }
                try {
                    IMLibRTCClient.this.mLibHandler.HangupRTCLiveInvitation(roomId, peerRoomId, sessionId, content, keys, new RTCOperationCallback(ipcCallbackProxy));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private class DefaultOperationCallback
    extends IOperationCallback.Stub {
        private IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy;

        public DefaultOperationCallback(IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy) {
            this.ipcCallbackProxy = ipcCallbackProxy;
        }

        @Override
        public void onComplete() {
            if (this.ipcCallbackProxy != null && this.ipcCallbackProxy.callback != null) {
                ((RongIMClient.OperationCallback)this.ipcCallbackProxy.callback).onCallback();
                this.ipcCallbackProxy.callback = null;
            }
        }

        @Override
        public void onFailure(int errorCode) {
            if (this.ipcCallbackProxy != null && this.ipcCallbackProxy.callback != null) {
                ((RongIMClient.OperationCallback)this.ipcCallbackProxy.callback).onFail(errorCode);
                this.ipcCallbackProxy.callback = null;
            }
        }
    }

    private class RTCExitRoomCallback
    extends DefaultOperationCallback {
        public RTCExitRoomCallback(IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy) {
            super(ipcCallbackProxy);
        }

        @Override
        public void onComplete() {
            RLog.d(IMLibRTCClient.TAG, "RTCExitRoomCallback onComplete ");
            super.onComplete();
        }

        @Override
        public void onFailure(int errorCode) {
            RLog.d(IMLibRTCClient.TAG, "RTCExitRoomCallback errorCode =  " + errorCode);
            super.onFailure(errorCode);
        }
    }

    private class RTCOperationCallback
    extends DefaultOperationCallback {
        public RTCOperationCallback(IpcCallbackProxy<RongIMClient.OperationCallback> ipcCallbackProxy) {
            super(ipcCallbackProxy);
        }

        @Override
        public void onFailure(int errorCode) {
            RLog.d(IMLibRTCClient.TAG, "RTCOperationCallback errorCode =  " + errorCode);
            super.onFailure(errorCode);
        }
    }

    private class JoinRTCRoomCallback
    extends IRTCJoinRoomCallback.Stub {
        private IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallbackEx<Object[]>> ipcCallbackProxy;
        private String rtcRoomId;
        private int roomType;
        private int broadcastType;

        public JoinRTCRoomCallback(IpcCallbackProxy<IRongCallback.IRTCJoinRoomCallbackEx<Object[]>> ipcCallbackProxy, String rtcRoomId, int roomType, int broadcastType) {
            this.rtcRoomId = rtcRoomId;
            this.broadcastType = broadcastType;
            this.roomType = roomType;
            this.ipcCallbackProxy = ipcCallbackProxy;
            RLog.d(IMLibRTCClient.TAG, this + "");
        }

        public String toString() {
            return "JoinRTCRoomCallback{rtcRoomId='" + this.rtcRoomId + '\'' + '}';
        }

        @Override
        public void OnSuccess(final List data, final String token, final String sessionId, final Map room_data) throws RemoteException {
            if (this.ipcCallbackProxy != null && this.ipcCallbackProxy.callback != null) {
                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((IRongCallback.IRTCJoinRoomCallbackEx)((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback).onSuccess(data, new Object[]{token, sessionId, room_data});
                        ((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback = null;
                    }
                });
            }
            if (rtcRoomActionListener != null) {
                rtcRoomActionListener.onJoined(this.rtcRoomId, data);
            }
        }

        @Override
        public void OnError(final int errorCode) throws RemoteException {
            RLog.e(IMLibRTCClient.TAG, "join rtcRroom " + this.rtcRoomId + ", error: " + errorCode);
            if (this.ipcCallbackProxy != null && this.ipcCallbackProxy.callback != null) {
                IMLibRTCClient.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((IRongCallback.IRTCJoinRoomCallbackEx)((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback).onError(RongIMClient.ErrorCode.valueOf(errorCode));
                        ((JoinRTCRoomCallback)JoinRTCRoomCallback.this).ipcCallbackProxy.callback = null;
                    }
                });
            }
            if (rtcRoomActionListener != null) {
                rtcRoomActionListener.onError(this.rtcRoomId, RongIMClient.ErrorCode.valueOf(errorCode));
            }
        }
    }

    private class RTCRoomCacheRunnable
    implements Runnable {
        String rtcRoomID;
        int roomType;
        int broadcastType;
        String key;
        String value;

        public RTCRoomCacheRunnable(String rtcRoomID, int roomType, int broadcastType, String key, String value) {
            this.rtcRoomID = rtcRoomID;
            this.roomType = roomType;
            this.broadcastType = broadcastType;
            this.key = key;
            this.value = value;
        }

        @Override
        public void run() {
            RongIMClient.ConnectionStatusListener.ConnectionStatus mConnectionStatus = RongIMClient.getInstance().getCurrentConnectionStatus();
            RLog.d(IMLibRTCClient.TAG, "rejoin rtc_room " + this);
            if (IMLibRTCClient.this.mLibHandler != null && RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED.equals((Object)mConnectionStatus)) {
                IpcCallbackProxy<Object> ipcCallbackProxy = new IpcCallbackProxy<Object>(null);
                if (rtcRoomActionListener != null) {
                    rtcRoomActionListener.onJoining(this.rtcRoomID);
                }
                try {
                    IMLibRTCClient.this.mLibHandler.joinRTCRoomAndGetData(this.rtcRoomID, this.roomType, this.broadcastType, this.key, this.value, new JoinRTCRoomCallback(ipcCallbackProxy, this.rtcRoomID, this.roomType, this.broadcastType));
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                    RLog.e(IMLibRTCClient.TAG, "rejoin rtc-room exception.");
                }
            } else {
                RLog.e(IMLibRTCClient.TAG, "rejoin rtc-room error : " + (Object)((Object)mConnectionStatus));
            }
        }

        public String toString() {
            return "RTCRoomCacheRunnable{rtcRoomID='" + this.rtcRoomID + '\'' + "roomType= " + '}';
        }
    }

    public static interface RTCRoomActionListener {
        public void onJoining(String var1);

        public void onJoined(String var1, List<RTCUser> var2);

        public void onExited(String var1);

        public void onError(String var1, RongIMClient.ErrorCode var2);
    }

    private static class SingletonHolder {
        static IMLibRTCClient sInstance = new IMLibRTCClient();

        private SingletonHolder() {
        }
    }
}

