/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.imlib.IMLibExtensionModule;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.HardwareResource;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class IMLibExtensionModuleManager
implements IMLibExtensionModule {
    private List<Class<? extends MessageContent>> messageContentClazzList;
    private List<Class<? extends MessageContent>> cmdMessageContentClazzList;
    private List<IMLibExtensionModule> extensionModules;
    private Map<IMLibExtensionModule, List<Class<? extends MessageContent>>> extensionModuleMessageContentMap;
    private static final String[] defaultModules = new String[]{"io.rong.wrapper.RongRemoteControlExtensionModule", "io.rongcloud.moment.lib.RongMomentExtensionModule", "io.rong.signal.core.RCSignalExtensionModule", "cn.rongcloud.rtc.RongRTCExtensionModule"};

    private IMLibExtensionModuleManager() {
        this.init();
    }

    public static IMLibExtensionModuleManager getInstance() {
        return IMLibExtensionModuleManagerHolder.instance;
    }

    public void registerModulesByName(List<String> moduleNames) {
        if (moduleNames != null && moduleNames.size() > 0) {
            for (String moduleName : moduleNames) {
                this.loadIMLibModuleByName(moduleName);
            }
        }
    }

    @Override
    public void onCreate(Context context, String appKey) {
        Context applicationContext = context.getApplicationContext();
        for (String moduleClazzName : defaultModules) {
            this.loadIMLibModuleByName(moduleClazzName);
        }
        for (IMLibExtensionModule module : this.extensionModules) {
            module.onCreate(applicationContext, appKey);
        }
    }

    void onConnected(String userId, String token) {
        for (IMLibExtensionModule module : this.extensionModules) {
            module.onLogin(userId, token);
        }
    }

    @Override
    public void onLogin(String userId, String token) {
    }

    @Override
    public boolean onReceiveMessage(Message message, int left, boolean offline, int cmdLeft) {
        Map.Entry<IMLibExtensionModule, List<Class<? extends MessageContent>>> entry;
        boolean handled = false;
        Iterator<Map.Entry<IMLibExtensionModule, List<Class<? extends MessageContent>>>> iterator = this.extensionModuleMessageContentMap.entrySet().iterator();
        while (!(!iterator.hasNext() || (entry = iterator.next()).getValue().contains(message.getContent().getClass()) && (handled = entry.getKey().onReceiveMessage(message, left, offline, cmdLeft)))) {
        }
        return handled;
    }

    @Override
    public List<Class<? extends MessageContent>> getMessageContentList() {
        return this.messageContentClazzList;
    }

    @Override
    public List<Class<? extends MessageContent>> getCmdMessageContentList() {
        return this.cmdMessageContentClazzList;
    }

    @Override
    public void onConnectStatusChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
        for (IMLibExtensionModule module : this.extensionModules) {
            module.onConnectStatusChanged(status);
        }
    }

    @Override
    public void onLogout() {
        for (IMLibExtensionModule module : this.extensionModules) {
            module.onLogout();
        }
    }

    @Override
    public void onDestroy() {
        for (IMLibExtensionModule module : this.extensionModules) {
            module.onDestroy();
        }
    }

    @Override
    public boolean onRequestHardwareResource(HardwareResource.ResourceType resourceType) {
        boolean handled = false;
        for (IMLibExtensionModule module : this.extensionModules) {
            handled = module.onRequestHardwareResource(resourceType);
            if (!handled) continue;
            RLog.i("IMLibExtensionModuleManager", "handledClass:" + module.getClass().getSimpleName());
            break;
        }
        return handled;
    }

    void init() {
        this.extensionModules = new CopyOnWriteArrayList<IMLibExtensionModule>();
        this.messageContentClazzList = new CopyOnWriteArrayList<Class<? extends MessageContent>>();
        this.cmdMessageContentClazzList = new CopyOnWriteArrayList<Class<? extends MessageContent>>();
        this.extensionModuleMessageContentMap = new ConcurrentHashMap<IMLibExtensionModule, List<Class<? extends MessageContent>>>();
    }

    private void loadIMLibModuleByName(String moduleClazzName) {
        try {
            Class<?> cls = Class.forName(moduleClazzName);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            IMLibExtensionModule module = (IMLibExtensionModule)constructor.newInstance(new Object[0]);
            this.registerInternal(module);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerInternal(IMLibExtensionModule module) {
        if (module == null) {
            return;
        }
        this.extensionModules.add(module);
        if (module.getMessageContentList() != null) {
            this.messageContentClazzList.addAll(module.getMessageContentList());
            this.extensionModuleMessageContentMap.put(module, module.getMessageContentList());
        }
        if (module.getCmdMessageContentList() != null) {
            this.cmdMessageContentClazzList.addAll(module.getMessageContentList());
        }
    }

    private void unRegisterInternal(IMLibExtensionModule module) {
        if (module == null) {
            return;
        }
        this.extensionModules.remove(module);
        if (module.getMessageContentList() != null) {
            this.messageContentClazzList.removeAll(module.getMessageContentList());
        }
        if (module.getCmdMessageContentList() != null) {
            this.cmdMessageContentClazzList.removeAll(module.getCmdMessageContentList());
        }
    }

    private static class IMLibExtensionModuleManagerHolder {
        private static IMLibExtensionModuleManager instance = new IMLibExtensionModuleManager();

        private IMLibExtensionModuleManagerHolder() {
        }
    }
}

