/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.rong.common.rlog.RLog;
import io.rong.imlib.NativeObject;
import io.rong.imlib.httpdns.HttpDnsCompletion;
import io.rong.imlib.httpdns.RongHttpDns;
import io.rong.imlib.httpdns.RongHttpDnsResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class HttpDnsManager {
    private static final String TAG = "HttpDnsManager";
    private static final int TIMEOUT = 3000;
    private ArrayList<String> hosts = new ArrayList();
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private boolean enableHttpDns = true;
    private static final String NAVIGATION_HOST_SUFFIX = "ronghub.com";

    private HttpDnsManager() {
    }

    public static HttpDnsManager getInstance() {
        return HttpDnsManagerHolder.instance;
    }

    public void initHttpDns(Context context, NativeObject nativeObject) {
        RongHttpDns httpDns = RongHttpDns.getService(context);
        httpDns.setLogEnable(true);
        try {
            httpDns.setAccountID(nativeObject.GetHttpDnsAccountId());
            httpDns.setSecret(nativeObject.GetHttpDnsSecret());
        }
        catch (IllegalArgumentException e) {
            RLog.e(TAG, "initHttpDns", e);
        }
        httpDns.setHttpsRequestEnable(true);
        httpDns.setNetworkSwitchPolicy(true, false);
        httpDns.setCachePolicy(RongHttpDns.CachePolicy.POLICY_TOLERANT);
    }

    public void shouldEnableHttpDns(List<String> serverAddressList) {
        this.enableHttpDns = false;
        if (serverAddressList != null && serverAddressList.size() > 0) {
            for (String address : serverAddressList) {
                Uri uri;
                String host;
                if (TextUtils.isEmpty((CharSequence)address) || (host = (uri = Uri.parse((String)address)).getHost()) == null || !host.endsWith(NAVIGATION_HOST_SUFFIX)) continue;
                this.enableHttpDns = true;
                break;
            }
        }
    }

    public HashMap<String, String> getHttpDnsIps(@NonNull Context context, String host) {
        String clientIp;
        String[] resolveIp;
        HashMap<String, String> ipMap;
        block6: {
            ipMap = new HashMap<String, String>();
            if (!this.enableHttpDns) {
                ipMap.put("resolveIp", "");
                ipMap.put("clientIp", "");
                return ipMap;
            }
            final CountDownLatch countDownLatchRequestDns = new CountDownLatch(1);
            RongHttpDnsResult httpDnsResult = RongHttpDns.getService(context).syncResolve(host);
            ArrayList<String> ipv4List = httpDnsResult.getIpv4List();
            resolveIp = new String[1];
            clientIp = httpDnsResult.getClientIp();
            RLog.i(TAG, "host = " + host + ", + ipv4List = " + ipv4List + ", clientIp = " + clientIp);
            if (ipv4List == null || ipv4List.isEmpty()) {
                HttpDnsCompletion completion = new HttpDnsCompletion(context){

                    @Override
                    protected void onSuccess(ArrayList<String> hosts) {
                        resolveIp[0] = hosts.get(0);
                        RLog.i(HttpDnsManager.TAG, "resolveIp success = " + resolveIp[0]);
                        countDownLatchRequestDns.countDown();
                    }

                    @Override
                    protected void onFailed(int code) {
                        resolveIp[0] = "";
                        RLog.i(HttpDnsManager.TAG, "resolveIp fail = " + resolveIp[0]);
                        countDownLatchRequestDns.countDown();
                    }
                };
                RongHttpDns.getService(context).asyncResolve(host, new RongHttpDns.CompletionHandler(){

                    @Override
                    public void completionHandler(RongHttpDnsResult result) {
                    }
                }, completion);
                try {
                    if (countDownLatchRequestDns.await(3000L, TimeUnit.MILLISECONDS)) {
                        RLog.i(TAG, "request dns ip countDownLatch is success");
                        RongHttpDnsResult requestDnsResult = RongHttpDns.getService(context).syncResolve(host);
                        clientIp = requestDnsResult.getClientIp();
                        RLog.i(TAG, "request clientIp = " + clientIp);
                        break block6;
                    }
                    RLog.i(TAG, "request dns ip countDownLatch is timeout");
                }
                catch (InterruptedException e) {
                    RLog.e(TAG, "request dns ip", e);
                    Thread.currentThread().interrupt();
                }
            } else {
                resolveIp[0] = ipv4List.get(0);
            }
        }
        ipMap.put("resolveIp", resolveIp[0]);
        ipMap.put("clientIp", clientIp);
        return ipMap;
    }

    void asyncSolveDnsIp(Context context, String host, RongHttpDns.CompletionHandler handler, HttpDnsCompletion completion) {
        RongHttpDns.getService(context).asyncResolve(host, handler, completion);
    }

    private static class HttpDnsManagerHolder {
        private static final HttpDnsManager instance = new HttpDnsManager();

        private HttpDnsManagerHolder() {
        }
    }
}

