/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.PowerManager;
import io.rong.common.RLog;
import io.rong.common.WakeLockUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.imlib.ConnectionService;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;

public class HeartBeatManager {
    private static final String TAG = "heartBeatManager";
    private PowerManager.WakeLock mRunWakeLock = null;
    private PowerManager pm;
    private final Object mLock = new Object();
    private ConcurrentLinkedQueue<Long> heartBeatQueue = new ConcurrentLinkedQueue();
    private static final long PING_MAX_TIME_OUT = 90000L;
    private static final long PING_PERIOD = 15000L;
    private static final long PING_ACQUIRE_WAKELOCK_TIME = 1000L;
    private Timer timer;
    private NativeObject nativeObject;
    private Handler mWorkHandler;
    private HeartBeatListener heartBeatListener;
    private volatile long acquireWakeLockTime;
    private volatile boolean isBackground;

    private HeartBeatManager() {
    }

    public static HeartBeatManager getInstance() {
        return HeartBeatManagerHolder.instance;
    }

    void setHeartBeatListener(HeartBeatListener heartBeatListener) {
        this.heartBeatListener = heartBeatListener;
    }

    void init(Context context, NativeObject nativeObject) {
        RLog.d(TAG, "init : " + nativeObject);
        if (nativeObject == null) {
            throw new RuntimeException("NativeClient is uninitialized!");
        }
        this.nativeObject = nativeObject;
        HandlerThread workThread = new HandlerThread("PING_WORK");
        workThread.start();
        this.mWorkHandler = new Handler(workThread.getLooper());
        this.initConfig(context);
    }

    private void initConfig(Context context) {
        RLog.d(TAG, "initConfig");
        Resources resources = context.getResources();
        try {
            String acquireTime = resources.getString(resources.getIdentifier("rc_heartbeat_acquire_time", "string", context.getPackageName()));
            this.acquireWakeLockTime = Long.parseLong(acquireTime);
        }
        catch (Exception e) {
            this.acquireWakeLockTime = 1000L;
            RLog.e(TAG, "Read config file exception. Use default heartbeat time value.");
        }
        if (this.acquireWakeLockTime < 1000L) {
            this.acquireWakeLockTime = 1000L;
        }
    }

    void ping(final Context context) {
        RLog.d(TAG, "ping");
        FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "time", System.currentTimeMillis());
        if (this.mWorkHandler != null) {
            this.mWorkHandler.post(new Runnable(){

                @Override
                public void run() {
                    HeartBeatManager.this.startPingWithWakeLock(context);
                }
            });
        }
    }

    private void startPingWithWakeLock(Context context) {
        RLog.d(TAG, "startPingWithWakeLock");
        this.acquirePingWakeLock(context);
        int responseCode = this.nativeObject.ping();
        this.enqueue(System.currentTimeMillis(), responseCode);
        this.scheduleHeartbeat(context);
    }

    void scheduleHeartbeat(Context context) {
        RLog.d(TAG, "scheduleHeartbeat");
        WakeLockUtils.scheduleHeartbeat(context);
    }

    void removeHeartbeatFromAM(Context context) {
        RLog.d(TAG, "cancelHeartbeat");
        WakeLockUtils.cancelHeartbeat(context);
    }

    void cancelSDKHeartBeat(Context context) {
        RLog.d(TAG, "cancelSDKHeartBeat");
        FwLog.write(2, 1, FwLog.LogTag.L_PING_S.getTag(), "cancel", true);
        WakeLockUtils.cancelSDKHeartBeat(context);
    }

    synchronized void dequeue() {
        RLog.d(TAG, "dequeue");
        boolean isTimeOut = this.isPingTimeOut(System.currentTimeMillis());
        RLog.d(TAG, "isTimeOut = " + isTimeOut);
        if (isTimeOut) {
            this.resetQueueAndReconnect();
        } else if (this.heartBeatQueue != null) {
            this.heartBeatQueue.poll();
        }
        this.releasePingWakeLock();
    }

    private synchronized void stopReplenishHeartbeat() {
        if (this.timer != null) {
            FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "interval|enabled", 15000L, false);
            this.timer.cancel();
            this.timer = null;
            RLog.d(TAG, "stop replenish heartbeat");
        }
    }

    synchronized void replenishPing(Context context, int status) {
        this.replenishPing(context, this.isBackground, status);
    }

    private synchronized void replenishPing(Context context, boolean isBackground, int status) {
        RLog.d(TAG, "replenishPing context = " + context + "\uff0cisBackground = " + isBackground + ", status = " + status);
        if (status == RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED.getValue()) {
            if (isBackground) {
                this.stopReplenishHeartbeat();
            } else {
                this.startReplenishHeartbeat(this.nativeObject);
            }
        } else {
            this.removeHeartbeatFromAM(context);
            this.stopReplenishHeartbeat();
        }
    }

    void setIsBackgroundMode(Context context, boolean isBackground) {
        this.isBackground = isBackground;
        this.replenishPing(context, isBackground, ConnectionService.getInstance().getConnectionState().getCurrentStatus().getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquirePingWakeLock(Context context) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.pm == null) {
                RLog.d(TAG, "acquirePingWakeLock pm is null");
                this.pm = (PowerManager)context.getApplicationContext().getSystemService("power");
            }
            if (this.mRunWakeLock == null && this.pm != null) {
                this.mRunWakeLock = this.pm.newWakeLock(1, "HeartBeatManager:run");
            }
            if (this.mRunWakeLock != null && !this.mRunWakeLock.isHeld()) {
                RLog.d(TAG, "acquirePingWakeLock");
                this.mRunWakeLock.acquire(this.acquireWakeLockTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePingWakeLock() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRunWakeLock != null && this.mRunWakeLock.isHeld()) {
                try {
                    RLog.d(TAG, "releasePingWakeLock");
                    this.mRunWakeLock.setReferenceCounted(false);
                    this.mRunWakeLock.release();
                }
                catch (Exception e) {
                    RLog.e(TAG, "releasePingWakeLock exception ", e);
                }
                finally {
                    this.mRunWakeLock = null;
                }
            }
        }
    }

    private synchronized void enqueue(long ts, int pingResponseCode) {
        RLog.d(TAG, "enqueue pingCode = " + pingResponseCode);
        boolean isTimeOut = this.isPingTimeOut(ts);
        RLog.d(TAG, "isTimeOut = " + isTimeOut);
        if (isTimeOut) {
            this.resetQueueAndReconnect();
        } else if (pingResponseCode == 0 && this.heartBeatQueue != null) {
            this.heartBeatQueue.add(ts);
        }
    }

    private void resetQueueAndReconnect() {
        RLog.d(TAG, "resetQueueAndReconnect");
        this.resetQueue();
        this.retry();
    }

    private void resetQueue() {
        RLog.d(TAG, "resetQueue");
        if (this.heartBeatQueue != null) {
            this.heartBeatQueue.clear();
        }
    }

    private boolean isPingTimeOut(long time) {
        if (this.heartBeatQueue == null) {
            return false;
        }
        Long firstTs = this.heartBeatQueue.peek();
        if (firstTs == null) {
            return false;
        }
        return time - firstTs > 90000L;
    }

    private void retry() {
        RLog.d(TAG, "retry");
        if (this.heartBeatListener != null) {
            this.heartBeatListener.onPongReceiveFail();
        }
    }

    private synchronized void startReplenishHeartbeat(final NativeObject nativeObject) {
        if (this.timer == null) {
            RLog.d(TAG, "start replenish heartbeat");
            this.timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "interval|enabled", 15000L, "polling");
                    int responseCode = nativeObject.ping();
                    HeartBeatManager.this.enqueue(System.currentTimeMillis(), responseCode);
                }
            };
            FwLog.write(3, 1, FwLog.LogTag.L_PING_S.getTag(), "interval|enabled", 0, true);
            this.timer.schedule(task, 0L, 15000L);
        }
    }

    static interface HeartBeatListener {
        public void onPongReceiveFail();
    }

    static class HeartBeatManagerHolder {
        static final HeartBeatManager instance = new HeartBeatManager();

        HeartBeatManagerHolder() {
        }
    }
}

