/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.NativeClient;
import io.rong.imlib.RongIMClient;

public class ConnectionState {
    private static final String TAG = "ConnectionState";
    private final int UNCONNECT_CODE = 34999;
    private final int SIGNUP_CODE = 34998;
    private final int NETWORK_UNAVAILABLE_CODE = 34997;
    private final int CONNECTING_CODE = 34996;
    private final int SUSPEND_CODE = 34995;
    private NativeClient.ICodeListener mConnectionStatusUpdateListener;
    private RongIMClient.ConnectionStatusListener.ConnectionStatus currentStatus = RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED;

    protected RongIMClient.ConnectionStatusListener.ConnectionStatus getCurrentStatus() {
        return this.currentStatus;
    }

    protected void setConnectionStatusListener(NativeClient.ICodeListener listener) {
        this.mConnectionStatusUpdateListener = listener;
    }

    protected void initConnectStatus(int status) {
        this.currentStatus = RongIMClient.ConnectionStatusListener.ConnectionStatus.valueOf(status);
        RLog.i(TAG, "initIpcConnectStatus " + (Object)((Object)this.currentStatus));
    }

    public void onEvent(int errorCode) {
        switch (this.currentStatus) {
            case KICKED_OFFLINE_BY_OTHER_CLIENT: 
            case UNCONNECTED: 
            case SIGN_OUT: 
            case TIMEOUT: 
            case TOKEN_INCORRECT: 
            case CONN_USER_BLOCKED: {
                this.unconnectedOnEvent(errorCode);
                break;
            }
            default: {
                this.defaultOnEvent(errorCode);
            }
        }
    }

    public void unconnect() {
        this.onEvent(34999);
    }

    public void signUp() {
        this.onEvent(34998);
    }

    public void networkUnavailable() {
        this.onEvent(34997);
    }

    public void connecting() {
        this.onEvent(34996);
    }

    public void suspend() {
        this.onEvent(34995);
    }

    boolean isTerminate() {
        return this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT) || this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED) || this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SIGN_OUT) || this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.TIMEOUT) || this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.TOKEN_INCORRECT) || this.currentStatus.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONN_USER_BLOCKED);
    }

    private void unconnectedOnEvent(int code) {
        switch (code) {
            case 34996: {
                this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTING);
                break;
            }
        }
    }

    private void defaultOnEvent(int code) {
        if (RongIMClient.ErrorCode.CONNECTED.getValue() == code || RongIMClient.ErrorCode.BIZ_ERROR_RECONNECT_SUCCESS.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED);
        } else if (RongIMClient.ErrorCode.RC_DISCONN_KICK.getValue() == code || RongIMClient.ErrorCode.RC_CONN_OTHER_DEVICE_LOGIN.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT);
        } else if (RongIMClient.ErrorCode.RC_CONN_USER_OR_PASSWD_ERROR.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.TOKEN_INCORRECT);
        } else if (RongIMClient.ErrorCode.RC_CONN_USER_BLOCKED.getValue() == code || RongIMClient.ErrorCode.RC_DISCONN_USER_BLOCKED.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.CONN_USER_BLOCKED);
        } else if (RongIMClient.ErrorCode.RC_CONN_PROTO_VERSION_ERROR.getValue() == code || RongIMClient.ErrorCode.RC_CONN_ID_REJECT.getValue() == code || RongIMClient.ErrorCode.RC_CONN_NOT_AUTHRORIZED.getValue() == code || RongIMClient.ErrorCode.RC_CONN_PACKAGE_NAME_INVALID.getValue() == code || RongIMClient.ErrorCode.RC_CONN_APP_BLOCKED_OR_DELETED.getValue() == code || RongIMClient.ErrorCode.RC_QUERY_ACK_NO_DATA.getValue() == code || RongIMClient.ErrorCode.RC_MSG_DATA_INCOMPLETE.getValue() == code || RongIMClient.ErrorCode.BIZ_ERROR_CLIENT_NOT_INIT.getValue() == code || RongIMClient.ErrorCode.BIZ_ERROR_DATABASE_ERROR.getValue() == code || RongIMClient.ErrorCode.PARAMETER_ERROR.getValue() == code || RongIMClient.ErrorCode.BIZ_ERROR_NO_CHANNEL.getValue() == code || RongIMClient.ErrorCode.BIZ_ERROR_CONNECTING.getValue() == code || RongIMClient.ErrorCode.CONCURRENT_LIMIT_ERROR.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED);
        } else if (RongIMClient.ErrorCode.RC_MSG_SEND_FAIL.getValue() == code || RongIMClient.ErrorCode.RC_NET_CHANNEL_INVALID.getValue() == code || RongIMClient.ErrorCode.RC_NET_UNAVAILABLE.getValue() == code || RongIMClient.ErrorCode.RC_MSG_RESP_TIMEOUT.getValue() == code || RongIMClient.ErrorCode.RC_HTTP_SEND_FAIL.getValue() == code || RongIMClient.ErrorCode.RC_HTTP_REQ_TIMEOUT.getValue() == code || RongIMClient.ErrorCode.RC_HTTP_RECV_FAIL.getValue() == code || RongIMClient.ErrorCode.RC_NAVI_RESOURCE_ERROR.getValue() == code || RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue() == code || RongIMClient.ErrorCode.RC_DOMAIN_NOT_RESOLVE.getValue() == code || RongIMClient.ErrorCode.RC_SOCKET_NOT_CREATED.getValue() == code || RongIMClient.ErrorCode.RC_SOCKET_DISCONNECTED.getValue() == code || RongIMClient.ErrorCode.RC_PONG_RECV_FAIL.getValue() == code || RongIMClient.ErrorCode.RC_CONN_ACK_TIMEOUT.getValue() == code || RongIMClient.ErrorCode.RC_CONN_OVERFREQUENCY.getValue() == code || RongIMClient.ErrorCode.RC_CONN_REFUSED.getValue() == code || RongIMClient.ErrorCode.RC_CONN_REDIRECTED.getValue() == code || RongIMClient.ErrorCode.RC_NETWORK_IS_DOWN_OR_UNREACHABLE.getValue() == code || RongIMClient.ErrorCode.RC_CONN_SERVER_UNAVAILABLE.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND);
        } else if (34999 == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED);
        } else if (34998 == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.SIGN_OUT);
        } else if (34997 == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE);
        } else if (34996 == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTING);
        } else if (34995 == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND);
        } else if (RongIMClient.ErrorCode.RC_CONNECT_TIMEOUT.getValue() == code) {
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.TIMEOUT);
        } else {
            RLog.e(TAG, "errorCodeToConnectionStatus unknown code : " + code);
            this.updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND);
        }
    }

    private void updateCurrentStatus(RongIMClient.ConnectionStatusListener.ConnectionStatus status) {
        if (this.currentStatus != status) {
            FwLog.write(4, 1, FwLog.LogTag.L_CONNECT_S.getTag(), "last_status|status", new Object[]{this.currentStatus, status});
            this.currentStatus = status;
            if (this.mConnectionStatusUpdateListener != null) {
                this.mConnectionStatusUpdateListener.onChanged(status.getValue());
            }
        }
    }
}

