/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import io.rong.common.SystemUtils;
import io.rong.common.fwlog.FwLog;
import io.rong.common.rlog.RLog;
import io.rong.imlib.CMPStrategy;
import io.rong.imlib.ConnectionState;
import io.rong.imlib.HeartBeatManager;
import io.rong.imlib.NativeClient;
import io.rong.imlib.NativeObject;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.common.SignatureUtils;
import io.rong.imlib.navigation.NavigationCacheHelper;
import io.rong.imlib.navigation.NavigationClient;
import io.rong.imlib.navigation.NavigationObserver;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionService {
    private static final String TAG = "ConnectionService";
    private Handler mHandler;
    private Executor mCallBackExecutor;
    private Context mContext = null;
    private String mAppKey;
    private NativeObject mNativeObj;
    private boolean mEnableReconnectKick = false;
    private volatile String mToken;
    private ReconnectRunnable mReconnectRunnable;
    private AtomicInteger mRcRetryCount = new AtomicInteger(0);
    private boolean mIsForeground;
    private ConnectionState mConnectionState;
    private ConnectStatusListener mConnectListener;
    private NativeClient.IConnectResultCallback<String> mConnectCallback;
    private String[] mReconnectInterval = new String[]{"0", "0.25", "0.5", "1", "2", "4", "8", "16", "32", "64"};
    private static final int RECONNECT_INTERVAL_MAX_LENGTH = 10;
    private static final int RECONNECT_INTERVAL = 1000;

    private ConnectionService() {
        HandlerThread workThread = new HandlerThread("IPC_RECONNECT_WORK");
        workThread.start();
        this.mHandler = new Handler(workThread.getLooper());
        this.mCallBackExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                Thread result = new Thread(runnable, "IPC_CONNECT_CALLBACK");
                return result;
            }
        });
        this.mConnectionState = new ConnectionState();
    }

    static ConnectionService getInstance() {
        return SingleHolder.instance;
    }

    void initService(Context context, NativeObject obj, String akey) {
        this.mContext = context;
        this.mNativeObj = obj;
        this.mAppKey = akey;
        this.mConnectListener = new ConnectStatusListener();
        this.mNativeObj.SetConnectionStatusListener(this.mConnectListener);
        CMPStrategy.getInstance().setEnvironment(this.mContext);
        try {
            Resources resources = context.getResources();
            this.mReconnectInterval = resources.getStringArray(resources.getIdentifier("rc_reconnect_interval", "array", context.getPackageName()));
            int length = this.mReconnectInterval.length;
            RLog.i(TAG, "mReconnectInterval " + length);
            if (length == 0 || this.mReconnectInterval[0] == null) {
                throw new IllegalArgumentException("rc_reconnect_interval must have a value and the type of the field must be string-array");
            }
            if (length > 10) {
                throw new IllegalArgumentException("The numbers of rc_reconnect_interval must less than 10");
            }
            for (String s : this.mReconnectInterval) {
                try {
                    Float.parseFloat(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The value of the field must be digits");
                }
            }
        }
        catch (Resources.NotFoundException e) {
            RLog.i(TAG, "Not found rc_reconnect_interval in rc_configuration.xml, use default config");
        }
        this.setHeartBeatListener();
    }

    private void setHeartBeatListener() {
        HeartBeatManager.getInstance().setHeartBeatListener(new HeartBeatManager.HeartBeatListener(){

            @Override
            public void onPongReceiveFail() {
                ConnectionService.this.disposeReconnectByErrorCode(RongIMClient.ErrorCode.RC_PONG_RECV_FAIL.getValue(), -1);
            }
        });
    }

    void setMainProgressConnectionStatusListener(NativeClient.ICodeListener listener) {
        this.mConnectionState.setConnectionStatusListener(listener);
    }

    void connect(final String token, final boolean isReconnect, final boolean inForeground, final NativeClient.IConnectResultCallback<String> callback) {
        this.resetReconnectCount();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ConnectionService.this.connectServer(token, isReconnect, inForeground, callback);
            }
        });
    }

    private void connectServer(final String token, final boolean isReconnect, final boolean inForeground, final NativeClient.IConnectResultCallback<String> callback) {
        if (isReconnect) {
            if (!this.canReconnect()) {
                RLog.i(TAG, "[connect] can't connect status " + (Object)((Object)this.mConnectionState.getCurrentStatus()));
                return;
            }
        } else {
            this.mToken = token;
        }
        if (TextUtils.isEmpty((CharSequence)token)) {
            RLog.e(TAG, "connectServer token is null");
            if (callback != null) {
                callback.onError(RongIMClient.ErrorCode.PARAMETER_ERROR.getValue());
            }
            return;
        }
        this.mConnectionState.connecting();
        this.stopRetry();
        NavigationClient.getInstance().addObserver(new NavigationObserver(){

            @Override
            public void onSuccess(String userId) {
                RLog.d(ConnectionService.TAG, "[connect] get cmp success");
                boolean isPrivate = NavigationCacheHelper.getPrivateCloudConfig(ConnectionService.this.mContext);
                FwLog.write(3, 1, "L-Env-S", "private", isPrivate);
                ConnectionService.this.mNativeObj.SetEnvironment(isPrivate);
                ConnectionService.this.internalConnect(token, userId, isReconnect, inForeground, callback);
            }

            @Override
            public void onError(String userId, int errorCode) {
                RLog.e(ConnectionService.TAG, "[connect] get cmp error, errorCode = " + errorCode);
                boolean isPrivate = NavigationCacheHelper.getPrivateCloudConfig(ConnectionService.this.mContext);
                List<String> cmpList = CMPStrategy.getInstance().getCmpList();
                if (cmpList == null || cmpList.size() == 0) {
                    ConnectionService.this.disposeReconnectByErrorCode(errorCode, -1);
                    if (RongIMClient.ErrorCode.RC_CONN_USER_OR_PASSWD_ERROR.getValue() == errorCode) {
                        callback.onError(errorCode);
                    }
                } else {
                    FwLog.write(3, 1, "L-Env-S", "private:", isPrivate);
                    ConnectionService.this.mNativeObj.SetEnvironment(isPrivate);
                    ConnectionService.this.internalConnect(token, userId, isReconnect, inForeground, callback);
                }
                if (errorCode == 30008) {
                    FwLog.write(1, 1, "P-rtcon-E", "code|method|nativeCode|sessionId|seq_id", errorCode, "navi", 0, 0, "0");
                }
            }
        });
        NavigationClient.getInstance().getCMPServerString(this.mContext, this.mAppKey, token);
    }

    private void internalConnect(String token, String userId, final boolean isReconnect, boolean inForeground, final NativeClient.IConnectResultCallback<String> callback) {
        boolean logType = true;
        FwLog.write(3, 1, isReconnect ? "L-reconnect-T" : "L-connect-T", "sequences", this.mRcRetryCount.get());
        this.mToken = token;
        this.tryConnect(token, userId, isReconnect, inForeground, new NativeClient.IConnectResultCallback<String>(){

            @Override
            public void onSuccess(String s) {
                FwLog.write(3, 1, isReconnect ? "L-reconnect-R" : "L-connect-R", "code|sequences", 0, ConnectionService.this.mRcRetryCount.get());
                if (callback != null) {
                    callback.onSuccess(s);
                }
            }

            @Override
            public void onError(int code) {
                FwLog.write(2, 1, isReconnect ? "L-reconnect-R" : "L-connect-R", "code|network|sequences", code, DeviceUtils.getNetworkType(ConnectionService.this.mContext), ConnectionService.this.mRcRetryCount.get());
                if (callback != null) {
                    callback.onError(code);
                }
            }

            @Override
            public void OnDatabaseOpened(int code) {
                if (callback != null) {
                    callback.OnDatabaseOpened(code);
                }
            }
        });
    }

    private void tryConnect(String token, String userId, boolean isReconnect, boolean inForeground, NativeClient.IConnectResultCallback<String> callback) {
        String clientIp;
        List<String> cmpList;
        List<URL> cmpUrlList;
        this.mIsForeground = inForeground;
        this.mConnectCallback = callback;
        if (userId == null) {
            userId = "";
        }
        if ((cmpUrlList = this.getLegalCmpList(cmpList = CMPStrategy.getInstance().getCmpList())) == null || cmpUrlList.size() <= 0) {
            CMPStrategy.getInstance().clearCache(this.mContext);
            this.mConnectListener.OnRmtpComplete(RongIMClient.ErrorCode.RC_NODE_NOT_FOUND.getValue(), "", 0, (short)0, "");
            return;
        }
        NativeObject.ConnectionEntry[] connectionEntries = this.getConnectionEntries(cmpUrlList);
        NativeClient.getInstance().setCurrentUserId(userId);
        boolean mpOpened = NavigationClient.getInstance().isMPOpened(this.mContext);
        boolean usOpened = NavigationClient.getInstance().isUSOpened(this.mContext);
        boolean grOpened = NavigationClient.getInstance().isGROpened(this.mContext);
        boolean kvStorageOpened = NavigationCacheHelper.isKvStorageEnabled(this.mContext);
        String MCCMNC = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            if (telephonyManager != null) {
                MCCMNC = telephonyManager.getNetworkOperator();
            }
        }
        catch (SecurityException e) {
            RLog.e(TAG, "tryConnect SecurityException", e);
        }
        String netType = DeviceUtils.getNetworkType(this.mContext);
        RLog.d(TAG, "[connect] device info: " + Build.MANUFACTURER + ", " + Build.MODEL + ", " + Build.VERSION.SDK_INT + ", " + "4.1.0" + ", " + netType + ", " + MCCMNC);
        RLog.d(TAG, "[connect] tryConnect::cmp:" + SystemUtils.listToString(cmpList) + ", userId : " + userId);
        FwLog.write(3, 1, "P-connect-T", "strategy|cached|use", "parallel", SystemUtils.listToString(cmpList), SystemUtils.listToString(cmpList));
        boolean enable = this.mEnableReconnectKick && isReconnect;
        int groupMessageLimit = 0;
        if (grOpened) {
            groupMessageLimit = NavigationClient.getInstance().getGroupMessageLimit(this.mContext);
        }
        if (!SystemUtils.isLegalServer(clientIp = NavigationCacheHelper.getClientIp(this.mContext))) {
            clientIp = "";
        }
        NativeObject.UserProfile userProfile = new NativeObject.UserProfile();
        userProfile.setIpv6Preferred(false);
        userProfile.setPublicService(mpOpened);
        userProfile.setPushSetting(usOpened);
        userProfile.setSdkReconnect(enable);
        userProfile.setGroupMessageLimit(groupMessageLimit);
        userProfile.setClientIp(clientIp);
        userProfile.setKvStorageOpened(kvStorageOpened);
        userProfile.setIdentification(SignatureUtils.getAppSignatureSHA1(this.mContext));
        String shortToken = NavigationClient.getInstance().getTokenExceptNavi(token);
        int ret = this.mNativeObj.Connect(shortToken, connectionEntries, userId, userProfile);
        if (ret != 0 && this.mConnectListener != null) {
            this.mConnectListener.OnRmtpComplete(ret, "", -1, (short)0, "");
        }
    }

    private void OnProtocolRmtpComplete(int status, String userId, int code, short duration, String logInfo) {
        RLog.d(TAG, "[connect] operationComplete status:" + status + ", logInfo:" + logInfo);
        if (status == 0) {
            FwLog.write(3, 1, "P-connect-R", "status_code|user_id|native_code|duration|network", status, userId, code, duration, DeviceUtils.getNetworkType(this.mContext));
            this.resetReconnectCount();
            this.stopRetry();
            this.mConnectionState.onEvent(status);
            NativeClient.getInstance().setCurrentUserId(userId);
            NavigationCacheHelper.saveUserId(this.mContext, userId);
            this.responseConnectSuccessBlock(userId);
            CMPStrategy.getInstance().onConnected();
        } else {
            FwLog.write(1, 1, "P-connect-R", "status_code|user_id|native_code|duration|network|bg", status, userId, code, duration, DeviceUtils.getNetworkType(this.mContext), this.mIsForeground ? "false" : "true");
            this.mConnectionState.onEvent(status);
            if (!this.mConnectionState.getCurrentStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND)) {
                this.responseConnectErrorBlock(status);
            }
            this.disposeReconnectByErrorCode(status, code);
        }
        boolean isFetchNavi = NavigationClient.getInstance().isFetching();
        if (!(NavigationClient.getInstance().isNaviCacheValid(this.mContext, this.mAppKey, this.mToken) || isFetchNavi || this.needClearNavi(status) || TextUtils.isEmpty((CharSequence)this.mToken))) {
            NavigationClient.getInstance().requestNavi(this.mAppKey, this.mToken, false);
        }
    }

    private void OnProtocolRmtpDisconnected(int status, int errorCode, String logInfo) {
        RLog.i(TAG, "ExceptionListener onError. errorCode: " + status);
        this.disposeReconnectByErrorCode(status, errorCode);
    }

    private void OnProtocolTcpComplete(NativeObject.ConnectionEntry entry) {
        RLog.e(TAG, "connectionCollection onComplete:" + entry.getHost() + " " + entry.getPort() + " " + entry.getError() + " " + entry.getDuration());
        int logLevel = 3;
        if (entry.getError() == 0) {
            String cmp = entry.getHost() + ":" + entry.getPort();
            CMPStrategy.getInstance().setMainCMP(cmp);
        } else {
            logLevel = entry.getError() == -1 ? 3 : 2;
        }
        FwLog.write(logLevel, 1, "P-connect_entry-S", "code|cmp|duration", entry.getError(), entry.getHost() + ":" + entry.getPort(), entry.getDuration());
    }

    private void OnProtocolDBOpened(int code) {
        this.responseDBOpenBlock(code);
    }

    private void OnProtocolPongReceived() {
        RLog.i(TAG, "ConnectionStatusListener OnPongReceived.");
    }

    private void responseConnectSuccessBlock(String userId) {
        if (this.mConnectCallback != null) {
            this.mConnectCallback.onSuccess(userId);
        }
    }

    private void responseConnectErrorBlock(int status) {
        if (this.mConnectCallback != null) {
            this.mConnectCallback.onError(status);
        }
    }

    private void responseDBOpenBlock(int code) {
        RLog.d(TAG, "onDatabaseOpened.");
        if (this.mConnectCallback != null) {
            this.mConnectCallback.OnDatabaseOpened(code);
        }
    }

    boolean disposeReconnectByErrorCode(int errorCode, int statusCode) {
        FwLog.write(4, 1, "P-connect-S", "status_code|native_code", errorCode, statusCode);
        this.mConnectionState.onEvent(errorCode);
        boolean willReconnect = false;
        RongIMClient.ConnectionStatusListener.ConnectionStatus status = this.mConnectionState.getCurrentStatus();
        if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
            this.stopRetry();
        } else if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.SUSPEND)) {
            this.handleSuspend(errorCode);
            willReconnect = true;
        } else {
            RLog.d(TAG, "disposeReconnectByErrorCode cannot reconnect : status = " + (Object)((Object)this.mConnectionState.getCurrentStatus()));
            if (status.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.TIMEOUT)) {
                this.disconnect(false);
            }
            this.stopRetry();
        }
        return willReconnect;
    }

    private void handleSuspend(int errorCode) {
        if (errorCode == RongIMClient.ErrorCode.RC_CONNECTION_RESET_BY_PEER.getValue() || errorCode == RongIMClient.ErrorCode.RC_CONN_ACK_TIMEOUT.getValue()) {
            CMPStrategy.getInstance().updateCmpList();
        } else if (errorCode == RongIMClient.ErrorCode.RC_PONG_RECV_FAIL.getValue() && this.isNetworkAvailable()) {
            CMPStrategy.getInstance().updateCmpList();
        } else if (this.needClearNavi(errorCode)) {
            CMPStrategy.getInstance().clearCache(this.mContext);
        }
        this.retry();
    }

    private boolean needClearNavi(int errorCode) {
        return errorCode == RongIMClient.ErrorCode.RC_CONN_REDIRECTED.getValue() || errorCode == RongIMClient.ErrorCode.PARAMETER_ERROR.getValue() || errorCode == RongIMClient.ErrorCode.RC_CONN_REFUSED.getValue();
    }

    private void retry() {
        if (this.canReconnect()) {
            int maxRetryCount = this.mReconnectInterval.length - 1;
            int interval = this.mRcRetryCount.get() >= 0 && this.mRcRetryCount.get() <= maxRetryCount ? (int)(Float.parseFloat(this.mReconnectInterval[this.mRcRetryCount.get()]) * 1000.0f) : (int)(Float.parseFloat(this.mReconnectInterval[maxRetryCount]) * 1000.0f);
            RLog.d(TAG, "onStatusChange, Will reconnect after " + interval);
            FwLog.write(4, 1, "L-reconnect-S", "retry_after", interval);
            this.mReconnectRunnable = new ReconnectRunnable();
            this.mHandler.postDelayed((Runnable)this.mReconnectRunnable, (long)interval);
            this.incrementCount();
        }
    }

    private void incrementCount() {
        this.mRcRetryCount.incrementAndGet();
    }

    private void stopRetry() {
        if (this.mReconnectRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mReconnectRunnable);
            this.mReconnectRunnable = null;
        }
    }

    private boolean canReconnect() {
        if (this.mConnectionState.isTerminate()) {
            RLog.e(TAG, "globalConnectionState can not reconnect");
            this.mToken = null;
            this.stopRetry();
            return false;
        }
        if (this.mConnectionState.getCurrentStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
            RLog.i(TAG, "already connected. ignore this connect event.");
            return false;
        }
        if (this.mToken == null) {
            RLog.e(TAG, "mToken is cleared for terminal reconnect reason");
            return false;
        }
        if (!this.isNetworkAvailable()) {
            this.resetReconnectCount();
            this.mConnectionState.networkUnavailable();
            return false;
        }
        return true;
    }

    void setReconnectKickEnable(boolean enable) {
        this.mEnableReconnectKick = enable;
    }

    void disconnect(boolean isReceivePush) {
        this.resetReconnectCount();
        this.stopRetry();
        if (this.mNativeObj == null) {
            throw new RuntimeException("NativeClient \u5c1a\u672a\u521d\u59cb\u5316!");
        }
        RLog.d(TAG, "[connect] disconnect:" + isReceivePush);
        this.mConnectionState.signUp();
        this.mToken = null;
        this.mNativeObj.Disconnect(isReceivePush ? 2 : 4);
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isAvailable();
    }

    void resetReconnectCount() {
        RLog.i(TAG, "reset reconnectCount");
        this.mRcRetryCount.set(0);
    }

    private NativeObject.ConnectionEntry[] getConnectionEntries(List<URL> list) {
        ArrayList<NativeObject.ConnectionEntry> result = new ArrayList<NativeObject.ConnectionEntry>();
        if (list == null || list.size() <= 0) {
            return result.toArray(new NativeObject.ConnectionEntry[0]);
        }
        for (URL url : list) {
            NativeObject.ConnectionEntry entry = new NativeObject.ConnectionEntry();
            String host = url.getHost().replace("[", "").replace("]", "");
            entry.setHost(host);
            entry.setPort(url.getPort());
            result.add(entry);
        }
        return result.toArray(new NativeObject.ConnectionEntry[list.size()]);
    }

    private List<URL> getLegalCmpList(List<String> list) {
        ArrayList<URL> result = new ArrayList<URL>();
        ArrayList<String> tempList = new ArrayList<String>(list);
        for (String cmp : tempList) {
            URL url = SystemUtils.getLegalServer(cmp, true);
            if (url != null) {
                result.add(url);
                continue;
            }
            FwLog.write(1, 1, "L-check_cmp-S", "cmp", cmp);
        }
        return result;
    }

    void setIpcConnectTimeOut() {
        this.mCallBackExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionService.this.mConnectionState.getCurrentStatus().equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.CONNECTED)) {
                    RLog.e(ConnectionService.TAG, "IM \u91cd\u8fde\u8d85\u65f6\uff0c\u5c06\u4e0d\u4f1a\u7ee7\u7eed\u8fde\u63a5");
                    ConnectionService.this.disposeReconnectByErrorCode(RongIMClient.ErrorCode.RC_CONNECT_TIMEOUT.getValue(), -1);
                    ConnectionService.this.responseConnectErrorBlock(RongIMClient.ErrorCode.RC_CONNECT_TIMEOUT.getValue());
                }
            }
        });
    }

    void initIPCEnviroment(String token, int status) {
        RLog.i(TAG, "initConnectToken " + token);
        this.mToken = token;
        this.mConnectionState.initConnectStatus(status);
    }

    ConnectionState getConnectionState() {
        return this.mConnectionState;
    }

    private class ReconnectRunnable
    implements Runnable {
        ReconnectRunnable() {
            RLog.d(ConnectionService.TAG, "ReconnectRunnable");
        }

        @Override
        public void run() {
            RLog.d(ConnectionService.TAG, "ReconnectRunnable, count = " + ConnectionService.this.mRcRetryCount.get());
            String token = ConnectionService.this.mToken;
            if (!TextUtils.isEmpty((CharSequence)token)) {
                ConnectionService.this.connectServer(token, true, true, ConnectionService.this.mConnectCallback);
            }
            ConnectionService.this.mReconnectRunnable = null;
        }
    }

    private class ConnectStatusListener
    implements NativeObject.ConnectionStatusListener {
        private ConnectStatusListener() {
        }

        @Override
        public void OnTcpComplete(final NativeObject.ConnectionEntry entry) {
            ConnectionService.this.mCallBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionService.this.OnProtocolTcpComplete(entry);
                }
            });
        }

        @Override
        public void OnRmtpComplete(final int status, final String userId, final int code, final short duration, final String logInfo) {
            ConnectionService.this.mCallBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionService.this.OnProtocolRmtpComplete(status, userId, code, duration, logInfo);
                }
            });
        }

        @Override
        public void OnRmtpDisconnected(final int status, final int errorCode, final String logInfo) {
            ConnectionService.this.mCallBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionService.this.OnProtocolRmtpDisconnected(status, errorCode, logInfo);
                }
            });
        }

        @Override
        public void OnPongReceived() {
            ConnectionService.this.mCallBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionService.this.OnProtocolPongReceived();
                    HeartBeatManager.getInstance().dequeue();
                }
            });
        }

        @Override
        public void OnDatabaseOpened(final int code) {
            ConnectionService.this.mCallBackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionService.this.OnProtocolDBOpened(code);
                }
            });
        }
    }

    private static class SingleHolder {
        static ConnectionService instance = new ConnectionService();

        private SingleHolder() {
        }
    }
}

