/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imlib;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.common.DeviceUtils;
import io.rong.imlib.navigation.NavigationCacheHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class CMPStrategy {
    private static final String TAG = CMPStrategy.class.getSimpleName();
    private Context context;
    private String connectNetInfo = "";
    private List<String> cmpList = new ArrayList<String>();
    private volatile boolean isConnectedState;

    public static CMPStrategy getInstance() {
        return SingletonHolder.sIns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnvironment(Context context) {
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            this.context = context;
            this.cmpList = NavigationCacheHelper.getConnectionCmpList(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGetCmpEntriesFromNavi() {
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            this.cmpList = NavigationCacheHelper.getConnectionCmpList(this.context);
            RLog.d(TAG, "get cmp list from navi:" + this.cmpList.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMainCMP(String cmp) {
        if (this.cmpList.size() <= 1) {
            return;
        }
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            List<String> tmpCmpList = this.cmpList;
            for (int i = 0; i < tmpCmpList.size(); ++i) {
                String c = tmpCmpList.get(i);
                if (!cmp.equals(c)) continue;
                if (i == 0) {
                    return;
                }
                this.cmpList.remove(i);
                this.cmpList.add(0, cmp);
                return;
            }
        }
    }

    void onConnected() {
        this.connectNetInfo = DeviceUtils.getNetworkType(this.context);
        this.isConnectedState = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCmpList() {
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            if (this.cmpList.size() > 1) {
                this.cmpList.add(this.cmpList.remove(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCmpList() {
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            ArrayList<String> cmps = new ArrayList();
            String currentNetInfo = DeviceUtils.getNetworkType(this.context);
            if (currentNetInfo.equals(this.connectNetInfo) && this.cmpList != null && this.cmpList.size() > 0) {
                RLog.d(TAG, "getCmpEntries from cache.");
            } else {
                RLog.d(TAG, "getCmpEntries from SP.");
                this.cmpList = NavigationCacheHelper.getConnectionCmpList(this.context);
            }
            cmps = this.cmpList;
            return cmps;
        }
    }

    public boolean isCMPValid(String cmp) {
        if (TextUtils.isEmpty((CharSequence)cmp)) {
            return false;
        }
        String str = cmp;
        if (!str.startsWith("http")) {
            str = "http://" + str;
        }
        try {
            URL url = new URL(str);
            if (url.getHost() != null && url.getPort() >= 0) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache(Context context) {
        CMPStrategy cMPStrategy = this;
        synchronized (cMPStrategy) {
            this.cmpList.clear();
            NavigationCacheHelper.clearCache(context);
        }
    }

    private static class SingletonHolder {
        @SuppressLint(value={"StaticFieldLeak"})
        private static final CMPStrategy sIns = new CMPStrategy();

        private SingletonHolder() {
        }
    }
}

