/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.rlog;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import io.rong.common.rlog.RLog;
import io.rong.imlib.common.SavePathUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.TreeSet;

public class RLogConfig {
    private static final String TAG = "RLogConfig";
    public static final long DEFAULT_MAX_SIZE = 0x100000L;
    public static final String ZIP_SUFFIX = ".gz";
    public static final String LOG_SUFFIX = ".log";
    private static final String LOG_DIR = "RLog";
    private static final String SP_NAME = "FwLog";
    private String mLogPath;
    private String mFileName = "r.log";
    private int mLogLevel = 0;
    private long mFileMaxSize = 0x100000L;
    private long mZipMaxSize = 0x100000L;
    private String mAppKey;
    private String mSdkVersion;
    private static final String R_LOG_LEVEL = "r_log_level";
    private static final String R_FILE_MAX_SIZE = "r_file_max_size";
    private static final String R_ZIP_MAX_SIZE = "r_zip_max_size";
    private static final String R_ZIP_CONFIG = "r_zip_config";
    private static final String R_START_TIME = "r_start_time";
    private static final String R_UPLOAD_URL = "r_upload_url";
    private static SharedPreferences mSp;
    private boolean isFirstGetLevel = true;
    private boolean isFirstFileMaxSize = true;
    private boolean isFirstZipMaxSize = true;
    private boolean isFirstStartTime = true;
    private boolean isDebugMode;
    private long mStartTime;
    private String uploadUrl;
    private String userId;
    private ZipConfig mZipConfig;

    public RLogConfig(Context pContext, String pAppKey, String pSdkVersion) {
        ApplicationInfo info = pContext.getApplicationInfo();
        this.isDebugMode = info != null && (info.flags & 2) != 0;
        File extLogDir = null;
        this.mAppKey = pAppKey;
        this.mSdkVersion = pSdkVersion;
        mSp = pContext.getSharedPreferences(SP_NAME, 0);
        if (!SavePathUtils.isSavePathEmpty()) {
            RLog.e(TAG, SavePathUtils.getSavePath());
            this.mLogPath = SavePathUtils.getSavePath() + File.separator + LOG_DIR;
            File file = new File(this.mLogPath);
            if (!file.exists()) {
                file.mkdirs();
            }
        } else {
            try {
                extLogDir = pContext.getExternalFilesDir(LOG_DIR);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                RLog.e(TAG, TAG, e);
            }
            if (extLogDir != null) {
                this.mLogPath = extLogDir.getAbsolutePath();
            } else {
                try {
                    String intLogDir;
                    this.mLogPath = intLogDir = pContext.getFilesDir().getAbsoluteFile() + File.separator + LOG_DIR;
                }
                catch (Exception e) {
                    RLog.e(TAG, TAG, e);
                }
            }
        }
        this.initZipConfig();
    }

    public String getLogPath() {
        return this.mLogPath;
    }

    public void setLogPath(String pLogPath) {
        this.mLogPath = pLogPath;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setFileName(String pFileName) {
        this.mFileName = pFileName;
    }

    public String getFilePath() {
        return this.mLogPath + File.separator + this.mFileName;
    }

    public void setLogLevel(int pLogLevel) {
        this.mLogLevel = pLogLevel;
        if (mSp != null) {
            mSp.edit().putInt(R_LOG_LEVEL, pLogLevel).apply();
        }
    }

    public void setFileMaxSize(long pFileMaxSize) {
        this.mFileMaxSize = pFileMaxSize;
        if (mSp != null) {
            mSp.edit().putLong(R_FILE_MAX_SIZE, pFileMaxSize).apply();
        }
    }

    public void setZipMaxSize(long pZipMaxSize) {
        this.mZipMaxSize = pZipMaxSize;
        if (mSp != null) {
            mSp.edit().putLong(R_ZIP_MAX_SIZE, pZipMaxSize).apply();
        }
    }

    public void setStartTime(long pStartTime) {
        this.mStartTime = pStartTime;
        if (mSp != null) {
            mSp.edit().putLong(R_START_TIME, pStartTime).apply();
        }
    }

    public int getLogLevel() {
        if (this.isFirstGetLevel && mSp != null) {
            this.mLogLevel = mSp.getInt(R_LOG_LEVEL, 0);
            this.isFirstGetLevel = false;
        }
        return this.mLogLevel;
    }

    public long getFileMaxSize() {
        if (this.isFirstFileMaxSize && mSp != null) {
            this.mFileMaxSize = mSp.getLong(R_FILE_MAX_SIZE, 0x100000L);
            this.isFirstFileMaxSize = false;
        }
        return this.mFileMaxSize;
    }

    public long getZipMaxSize() {
        if (this.isFirstZipMaxSize && mSp != null) {
            this.mZipMaxSize = mSp.getLong(R_ZIP_MAX_SIZE, 0x100000L);
            this.isFirstZipMaxSize = false;
        }
        return this.mZipMaxSize;
    }

    public long getStartTime() {
        if (this.isFirstStartTime && mSp != null) {
            this.mStartTime = mSp.getLong(R_START_TIME, System.currentTimeMillis());
            this.isFirstStartTime = false;
        }
        return this.mStartTime;
    }

    public String getUploadUrl() {
        if (this.uploadUrl == null && mSp != null) {
            this.uploadUrl = mSp.getString(R_UPLOAD_URL, "https://feedback.cn.ronghub.com");
        }
        return this.uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        if (mSp != null) {
            mSp.edit().putString(R_UPLOAD_URL, uploadUrl).apply();
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public ZipConfig getZipConfig() {
        return this.mZipConfig;
    }

    public void clearZipConfig() {
        if (this.mZipConfig != null) {
            this.mZipConfig.clear();
            this.mZipConfig = null;
        }
    }

    public void initZipConfig() {
        this.mZipConfig = this.refreshZipConfig();
    }

    private ZipConfig refreshZipConfig() {
        File dir = new File(this.mLogPath);
        if (!dir.exists()) {
            return null;
        }
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                return pathname.getName().endsWith(RLogConfig.ZIP_SUFFIX);
            }
        });
        TreeSet<File> set = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.lastModified() - o2.lastModified() < 0L ? -1 : 1;
            }
        });
        long zipSize = 0L;
        if (files != null) {
            for (File zip : files) {
                zipSize += zip.length();
                set.add(zip);
            }
        }
        return new ZipConfig(zipSize, set);
    }

    public class ZipConfig {
        private long currentSize;
        private TreeSet<File> zipFiles;

        public ZipConfig(long pCurrentSize, TreeSet<File> pZipFiles) {
            this.currentSize = pCurrentSize;
            this.zipFiles = pZipFiles;
        }

        public void setCurrentSize(long pCurrentSize) {
            this.currentSize = pCurrentSize;
        }

        public long getCurrentSize() {
            return this.currentSize;
        }

        public TreeSet<File> getZipFiles() {
            return this.zipFiles;
        }

        public void addFile(File pFile) {
            this.zipFiles.add(pFile);
        }

        public void clear() {
            if (this.zipFiles != null) {
                this.zipFiles.clear();
                this.zipFiles = null;
            }
        }
    }
}

