/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.rlog;

import android.util.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LogFileWriter {
    ExecutorService pool = Executors.newSingleThreadExecutor();
    private File mLogFile;
    private FileWriter mFileWriter;
    private IWriterListener mListener;
    private String mFilePath;
    private int openRetry = 0;
    private long timestamp = 0L;

    public LogFileWriter(String filePath) {
        this(filePath, null);
    }

    public LogFileWriter(String filePath, IWriterListener pListener) {
        this.mFilePath = filePath;
        this.mListener = pListener;
    }

    public void write(final String data) {
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                if (LogFileWriter.this.mFileWriter == null && !LogFileWriter.this.open()) {
                    return;
                }
                try {
                    LogFileWriter.this.mFileWriter.write(data);
                    LogFileWriter.this.mFileWriter.flush();
                    if (LogFileWriter.this.mListener != null) {
                        LogFileWriter.this.mListener.onWriteFinish(LogFileWriter.this.mLogFile.length(), LogFileWriter.this.mLogFile.getAbsolutePath());
                    }
                }
                catch (Exception e) {
                    Log.e((String)"RongLog", (String)("write file error " + LogFileWriter.this.mFilePath), (Throwable)e);
                }
            }
        });
    }

    public void stopWrite(final IWriterOnStopListener pListener) {
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                pListener.onStopWrite(LogFileWriter.this.mFilePath);
            }
        });
    }

    public boolean open() {
        if (!this.validateOpen()) {
            return false;
        }
        try {
            File parentFile;
            this.mLogFile = new File(this.mFilePath);
            if (!this.mLogFile.exists() && this.mListener != null) {
                this.mListener.onFileCreate(System.currentTimeMillis());
            }
            if (!(parentFile = this.mLogFile.getParentFile()).exists()) {
                parentFile.mkdirs();
            }
            this.mFileWriter = new FileWriter(this.mLogFile, true);
            this.openRetry = 0;
            this.timestamp = 0L;
            return true;
        }
        catch (IOException e) {
            Log.e((String)"RongLog", (String)("open file error " + this.mFilePath), (Throwable)e);
            ++this.openRetry;
            this.timestamp = System.currentTimeMillis();
            return false;
        }
    }

    public void close() {
        if (this.mFileWriter != null) {
            try {
                this.mFileWriter.close();
                this.mFileWriter = null;
            }
            catch (IOException pE) {
                Log.e((String)"RongLog", (String)"RLogFileProcessor close error", (Throwable)pE);
            }
        }
    }

    private boolean validateOpen() {
        long curTime;
        if (this.openRetry >= 3) {
            return false;
        }
        return this.timestamp == 0L || (curTime = System.currentTimeMillis()) - this.timestamp >= 5000L;
    }

    static interface IWriterOnStopListener {
        public void onStopWrite(String var1);
    }

    static interface IWriterListener {
        public void onWriteFinish(long var1, String var3);

        public void onFileCreate(long var1);
    }
}

