/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.fwlog;

import android.text.TextUtils;
import io.rong.common.fwlog.FwLog;
import java.util.Arrays;

public class LogSplitUtil {
    private static final int MAX_CONTENT_SIZE = 850;
    public static final String SUFFIX_SPLIT = "-X";

    public static void write(int level, String tag, String keys, Object ... values) {
        int length = keys.length();
        for (Object obj : values) {
            String value = obj != null ? obj.toString() : "null";
            length += value.length();
        }
        if (length <= 850) {
            FwLog.write(level, 2, tag, keys, values);
            return;
        }
        String suffix = tag.substring(tag.lastIndexOf("-"));
        tag = tag.substring(0, tag.lastIndexOf("-"));
        String[] keyArray = keys.split("\\|");
        String splitKeys = "";
        int splitLength = 0;
        int start = 0;
        boolean haveMergedKeys = false;
        for (int i = 0; i < keyArray.length; ++i) {
            String value;
            if (splitKeys.contains("|")) {
                haveMergedKeys = true;
            }
            splitKeys = splitKeys + keyArray[i] + "|";
            splitLength += splitKeys.length();
            String string2 = value = values[i] != null ? values[i].toString() : "null";
            if (value.length() < 850) {
                if ((splitLength += value.length()) > 850) {
                    LogSplitUtil.merge(level, tag, suffix, start, i, splitKeys, values);
                    suffix = SUFFIX_SPLIT;
                    start = i + 1;
                    splitKeys = keyArray[i] + "|";
                    splitLength = keyArray[i].length() + value.length() + 1;
                    continue;
                }
                if (i != keyArray.length - 1) continue;
                if (start == i) {
                    int logLevel = level;
                    if (SUFFIX_SPLIT.equals(suffix) && logLevel <= 1) {
                        logLevel = 2;
                    }
                    FwLog.write(logLevel, 2, tag + suffix, keyArray[i], value);
                    continue;
                }
                LogSplitUtil.merge(level, tag, suffix, start, i, splitKeys, values);
                continue;
            }
            if (!haveMergedKeys) {
                LogSplitUtil.split(level, tag, suffix, keyArray[i], value);
            } else {
                if (i > start) {
                    LogSplitUtil.merge(level, tag, suffix, start, i, splitKeys, values);
                    suffix = SUFFIX_SPLIT;
                }
                LogSplitUtil.split(level, tag, suffix, keyArray[i], value);
            }
            suffix = SUFFIX_SPLIT;
            splitKeys = "";
            splitLength = 0;
            start = i + 1;
            haveMergedKeys = false;
        }
    }

    private static void merge(int level, String tag, String suffix, int start, int end, String splitKeys, Object ... values) {
        if (start >= end) {
            return;
        }
        Object[] content = new Object[end - start];
        for (int j = 0; j < end; ++j) {
            content[j] = values[start + j];
        }
        splitKeys = splitKeys.substring(0, splitKeys.length() - 1);
        splitKeys = splitKeys.substring(0, splitKeys.lastIndexOf("|"));
        int logLevel = level;
        if (SUFFIX_SPLIT.equals(suffix) && logLevel <= 1) {
            logLevel = 2;
        }
        FwLog.write(logLevel, 2, tag + suffix, splitKeys, content);
    }

    private static void split(int level, String tag, String suffix, String key, String value) {
        while (!TextUtils.isEmpty((CharSequence)value)) {
            String split = value;
            if (value.length() > 850) {
                split = new String(Arrays.copyOf(value.getBytes(), 850));
            }
            int logLevel = level;
            if (SUFFIX_SPLIT.equals(suffix) && logLevel <= 1) {
                logLevel = 2;
            }
            FwLog.write(logLevel, 2, tag + suffix, key, split);
            suffix = SUFFIX_SPLIT;
            if (value.length() < 850) break;
            value = value.substring(850);
        }
    }
}

