/*
 * Decompiled with CFR 0.152.
 */
package io.rong.common.dlog;

import io.rong.common.dlog.DLog;
import io.rong.common.dlog.LogReporter;
import io.rong.common.dlog.LogThresholdCallback;
import io.rong.common.dlog.LogWriter;
import java.util.Vector;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RealTimeLogWriter
implements LogWriter {
    private static final int Interval = 5;
    private static final int MAX_SIZE = 100;
    private Vector<String> lruLog = new Vector();
    private ScheduledExecutorService executorService;
    private LogThresholdCallback thresholdCallback;
    private ScheduledFuture future;
    private long startTime;

    public RealTimeLogWriter(ScheduledExecutorService executorService, LogThresholdCallback callback) {
        this.executorService = executorService;
        this.thresholdCallback = callback;
    }

    @Override
    public void write(String log) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.lruLog.add(log);
        if (this.lruLog.size() > 100) {
            this.lruLog.remove(0);
        }
        if (this.future == null || this.future.isDone()) {
            this.future = this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    long endTime = System.currentTimeMillis();
                    RealTimeLogWriter.this.thresholdCallback.onTimeout(RealTimeLogWriter.this.lruLog, RealTimeLogWriter.this.startTime + "", endTime + "");
                    RealTimeLogWriter.this.lruLog.clear();
                    RealTimeLogWriter.this.startTime = 0L;
                }
            }, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void flushAndReport(boolean isNeedFlush, LogReporter logReporter, DLog.ILogUploadCallback callback) {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

